/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.autoviewer;

import com.ge.med.terra.jami.autoviewer.XpAutoViewport;
import com.ge.med.terra.jami.autoviewer.XpRTImageProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class XpAvTimer
extends Thread {
    private XpAutoViewport av = null;
    private XpRTImageProvider rtip = null;
    private FileLog log = new FileLog("AvTimer");
    private int rate = 0;
    private long lastTime = 0L;
    private long lastPaintCount = 0L;
    private long lastRepaintCount = 0L;
    private long lastEventCount = 0L;
    private long time = 0L;
    private long paintCount = 0L;
    private long repaintCount = 0L;
    private long eventCount = 0L;
    private boolean first = true;
    private boolean running = true;

    public XpAvTimer(int sampleRate, XpAutoViewport viewport, XpRTImageProvider provider) {
        this.rate = sampleRate;
        this.av = viewport;
        this.rtip = provider;
        this.log.insert("Time Interval,Event Count,Repaint Count,Paint Count");
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.time = System.currentTimeMillis();
            this.paintCount = this.av.getPaintCount();
            this.repaintCount = this.av.getRepaintCount();
            this.eventCount = this.rtip.getEventCount();
            if (this.first) {
                this.first = false;
            } else {
                this.log.insert(this.time - this.lastTime + "," + (this.eventCount - this.lastEventCount) + "," + (this.repaintCount - this.lastRepaintCount) + "," + (this.paintCount - this.lastPaintCount));
            }
            this.lastTime = this.time;
            this.lastPaintCount = this.paintCount;
            this.lastRepaintCount = this.repaintCount;
            this.lastEventCount = this.eventCount;
            try {
                XpAvTimer.sleep(this.rate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopRunning() {
        this.running = false;
    }

    public void print() {
        this.log.print();
    }

    private class FileLog {
        private List entries = new ArrayList();
        private String title = null;
        private int MAX_SIZE = 5000;

        public FileLog(String title) {
            this.title = title;
        }

        public void insert(String data) {
            if (this.entries.size() < this.MAX_SIZE) {
                this.entries.add(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print() {
            OutputStreamWriter fileWriter = null;
            try {
                File outfile = new File(this.title + ".txt");
                fileWriter = new FileWriter(outfile);
                for (int i = 0; i < this.entries.size(); ++i) {
                    fileWriter.write((String)this.entries.get(i));
                    fileWriter.write("\n");
                }
                fileWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }
}

