/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.apps.utils;

import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpDMSessionProvider;
import java.awt.image.BufferedImage;

public class dicomexport {
    private static boolean verbose = false;
    private static int rows = 512;
    private static int cols = 512;
    private static double zoom = 1.0;
    private static double ww = 4000.0;
    private static double wl = 1200.0;
    private static boolean doWW = false;
    private static boolean doWL = false;
    private static XpComponentSave cs = new XpComponentSave();

    public static XpMedicalImage[] getImages(String fname) {
        XpDMSessionProvider dmsp = new XpDMSessionProvider(new String[]{"file", fname});
        dmsp.printESInfo();
        dmsp.setExamSeries(0, 0);
        return dmsp.getImages();
    }

    public static void main(String[] args) {
        String jpegexport = null;
        String pngexport = null;
        String inputImgs = null;
        for (int argIdx = 0; argIdx < args.length; ++argIdx) {
            if (args[argIdx].equals("-h")) {
                System.out.println("USAGE: dicomexport <dicom_image> {-jpeg <filename>} {-png <filename>} {-dim <row> <col>} {-zoom <zoom factor>} {-ww <ww>} {-wl <wl>}");
                return;
            }
            if (args[argIdx].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[argIdx].equals("-jpeg")) {
                if (++argIdx >= args.length) continue;
                jpegexport = args[argIdx];
                continue;
            }
            if (args[argIdx].equals("-png")) {
                if (++argIdx >= args.length) continue;
                pngexport = args[argIdx];
                continue;
            }
            if (args[argIdx].equals("-dim")) {
                if (++argIdx < args.length) {
                    rows = Integer.parseInt(args[argIdx]);
                }
                if (++argIdx >= args.length) continue;
                cols = Integer.parseInt(args[argIdx]);
                continue;
            }
            if (args[argIdx].equals("-zoom")) {
                if (++argIdx >= args.length) continue;
                zoom = Double.parseDouble(args[argIdx]);
                continue;
            }
            if (args[argIdx].equals("-ww")) {
                if (++argIdx >= args.length) continue;
                ww = Double.parseDouble(args[argIdx]);
                doWW = true;
                continue;
            }
            if (args[argIdx].equals("-wl")) {
                if (++argIdx >= args.length) continue;
                wl = Double.parseDouble(args[argIdx]);
                doWL = true;
                continue;
            }
            inputImgs = args[argIdx];
        }
        if (inputImgs != null) {
            XpMedicalImage[] imgs;
            if (verbose) {
                System.out.println("dicomexport: Loading DICOM images " + inputImgs);
            }
            if ((imgs = dicomexport.getImages(inputImgs)) != null) {
                XpImageViewport ivOffscreen = new XpImageViewport();
                ivOffscreen.setImages(imgs);
                boolean sequence = false;
                if (imgs.length > 1) {
                    sequence = true;
                }
                for (int i = 0; i < imgs.length; ++i) {
                    ivOffscreen.setFrameIndex(i);
                    double setww = ivOffscreen.getImageRenderAttributes().getWindowWidth();
                    double setwl = ivOffscreen.getImageRenderAttributes().getWindowLevel();
                    if (doWW) {
                        setww = ww;
                    }
                    if (doWL) {
                        setwl = wl;
                    }
                    ivOffscreen.setWindowing(setww, setwl);
                    ivOffscreen.setZoom(zoom);
                    if (jpegexport != null) {
                        if (verbose) {
                            System.out.println("dicomexport: Exporting to jpg " + jpegexport);
                        }
                        String saveName = jpegexport;
                        if (sequence) {
                            saveName = saveName + i + ".jpg";
                        }
                        cs.saveJPEG(ivOffscreen, cols, rows, saveName);
                    }
                    if (pngexport == null) continue;
                    if (verbose) {
                        System.out.println("dicomexport: Exporting to png " + pngexport);
                    }
                    BufferedImage bi = cs.renderOffscreen(ivOffscreen, rows, cols, 0);
                    String saveName = pngexport;
                    if (sequence) {
                        saveName = saveName + i + ".png";
                    }
                    XpComponentSave.imageSave(bi, "png", saveName);
                }
            }
        }
        System.exit(0);
    }
}

