/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpRASAnnotation;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.marker.XpPointMarker;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Xp3DRoiVc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public abstract class XpMRCTApdAnnotationConfig
implements XpAnnotationConfig {
    private static final int MAX_ROI_RESULTS = 3;
    private static final String[] roiPropName = new String[]{"roiResult1", "roiResult2", "roiResult3"};
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");
    private static final String[] pads = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private Dimension size = new Dimension();
    private CPoint disp_pt = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private CPoint[] cornerPts = new CPoint[4];
    private String[] roiStat = new String[3];
    private XpRASAnnotation rasAnno = new XpRASAnnotation();

    public XpMRCTApdAnnotationConfig() {
        for (int i = 0; i < this.cornerPts.length; ++i) {
            this.cornerPts[i] = new CPoint(2);
        }
    }

    private void clipImagePoint(CPoint pt, int w, int h) {
        if (pt.x < 0.0) {
            pt.x = 0.0;
        } else if (pt.x > (double)w) {
            pt.x = w;
        }
        if (pt.y < 0.0) {
            pt.y = 0.0;
        } else if (pt.y > (double)h) {
            pt.y = h;
        }
    }

    protected void setRASCorners(XpAnnotationVc avc, XpVisualComponent viewport) {
        XpAnnotationModel am = avc.getAnnotationModel();
        if (am == null) {
            return;
        }
        CTransform tir = viewport.getTransform((byte)0, (byte)2);
        CTransform tdi = viewport.getTransform((byte)1, (byte)0);
        String rasSouth = null;
        String rasNorth = null;
        String rasEast = null;
        String rasWest = null;
        if (tir != null && tdi != null) {
            XpSlice slice;
            viewport.getSize(this.size);
            int w = this.size.width;
            int h = this.size.height;
            int iw = 0;
            int ih = 0;
            FrameOwner fowner = (FrameOwner)((Object)viewport);
            XpImage img = fowner.getFrame();
            if (img != null && (slice = img.getSlice()) != null) {
                iw = slice.width;
                ih = slice.height;
            }
            this.disp_pt.setLocation(0.0, 0.0, 0.0);
            tdi.transform(this.disp_pt, this.img_pt);
            this.clipImagePoint(this.img_pt, iw, ih);
            tir.transform(this.img_pt, this.cornerPts[0]);
            this.disp_pt.setLocation(w, 0.0, 0.0);
            tdi.transform(this.disp_pt, this.img_pt);
            this.clipImagePoint(this.img_pt, iw, ih);
            tir.transform(this.img_pt, this.cornerPts[1]);
            this.disp_pt.setLocation(w, h, 0.0);
            tdi.transform(this.disp_pt, this.img_pt);
            this.clipImagePoint(this.img_pt, iw, ih);
            tir.transform(this.img_pt, this.cornerPts[2]);
            this.rasAnno.set(this.cornerPts[0], this.cornerPts[1], this.cornerPts[2]);
            rasNorth = this.rasAnno.getNorth();
            rasSouth = this.rasAnno.getSouth();
            rasEast = this.rasAnno.getEast();
            rasWest = this.rasAnno.getWest();
        }
        am.setProperty("rasSouth", rasSouth);
        am.setProperty("rasNorth", rasNorth);
        am.setProperty("rasEast", rasEast);
        am.setProperty("rasWest", rasWest);
    }

    protected void setRenderAttributes(XpAnnotationVc avc, XpImageRenderAttributesOwner iraOwner) {
        XpAnnotationModel am = avc.getAnnotationModel();
        XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
        if (am != null && ira != null) {
            long ww = (long)ira.getWindowWidth();
            long wl = (long)ira.getWindowLevel();
            double zoom = ira.getZoom();
            IndexColorModel icm = ira.getColormap();
            List ops = ira.getImageOperations();
            boolean setGSE = false;
            am.setProperty("windowWidth", (int)ww);
            am.setProperty("windowLevel", (int)wl);
            am.setProperty("zoomFactor", zoom);
            am.setProperty("currentFilterDescription", "   ");
            am.setProperty("stretchDescription", "   ");
            if (icm != null) {
                String ctableName = "" + icm;
                if (ctableName.indexOf("g1") != -1 || ctableName.indexOf("g2") != -1 || ctableName.indexOf("g3") != -1) {
                    setGSE = true;
                }
                if (setGSE) {
                    am.setProperty("stretchDescription", ctableName);
                }
            }
            if (ops != null) {
                int len = ops.size();
                String filters = null;
                for (int i = 0; i < len; ++i) {
                    XpImageOp iop = (XpImageOp)ops.get(i);
                    filters = i == 0 ? "" + iop.getImageOpName() : " " + iop.getImageOpName();
                }
                if (filters != null) {
                    am.setProperty("currentFilterDescription", filters);
                }
            }
        }
    }

    protected void setROIInfo(XpAnnotationVc avc, JComponent jc) {
        int i;
        XpAnnotationModel am = avc.getAnnotationModel();
        if (am == null) {
            return;
        }
        int nroi = 0;
        int childCount = jc.getComponentCount();
        for (i = 0; i < childCount; ++i) {
            Component c = jc.getComponent(i);
            if (c instanceof XpImageRoiVc && XpStatisticsRoi.isShowStatistics() || c instanceof InfoLabelReporter) {
                String label = null;
                if (c instanceof Xp3DRoiVc) {
                    Xp3DRoiVc x3dvc = (Xp3DRoiVc)c;
                    if (x3dvc.isRoiVisible()) {
                        label = x3dvc.getInfoLabel();
                    }
                } else if (c instanceof InfoLabelReporter) {
                    label = ((InfoLabelReporter)((Object)c)).getInfoLabel();
                } else {
                    RoiActor ra;
                    XpImageRoiVc rvc = (XpImageRoiVc)c;
                    if (rvc.isVisible() && (ra = rvc.getRoiActor()) instanceof InfoLabelReporter) {
                        InfoLabelReporter ilr = (InfoLabelReporter)((Object)ra);
                        label = ilr.getInfoLabel();
                    }
                }
                if (label == null) continue;
                this.roiStat[nroi] = label;
                if (++nroi < 3) continue;
                break;
            }
            if (!(c instanceof XpPointMarker)) continue;
            XpPointMarker pm = (XpPointMarker)c;
            CPoint cp = pm.getRAS();
            double value = pm.getValue();
            String R2 = "R ";
            String A2 = "A ";
            String S2 = "S ";
            String V = "V = ";
            double r = cp.x;
            double a = cp.y;
            double s = cp.z;
            if (r < 0.0) {
                r = -r;
                R2 = "L ";
            }
            if (a < 0.0) {
                a = -a;
                A2 = "P ";
            }
            if (s < 0.0) {
                s = -s;
                S2 = "I ";
            }
            R2 = R2 + rasf.format(r) + "mm";
            A2 = A2 + rasf.format(a) + "mm";
            S2 = S2 + rasf.format(s) + "mm";
            V = V + rasf.format(value);
            int rlen = R2.length();
            int alen = A2.length();
            int slen = S2.length();
            int vlen = V.length();
            int max = Math.max(rlen, alen);
            max = Math.max(max, slen);
            if ((max = Math.max(max, vlen)) > rlen) {
                R2 = R2 + pads[max - rlen];
            }
            if (max > alen) {
                A2 = A2 + pads[max - alen];
            }
            if (max > slen) {
                S2 = S2 + pads[max - slen];
            }
            if (max > vlen) {
                V = V + pads[max - vlen];
            }
            am.setProperty("reportPixel_R", R2);
            am.setProperty("reportPixel_A", A2);
            am.setProperty("reportPixel_S", S2);
            am.setProperty("reportPixel_V", V);
        }
        if (nroi > 0) {
            for (i = 0; i < nroi; ++i) {
                am.setProperty(roiPropName[i], this.roiStat[i]);
            }
        }
        for (i = nroi; i < 3; ++i) {
            am.setProperty(roiPropName[i], "");
        }
    }

    @Override
    public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
        XpAnnotationModel am = avc.getAnnotationModel();
        XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
        XpImage2DVc viewport = mivc.getImageVc();
        if (am == null) {
            return;
        }
        this.setRASCorners(avc, mivc);
        this.setRenderAttributes(avc, mivc);
        XpImageOrientation ior = mivc.getDisplayOrientation();
        if (ior != null) {
            String iorStr = ior.toString();
            am.setProperty("currentOrientation", iorStr);
        }
        this.setROIInfo(avc, viewport);
    }

    private static class WLAnnotHandler
    extends SliderAnnotHandler {
        public WLAnnotHandler() {
            super("Window level", 10, 4096, 1000);
            this.setSliderChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    int value = slider.getValue();
                    if (WLAnnotHandler.this.mivc != null) {
                        XpImageRenderAttributes ira = WLAnnotHandler.this.mivc.getImageRenderAttributes();
                        ira.setWindowLevel(value);
                        WLAnnotHandler.this.mivc.setImageRenderAttributes(ira);
                        WLAnnotHandler.this.mivc.repaint();
                    }
                }
            });
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            XpAnnotationVc avc = (XpAnnotationVc)e.getSource();
            this.mivc = (XpMedicalImage2DVc)avc.getParent();
            XpImageRenderAttributes ira = this.mivc.getImageRenderAttributes();
            int value = (int)ira.getWindowLevel();
            this.slider.setValue(value);
            this.jpm.show(avc, x - 25, y - 50);
        }
    }

    private static class WWAnnotHandler
    extends SliderAnnotHandler {
        public WWAnnotHandler() {
            super("Window width", 10, 4096, 1000);
            this.setSliderChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    int value = slider.getValue();
                    if (WWAnnotHandler.this.mivc != null) {
                        XpImageRenderAttributes ira = WWAnnotHandler.this.mivc.getImageRenderAttributes();
                        ira.setWindowWidth(value);
                        WWAnnotHandler.this.mivc.setImageRenderAttributes(ira);
                        WWAnnotHandler.this.mivc.repaint();
                    }
                }
            });
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            XpAnnotationVc avc = (XpAnnotationVc)e.getSource();
            this.mivc = (XpMedicalImage2DVc)avc.getParent();
            XpImageRenderAttributes ira = this.mivc.getImageRenderAttributes();
            int value = (int)ira.getWindowWidth();
            this.slider.setValue(value);
            this.jpm.show(avc, x - 25, y - 50);
        }
    }

    private static class MagAnnotHandler
    extends SliderAnnotHandler {
        private static final int MAX = 21;
        private static final int MIN = 1;

        public MagAnnotHandler() {
            super("Magnification", 1, 21, 11);
            this.setSliderChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    int value = slider.getValue();
                    if (MagAnnotHandler.this.mivc != null) {
                        XpImageRenderAttributes ira = MagAnnotHandler.this.mivc.getImageRenderAttributes();
                        int mid = 11;
                        double zoom = (double)value / (double)mid;
                        ira.setZoom(zoom);
                        MagAnnotHandler.this.mivc.setImageRenderAttributes(ira);
                        MagAnnotHandler.this.mivc.repaint();
                    }
                }
            });
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            XpAnnotationVc avc = (XpAnnotationVc)e.getSource();
            this.mivc = (XpMedicalImage2DVc)avc.getParent();
            XpImageRenderAttributes ira = this.mivc.getImageRenderAttributes();
            int mid = 11;
            int value = (int)(ira.getZoom() * (double)mid);
            if (value < 1) {
                value = 1;
            }
            if (value > 21) {
                value = 21;
            }
            this.slider.setValue(value);
            this.jpm.show(avc, x, y - 50);
        }
    }

    private static class SliderAnnotHandler
    extends ActiveAnnotHandler {
        private static Dimension pdim = new Dimension(20, 100);
        protected JPopupMenu jpm = null;
        protected JSlider slider = null;
        protected XpMedicalImage2DVc mivc = null;

        public SliderAnnotHandler(String title, int min, int max, int value) {
            this.jpm = new JPopupMenu(title);
            this.slider = new JSlider(1, min, max, value);
            this.slider.setPaintLabels(true);
            this.slider.setPaintTrack(true);
            this.slider.setPreferredSize(pdim);
            this.jpm.add(this.slider);
        }

        protected void setSliderChangeListener(ChangeListener cl) {
            this.slider.addChangeListener(cl);
        }
    }

    private static abstract class ActiveAnnotHandler
    extends MouseInputAdapter
    implements MouseInputListener {
        private ActiveAnnotHandler() {
        }
    }

    public static class PETFull
    extends XpMRCTApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am = avc.getAnnotationModel();
            if (am == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpDicomElement wwwlUnits = new XpDicomElement(84, 4097);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(wwwlUnits);
            }
            this.setRASCorners(avc, vc);
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setROIInfo(avc, viewport);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                double wMax = 0.0;
                double wMin = 0.0;
                String windowingUnits = wwwlUnits.getStringValue();
                if (windowingUnits != null && windowingUnits.compareTo("BQML") == 0) {
                    wMax = ira.getWindowMax() / 1000.0;
                    wMin = ira.getWindowMin() / 1000.0;
                } else {
                    wMax = ira.getWindowMax();
                    wMin = ira.getWindowMin();
                }
                double zoom = ira.getZoom();
                if (jc instanceof XpMedicalImage2DVc) {
                    XpMedicalImage2DVc mivc1 = (XpMedicalImage2DVc)jc;
                    XpImageOrientation ior = mivc1.getDisplayOrientation();
                    String iorStr = "" + ior;
                    am.setProperty("currentOrientation", iorStr);
                }
                am.setProperty("windowMin", wMin);
                am.setProperty("windowMax", wMax);
                am.setProperty("zoomFactor", zoom);
            }
        }
    }

    public static class CTScout
    extends XpMRCTApdAnnotationConfig {
    }

    public static class CT
    extends XpMRCTApdAnnotationConfig {
    }

    public static class MR
    extends XpMRCTApdAnnotationConfig {
    }
}

