/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class XpAnnotationManager {
    private static String[] tags = null;
    private static String[] loadTags = null;
    private static String annotationType;
    private static String defaultGenerator;

    private static void createDefaultTags() {
        tags = new String[28];
        XpAnnotationManager.tags[0] = "8,22";
        XpAnnotationManager.tags[1] = "8,24";
        XpAnnotationManager.tags[2] = "32,14";
        XpAnnotationManager.tags[3] = "32,17";
        XpAnnotationManager.tags[4] = "32,19";
        XpAnnotationManager.tags[5] = "32,50";
        XpAnnotationManager.tags[6] = "32,55";
        XpAnnotationManager.tags[7] = "40,48";
        XpAnnotationManager.tags[8] = "40,16";
        XpAnnotationManager.tags[9] = "40,17";
        XpAnnotationManager.tags[10] = "40,4176";
        XpAnnotationManager.tags[11] = "40,4177";
        XpAnnotationManager.tags[12] = "40,4178";
        XpAnnotationManager.tags[13] = "40,4179";
        XpAnnotationManager.tags[14] = "16,4144";
        XpAnnotationManager.tags[15] = "16,4112";
        XpAnnotationManager.tags[16] = "16,64";
        XpAnnotationManager.tags[17] = "8,96";
        XpAnnotationManager.tags[18] = "8,50";
        XpAnnotationManager.tags[19] = "8,48";
        XpAnnotationManager.tags[20] = "8,4144";
        XpAnnotationManager.tags[21] = "8,4112";
        XpAnnotationManager.tags[22] = "8,4240";
        XpAnnotationManager.tags[23] = "8,32";
        XpAnnotationManager.tags[24] = "8,34";
        XpAnnotationManager.tags[25] = "8,8";
        XpAnnotationManager.tags[26] = "25,4134";
        XpAnnotationManager.tags[27] = "40,12288";
    }

    public static String[] getDefaultTags() {
        if (tags == null) {
            XpAnnotationManager.createDefaultTags();
        }
        return tags;
    }

    public static XpAnnotationGenerator create(String className) {
        XpAnnotationGenerator ag;
        block12: {
            ag = null;
            try {
                Class<?> cl = Class.forName(className);
                if (cl != null) {
                    Class<XpAnnotationGenerator> baseClass = XpAnnotationGenerator.class;
                }
                if (cl == null) break block12;
                try {
                    Class<?>[] paramType = null;
                    Constructor<?> c = cl.getConstructor(paramType);
                    if (c != null) {
                        Object[] args = null;
                        ag = (XpAnnotationGenerator)c.newInstance(args);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    nsme.printStackTrace();
                    XpLog.logger().warning(nsme.getMessage());
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                    XpLog.logger().warning(ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                    XpLog.logger().warning(iae.getMessage());
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                    XpLog.logger().warning(ie.getMessage());
                }
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                XpLog.logger().warning(ex.getMessage());
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
                XpLog.logger().warning(ex.getMessage());
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                XpLog.logger().warning(ex.getMessage());
            }
        }
        if (ag == null) {
            XpLog.logger().warning("Error loading annotation generator " + className);
        }
        return ag;
    }

    public static XpAnnotationGenerator getDefaultGenerator() {
        String className = XpPropertiesManager.getProperty("jami.annotation", defaultGenerator);
        XpAnnotationGenerator ag = XpAnnotationManager.create(className);
        String clName = ag != null ? ag.getClass().toString() : "null";
        XpLog.logger().config("Using annotation generator=" + clName);
        return ag;
    }

    public static String[] getNeededTags(String modalityHint, String imgType) {
        XpAnnotationGenerator ag;
        if (loadTags == null && (ag = XpAnnotationManager.getDefaultGenerator()) != null) {
            loadTags = ag.getNeededTags(modalityHint, imgType);
        }
        return loadTags;
    }

    static {
        defaultGenerator = "com.ge.med.terra.jami.toolkit.annotation.XpApdAnnotationGenerator";
    }
}

