/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.Capable;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.DelayedPrintCapable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.PaintStatCapable;
import com.ge.med.idc.XjLoader;
import com.ge.med.terra.jami.PaintListener;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.filter.XpMultiImageOp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class XpViewport
extends JPanel
implements AnnotCapable,
PaintStatCapable,
DelayedPrintCapable,
Replicable {
    private static long portIdCnt = 100L;
    private long _paintCount = 0L;
    private boolean autoRepaint = true;
    private long _repaintCount = 0L;
    private long portId = portIdCnt++;
    private List plList = new ArrayList();
    private boolean hasPaintListeners = false;
    private String lang = "en";

    @Override
    public String getAnnotationGroup() {
        return null;
    }

    @Override
    public Map<String, Boolean> getAnnotationItemStates() {
        return null;
    }

    public XpViewport() {
        this.setBackground(Color.black);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, Object propagationId) {
        PropertyChangeListener[] pcls = this.getPropertyChangeListeners(propertyName);
        if (pcls != null) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            pce.setPropagationId(propagationId);
            for (int i = 0; i < pcls.length; ++i) {
                pcls[i].propertyChange(pce);
            }
        }
    }

    @Override
    public Capable getCapable(String capableIFName) {
        try {
            Class<?> cap = this.getClass();
            Class<?> cl = Class.forName(capableIFName);
            if (cl.isAssignableFrom(cap) && cl.isInstance(this)) {
                return this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public final long getPortId() {
        return this.portId;
    }

    @Override
    public final boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
    }

    public abstract void refreshContents();

    public abstract XpMedicalImage[] getImages();

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ++this._paintCount;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.hasPaintListeners) {
            int len = this.plList.size();
            for (int i = 0; i < len; ++i) {
                PaintListener pl = (PaintListener)this.plList.get(i);
                if (pl == null) continue;
                pl.paintComplete(this);
            }
        }
    }

    @Override
    public long getPaintCount() {
        return this._paintCount;
    }

    protected void addContainedRootVcs(ArrayList list, Component c, Class cl) {
        if (cl.isInstance(c)) {
            list.add(c);
            return;
        }
        if (c instanceof Container) {
            Component[] children = ((Container)c).getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addContainedRootVcs(list, children[i], cl);
            }
        }
    }

    public final Iterator getVcIterator(Class cl) {
        ArrayList sceneList = new ArrayList();
        this.addContainedRootVcs(sceneList, this, cl);
        return sceneList.iterator();
    }

    @Override
    public String[] getAnnotationGroups() {
        return null;
    }

    @Override
    public String[] getAnnotationItems() {
        return null;
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        return null;
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
    }

    @Override
    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        return false;
    }

    @Override
    public void setAnnotationVisible(boolean annotVisible) {
    }

    @Override
    public boolean isAnnotationVisible() {
        return false;
    }

    @Override
    public void setAnnotationGenerator(Class ag, Properties prop) {
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        return null;
    }

    @Override
    public void setAnnotationColor(Color c) {
    }

    @Override
    public Color getAnnotationColor() {
        return null;
    }

    public final void setAnnotationLanguage(String lang) {
        this.lang = lang;
        this.applyAnnotationLanguage(lang);
    }

    public final String getAnnotationLanguage() {
        return this.lang;
    }

    protected void applyAnnotationLanguage(String lang) {
    }

    public void setComponentCreator(ComponentCreator rc) {
        throw new UnsupportedOperationException("Method setComponentCreator() not yet implemented.");
    }

    public void dispose() {
    }

    public void clearGraphics() {
    }

    public final long getRepaintCount() {
        return this._repaintCount;
    }

    public final void request_repaint() {
        this.repaint();
        ++this._repaintCount;
    }

    public final void auto_repaint() {
        if (this.autoRepaint) {
            this.request_repaint();
        }
    }

    @Override
    public Object clone() {
        return null;
    }

    public abstract XpImage getImageAt(int var1);

    @Override
    public Printable getPrintable() {
        XpViewport vpClone = (XpViewport)this.clone();
        if (vpClone != null) {
            return new VpDicomPrintable(vpClone);
        }
        return null;
    }

    public final void addPaintListener(PaintListener pl) {
        this.plList.add(pl);
        this.hasPaintListeners = true;
    }

    public final void removePaintListener(PaintListener pl) {
        this.plList.remove(pl);
        if (this.plList.size() <= 0) {
            this.hasPaintListeners = false;
        }
    }

    static {
        XjLoader.initialize();
        if (XpPropertiesManager.getProperty("jami.verbose") != null) {
            XpPropertiesManager.printProperties();
        }
    }

    protected static class MultiImageOpImage
    implements XpImage {
        private XpMultiImageOp miop = null;
        private int imageIndex = -1;

        public MultiImageOpImage(XpMultiImageOp miop, int index) {
            this.miop = miop;
            this.imageIndex = index;
        }

        @Override
        public RenderedImage getPixelData() {
            XpImage frame = this.miop.getFrame(this.imageIndex);
            return frame.getPixelData();
        }

        @Override
        public double getPixelDimensionX() {
            return this.miop.getFrame(this.imageIndex).getPixelDimensionX();
        }

        @Override
        public double getPixelDimensionY() {
            return this.miop.getFrame(this.imageIndex).getPixelDimensionY();
        }

        @Override
        public XpSlice getSlice() {
            return this.miop.getFrame(this.imageIndex).getSlice();
        }

        @Override
        public double getDefaultWindowWidth() {
            return this.miop.getFrame(this.imageIndex).getDefaultWindowWidth();
        }

        @Override
        public double getDefaultWindowLevel() {
            return this.miop.getFrame(this.imageIndex).getDefaultWindowLevel();
        }

        @Override
        public double getRescaleIntercept() {
            return this.miop.getFrame(this.imageIndex).getRescaleIntercept();
        }

        @Override
        public double getRescaleSlope() {
            return this.miop.getFrame(this.imageIndex).getRescaleSlope();
        }

        @Override
        public double getAzimuth() {
            return this.miop.getFrame(this.imageIndex).getAzimuth();
        }
    }

    private static class VpDicomPrintable
    implements DicomPrintable {
        private XpViewport vp = null;
        private XpComponentSave cs = new XpComponentSave();

        public VpDicomPrintable(XpViewport vp) {
            this.vp = vp;
        }

        @Override
        public String getESIString() {
            return null;
        }

        @Override
        public String getOriginalImagePath() {
            return null;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 0) {
                return 1;
            }
            int w = (int)pageFormat.getImageableWidth();
            int h = (int)pageFormat.getImageableHeight();
            int x = (int)pageFormat.getImageableX();
            int y = (int)pageFormat.getImageableY();
            int vp_w = this.vp.getWidth();
            int vp_h = this.vp.getHeight();
            double ratio = (double)vp_w / (double)vp_h;
            double nw = (double)h * ratio;
            double nh = (double)w / ratio;
            int center_x = 0;
            if (nw <= (double)w && nw < (double)h) {
                center_x = (int)(((double)w - nw) * 0.5);
                w = (int)nw;
            } else {
                h = (int)nh;
            }
            Graphics2D g2 = (Graphics2D)graphics;
            BufferedImage bi = this.cs.renderOffscreen(this.vp, w, h, 4);
            g2.translate(x + center_x, y);
            g2.drawImage((Image)bi, 0, 0, null);
            return 0;
        }
    }

    public static class JamiIndexColorModel
    extends IndexColorModel {
        private int hash = 0;

        public JamiIndexColorModel(int[] cMap) {
            super(16, cMap.length, cMap, 0, false, -1, 1);
            int first = cMap[0];
            int last = cMap[cMap.length - 1];
            this.hash = Arrays.hashCode(cMap) + first + last;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JamiIndexColorModel other = (JamiIndexColorModel)obj;
            return this.hash == other.hash;
        }
    }

    protected static class IntValueDispatcher
    implements Runnable {
        private int newVal = Integer.MIN_VALUE;
        private String propName = null;
        private JComponent jc = null;

        public IntValueDispatcher(String propName) {
            this.propName = propName;
        }

        public void setValues(JComponent jc, int newVal) {
            this.newVal = newVal;
            this.jc = jc;
        }

        @Override
        public void run() {
            if (this.jc != null) {
                this.jc.firePropertyChange(this.propName, Integer.MIN_VALUE, this.newVal);
                this.jc = null;
            }
        }
    }
}

