/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVcFactory;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XpVcCreationDirector
extends JPanel
implements XpViewportDirector,
DragSourceListener,
DragGestureListener {
    private Vector viewports = new Vector();
    private HashMap factories = new HashMap();
    private GridLayout gridLayout = new GridLayout();

    public XpVcCreationDirector() {
        this.gridLayout.setColumns(2);
        this.setLayout(this.gridLayout);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, this);
    }

    public void addFactory(JComponent source, XpVcFactory f) {
        source.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)source, null);
        this.gridLayout.setRows((this.getComponentCount() + 1) / this.gridLayout.getColumns());
        this.factories.put(source, f);
    }

    public void addFactory(String name, XpVcFactory f) {
        this.addFactory(new JLabel(name), f);
    }

    public void removeFactory(JComponent source) {
        this.factories.remove(source);
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        this.viewports.add(viewport);
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        this.viewports.remove(viewport);
    }

    @Override
    public void disconnectAllViewports() {
        Iterator i = this.viewports.iterator();
        while (i.hasNext()) {
            this.disconnectViewport((XpViewport)i.next());
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        Component c;
        XpVcFactory f;
        if (this == event.getComponent() && (f = (XpVcFactory)this.factories.get(c = this.getComponentAt(event.getDragOrigin()))) != null) {
            DragSource.getDefaultDragSource().startDrag(event, DragSource.DefaultMoveDrop, f, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        XpLog.logger().finest("source dragDropEnd: " + event.getDropSuccess());
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
        XpLog.logger().finest("source dragEnter");
    }

    @Override
    public void dragExit(DragSourceEvent event) {
        XpLog.logger().finest("source dragExit: " + event.getDragSourceContext().getComponent());
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        XpLog.logger().finest("source dragOver");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
        XpLog.logger().finest("source dropActionChanged");
    }
}

