/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CPISerializable;
import com.ge.med.terra.jami.capable.Replicable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpTickMarkRuler
extends XpVisualComponent
implements Replicable,
CPISerializable {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int orientation;
    private XpImage prevImage;
    private Rectangle r;
    private DecimalFormat df;
    private int tickFreq = 5;
    private int tickLength = 5;
    private double tickSpacing = 10.0;
    private int margin = 30;
    private CTransform imgDispTrans = null;
    private CPoint borderPt = new CPoint(0);
    private CPoint borderPt1 = new CPoint(0);
    private CPoint centerImagePoint = new CPoint(0);
    private CPoint oneImageTick = new CPoint(0);
    private CPoint centerPoint = new CPoint(0);
    private CPoint oneTick = new CPoint(0);

    public XpTickMarkRuler(int orientation) {
        this.orientation = orientation;
        this.prevImage = null;
        this.r = new Rectangle();
        this.df = new DecimalFormat("###0.##");
        this.setForeground(Color.orange);
    }

    @Override
    public Object clone() {
        XpTickMarkRuler ccr = new XpTickMarkRuler(this.orientation);
        this.copyObject(ccr);
        return ccr;
    }

    protected void copyObject(Object o) {
        XpTickMarkRuler is = (XpTickMarkRuler)o;
        is.orientation = this.orientation;
        is.r = (Rectangle)this.r.clone();
        is.df = new DecimalFormat("###0.##");
    }

    public XpTickMarkRuler(int orientation, int atickFreq, int atickLength, int atickSpacing, int amargin) {
        this.orientation = 1;
        this.prevImage = null;
        this.r = new Rectangle();
        this.df = new DecimalFormat("###0.##");
        this.setForeground(Color.orange);
        this.tickFreq = atickFreq;
        this.tickLength = atickLength;
        this.tickSpacing = atickSpacing;
        this.margin = amargin;
        this.orientation = orientation;
    }

    @Override
    public final boolean contains(int x, int y) {
        return this.r.contains(x, y);
    }

    protected final void line(Graphics g, int x1, int y1, int x2, int y2) {
        g.setColor(Color.black);
        g.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
        Color foreground = this.getForeground();
        g.setColor(foreground);
        g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle vp = this.getBounds();
        boolean updateInfo = false;
        double pixX = 1.0;
        double pixY = 1.0;
        Container c = this.getParent();
        if (c instanceof XpImage2DVc) {
            XpImage2DVc mivc = (XpImage2DVc)c;
            XpImage img = mivc.getFrame();
            if (img != null) {
                pixX = img.getPixelDimensionX();
                pixY = img.getPixelDimensionY();
            } else {
                pixY = 1.0;
                pixX = 1.0;
            }
            if (this.prevImage != img) {
                updateInfo = true;
                this.prevImage = img;
            }
        } else {
            XpLog.logger().warning("Parent container is not a XpImage2DVc.");
        }
        if (this.orientation == 0) {
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.oneImageTick.setLocation(this.tickSpacing / pixY, 0.0, 0.0);
            if (this.imgDispTrans == null) {
                this.imgDispTrans = this.getTransform((byte)0, (byte)1);
            }
            this.imgDispTrans.transform(this.centerImagePoint, this.centerPoint);
            this.imgDispTrans.transform(this.oneImageTick, this.oneTick);
            double cmHeight = Math.sqrt(this.square(this.oneTick.x - this.centerPoint.x) + this.square(this.oneTick.y - this.centerPoint.y));
            double maxHeight = (double)vp.height / 3.0;
            int nbOfCm = cmHeight > 0.0 ? (int)(maxHeight / cmHeight) : 1;
            double x = vp.width - this.margin;
            double ymargin = ((double)vp.height - (double)nbOfCm * cmHeight) / 2.0;
            int i = 0;
            double y1 = 0.0;
            double y2 = 0.0;
            for (i = 0; i < nbOfCm; ++i) {
                y1 = (double)i * cmHeight + ymargin;
                y2 = y1 + cmHeight;
                if (i == 0) {
                    this.borderPt.setLocation(x, y1, 0.0);
                }
                this.line(g, (int)x - this.getTickLength(i), (int)y1, (int)x, (int)y1);
                if (i == nbOfCm - 1) {
                    this.borderPt1.setLocation(x, y2, 0.0);
                }
                this.line(g, (int)x, (int)y2, (int)x - this.getTickLength(i + 1), (int)y2);
            }
            this.line(g, (int)this.borderPt.x, (int)this.borderPt.y, (int)this.borderPt1.x, (int)this.borderPt1.y);
        } else if (this.orientation == 1) {
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.oneImageTick.setLocation(this.tickSpacing / pixX, 0.0, 0.0);
            if (this.imgDispTrans == null) {
                this.imgDispTrans = this.getTransform((byte)0, (byte)1);
            }
            this.imgDispTrans.transform(this.centerImagePoint, this.centerPoint);
            this.imgDispTrans.transform(this.oneImageTick, this.oneTick);
            double maxWidth = (double)vp.width / 2.0;
            double cmWidth = Math.sqrt(this.square(this.oneTick.x - this.centerPoint.x) + this.square(this.oneTick.y - this.centerPoint.y));
            int nbOfCm = cmWidth > 0.0 ? (int)(maxWidth / cmWidth) : 1;
            double xmargin = ((double)vp.width - (double)nbOfCm * cmWidth) / 2.0;
            int i = 0;
            double y = vp.height - this.margin;
            for (i = 0; i < nbOfCm; ++i) {
                double x1 = (double)i * cmWidth + xmargin;
                double x2 = x1 + cmWidth;
                if (i == 0) {
                    this.borderPt.setLocation(x1, y, 0.0);
                }
                this.line(g, (int)x1, (int)(y - (double)this.getTickLength(i)), (int)x1, (int)y);
                if (i == nbOfCm - 1) {
                    this.borderPt1.setLocation(x2, y, 0.0);
                }
                this.line(g, (int)x2, (int)y, (int)x2, (int)y - this.getTickLength(i + 1));
            }
            this.line(g, (int)this.borderPt.x, (int)this.borderPt.y, (int)this.borderPt1.x, (int)this.borderPt1.y);
        }
    }

    private double square(double n) {
        return n * n;
    }

    public int getTickLength(int i) {
        if (i % this.tickFreq == 0) {
            return this.tickLength << 1;
        }
        return this.tickLength;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public String getCPIInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.getClass().getName() + " orientation=\"" + this.orientation + "\"" + " margin=\"" + this.margin + "\" tickFreq=\"" + this.tickFreq + "\"" + " df=\"" + this.df.toPattern() + "\" tickLength=\"" + this.tickLength + "\"" + " r.x=\"" + this.r.x + "\" r.y=\"" + this.r.y + "\"/>");
        return buf.toString();
    }

    public static XpTickMarkRuler createVC(String info) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(info)));
            Element elem = doc.getDocumentElement();
            int orientation = Integer.parseInt(elem.getAttribute("orientation"));
            XpTickMarkRuler ccr = new XpTickMarkRuler(orientation);
            ccr.orientation = orientation;
            ccr.r = new Rectangle();
            ccr.r.x = Integer.parseInt(elem.getAttribute("r.x"));
            ccr.r.x = Integer.parseInt(elem.getAttribute("r.y"));
            ccr.df = new DecimalFormat(elem.getAttribute("df"));
            ccr.margin = Integer.parseInt(elem.getAttribute("margin"));
            ccr.tickFreq = Integer.parseInt(elem.getAttribute("tickFreq"));
            ccr.tickLength = Integer.parseInt(elem.getAttribute("tickLength"));
            return ccr;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

