/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CPISerializable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpSliceCollection
extends XpVisualComponent
implements PropertyChangeListener,
Serializable,
CPISerializable {
    public static final String SLICENO = "SliceNo";
    private ArrayList slices = new ArrayList();
    private XpSlice imageSlice = null;
    private Point2D[] segments;
    private boolean invalid = true;
    private int index = 0;
    private CPoint imgPt = new CPoint(0);
    private CPoint dispPt = new CPoint(1);
    private Point dp1 = new Point();
    private Point dp2 = new Point();
    private String lineStyle = "DOTTED";
    private int oldValue = this.index;
    private Integer newIndex = new Integer("0");
    private int newValue = 0;
    private XpSliceCollection myComp;
    private AffineTransform inv = new AffineTransform();
    private XpGeomUtils gu = new XpGeomUtils();
    private int sliceIncrementer = 1;
    private int sliceStartindex = 0;
    private int numberingPos = 0;
    private Color choiceSelectedColor = Color.red;
    private Color choiceunSelectedColor = Color.cyan;

    public XpSliceCollection() {
        this.addMouseListener(new sliceMouseListener(this));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().compareTo("FrameIndex") == 0) {
            this.newIndex = (Integer)e.getNewValue();
            this.newValue = this.newIndex;
            this.repaint();
        }
    }

    public final XpSlice getImageSlice() {
        return this.imageSlice;
    }

    public void setImageSlice(XpSlice s) {
        this.imageSlice = s;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        XpVisualComponent parent = this.getXpVisualComponentParent();
        if (parent instanceof XpImage2DVc) {
            XpImage image = ((XpImage2DVc)parent).getFrame();
            if (image == null) {
                return;
            }
            XpSlice slice = image.getSlice();
            this.setImageSlice(slice);
        } else {
            this.setImageSlice(new XpSlice(new CPoint(-10.0, 0.0, -10.0, 2), new CPoint(10.0, 0.0, -10.0, 2), new CPoint(10.0, 0.0, 10.0, 2)));
        }
    }

    public void addSlice(XpSlice s) {
        this.slices.add(s);
        this.invalid = true;
    }

    public void removeAllSlices() {
        this.slices.clear();
    }

    public final int getNumberOfSlices() {
        return this.slices.size();
    }

    final void line(Graphics g, Point2D p0, Point2D p1, int offset) {
        g.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int i;
        Graphics2D g = (Graphics2D)graphics;
        CTransform t = this.getTransform((byte)0, (byte)1);
        if (t != null) {
            AffineTransform at = t.getTransform2D();
            this.gu.calcInverse(at, this.inv);
            g.transform(at);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.invalid && this.imageSlice != null) {
            if (this.slices.size() > 0) {
                this.segments = new Point2D[2 * this.slices.size()];
                for (i = 0; i < this.slices.size(); ++i) {
                    XpSlice s = (XpSlice)this.slices.get(i);
                    Point2D[] p = this.imageSlice.getIntersection(s);
                    this.segments[2 * i] = p[0];
                    this.segments[2 * i + 1] = p[1];
                }
            } else {
                this.segments = null;
            }
            this.invalid = false;
        }
        g.setColor(Color.black);
        if (this.segments != null) {
            for (i = this.sliceStartindex; i < this.slices.size(); i += this.sliceIncrementer) {
                if (this.lineStyle == null) continue;
                if (this.lineStyle.compareTo("SOLID") == 0) {
                    this.line(g, this.segments[2 * i], this.segments[2 * i + 1], 1);
                    continue;
                }
                if (this.lineStyle.compareTo("DOTTED") != 0) continue;
                this.drawDottedLine(g, this.segments[2 * i], this.segments[2 * i + 1], 1);
            }
            for (i = this.sliceStartindex; i < this.slices.size(); i += this.sliceIncrementer) {
                if (i == this.newValue) {
                    g.setColor(this.choiceSelectedColor);
                    this.drawsliceNumber(g, i, (int)this.segments[2 * i + this.numberingPos].getX(), (int)this.segments[2 * i + this.numberingPos].getY());
                    if (this.lineStyle != null) {
                        if (this.lineStyle.compareTo("SOLID") == 0) {
                            this.line(g, this.segments[2 * i], this.segments[2 * i + 1], 0);
                        } else if (this.lineStyle.compareTo("DOTTED") == 0) {
                            this.drawDottedLine(g, this.segments[2 * i], this.segments[2 * i + 1], 0);
                        }
                    }
                } else {
                    g.setColor(this.choiceunSelectedColor);
                    this.drawsliceNumber(g, i, (int)this.segments[2 * i + this.numberingPos].getX(), (int)this.segments[2 * i + this.numberingPos].getY());
                    if (this.lineStyle != null) {
                        if (this.lineStyle.compareTo("SOLID") == 0) {
                            this.line(g, this.segments[2 * i], this.segments[2 * i + 1], 0);
                        } else if (this.lineStyle.compareTo("DOTTED") == 0) {
                            this.drawDottedLine(g, this.segments[2 * i], this.segments[2 * i + 1], 0);
                        }
                    }
                }
                this.numberingPos = this.numberingPos == 0 ? 1 : 0;
            }
        }
        g.setTransform(this.inv);
    }

    public void drawsliceNumber(Graphics2D g, int index, int xPos, int yPos) {
        int fontStyle = Integer.parseInt(System.getProperty("jami.xpslicecollection.font.style", "5"));
        int fontSize = Integer.parseInt(System.getProperty("jami.xpslicecollection.font.size", "6"));
        g.setFont(new Font("", fontStyle, fontSize));
        g.drawString(String.valueOf(index), xPos, yPos);
    }

    public void drawDottedLine(Graphics2D g, Point2D p0, Point2D p1, int offset) {
        float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
        g.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
        g.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    @Override
    public boolean contains(int x, int y) {
        int x1 = x - 6;
        int x2 = x + 6;
        int y1 = y - 6;
        int y2 = y + 6;
        CTransform ctc = this.getTransform((byte)0, (byte)1);
        for (int i = this.sliceStartindex; i < this.slices.size(); i += this.sliceIncrementer) {
            if (this.segments == null) {
                return false;
            }
            this.imgPt.setPoint((int)this.segments[2 * i].getX(), (int)this.segments[2 * i].getY(), 0.0, (byte)0);
            ctc.transform(this.imgPt, this.dispPt);
            this.dp1.setLocation(this.dispPt.x, this.dispPt.y);
            this.imgPt.setPoint((int)this.segments[2 * i + 1].getX(), (int)this.segments[2 * i + 1].getY(), 0.0, (byte)0);
            ctc.transform(this.imgPt, this.dispPt);
            this.dp2.setLocation(this.dispPt.x, this.dispPt.y);
            if (!this.intersects(x1, y1, x2, y2, this.dp1.x, this.dp1.y, this.dp2.x, this.dp2.y)) continue;
            this.index = i;
            return true;
        }
        return false;
    }

    private boolean intersects(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int x43 = x4 - x3;
        int y13 = y1 - y3;
        int y43 = y4 - y3;
        int x13 = x1 - x3;
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int denom = y43 * x21 - x43 * y21;
        int n1 = x43 * y13 - y43 * x13;
        int n2 = x21 * y13 - y21 * x13;
        if (denom == 0 && (n1 == 0 || n2 == 0)) {
            return true;
        }
        if (denom == 0) {
            return false;
        }
        double ua = (double)n1 / (double)denom;
        double ub = (double)n2 / (double)denom;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }

    public void setlineStyle(String style) {
        this.lineStyle = style;
    }

    public void setSelectedlineColor(Color c) {
        this.choiceSelectedColor = c;
    }

    public void setUnSelectedlineColor(Color c) {
        this.choiceunSelectedColor = c;
    }

    public static final XpSliceCollection create(String cpiInfo) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(cpiInfo)));
            Element elem = doc.getDocumentElement();
            Color s = new Color(Integer.parseInt(elem.getAttribute("selectedLineColor")));
            Color u = new Color(Integer.parseInt(elem.getAttribute("unSelectedlineColor")));
            String ls = elem.getAttribute("lineStyle");
            XpSliceCollection sc = new XpSliceCollection();
            sc.setSelectedlineColor(s);
            sc.setUnSelectedlineColor(u);
            sc.setlineStyle(ls);
            return sc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getCPIInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.getClass().getName() + " selectedLineColor=\"" + this.choiceSelectedColor.getRGB() + "\"" + " unSelectedlineColor=\"" + this.choiceunSelectedColor.getRGB() + "\"" + " lineStyle=\"" + this.lineStyle + "\"/>");
        return buf.toString();
    }

    class sliceMouseListener
    implements MouseListener {
        public sliceMouseListener(XpSliceCollection outerComp) {
            XpSliceCollection.this.myComp = outerComp;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            XpSliceCollection.this.myComp.validate();
            XpSliceCollection.this.myComp.repaint();
            XpSliceCollection.this.newValue = XpSliceCollection.this.index;
            XpSliceCollection.this.firePropertyChange(XpSliceCollection.SLICENO, XpSliceCollection.this.oldValue, XpSliceCollection.this.newValue);
            XpSliceCollection.this.oldValue = XpSliceCollection.this.newValue;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

