/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjSlice;
import com.ge.med.idc.XjTagValue;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpSliceBase;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class XpSlice
extends XpSliceBase
implements XjSlice {
    public CPoint ul = new CPoint(2);
    public CPoint ur = new CPoint(2);
    public CPoint br = new CPoint(2);
    public CPoint bl = new CPoint(2);
    public CPoint I = new CPoint(2);
    public CPoint J = new CPoint(2);
    public CPoint N = new CPoint(2);
    public CTransform imageToRas = new CTransform();
    public CTransform rasToImage = new CTransform();
    public double pixelSizeX = 0.0;
    public double pixelSizeY = 0.0;
    public int width = 0;
    public int height = 0;
    private static final int ULHC = 0;
    private static final int URBRHC = 1;
    private static final int ROWS = 2;
    private static final int COLUMNS = 3;
    private static final int[] PIXEL_SPACING_GE = new int[]{40, 48};
    private static final int[] IMAGER_PIXEL_SPACING_GE = new int[]{24, 4452};
    private static final int[] NOMINNAL_SCANNER_PIXEL_SPACING_GE = new int[]{24, 8208};
    private XpDicomElement[] dcm = null;
    private CPoint OA = new CPoint();
    private CPoint OB = new CPoint();
    private CPoint OC = new CPoint();
    private CPoint OD = new CPoint();

    private XpSlice() {
        this.dcm = new XpDicomElement[4];
        this.dcm[0] = new XpDicomElement(32, 50);
        this.dcm[1] = new XpDicomElement(32, 55);
        this.dcm[2] = new XpDicomElement(40, 16);
        this.dcm[3] = new XpDicomElement(40, 17);
        this.pixelSizeY = 1.0;
        this.pixelSizeX = 1.0;
    }

    public XpSlice(CPoint ul, CPoint ur, CPoint br) {
        this(ul, ur, br, 2, 2);
    }

    public XpSlice(CPoint ul, CPoint ur, CPoint br, int width, int height) {
        this();
        this.bl = new CPoint(ur, br);
        this.bl.add(ul);
        this.width = width;
        this.height = height;
        double vx = ul.x - this.bl.x;
        double vy = ul.y - this.bl.y;
        double vz = ul.z - this.bl.z;
        double lv = Math.sqrt(vx * vx + vy * vy + vz * vz);
        this.pixelSizeY = lv / (double)(height - 1);
        double hx = ul.x - ur.x;
        double hy = ul.y - ur.y;
        double hz = ul.z - ur.z;
        double lh = Math.sqrt(hx * hx + hy * hy + hz * hz);
        this.pixelSizeX = lh / (double)(width - 1);
        this.setCorners(new CPoint(ul), new CPoint(ur), new CPoint(br));
    }

    public XpSlice(XpDicomObject image) {
        this();
        this.loadMedicalImage(image);
    }

    public XpSlice(int w, int h) {
        this();
        this.makeDefaultSlice(w, h, 0.0);
    }

    public XpSlice(XjDicomObject image) {
        this.loadXjImage(image);
    }

    private void makeDefaultSlice(int w, int h, double zval) {
        this.setCorners(new CPoint(0.0, 0.0, zval, 2), new CPoint(511.0, 0.0, zval, 2), new CPoint(511.0, 511.0, zval, 2));
        this.width = w;
        this.height = h;
        this.pixelSizeX = 1.0;
        this.pixelSizeY = 1.0;
    }

    public void loadMedicalImage(XpDicomObject image) {
        double[] pixelSpacing;
        double[] ulhc = null;
        double[] urbrhc = null;
        double[] spacing = null;
        if (0 != image.getValues(this.dcm)) {
            XpLog.logger().warning("Fields missing while loading XpDicomObject!!!!");
            int w = 0;
            int h = 0;
            try {
                Integer iW = new Integer("" + this.dcm[3].value);
                Integer iH = new Integer("" + this.dcm[2].value);
                w = iW;
                h = iH;
            }
            catch (NumberFormatException ex) {
                XpLog.logger().fine("Row/Column Info broken: cols=" + this.dcm[3].value + " rows=" + this.dcm[2].value);
            }
            if ((w == 0 || h == 0) && image instanceof XpImage) {
                w = ((XpImage)((Object)image)).getPixelData().getWidth();
                h = ((XpImage)((Object)image)).getPixelData().getHeight();
            }
            this.width = w;
            this.height = h;
            ulhc = new double[]{0.0, 0.0, 0.0};
            urbrhc = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        } else {
            ulhc = this.dcm[0].getDoubleArrayValue();
            urbrhc = this.dcm[1].getDoubleArrayValue();
            this.width = this.dcm[3].getIntValue();
            this.height = this.dcm[2].getIntValue();
        }
        XpDicomElement de1 = new XpDicomElement(PIXEL_SPACING_GE[0], PIXEL_SPACING_GE[1]);
        double[] dArray = pixelSpacing = image.getValue(de1) == 0 ? de1.getDoubleArrayValue() : null;
        if (pixelSpacing == null) {
            XpDicomElement de2 = new XpDicomElement(IMAGER_PIXEL_SPACING_GE[0], IMAGER_PIXEL_SPACING_GE[1]);
            double[] dArray2 = pixelSpacing = image.getValue(de2) == 0 ? de2.getDoubleArrayValue() : null;
        }
        if (pixelSpacing == null) {
            XpDicomElement de3 = new XpDicomElement(NOMINNAL_SCANNER_PIXEL_SPACING_GE[0], NOMINNAL_SCANNER_PIXEL_SPACING_GE[1]);
            pixelSpacing = image.getValue(de3) == 0 ? de3.getDoubleArrayValue() : null;
        }
        spacing = pixelSpacing == null ? new double[]{1.0, 1.0} : pixelSpacing;
        this.initSlice(ulhc, urbrhc, spacing);
    }

    private void initSlice(double[] ulhc, double[] urbrhc, double[] spacing) {
        CPoint dbr;
        CPoint dur;
        CPoint ul;
        if (ulhc == null || ulhc.length < 3 || urbrhc == null || urbrhc.length < 6) {
            ul = new CPoint();
            dur = new CPoint(1.0, 0.0, 0.0, 2);
            dbr = new CPoint(0.0, 1.0, 0.0, 2);
        } else {
            ul = new CPoint(ulhc, 2);
            ul.x *= -1.0;
            ul.y *= -1.0;
            dur = new CPoint(urbrhc, 2);
            dur.x *= -1.0;
            dur.y *= -1.0;
            double[] brhc = new double[3];
            System.arraycopy(urbrhc, 3, brhc, 0, 3);
            dbr = new CPoint(brhc, 2);
            dbr.x *= -1.0;
            dbr.y *= -1.0;
        }
        if (spacing == null || spacing.length < 2) {
            spacing = new double[2];
            spacing[1] = 1.0;
            spacing[0] = 1.0;
        }
        int W = this.width - 1;
        int H = this.height - 1;
        CPoint ur = new CPoint(dur);
        ur.multiplyBy(spacing[1] * (double)W);
        ur.add(ul);
        CPoint br = new CPoint(dbr);
        br.multiplyBy(spacing[0] * (double)H);
        br.add(ur);
        this.pixelSizeX = spacing[1];
        this.pixelSizeY = spacing[0];
        this.setCorners(ul, ur, br);
        if (spacing[0] > 0.0 && spacing[1] > 0.0) {
            this.pixelSizeX = spacing[1];
            this.pixelSizeY = spacing[0];
        }
    }

    private void setXjTag(XjTagValue value, int group, int element) {
        value.group = group;
        value.element = element;
    }

    private double[] getDoubleArrayValue(XjTagValue tag2) {
        String s = (String)tag2.value;
        return XpSlice.getDoubleArray(s);
    }

    private static double[] getDoubleArray(String s) {
        if (s != null) {
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s, " ,\\\t\n");
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            double[] result = new double[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                try {
                    result[i] = Double.parseDouble((String)l.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return result;
        }
        return null;
    }

    private int getIntValue(XjTagValue tag2) {
        Object value = tag2.value;
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void loadXjImage(XjDicomObject image) {
        double[] dArray;
        double[] pixelSpacing;
        XjTagValue[] dcm = new XjTagValue[4];
        for (int i = 0; i < dcm.length; ++i) {
            dcm[i] = new XjTagValue();
        }
        this.setXjTag(dcm[0], 32, 50);
        this.setXjTag(dcm[1], 32, 55);
        this.setXjTag(dcm[2], 40, 16);
        this.setXjTag(dcm[3], 40, 17);
        this.pixelSizeY = 1.0;
        this.pixelSizeX = 1.0;
        double[] ulhc = null;
        double[] urbrhc = null;
        double[] spacing = null;
        if (image.getValues(dcm) <= 0) {
            XpLog.logger().warning("Fields missing in XjDicomObject!");
            int w = 0;
            int h = 0;
            try {
                Integer iW = new Integer("" + dcm[3].value);
                Integer iH = new Integer("" + dcm[2].value);
                w = iW;
                h = iH;
            }
            catch (NumberFormatException ex) {
                XpLog.logger().fine("Row/Column Info broken: cols=" + dcm[3].value + " rows=" + dcm[2].value);
            }
            if ((w == 0 || h == 0) && image instanceof XpImage) {
                w = ((XpImage)((Object)image)).getPixelData().getWidth();
                h = ((XpImage)((Object)image)).getPixelData().getHeight();
            }
            this.width = w;
            this.height = h;
            ulhc = new double[]{0.0, 0.0, 0.0};
            urbrhc = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        } else {
            ulhc = this.getDoubleArrayValue(dcm[0]);
            urbrhc = this.getDoubleArrayValue(dcm[1]);
            this.width = this.getIntValue(dcm[3]);
            this.height = this.getIntValue(dcm[2]);
        }
        Object o1 = image.getValue(PIXEL_SPACING_GE[0], PIXEL_SPACING_GE[1]);
        double[] dArray2 = pixelSpacing = o1 != null ? XpSlice.getDoubleArray((String)o1) : null;
        if (pixelSpacing == null) {
            Object o2 = image.getValue(IMAGER_PIXEL_SPACING_GE[0], IMAGER_PIXEL_SPACING_GE[1]);
            double[] dArray3 = pixelSpacing = o2 != null ? XpSlice.getDoubleArray((String)o2) : null;
        }
        if (pixelSpacing == null) {
            Object o3 = image.getValue(NOMINNAL_SCANNER_PIXEL_SPACING_GE[0], NOMINNAL_SCANNER_PIXEL_SPACING_GE[1]);
            double[] dArray4 = pixelSpacing = o3 != null ? XpSlice.getDoubleArray((String)o3) : null;
        }
        if (pixelSpacing == null) {
            double[] dArray5 = new double[2];
            dArray5[0] = 1.0;
            dArray = dArray5;
            dArray5[1] = 1.0;
        } else {
            dArray = pixelSpacing;
        }
        spacing = dArray;
        this.initSlice(ulhc, urbrhc, spacing);
    }

    public Object clone() {
        XpSlice newSlice = new XpSlice(this.ul, this.ur, this.br, this.width, this.height);
        newSlice.pixelSizeX = this.pixelSizeX;
        newSlice.pixelSizeY = this.pixelSizeY;
        return newSlice;
    }

    public final CTransform getImageToRasTransform() {
        return this.imageToRas;
    }

    public final CTransform getRasToImageTransform() {
        return this.rasToImage;
    }

    public final void setCorners(CPoint ul, CPoint ur, CPoint br) {
        if (ul.csystem == 4) {
            this.ul.set(-ul.x, -ul.y, ul.z);
        } else {
            this.ul.set(ul);
        }
        if (ur.csystem == 4) {
            this.ur.set(-ur.x, -ur.y, ur.z);
        } else {
            this.ur.set(ur);
        }
        if (br.csystem == 4) {
            this.br.set(-br.x, -br.y, br.z);
        } else {
            this.br.set(br);
        }
        this.bl.sub(br, ur);
        this.bl.add(ul);
        this.I.sub(ur, ul);
        this.J.sub(br, ur);
        double a = this.I.magnitude();
        this.I.multiplyBy(1.0 / a);
        double b = this.J.magnitude();
        this.J.multiplyBy(1.0 / b);
        this.I.cross(this.J, this.N);
        double vx = ul.x - this.bl.x;
        double vy = ul.y - this.bl.y;
        double vz = ul.z - this.bl.z;
        double lv = Math.sqrt(vx * vx + vy * vy + vz * vz);
        this.pixelSizeY = lv / (double)(this.height - 1);
        double hx = ul.x - ur.x;
        double hy = ul.y - ur.y;
        double hz = ul.z - ur.z;
        double lh = Math.sqrt(hx * hx + hy * hy + hz * hz);
        this.pixelSizeX = lh / (double)(this.width - 1);
        this.imageToRas.loadIdentity();
        double[] m = this.imageToRas.getElements();
        m[0] = this.I.x * this.pixelSizeX;
        m[4] = this.I.y * this.pixelSizeX;
        m[8] = this.I.z * this.pixelSizeX;
        m[1] = this.J.x * this.pixelSizeY;
        m[5] = this.J.y * this.pixelSizeY;
        m[9] = this.J.z * this.pixelSizeY;
        m[2] = this.N.x;
        m[6] = this.N.y;
        m[10] = this.N.z;
        double hpx = this.pixelSizeX * 0.5;
        double hpy = this.pixelSizeY * 0.5;
        m[3] = ul.x - this.I.x * hpx - this.J.x * hpy;
        m[7] = ul.y - this.I.y * hpx - this.J.y * hpy;
        m[11] = ul.z - this.I.z * hpx - this.J.z * hpy;
        this.imageToRas.inverse(this.rasToImage);
    }

    public final CPoint getUpperLeft() {
        return this.ul;
    }

    public final CPoint getUpperRight() {
        return this.ur;
    }

    public final CPoint getBottomRight() {
        return this.br;
    }

    public final CPoint getBottomLeft() {
        return this.bl;
    }

    public final void getSliceCenter(CPoint center) {
        center.csystem = (byte)2;
        center.x = (this.ul.x + this.ur.x + this.br.x + this.bl.x) / 4.0;
        center.y = (this.ul.y + this.ur.y + this.br.y + this.bl.y) / 4.0;
        center.z = (this.ul.z + this.ur.z + this.br.z + this.bl.z) / 4.0;
    }

    public final double getSliceDimensionX() {
        return this.pixelSizeX * (double)this.width;
    }

    public final double getSliceDimensionY() {
        return this.pixelSizeY * (double)this.height;
    }

    public final boolean isInsideSlice(CPoint p) {
        CPoint AP = new CPoint(this.ul, p);
        double dist = this.N.dot(AP);
        if (dist < -0.01 || dist > 0.01) {
            return false;
        }
        double Xp = this.I.dot(AP);
        double Yp = this.J.dot(AP);
        return !(Xp > (double)this.width || Xp < 0.0 || Yp > (double)this.height) && !(Yp < 0.0);
    }

    public final JnPoint2D transformToSlice(CPoint P2) {
        CPoint imgPt = new CPoint(0);
        this.rasToImage.transform(P2, imgPt);
        double Xp = imgPt.x;
        double Yp = imgPt.y;
        return new JnPoint2D.Double(Xp, Yp);
    }

    private final void segment(CPoint p0, CPoint p1, JnPoint2D[] result) {
        result[0] = this.transformToSlice(p0);
        result[1] = this.transformToSlice(p1);
    }

    private final JnPoint2D[] segment(CPoint p0, CPoint p1) {
        JnPoint2D[] result = new JnPoint2D.Double[2];
        this.segment(p0, p1, result);
        return result;
    }

    private final JnPoint2D[] solve2InsideConfiguration(XpSlice s, double nA, double nB, double nC, double nD) {
        JnPoint2D[] result = new JnPoint2D.Double[2];
        this.solve2InsideConfiguration(s, nA, nB, nC, nD, result);
        return result;
    }

    private final void solve2InsideConfiguration(XpSlice s, double nA, double nB, double nC, double nD, JnPoint2D[] result) {
        CPoint Y;
        CPoint X;
        if (nA == 0.0) {
            X = s.getUpperLeft();
            Y = nB == 0.0 ? s.getUpperRight() : (nC == 0.0 ? s.getBottomLeft() : s.getBottomRight());
        } else if (nB == 0.0) {
            X = s.getUpperRight();
            Y = nC == 0.0 ? s.getBottomLeft() : s.getBottomRight();
        } else {
            X = s.getBottomLeft();
            Y = s.getBottomRight();
        }
        this.segment(X, Y, result);
    }

    private JnPoint2D[] solve2x2Configuration(XpSlice s, double nA, double nB, double nC, double nD) {
        JnPoint2D[] result = new JnPoint2D.Double[2];
        this.solve2x2Configuration(s, nA, nB, nC, nD, result);
        return result;
    }

    private void solve2x2Configuration(XpSlice s, double nA, double nB, double nC, double nD, JnPoint2D[] result) {
        CPoint Y;
        if (nA >= 0.0 && nB >= 0.0 || nA < 0.0 && nB <= 0.0) {
            CPoint X = this.pointIntersection(s.getUpperLeft(), s.getBottomLeft());
            CPoint Y2 = this.pointIntersection(s.getUpperRight(), s.getBottomRight());
            this.segment(X, Y2, result);
            return;
        }
        if (nA >= 0.0 && nC >= 0.0 || nA < 0.0 && nC <= 0.0) {
            CPoint X = this.pointIntersection(s.getUpperLeft(), s.getUpperRight());
            CPoint Y3 = this.pointIntersection(s.getBottomLeft(), s.getBottomRight());
            this.segment(X, Y3, result);
            return;
        }
        CPoint X = Y = new CPoint();
        this.segment(X, Y, result);
    }

    private JnPoint2D[] solve3x1Configuration(XpSlice s, double nA, double nB, double nC, double nD) {
        JnPoint2D[] result = new JnPoint2D.Double[2];
        this.solve3x1Configuration(s, nA, nB, nC, nD, result);
        return result;
    }

    private void solve3x1Configuration(XpSlice s, double nA, double nB, double nC, double nD, JnPoint2D[] result) {
        CPoint Y;
        CPoint X;
        int pointsAbove = 0;
        if (nA > 0.0) {
            ++pointsAbove;
        }
        if (nB > 0.0) {
            ++pointsAbove;
        }
        if (nC > 0.0) {
            ++pointsAbove;
        }
        if (nD > 0.0) {
            ++pointsAbove;
        }
        if (pointsAbove == 1 && nA > 0.0 || pointsAbove == 3 && nA < 0.0) {
            X = this.pointIntersection(s.getUpperLeft(), s.getUpperRight());
            Y = this.pointIntersection(s.getUpperLeft(), s.getBottomLeft());
        } else if (pointsAbove == 1 && nB > 0.0 || pointsAbove == 3 && nB < 0.0) {
            X = this.pointIntersection(s.getUpperRight(), s.getBottomRight());
            Y = this.pointIntersection(s.getUpperRight(), s.getUpperLeft());
        } else if (pointsAbove == 1 && nC > 0.0 || pointsAbove == 3 && nC < 0.0) {
            X = this.pointIntersection(s.getBottomLeft(), s.getUpperLeft());
            Y = this.pointIntersection(s.getBottomLeft(), s.getBottomRight());
        } else {
            X = this.pointIntersection(s.getBottomRight(), s.getUpperRight());
            Y = this.pointIntersection(s.getBottomRight(), s.getBottomLeft());
        }
        this.segment(X, Y, result);
    }

    @Override
    public final void getIntersection(XpSlice s, JnPoint2D[] result) {
        this.OA.setPoint(this.ul, s.getUpperLeft());
        this.OB.setPoint(this.ul, s.getUpperRight());
        this.OC.setPoint(this.ul, s.getBottomLeft());
        this.OD.setPoint(this.ul, s.getBottomRight());
        double nA = this.N.dot(this.OA);
        double nB = this.N.dot(this.OB);
        double nC = this.N.dot(this.OC);
        double nD = this.N.dot(this.OD);
        int pointsAbove = 0;
        int pointsInside = 0;
        if (nA > 0.0) {
            ++pointsAbove;
        }
        if (nB > 0.0) {
            ++pointsAbove;
        }
        if (nC > 0.0) {
            ++pointsAbove;
        }
        if (nD > 0.0) {
            ++pointsAbove;
        }
        if (nA == 0.0) {
            ++pointsInside;
        }
        if (nB == 0.0) {
            ++pointsInside;
        }
        if (nC == 0.0) {
            ++pointsInside;
        }
        if (nD == 0.0) {
            ++pointsInside;
        }
        if (pointsInside == 2) {
            this.solve2InsideConfiguration(s, nA, nB, nC, nD, result);
            return;
        }
        if (pointsAbove == 2) {
            this.solve2x2Configuration(s, nA, nB, nC, nD, result);
            return;
        }
        if (pointsAbove == 1 || pointsAbove == 3) {
            this.solve3x1Configuration(s, nA, nB, nC, nD, result);
            return;
        }
        CPoint zero = new CPoint(2);
        this.segment(zero, zero, result);
    }

    @Override
    public final JnPoint2D[] getJnIntersection(XpSlice s) {
        JnPoint2D[] result = new JnPoint2D.Double[2];
        this.getIntersection(s, result);
        return result;
    }

    private static void compute_crossing(CPoint N, double dA, CPoint A2, CPoint B, ArrayList crossing) {
        double x;
        CPoint J = new CPoint(A2, B);
        double dNJ = N.dot(J);
        if (dNJ != 0.0 && (x = -dA / dNJ) >= 0.0 && x < 1.0) {
            CPoint p = new CPoint(J);
            p.multiplyBy(x);
            p.add(A2);
            crossing.add(p);
        }
    }

    @Override
    public final JnPoint2D[] getJnIntersectionWithInfinite(XpSlice other) {
        this.OA.setPoint(other.ul, this.ul);
        this.OB.setPoint(other.ul, this.ur);
        this.OC.setPoint(other.ul, this.bl);
        this.OD.setPoint(other.ul, this.br);
        double dA = other.N.dot(this.OA);
        double dB = other.N.dot(this.OB);
        double dC = other.N.dot(this.OC);
        double dD = other.N.dot(this.OD);
        ArrayList crossing = new ArrayList();
        if (dA * dB < 0.0) {
            XpSlice.compute_crossing(other.N, dA, this.ul, this.ur, crossing);
        }
        if (dB * dD < 0.0) {
            XpSlice.compute_crossing(other.N, dB, this.ur, this.br, crossing);
        }
        if (dD * dC < 0.0) {
            XpSlice.compute_crossing(other.N, dD, this.br, this.bl, crossing);
        }
        if (dC * dA < 0.0) {
            XpSlice.compute_crossing(other.N, dC, this.bl, this.ul, crossing);
        }
        if (crossing.size() > 1) {
            return this.segment((CPoint)crossing.get(0), (CPoint)crossing.get(1));
        }
        CPoint zero = new CPoint(2);
        return this.segment(zero, zero);
    }

    CPoint pointIntersection(CPoint X, CPoint Y) {
        boolean signY;
        CPoint OX = new CPoint(this.ul, X);
        CPoint OY = new CPoint(this.ul, Y);
        CPoint XY = new CPoint(X, Y);
        double nX = this.N.dot(OX);
        double nY = this.N.dot(OY);
        double nXY = this.N.dot(XY);
        boolean signX = nX >= 0.0;
        boolean bl = signY = nY >= 0.0;
        if (nXY == 0.0) {
            if (nX == 0.0) {
                return X;
            }
            return new CPoint(0.0, 0.0, 0.0, X.csystem);
        }
        if (nX == 0.0) {
            return X;
        }
        if (nY == 0.0) {
            return Y;
        }
        if (signX != signY) {
            double lambda = -1.0 * (nX / nXY);
            CPoint a = new CPoint(XY);
            a.multiplyBy(lambda);
            a.add(X);
            return a;
        }
        return new CPoint(0.0, 0.0, 0.0, X.csystem);
    }

    public final double getPointToSliceDistance(CPoint p) {
        double d = this.N.dot(p) - this.N.dot(this.ul);
        return d;
    }

    public String toString() {
        return "Slice(" + this.ul + "," + this.ur + "," + this.br + ")" + this.width + "x" + this.height + " PixDim(" + this.pixelSizeX + "," + this.pixelSizeY + ")";
    }

    @Override
    public double[] getNormalRAS(double[] ras_normal) {
        double[] arr = ras_normal;
        if (arr == null) {
            arr = new double[]{this.N.x, this.N.y, this.N.z};
        }
        return arr;
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        double[] arr = ras_ulc;
        if (arr == null) {
            arr = new double[]{this.ul.x, this.ul.y, this.ul.z};
        }
        return arr;
    }

    @Override
    public int getSliceColumns() {
        return this.width;
    }

    @Override
    public int getSliceRows() {
        return this.height;
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        double[] arr = ras_dx;
        if (arr == null) {
            arr = new double[]{this.I.x * this.pixelSizeX, this.I.y * this.pixelSizeX, this.I.z * this.pixelSizeX};
        }
        return arr;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        double[] arr = ras_dy;
        if (arr == null) {
            arr = new double[]{this.J.x * this.pixelSizeY, this.J.y * this.pixelSizeY, this.J.z * this.pixelSizeY};
        }
        return arr;
    }
}

