/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.idc.Capable;
import com.ge.med.idc.ClipCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreationListener;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.FusionCapable;
import com.ge.med.idc.OnPortCapable;
import com.ge.med.idc.OnPortControl;
import com.ge.med.idc.PaintStatCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.ClipRoiActor;
import com.ge.med.terra.jami.DICOMLut;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpImageMouseControls;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpOnPortLayoutManager;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.render.remote.RmImage2DVc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public abstract class XpSingularPort
extends XpViewport
implements OnPortCapable,
ComponentCreationListener,
FrameOwner,
ComponentCapable,
PaintStatCapable,
WindowLevelCapable,
ClipCapable,
XpImageRenderAttributesOwner,
PanZoomCapable,
ROICapable,
UserAnnoCapable,
SliceSourceCapable,
ColorMapCapable,
ActiveAnnotationCapable {
    private int[] _actColorMap = null;
    private XpMedicalImage2DVc mivc = null;
    private XpMouseController mc = null;
    private XpVisualComponent contentPane = new XpVisualComponent();
    private GridBagLayout contentPaneLayout = new GridBagLayout();
    private XpVisualComponent onPortCtls = new XpVisualComponent();
    private Map onPortMap = new HashMap();
    private ComponentCreator componentCreator = null;
    private boolean invalidateFlag = true;
    private List roiList = new ArrayList();
    private List uAnnoList = new ArrayList();
    private Point2D currentPan = new Point2D.Double();
    private double winUpperLimit = Double.MAX_VALUE;
    private double winLowerLimit = -1.7976931348623157E308;
    private String rendererType = null;
    Cursor oldCursor;
    public static final ImageIcon CROSS_ICON = new ImageIcon(XpSingularPort.class.getResource("measureCursor.gif"));
    public static final Cursor MEASUREMENT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(CROSS_ICON.getImage(), new Point(CROSS_ICON.getIconWidth() / 2, CROSS_ICON.getIconHeight() / 2), "Measurement");
    public static final String ACTIVE_VOILUT_INDEX = "activeVOILutIndex";

    public XpSingularPort() {
        this.mivc = new XpMedicalImage2DVc();
        this.initializeSingularPort();
    }

    public XpSingularPort(RmRenderSession rs, String remote2DRenderer) {
        RmImage2DVc ivc = new RmImage2DVc(rs, remote2DRenderer);
        this.mivc = new XpMedicalImage2DVc(ivc);
        this.initializeSingularPort();
    }

    public XpSingularPort(String rendererType) {
        this.rendererType = rendererType;
        this.mivc = new XpMedicalImage2DVc(rendererType);
        this.initializeSingularPort();
    }

    public void initializeImageViewport() {
    }

    private final void initializeSingularPort() {
        this.setBackground(Color.black);
        this.mivc.getImageVc().addMouseListener(XpAppContext.instance().getSelectionManager());
        this.setLayout(new XpStackLayout());
        XpImageMouseControls imc = new XpImageMouseControls();
        imc.setRepaint(true);
        this.setMouseController(imc);
        this.contentPane.setLayout(this.contentPaneLayout);
        this.mivc.getImageVc().add(this.contentPane);
        this.add(this.mivc);
        this.initializeImageViewport();
        this.onPortCtls.setLayout(new XpOnPortLayoutManager());
        this.add((Component)this.onPortCtls, 0);
    }

    protected void copyObject(Object o) {
        XpSingularPort iv = (XpSingularPort)o;
        XpImage2DVc ivc = this.mivc.getImageVc();
        int childCount = ivc.getComponentCount();
        for (int i = 0; i < childCount; ++i) {
            Replicable rep;
            Component newcomponent;
            Component c = ivc.getComponent(i);
            if (!c.isVisible() || !(c instanceof Replicable) || (newcomponent = (Component)(rep = (Replicable)((Object)c)).clone()) == null) continue;
            iv.getMedicalImageVc().getImageVc().add(newcomponent);
        }
        String[] agItems = this.mivc.getAnnotationItems();
        if (agItems != null) {
            for (int i = 0; i < agItems.length; ++i) {
                boolean activate = this.mivc.queryAnnotationItem(agItems[i]);
                iv.getMedicalImageVc().setAnnotationItems(new String[]{agItems[i]}, activate);
            }
        }
    }

    @Override
    protected final void applyAnnotationLanguage(String lang) {
        XpAnnotationGenerator ag = this.getAnnotationGenerator();
        if (ag instanceof XpApdAnnotationGenerator) {
            XpApdAnnotationGenerator generator = (XpApdAnnotationGenerator)ag;
            generator.setLanguage(lang);
        }
    }

    public final String getRendererType() {
        return this.rendererType;
    }

    public final XpMouseController getMouseController() {
        return this.mc;
    }

    public final void disableMouseController() {
        if (this.oldCursor == null) {
            this.oldCursor = this.getCursor();
        }
        this.setCursor(null);
        if (this.mc != null) {
            this.mivc.getImageVc().removeMouseListener(this.mc);
            this.mivc.getImageVc().removeMouseMotionListener(this.mc);
        }
    }

    public final void enableMouseController() {
        this.setCursor(this.oldCursor);
        this.oldCursor = null;
        if (this.mc != null) {
            this.mivc.getImageVc().addMouseListener(this.mc);
            this.mivc.getImageVc().addMouseMotionListener(this.mc);
        }
    }

    public final void setMouseController(XpMouseController mc) {
        if (mc != this.mc) {
            this.disableMouseController();
            this.mc = mc;
            this.enableMouseController();
            if (mc != null) {
                mc.setTarget(this);
            }
        }
    }

    @Override
    public void setBackground(Color background) {
        XpImage2DVc ivc;
        super.setBackground(background);
        if (this.mivc != null && (ivc = this.mivc.getImageVc()) != null) {
            this.mivc.getImageVc().setBackground(background);
        }
    }

    @Override
    public final void refreshContents() {
        this.mivc.refreshImage();
        this.auto_repaint();
    }

    @Override
    public void dispose() {
        if (this.mivc != null) {
            this.mivc.getImageVc().dispose();
        }
    }

    public final XpMedicalImage2DVc getMedicalImageVc() {
        return this.mivc;
    }

    public final void transform(CPoint input, CPoint output, byte coordSys) {
        if (this.mivc != null) {
            this.mivc.transform(input, output, coordSys);
        }
    }

    @Override
    public final long getPaintCount() {
        return this.mivc.getPaintCount();
    }

    public final Container getContentPane() {
        return this.contentPane;
    }

    @Override
    public final void addPortControl(Class onPortComp, Object location) {
        try {
            Component c = (Component)onPortComp.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (c != null) {
                if (c instanceof OnPortControl) {
                    OnPortControl pp = (OnPortControl)((Object)c);
                    pp.listenTo(this.mivc.getImageVc());
                    pp.setCapable(this);
                }
                this.onPortCtls.add(c, location);
                this.onPortMap.put(onPortComp, c);
            }
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public final void setOnPortLayoutManager(Class layoutMgrClass) {
        try {
            LayoutManager lm = (LayoutManager)layoutMgrClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (lm != null) {
                this.onPortCtls.setLayout(lm);
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    @Override
    public final void removePortControl(Class onPortComp) {
        Component c = (Component)this.onPortMap.get(onPortComp);
        if (c != null) {
            this.onPortCtls.remove(c);
            this.onPortMap.remove(onPortComp);
        }
    }

    @Override
    public final ComponentCreator getComponentCreator() {
        return this.componentCreator;
    }

    @Override
    public final void setComponentCreator(ComponentCreator rc) {
        if (this.componentCreator != null) {
            this.componentCreator.removeViewport(this, this.mivc.getImageVc());
            this.componentCreator.removeComponentCreationListener(this);
            this.componentCreator = null;
        }
        if (rc != null) {
            rc.addViewport(this, this.mivc.getImageVc());
            rc.addComponentCreationListener(this);
            this.componentCreator = rc;
            this.disableMouseController();
            this.setCursor(MEASUREMENT_CURSOR);
        } else {
            this.enableMouseController();
        }
    }

    @Override
    public final void componentCreationNotification(ComponentCapable cc) {
        this.componentCreator.removeViewport(this, this.mivc.getImageVc());
        this.componentCreator = null;
        this.enableMouseController();
        for (int i = 0; i < this.roiList.size(); ++i) {
            RoiActor ra;
            XpImageRoiVc vc = (XpImageRoiVc)this.roiList.get(i);
            if (vc == null || !vc.isVisible() || (ra = vc.getRoiActor()) == null || !ra.isSelected()) continue;
            vc.requestFocus();
        }
    }

    @Override
    public void componentAddedNotification(ComponentCapable cc) {
    }

    @Override
    public final XpImageRenderAttributes getImageRenderAttributes() {
        return this.mivc.getImageRenderAttributes();
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.mivc.setImageRenderAttributes(attr);
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        return this.mivc.getImagePixelAttributes(layer);
    }

    @Override
    public final void setBorder(Border b) {
        if (this.mivc != null) {
            this.mivc.getImageVc().setBorder(b);
        }
        super.setBorder(b);
    }

    @Override
    public final Border getBorder() {
        if (this.mivc != null) {
            return this.mivc.getImageVc().getBorder();
        }
        return super.getBorder();
    }

    public final Object getInterpolationHint() {
        return this.mivc.getInterpolationHint();
    }

    public final void setInterpolationHint(Object interpolationHint) {
        if (interpolationHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR || interpolationHint == RenderingHints.VALUE_INTERPOLATION_BILINEAR || interpolationHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            this.mivc.setInterpolationHint(interpolationHint);
        }
    }

    @Override
    public final Shape getClipShape() {
        return this.mivc.getClipShape();
    }

    @Override
    public final void setImageClip(Shape s) {
        this.mivc.setImageClip(s);
    }

    @Override
    public final Shape getImageClip() {
        return this.mivc.getImageClip();
    }

    @Override
    public final void setClipShape(Shape clipShape) {
        this.mivc.setClipShape(clipShape);
    }

    @Override
    public final XpSlice getActiveSlice() {
        XpImage mi = this.mivc.getFrame();
        return mi != null ? mi.getSlice() : null;
    }

    public int getFrameIndex() {
        return 0;
    }

    @Override
    public String[] getAnnotationGroups() {
        return this.mivc.getAnnotationGroups();
    }

    @Override
    public String getAnnotationGroup() {
        return this.mivc.getAnnotationGroup();
    }

    public Map getAnnotationItemStates() {
        return this.mivc.getAnnotationItemStates();
    }

    @Override
    public String[] getAnnotationItems() {
        return this.mivc.getAnnotationItems();
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        return this.mivc.getAnnotationItems(agName);
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        this.mivc.setAnnotationGroup(agName, activate);
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        this.mivc.setAnnotationItems(annoItems, activate);
    }

    @Override
    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        this.mivc.queryAnnotationItems(annoItems, queryRes);
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        return this.mivc.queryAnnotationItem(aiName);
    }

    @Override
    public void setAnnotationGenerator(Class agClass, Properties props) {
        try {
            XpAnnotationGenerator ag = (XpAnnotationGenerator)agClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (ag != null) {
                ag.setProperties(props);
                this.mivc.setAnnotationGenerator(ag);
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        return this.mivc.getAnnotationGenerator();
    }

    @Override
    public void setAnnotationColor(Color c) {
        this.mivc.setAnnotationColor(c);
    }

    @Override
    public Color getAnnotationColor() {
        return this.mivc.getAnnotationColor();
    }

    @Override
    public void setAnnotationVisible(boolean annotVisible) {
        this.mivc.setAnnotationVisible(annotVisible);
    }

    @Override
    public boolean isAnnotationVisible() {
        return this.mivc.isAnnotationVisible();
    }

    protected void setImageLayerWindowing(int layer, double ww, double wl) {
        List l = this.mivc.getImageVc().getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.setWindowing(ww, wl);
        }
    }

    protected void setImageLayerVideoInverted(int layer, boolean ivvideo) {
        List l = this.mivc.getImageVc().getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.setVideoInverted(ivvideo);
        }
    }

    protected void setImageLayerColorMap(int layer, int[] cmap) {
        List l = this.mivc.getImageVc().getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.setColorMap(cmap);
        }
    }

    protected void resetImageLayerWindowing(int layer) {
        List l = this.mivc.getImageVc().getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.resetWindowing();
        }
    }

    public void setColorMap(int layer, int[] cMap) {
        if (layer == 0) {
            XpViewport.JamiIndexColorModel colorModel = null;
            if (cMap != null) {
                colorModel = new XpViewport.JamiIndexColorModel(cMap);
            }
            this._actColorMap = cMap;
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            kir.setColormap(colorModel);
            this.setImageRenderAttributes(kir);
        } else {
            this.setImageLayerColorMap(layer, cMap);
        }
        this.firePropertyChange("COLOR_MAP", null, cMap);
        this.auto_repaint();
    }

    @Override
    public void setColorMap(int[] cMap) {
        int layer = this.mivc.getImageVc().getImageLayer();
        this.setColorMap(layer, cMap);
    }

    @Override
    public int[] getColorMap() {
        XpImage2DVc r = this.mivc.getImageVc();
        int layer = r.getImageLayer();
        if (layer == 0) {
            return this._actColorMap;
        }
        List l = r.getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            return il.getColorMapTable();
        }
        return null;
    }

    public synchronized void setWindowing(int layer, double width, double level) {
        if (width < 0.0) {
            return;
        }
        double hw = width * 0.5;
        double min = level - hw;
        double max = level + hw;
        if (min < this.winLowerLimit) {
            min = this.winLowerLimit;
        } else if (min > this.winUpperLimit) {
            min = this.winUpperLimit;
        }
        if (max > this.winUpperLimit) {
            max = this.winUpperLimit;
        } else if (max < this.winLowerLimit) {
            max = this.winLowerLimit;
        }
        width = max - min;
        level = (max + min) * 0.5;
        double oldMin = 0.0;
        double oldMax = 0.0;
        if (layer == 0) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            oldMin = ira.getWindowMin();
            oldMax = ira.getWindowMax();
            ira.setWindowing(width, level);
            this.setImageRenderAttributes(ira);
        } else {
            oldMin = this.getWinMin();
            oldMax = this.getWinMax();
            this.setImageLayerWindowing(layer, width, level);
        }
        if (min != oldMin) {
            this.firePropertyChange("winMin", oldMin, min);
        }
        if (max != oldMax) {
            this.firePropertyChange("winMax", oldMax, max);
        }
        this.auto_repaint();
    }

    public synchronized void setWindowing(double width, double level) {
        int layer = this.mivc.getImageVc().getImageLayer();
        this.setWindowing(layer, width, level);
    }

    @Override
    public void setWinMinMax(double min, double max) {
        double ww = max - min;
        double wl = (max + min) * 0.5;
        this.setWindowing(ww, wl);
    }

    @Override
    public double getWinMin() {
        int layer = this.mivc.getImageVc().getImageLayer();
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            return kir.getWindowMin();
        }
        List l = this.mivc.getImageVc().getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            return il.getWindowMin();
        }
        return 0.0;
    }

    @Override
    public final void setWinMin(double min) {
        double winMax = this.getWinMax();
        this.setWinMinMax(min, winMax);
    }

    @Override
    public double getWinMax() {
        int layer = this.mivc.getImageVc().getImageLayer();
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            return kir.getWindowMax();
        }
        List l = this.mivc.getImageVc().getImageLayers();
        if (l != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            return il.getWindowMax();
        }
        return 0.0;
    }

    @Override
    public final void setWinMax(double max) {
        double winMin = this.getWinMin();
        this.setWinMinMax(winMin, max);
    }

    @Override
    public void resetWindowing() {
        int layer = this.mivc.getImageVc().getImageLayer();
        boolean arp = this.isAutoRepaint();
        if (layer == 0) {
            this.setAutoRepaint(false);
            XpImage img = this.getFrame();
            if (img != null) {
                double ww = img.getDefaultWindowWidth();
                double wl = img.getDefaultWindowLevel();
                double min = wl - ww / 2.0;
                double max = wl + ww / 2.0;
                this.setWinMinMax(min, max);
                this.setVideoInverted(false);
            }
        } else {
            this.resetImageLayerWindowing(layer);
        }
        this.setAutoRepaint(arp);
        this.auto_repaint();
    }

    @Override
    public final void setWinUpperLimit(double wuLimit) {
        if (wuLimit >= this.winLowerLimit) {
            this.winUpperLimit = wuLimit;
            double max = this.getWinMax();
            if (max > this.winUpperLimit) {
                this.setWinMax(this.winUpperLimit);
            }
        }
    }

    @Override
    public final double getWinUpperLimit() {
        return this.winUpperLimit;
    }

    @Override
    public final void setWinLowerLimit(double wlLimit) {
        if (wlLimit <= this.winUpperLimit) {
            this.winLowerLimit = wlLimit;
            double min = this.getWinMin();
            if (min < this.winLowerLimit) {
                this.setWinMin(this.winLowerLimit);
            }
        }
    }

    @Override
    public final double getWinLowerLimit() {
        return this.winLowerLimit;
    }

    public void setVideoInverted(int layer, boolean inverted) {
        boolean old_ivvideo = this.isVideoInverted();
        if (old_ivvideo != inverted) {
            if (layer == 0) {
                XpImageRenderAttributes kir = this.getImageRenderAttributes();
                kir.setVideoInverted(inverted);
                this.setImageRenderAttributes(kir);
            } else {
                this.setImageLayerVideoInverted(layer, inverted);
            }
            this.firePropertyChange("videoInverted", old_ivvideo, inverted);
            this.auto_repaint();
        }
    }

    @Override
    public void setVideoInverted(boolean inverted) {
        int layer = this.mivc.getImageVc().getImageLayer();
        this.setVideoInverted(layer, inverted);
    }

    @Override
    public boolean isVideoInverted() {
        int layer = this.mivc.getImageVc().getImageLayer();
        boolean ivvideo = false;
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            ivvideo = kir.isVideoInverted();
        } else {
            List l = this.mivc.getImageVc().getImageLayers();
            if (l != null) {
                XpImageLayer il = (XpImageLayer)l.get(layer - 1);
                ivvideo = il.isVideoInverted();
            }
        }
        return ivvideo;
    }

    @Override
    public double[] getRange() {
        XpPixelStatistics kps = this.getMedicalImageVc().getPixelStatistics(16);
        double[] range = new double[2];
        if (kps != null) {
            range[0] = kps.getMin();
            range[1] = kps.getMax();
        }
        return range;
    }

    public void setActiveVoiLutIndex(int idx) {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        int oldIdx = kir.getActiveVoiLutIndex();
        if (idx != oldIdx) {
            kir.setActiveVoiLutIndex(idx);
            XpImage img = this.getFrame();
            if (idx == -1) {
                kir.setWindowing(img.getDefaultWindowWidth(), img.getDefaultWindowLevel());
            } else if (img instanceof XpMedicalImage) {
                XpMedicalImage mimg = (XpMedicalImage)img;
                int[][] descriptors = DICOMLut.getVoiLUTDescriptors(mimg);
                kir.setWindowMinMax(0.0, 1 << descriptors[idx][2]);
            }
            this.setImageRenderAttributes(kir);
            this.firePropertyChange(ACTIVE_VOILUT_INDEX, oldIdx, idx);
            this.auto_repaint();
        }
    }

    @Override
    public void setZoom(double zoom) {
        if (zoom <= 0.0) {
            return;
        }
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        double oldZoom = kir.getZoom();
        kir.setZoom(zoom);
        this.setImageRenderAttributes(kir);
        this.firePropertyChange("zoom", oldZoom, zoom);
        this.auto_repaint();
    }

    @Override
    public double getZoom() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getZoom();
    }

    @Override
    public void setRotate(double rotate) {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        rotate = Math.toRadians(rotate);
        kir.setAngle(rotate);
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
    }

    @Override
    public double getRotate() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return Math.toDegrees(kir.getAngle());
    }

    @Override
    public void setPan(double pan_x, double pan_y) {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.setPan(pan_x, pan_y);
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
        Point2D newPan = kir.getPan();
        this.firePropertyChange("pan", this.currentPan, newPan);
        this.currentPan.setLocation(newPan);
    }

    @Override
    public void setPanY(double pan_y) {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        double pan_x = kir.getPanX();
        kir.setPan(pan_x, pan_y);
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
        Point2D newPan = kir.getPan();
        this.firePropertyChange("pan", this.currentPan, newPan);
        this.currentPan.setLocation(newPan);
    }

    @Override
    public double getPanY() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getPanY();
    }

    @Override
    public void setPanX(double pan_x) {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        double pan_y = kir.getPanY();
        kir.setPan(pan_x, pan_y);
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
        Point2D newPan = kir.getPan();
        this.firePropertyChange("pan", this.currentPan, newPan);
        this.currentPan.setLocation(newPan);
    }

    @Override
    public double getPanX() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getPanX();
    }

    @Override
    public void flipVertical() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.getImageOrientation().flipVertical();
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
    }

    @Override
    public void flipHorizontal() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.getImageOrientation().flipHorizontal();
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
    }

    @Override
    public void resetPanZoom() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.resetAffine();
        this.setImageRenderAttributes(kir);
        this.auto_repaint();
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.mivc.getImageVc().addKeyListener(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.mivc.getImageVc().addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.mivc.getImageVc().addMouseMotionListener(l);
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        this.mivc.getImageVc().addMouseWheelListener(l);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        if (this.mivc != null) {
            this.mivc.getImageVc().addFocusListener(l);
        } else {
            super.addFocusListener(l);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.mivc.getImageVc().removeKeyListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.mivc.getImageVc().removeMouseListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.mivc.getImageVc().removeMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        this.mivc.getImageVc().removeMouseWheelListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        if (this.mivc != null) {
            this.mivc.getImageVc().removeFocusListener(l);
        } else {
            super.removeFocusListener(l);
        }
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        return this.mivc.getImageVc().getKeyListeners();
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        return this.mivc.getImageVc().getMouseListeners();
    }

    @Override
    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return this.mivc.getImageVc().getMouseMotionListeners();
    }

    @Override
    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return this.mivc.getImageVc().getMouseWheelListeners();
    }

    @Override
    public synchronized FocusListener[] getFocusListeners() {
        return this.mivc.getImageVc().getFocusListeners();
    }

    public final boolean isAnnotationTooltip() {
        return this.mivc.getAnnotationVc().isAnnotationTooltip();
    }

    public final void setAnnotationTooltip(boolean annotTooltip) {
        this.mivc.getAnnotationVc().setAnnotationTooltip(annotTooltip);
    }

    public final void setFitToViewport(boolean fToViewport) {
        this.mivc.getImageVc().setFitToViewport(fToViewport);
    }

    public final boolean getFitToViewport() {
        return this.mivc.getImageVc().getFitToViewport();
    }

    public void syncScene() {
        this.syncROI();
        this.syncUserAnnotation();
        if (this.invalidateFlag) {
            this.invalidate();
            this.validate();
            this.invalidateFlag = false;
        }
    }

    private XpImageRoiVc getRoiVc(int i) {
        XpImageRoiVc vc = null;
        if (i < this.roiList.size()) {
            vc = (XpImageRoiVc)this.roiList.get(i);
        } else {
            vc = new XpImageRoiVc();
            XpMedicalImage2DVc mivc = this.getMedicalImageVc();
            mivc.getImageVc().add(vc);
            this.roiList.add(vc);
            this.invalidateFlag = true;
        }
        return vc;
    }

    protected void syncROI() {
        RoiActor cra;
        XpImageRoiVc vc;
        RoiActor ra;
        int i;
        List rois = this.getRois();
        int size = rois != null ? rois.size() : 0;
        int roisAssigned = 0;
        for (i = 0; i < size; ++i) {
            ra = (RoiActor)rois.get(i);
            if (!(ra instanceof ClipRoiActor)) continue;
            vc = this.getRoiVc(roisAssigned);
            cra = vc.getRoiActor();
            if (cra != ra) {
                vc.setRoiActor(ra);
            }
            ++roisAssigned;
            vc.setVisible(true);
        }
        for (i = 0; i < size; ++i) {
            ra = (RoiActor)rois.get(i);
            if (ra instanceof ClipRoiActor) continue;
            vc = this.getRoiVc(roisAssigned);
            cra = vc.getRoiActor();
            if (cra != ra) {
                vc.setRoiActor(ra);
            }
            ++roisAssigned;
            vc.setVisible(true);
            if (!ra.isSelected()) continue;
            vc.requestFocus();
        }
        for (i = size; i < this.roiList.size(); ++i) {
            XpImageRoiVc vc2 = (XpImageRoiVc)this.roiList.get(i);
            vc2.setRoiActor(null);
            vc2.setVisible(false);
            this.invalidateFlag = true;
        }
    }

    protected void syncUserAnnotation() {
        XpUserAnnotationVc vc;
        int i;
        List uannos = this.getUserAnnos();
        if (uannos == null) {
            return;
        }
        int size = uannos.size();
        XpMedicalImage2DVc mivc = this.getMedicalImageVc();
        for (i = 0; i < size; ++i) {
            XpUserAnnotationModel uam = (XpUserAnnotationModel)uannos.get(i);
            if (i < this.uAnnoList.size()) {
                vc = (XpUserAnnotationVc)this.uAnnoList.get(i);
                XpUserAnnotationModel cuam = vc.getUserAnnotationModel();
                vc.setUserAnnotationModel(uam);
            } else {
                vc = new XpUserAnnotationVc(uam);
                mivc.getImageVc().add(vc);
                this.uAnnoList.add(vc);
                this.invalidateFlag = true;
            }
            vc.setVisible(uam.isVisible());
        }
        for (i = size; i < this.uAnnoList.size(); ++i) {
            vc = (XpUserAnnotationVc)this.uAnnoList.get(i);
            vc.setVisible(false);
            this.invalidateFlag = true;
        }
    }

    public final void setClipGraphics(boolean clipGraphics) {
        this.mivc.getImageVc().setClipGraphics(clipGraphics);
    }

    public final boolean isClipGraphics() {
        return this.mivc.getImageVc().isClipGraphics();
    }

    @Override
    public String[] getAnnotationSegments() {
        return this.mivc.getAnnotationVc().getAnnotationSegments();
    }

    @Override
    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil) {
        this.mivc.getAnnotationVc().setActiveAnnotationListener(annotSegment, mil);
    }

    @Override
    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil, String tooltip) {
        this.mivc.getAnnotationVc().setActiveAnnotationListener(annotSegment, mil, tooltip);
    }

    @Override
    public void clearActiveAnnotationListener(String annotSegment) {
        this.mivc.getAnnotationVc().clearActiveAnnotationListener(annotSegment);
    }

    @Override
    public void clearActiveAnnotationListeners() {
        this.mivc.getAnnotationVc().clearActiveAnnotationListeners();
    }

    @Override
    public Capable getCapable(String capableIFName) {
        try {
            Class<?> cl = Class.forName(capableIFName);
            if (cl == FusionCapable.class) {
                if (this.mivc.getImageVc().isFusionCapable() && this instanceof FusionCapable) {
                    return this;
                }
            } else {
                if (cl.isAssignableFrom(this.getClass())) {
                    return this;
                }
                if (cl.isAssignableFrom(this.mivc.getImageVc().getClass())) {
                    return this.mivc.getImageVc();
                }
                if (cl.isAssignableFrom(this.mivc.getClass())) {
                    return this.mivc;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.getCapable(capableIFName);
    }

    public void selectImageLayer(int layer) {
        int old_layer = this.mivc.getImageVc().getImageLayer();
        this.mivc.getImageVc().selectImageLayer(layer);
        this.firePropertyChange("IMAGE_LAYER_PROPERTY", old_layer, layer);
    }

    public int getNumImageLayers() {
        return this.mivc.getImageVc().getNumImageLayers();
    }

    public int getImageLayer() {
        return this.mivc.getImageVc().getImageLayer();
    }

    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.mivc.getImageVc().setPixelCombiner(fpc);
    }

    public XjFusionPixelCombiner getPixelCombiner() {
        return this.mivc.getImageVc().getPixelCombiner();
    }

    public void removeUserAnnotVc(XpUserAnnotationVc vc) {
        this.uAnnoList.remove(vc);
    }
}

