/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.capable.Replicable;
import java.util.Arrays;

public class XpIndexPrism
implements Replicable {
    private int _len;
    private int[] _size;
    private int[] _index;
    private int[] _offset;
    private int[] _register;

    public XpIndexPrism(int[] size) {
        this.allocate(size);
    }

    public XpIndexPrism() {
        int[] size = new int[]{1};
        this.allocate(size);
    }

    public XpIndexPrism(XpIndexPrism other) {
        int i;
        this.allocate(other._size);
        if (null != this._index) {
            for (i = 0; i < this._len; ++i) {
                this._index[i] = other._index[i];
            }
        }
        if (null != other._offset) {
            this.allocateOffset();
            for (i = 0; i < this.getDimensions() * this._len; ++i) {
                this._offset[i] = other._offset[i];
            }
        }
        if (null != this._register) {
            for (i = 0; i < other._register.length; ++i) {
                this._register[i] = other._register[i];
            }
        }
    }

    @Override
    public Object clone() {
        XpIndexPrism ip = new XpIndexPrism(this);
        return ip;
    }

    public static boolean isArrayEqual(int[] a, int[] b) {
        boolean equality = true;
        if (a != null && b != null && a.length == b.length) {
            for (int i = 0; i < a.length; ++i) {
                equality = equality && a[i] == b[i];
            }
        } else if (a != null || b != null) {
            equality = false;
        }
        return equality;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XpIndexPrism) {
            XpIndexPrism ip = (XpIndexPrism)obj;
            boolean equality = true;
            equality = this._len == ip._len;
            equality = equality && XpIndexPrism.isArrayEqual(this._size, ip._size);
            equality = equality && XpIndexPrism.isArrayEqual(this._index, ip._index);
            equality = equality && XpIndexPrism.isArrayEqual(this._offset, ip._offset);
            return equality;
        }
        return false;
    }

    public int hashCode() {
        int result = this._len;
        result = result * 31 + Arrays.hashCode(this._size);
        result = result * 31 + Arrays.hashCode(this._index);
        result = result * 31 + Arrays.hashCode(this._offset);
        return result;
    }

    public final int getDimensions() {
        return this._size.length;
    }

    public final int getSize(int dim) {
        return dim < 0 ? 0 : (dim >= this.getDimensions() ? this.getDimensions() - 1 : this._size[dim]);
    }

    public final int getTotalSize() {
        return this._len;
    }

    public final int getAddress(int[] pos) {
        int addr = 0;
        for (int i = this.getDimensions() - 1; i >= 0; --i) {
            if (pos[i] < 0 || pos[i] >= this.getSize(i)) {
                return -1;
            }
            addr = (addr + pos[i]) * (i > 0 ? this.getSize(i - 1) : 1);
        }
        return addr;
    }

    public final int getIndex(int[] pos) {
        int addr = this.getAddress(pos = this.addOffset(pos));
        return addr < 0 || null == this._index ? -1 : this._index[addr];
    }

    public final void setIndex(int[] pos, int index) {
        int addr = this.getAddress(pos = this.addOffset(pos));
        if (addr >= 0 && null != this._index) {
            this._index[addr] = index;
        }
    }

    public final boolean findIndex(int index, int[] pos) {
        int m = this.getTotalSize();
        for (int i = 0; i < m; ++i) {
            if (this._index[i] != index) continue;
            return this.getPosition(i, pos);
        }
        return false;
    }

    public void loadIndices(int[] indexArray) {
        for (int i = 0; i < this._len; ++i) {
            this._index[i] = indexArray[i];
        }
    }

    public final void loadIdentity() {
        for (int i = 0; i < this._len; ++i) {
            this._index[i] = i;
        }
    }

    public void setOffset(int offsetDimension, int value, int[] plane) {
        if (null == this._offset) {
            this.allocateOffset();
        }
        boolean shift = true;
        for (int i = 0; i < this._len; ++i) {
            int k = i;
            shift = true;
            for (int j = 0; j < this.getDimensions(); ++j) {
                if (plane[j] != -1 && plane[j] != k % this.getSize(j)) {
                    shift = false;
                    break;
                }
                k /= this.getSize(j);
            }
            if (!shift) continue;
            this._offset[i * this.getDimensions() + offsetDimension] = value;
        }
    }

    public void clearOffsets() {
        if (null != this._offset) {
            for (int i = 0; i < this.getDimensions() * this._len; ++i) {
                this._offset[i] = 0;
            }
        }
    }

    public void print(int xdim, int ydim, int[] pos) {
        int i;
        int[] p = new int[this.getDimensions()];
        for (i = 0; i < this.getDimensions(); ++i) {
            System.out.print(i > 0 ? "x" : "" + this.getSize(i));
            p[i] = pos[i];
        }
        System.out.println(" prism plane (" + xdim + "," + ydim + ":");
        for (int j = 0; j < this.getSize(ydim); ++j) {
            p[ydim] = j;
            for (i = 0; i < this.getSize(xdim); ++i) {
                p[xdim] = i;
                int val = this.getIndex(p);
                if (val < 0) {
                    System.out.print("... ");
                    continue;
                }
                System.out.print(val);
            }
            System.out.println("");
        }
    }

    private boolean getPosition(int address, int[] pos) {
        int m = this.getTotalSize();
        for (int i = this.getDimensions() - 1; i >= 0; --i) {
            pos[i] = address / (m /= this.getSize(i));
            if (pos[i] < 0 || pos[i] >= this.getSize(i)) {
                return false;
            }
            address -= pos[i] * m;
        }
        return true;
    }

    private int[] addOffset(int[] pos) {
        int addr;
        int i;
        int[] reg = this._register;
        for (i = 0; i < this.getDimensions(); ++i) {
            reg[i] = pos[i];
        }
        if (null != this._offset && (addr = this.getAddress(pos)) >= 0) {
            for (i = 0; i < this.getDimensions(); ++i) {
                int n = i;
                reg[n] = reg[n] + this._offset[addr * this.getDimensions() + i];
            }
        }
        return reg;
    }

    private void allocate(int[] size) {
        this._len = 0;
        this._size = null;
        this._index = null;
        this._offset = null;
        if (size.length > 0) {
            int i;
            this._register = new int[size.length];
            this._size = new int[size.length];
            this._len = 1;
            for (i = 0; i < size.length; ++i) {
                this._size[i] = size[i];
                this._len *= size[i];
            }
            this._index = new int[this._len];
            for (i = 0; i < this._len; ++i) {
                this._index[i] = -1;
            }
        }
    }

    private void allocateOffset() {
        int sz = this.getDimensions() * this._len;
        this._offset = new int[sz];
        this.clearOffsets();
    }
}

