/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.DynamicLoadCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.FusionCapable;
import com.ge.med.idc.GSPSCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpCineMotor;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpMedicalImageListListener;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.capable.CPISerializable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.capable.MultiImageOpCapable;
import com.ge.med.terra.jami.capable.RenderSettingsCapable;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceListener;
import com.ge.med.terra.jami.filter.XpImageConvolution;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.filter.XpMultiImageOp;
import com.ge.med.terra.jami.image.JVolumeImage;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.image.XpPatternImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.platform.dm.XpDMgsps;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderSettings;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class XpImageViewport
extends XpSingularPort
implements SliceControlledCapable,
ImageOpCapable,
PanZoomCapable,
WindowLevelCapable,
ColorMapCapable,
CineCapable,
FramePositioningCapable,
MultiImageOpCapable,
FrameCapable,
XpMedicalImageListListener,
CPICapable,
GSPSCapable,
RenderSettingsCapable,
DynamicLoadCapable,
FusionCapable {
    private List sceneList = new ArrayList();
    private List orgSceneList = this.sceneList;
    private List sliceListeners = new ArrayList(20);
    private XpImageScene currentScene = null;
    private int frameIndex = -1;
    private XpCineMotor projector = new XpCineMotor(this, 20);
    private KeyboardWheelManager kbwManager = null;
    private XpImageRenderAttributes portIRA = new XpImageRenderAttributes();
    private XpImagePixelAttributes[] layerIPA = new XpImagePixelAttributes[16];
    private boolean fixedportIRA = false;
    private int cineSkip = 1;
    private Object cineQuality = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private boolean _cineOn = false;
    private int _cineRate = 20;
    private int _cineStartOffset = 0;
    private int _cineEndOffset = 0;
    private int _cineMode = 0;
    private RoiActor lastRoi = null;
    private boolean keyboardPaging = true;
    private boolean mousewheelPaging = true;
    private XpViewport.IntValueDispatcher frameDispatcher = new XpViewport.IntValueDispatcher("FrameIndex");
    private XpMultiImageOp multiImageOp = null;
    private XpImage lastXpImage = null;
    private AnnotationState annoState = new AnnotationState();
    private PropertyChangeListener miopSyncPCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            XpImageViewport.this.refresh();
        }
    };
    private PropertyChangeListener componentPCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            Object obj = pce.getNewValue();
            String pname = pce.getPropertyName();
            if (obj instanceof RoiActor) {
                if (pname.equals("COMPONENT_ADDED")) {
                    XpImageViewport.this.firePropertyChange("ROI_ADDED", null, obj, pce.getSource());
                } else if (pname.equals("COMPONENT_REMOVED")) {
                    XpImageViewport.this.firePropertyChange("ROI_REMOVED", null, obj, pce.getSource());
                }
            } else if (obj instanceof XpUserAnnotationModel) {
                if (pname.equals("COMPONENT_ADDED")) {
                    XpImageViewport.this.firePropertyChange("USERANNO_ADDED", null, obj, pce.getSource());
                } else if (pname.equals("COMPONENT_REMOVED")) {
                    XpImageViewport.this.firePropertyChange("USERANNO_REMOVED", null, obj, pce.getSource());
                }
            }
        }
    };
    private J3DVolumeModel j3d_vm = null;
    private Object prevInterpolationHint = null;

    public XpImageViewport() {
    }

    public XpImageViewport(RmRenderSession rs, String remote2DRenderer) {
        super(rs, remote2DRenderer);
    }

    public XpImageViewport(String rendererType) {
        super(rendererType);
    }

    @Override
    public final void initializeImageViewport() {
        this.kbwManager = new KeyboardWheelManager(this, this.getMedicalImageVc().getImageVc());
        if (Beans.isDesignTime()) {
            XpMedicalImage[] imgs = XpPatternImage.getPatternImages(5, 256, 256, 2);
            this.setImages(imgs);
        }
    }

    @Override
    public final void setImageRenderAttributes(XpImageRenderAttributes ira) {
        super.setImageRenderAttributes(ira);
        if (!this.fixedportIRA && this.currentScene != null) {
            this.currentScene.setImageRenderAttributes(ira);
        }
    }

    public final int getNumScenes() {
        return this.sceneList.size();
    }

    public final XpImageScene getScene(int i) {
        int n = this.getNumScenes();
        if (i >= 0 && i < n) {
            return (XpImageScene)this.sceneList.get(i);
        }
        return null;
    }

    @Override
    public final XpMedicalImage[] getImages() {
        int len = this.orgSceneList.size();
        XpMedicalImage[] imgs = new XpMedicalImage[len];
        for (int i = 0; i < len; ++i) {
            imgs[i] = (XpMedicalImage)((XpImageScene)this.orgSceneList.get(i)).getFrame();
        }
        return imgs;
    }

    public final void refresh() {
        if (this.orgSceneList.size() > 0) {
            if (this.multiImageOp != null) {
                this.loadMultiImageOp();
            } else {
                this.refreshContents();
            }
        }
    }

    public final void loadImages(XpMedicalImage[] imgList) {
        if (this.getCine()) {
            return;
        }
        this.loadImages(imgList, -1);
    }

    private void loadImages(XpMedicalImage[] imgList, int initialFrameIndex) {
        this.lastXpImage = null;
        this.getMedicalImageVc().getAnnotationGenerator().reset();
        if (imgList == null) {
            this.getMedicalImageVc().setMedicalImage(null, null);
        }
        for (int i = 0; i < this.sceneList.size(); ++i) {
            XpImageScene scene2 = (XpImageScene)this.sceneList.get(i);
            List rois = scene2.getRois();
            for (int r = 0; r < rois.size(); ++r) {
                RoiActor ra = (RoiActor)rois.get(r);
                if (!(ra instanceof XpStatisticsRoi)) continue;
                XpStatisticsRoi roi = (XpStatisticsRoi)ra;
                RoiShapeModel model = roi.getModel();
                model.removePropertyChangeListener("ROI_SHAPE_MODEL", roi);
                model.removePropertyChangeListener("COMPONENT_SELECTED", roi);
                model.removePropertyChangeListener("COMPONENT_UNSELECTED", roi);
            }
        }
        this.orgSceneList = this.createScenes(imgList);
        if (this.multiImageOp != null) {
            this.setupMultiImageOp(imgList);
        } else {
            this.sceneList = this.orgSceneList;
        }
        this.setEndOffset(this.getNumFrames() - 1);
        this.setFrame(initialFrameIndex);
    }

    @Override
    public Object clone() {
        String rtype = this.getRendererType();
        XpImageViewport iv = null;
        iv = rtype != null ? new XpImageViewport(rtype) : new XpImageViewport();
        iv.setSize(this.getSize());
        iv.setPreferredSize(this.getPreferredSize());
        XpMedicalImage[] imgs = this.getImages();
        int frameIndex = this.getFrameIndex();
        iv.setSharedRenderAttributes(this.isSharedRenderAttributes());
        iv.setImages(imgs);
        if (this.multiImageOp != null) {
            iv.setMultiImageOp(this.multiImageOp);
        }
        XpImageScene.copyScenes(this.orgSceneList, iv.orgSceneList);
        if (this.multiImageOp != null) {
            XpImageScene.copyScenes(this.sceneList, iv.sceneList);
        } else {
            iv.sceneList = iv.orgSceneList;
        }
        this.copyObject(iv);
        iv.setFrameIndex(frameIndex);
        return iv;
    }

    @Override
    public final void setImages(XpMedicalImage[] imgList) {
        if (this.getCine()) {
            return;
        }
        this.annoState.clear();
        this.loadImages(imgList, 0);
    }

    public final void setImages(XjImage[] imgList) {
        this.setImages(XjMedicalImage.createImages(imgList));
    }

    public final void setVolume(XjVolume volume) {
        J3DVolumeModel vm = null;
        if (volume != null) {
            vm = new J3DVolumeModel(volume);
        }
        this.setVolumeModel(vm);
    }

    public XjVolumeModel getVolumeModel() {
        return this.j3d_vm;
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.j3d_vm = (J3DVolumeModel)vm;
        if (this.j3d_vm != null) {
            XpMedicalImage[] imgs = JVolumeImage.getImages(this.j3d_vm.j_vol);
            this.setImages(imgs);
            if (this.j3d_vm.j_vol instanceof JVolume.LinearByte) {
                JVolume.LinearByte jlb = (JVolume.LinearByte)this.j3d_vm.j_vol;
                int[] cmap = jlb.cmap;
                if (cmap != null) {
                    this.setColorMap(cmap);
                }
                this.setWinMinMax(0.0, 255.0);
            }
        } else {
            this.setImages((XpMedicalImage[])null);
        }
    }

    @Override
    public int addImageLayer(XjImage[] imgs) {
        return this.addImageLayer(XjMedicalImage.createImages(imgs));
    }

    @Override
    public int removeImageLayer(int layer) {
        int nscenes = this.getNumScenes();
        int ret = -1;
        for (int i = 0; i < nscenes; ++i) {
            XpImageScene is = this.getScene(i);
            if (is != null) {
                ret = is.removeImageLayer(layer);
            }
            if (ret == -1) break;
        }
        if (ret != -1) {
            this.refreshContents();
            this.repaint();
        }
        return ret;
    }

    public int addImageLayer(XpMedicalImage[] imgs) {
        int len = Math.min(this.getNumScenes(), imgs.length);
        for (int i = 0; i < len; ++i) {
            XpImageScene is = this.getScene(i);
            XpImageLayer il = null;
            if (this.isSharedRenderAttributes()) {
                int nlayers = is.getNumLayers();
                if (this.layerIPA[nlayers] == null) {
                    this.layerIPA[nlayers] = new XpImagePixelAttributes();
                }
                il = new XpImageLayer(imgs[i], this.layerIPA[nlayers]);
            } else {
                il = new XpImageLayer(imgs[i]);
            }
            is.addImageLayer(il);
            if (imgs[i] == null) continue;
            il.setWindowing(imgs[i].getDefaultWindowWidth(), imgs[i].getDefaultWindowLevel());
        }
        XpImageScene is = this.getScene(0);
        int layer = is.getNumLayers() - 1;
        this.updateXpVisualComponents();
        return layer;
    }

    @Override
    public int addImage(XjImage image) {
        return this.addImage(XjMedicalImage.createImage(image));
    }

    public int addImage(XpMedicalImage image) {
        if (this.getCine() || this.multiImageOp != null) {
            return -1;
        }
        XpImageScene m = this.createScene(image);
        this.sceneList.add(m);
        if (this.getFrameIndex() == -1) {
            this.setFrameIndex(0);
        }
        return this.getNumFrames() - 1;
    }

    @Override
    public int addImages(XjImage[] images) {
        return this.addImages(XjMedicalImage.createImages(images));
    }

    public int addImages(XpMedicalImage[] images) {
        if (this.getCine() || this.multiImageOp != null) {
            return -1;
        }
        int oldLength = this.getNumFrames();
        for (int i = 0; i < images.length; ++i) {
            XpImageScene m = this.createScene(images[i]);
            this.sceneList.add(m);
        }
        if (this.getFrameIndex() == -1) {
            this.setFrameIndex(0);
        }
        return oldLength;
    }

    @Override
    public int addImage(XjImage image, int index) {
        return this.addImage(XjMedicalImage.createImage(image), index);
    }

    public int addImage(XpMedicalImage image, int index) {
        if (this.getCine() || this.multiImageOp != null) {
            return -1;
        }
        XpImageScene m = this.createScene(image);
        this.sceneList.add(index, m);
        if (index <= this.frameIndex) {
            ++this.frameIndex;
        }
        return index;
    }

    @Override
    public int addImages(XjImage[] images, int index) {
        return this.addImages(XjMedicalImage.createImages(images), index);
    }

    public int addImages(XpMedicalImage[] images, int index) {
        if (this.getCine() || this.multiImageOp != null) {
            return -1;
        }
        for (int i = images.length - 1; i >= 0; --i) {
            XpImageScene m = this.createScene(images[i]);
            this.sceneList.add(index, m);
        }
        if (this.getFrameIndex() == -1) {
            this.setFrameIndex(0);
        }
        if (index <= this.frameIndex) {
            this.frameIndex += images.length;
        }
        return index;
    }

    @Override
    public int removeImage(int index) {
        if (this.getCine() || this.multiImageOp != null) {
            return -1;
        }
        this.sceneList.remove(index);
        if (index < this.frameIndex) {
            --this.frameIndex;
        } else if (index == this.frameIndex) {
            if (this.frameIndex == this.getNumFrames()) {
                this.setFrame(0);
            } else {
                this.setFrame(this.frameIndex);
            }
        }
        if (this.getEndOffset() >= this.getNumFrames()) {
            this.setEndOffset(this.getNumFrames() - 1);
        }
        return index;
    }

    @Override
    public final int getNumFrames() {
        return this.getNumScenes();
    }

    @Override
    public final void setFrameIndex(int index) {
        this.setFrame(index);
    }

    public final void setFrame(int index) {
        int msize = this.getNumFrames();
        if (index >= 0 && index < msize) {
            int oldIndex = this.getFrameIndex();
            XpImageScene m = this.getScene(index);
            if (this.currentScene != null && !this.fixedportIRA) {
                XpImageRenderAttributes kir = this.getMedicalImageVc().getImageRenderAttributes();
                this.currentScene.setImageRenderAttributes(kir);
            }
            this.frameIndex = index;
            this.setCurrentScene(m);
            this.notifyFrameIndexListeners(oldIndex, index);
        } else {
            this.frameIndex = -1;
            this.setCurrentScene(null);
        }
        this.notifySliceListeners();
    }

    @Override
    public void setOffset(int offset) {
        this.setFrame(offset);
    }

    @Override
    public final void setStartOffset(int offset) {
        int n = this.getNumFrames();
        if (offset <= this._cineEndOffset && offset >= 0) {
            this._cineStartOffset = offset;
        }
    }

    @Override
    public final int getStartOffset() {
        return this._cineStartOffset;
    }

    @Override
    public final void setEndOffset(int offset) {
        int n = this.getNumFrames();
        if (offset >= this._cineStartOffset && offset < n) {
            this._cineEndOffset = offset;
        }
    }

    @Override
    public final int getEndOffset() {
        return this._cineEndOffset;
    }

    @Override
    public final int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public final XpImage getFrame() {
        int idx = this.getFrameIndex();
        return this.getFrame(idx);
    }

    @Override
    public XpImage getImageAt(int idx) {
        if (idx >= 0 && idx < this.getNumScenes()) {
            return ((XpImageScene)this.sceneList.get(idx)).getFrame();
        }
        return null;
    }

    @Override
    public final XpImage getFrame(int idx) {
        return this.getImageAt(idx);
    }

    @Override
    public void add(RoiActor m) {
        if (this.getCine()) {
            return;
        }
        if (this.currentScene != null) {
            this.lastRoi = m;
            this.currentScene.add(m);
            this.updateXpVisualComponents();
        }
    }

    @Override
    public boolean remove(RoiActor m) {
        XpImageScene is;
        int i;
        if (this.currentScene != null && this.currentScene.remove(m)) {
            this.updateXpVisualComponents();
            return true;
        }
        int nScenes = this.getNumScenes();
        for (i = 0; i < nScenes; ++i) {
            is = this.getScene(i);
            if (is == null || !is.remove(m)) continue;
            return true;
        }
        if (this.multiImageOp != null) {
            nScenes = this.orgSceneList.size();
            for (i = 0; i < nScenes; ++i) {
                is = (XpImageScene)this.orgSceneList.get(i);
                if (is == null || !is.remove(m)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List getRois() {
        if (this.currentScene != null) {
            return this.currentScene.getRois();
        }
        return null;
    }

    @Override
    public RoiActor getRoi() {
        return this.lastRoi;
    }

    @Override
    public void add(XpUserAnnotationModel m) {
        if (this.getCine()) {
            return;
        }
        if (this.currentScene != null) {
            this.currentScene.add(m);
        }
        this.updateXpVisualComponents();
    }

    @Override
    public boolean remove(XpUserAnnotationModel m) {
        XpImageScene is;
        int i;
        if (this.currentScene != null && this.currentScene.remove(m)) {
            this.updateXpVisualComponents();
            return true;
        }
        int nScenes = this.getNumScenes();
        for (i = 0; i < nScenes; ++i) {
            is = this.getScene(i);
            if (is == null || !is.remove(m)) continue;
            return true;
        }
        if (this.multiImageOp != null) {
            nScenes = this.orgSceneList.size();
            for (i = 0; i < nScenes; ++i) {
                is = (XpImageScene)this.orgSceneList.get(i);
                if (is == null || !is.remove(m)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List getUserAnnos() {
        if (this.currentScene != null) {
            return this.currentScene.getUserAnnos();
        }
        return null;
    }

    private void setCurrentScene(XpImageScene s) {
        this.currentScene = s;
        this.updateXpVisualComponents();
    }

    private void updateXpVisualComponents() {
        XpMedicalImage2DVc mivc = this.getMedicalImageVc();
        if (this.currentScene == null) {
            mivc.setVisible(false);
            return;
        }
        mivc.setVisible(true);
        int imageIndex = this.getFrameIndex();
        XpImage image = this.getFrame();
        if (image == null || image != this.lastXpImage) {
            XpDicomObject dicomSource = null;
            if (this.multiImageOp != null) {
                dicomSource = this.multiImageOp.getDicomSource(imageIndex);
            } else if (image instanceof XpMedicalImage) {
                dicomSource = (XpDicomObject)((Object)image);
            }
            mivc.setMedicalImage(image, dicomSource);
            this.lastXpImage = image;
            if (image != null) {
                this.annoState.applyMIVC(mivc);
            }
        }
        List imgLayers = this.currentScene.getImageLayers();
        mivc.setImageLayers(imgLayers);
        XpImageRenderAttributes ira = this.portIRA;
        if (!this.fixedportIRA) {
            ira = this.currentScene.getImageRenderAttributes();
        }
        mivc.setImageRenderAttributes(ira);
        this.syncScene();
    }

    private XpImageScene createScene(XpImage img) {
        XpImageScene is = null;
        is = this.isSharedRenderAttributes() ? new XpImageScene(img, this.portIRA) : new XpImageScene(img);
        is.addPropertyChangeListener("COMPONENT_ADDED", this.componentPCL);
        is.addPropertyChangeListener("COMPONENT_REMOVED", this.componentPCL);
        return is;
    }

    private List createScenes(XpImage[] imgs) {
        int len = 0;
        if (imgs != null) {
            len = imgs.length;
        }
        ArrayList<XpImageScene> scenes = new ArrayList<XpImageScene>();
        for (int i = 0; i < len; ++i) {
            XpImage mi;
            if (this.fixedportIRA && i == 0 && (mi = imgs[i]) != null) {
                double defWL = mi.getDefaultWindowLevel();
                double defWW = mi.getDefaultWindowWidth();
                this.portIRA.setWindowing(defWW, defWL);
            }
            XpImageScene m = this.createScene(imgs[i]);
            scenes.add(i, m);
        }
        return scenes;
    }

    private void setupMultiImageOp(XpMedicalImage[] images) {
        this.multiImageOp.setFrames(images);
        XpImage[] miopImages = this.createMultiImageOpImages();
        this.sceneList = this.createScenes(miopImages);
    }

    private XpImage[] createMultiImageOpImages() {
        int numFrames = this.multiImageOp.getNumFrames();
        XpImage[] miopImages = new XpImage[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            miopImages[i] = new XpViewport.MultiImageOpImage(this.multiImageOp, i);
        }
        return miopImages;
    }

    @Override
    public void setColorMap(int[] cMap) {
        super.setColorMap(cMap);
        int layer = this.getMedicalImageVc().getImageVc().getImageLayer();
        if (layer == 0) {
            XpImageRenderAttributes kir = this.getImageRenderAttributes();
            IndexColorModel icm = kir.getColormap();
            if (this.currentScene != null) {
                kir = this.currentScene.getImageRenderAttributes();
                kir.setColormap(icm);
                this.currentScene.setImageRenderAttributes(kir);
            } else {
                kir.setColormap(icm);
                this.setImageRenderAttributes(kir);
            }
        }
    }

    @Override
    public final boolean getCine() {
        return this._cineOn;
    }

    @Override
    public final int getCineRate() {
        return this._cineRate;
    }

    @Override
    public final int getOffset() {
        return this.getFrameIndex();
    }

    @Override
    public final void setCine(boolean cine) {
        boolean prevCine = this.getCine();
        this._cineOn = cine;
        if (!prevCine && cine) {
            this.prevInterpolationHint = this.getInterpolationHint();
            this.setInterpolationHint(this.cineQuality);
            this.projector.setCineRate(this.getCineRate());
            this.projector.start();
        }
        if (!cine) {
            this.setInterpolationHint(this.prevInterpolationHint);
            this.projector.stopProjection();
        }
        this.repaint();
        this.firePropertyChange("Cine", prevCine, cine);
    }

    @Override
    public final void setCineRate(int rate) {
        int oldRate = this.getCineRate();
        if (rate == oldRate) {
            return;
        }
        this._cineRate = rate;
        if (this.projector != null) {
            this.projector.setCineRate(rate);
        }
        this.firePropertyChange("CineRate", oldRate, rate);
    }

    @Override
    public final void setCineMode(int cineMode) {
        this._cineMode = cineMode;
    }

    @Override
    public final int getCineMode() {
        return this._cineMode;
    }

    @Override
    public final int getMaxFrame() {
        return this.getNumFrames();
    }

    @Override
    public final int getCineSkip() {
        return this.cineSkip;
    }

    @Override
    public final void setCineSkip(int cineSkip) {
        this.cineSkip = cineSkip;
    }

    @Override
    public final int getNumberShown() {
        return 1;
    }

    public final boolean getUpdateImmediate() {
        return this.isAutoRepaint();
    }

    public final void setUpdateImmediate(boolean updateImmediate) {
        this.setAutoRepaint(updateImmediate);
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        this.getMedicalImageVc().setAnnotationGroup(agName, activate);
        this.annoState.setAnnotationGroup(agName, activate);
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        this.getMedicalImageVc().setAnnotationItems(annoItems, activate);
        this.annoState.setAnnotationItems(annoItems, activate);
    }

    @Override
    public final void addImageOp(XpImageOp imageOp) {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.addImageOperation(imageOp);
        this.setImageRenderAttributes(kir);
        if (this.isAutoRepaint()) {
            this.repaint();
        }
        this.firePropertyChange("IMAGEOP_ADDED", null, imageOp);
    }

    @Override
    public final List getImageOps() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        return kir.getImageOperations();
    }

    @Override
    public final void clearImageOps() {
        XpImageRenderAttributes kir = this.getImageRenderAttributes();
        kir.clearImageOperations();
        this.setImageRenderAttributes(kir);
        if (this.isAutoRepaint()) {
            this.repaint();
        }
        this.firePropertyChange("IMAGEOPS_CLEARED", null, this);
    }

    @Override
    public final void setMultiImageOp(XpMultiImageOp multiImageOp) {
        if (this.getCine()) {
            return;
        }
        this.multiImageOp = multiImageOp;
        this.loadMultiImageOp();
        if (multiImageOp != null) {
            multiImageOp.addPropertyChangeListener("MULTI_IMAGE_OP_SYNC", this.miopSyncPCL);
        }
    }

    private void loadMultiImageOp() {
        if (this.orgSceneList.size() > 0) {
            this.lastXpImage = null;
            this.getMedicalImageVc().getAnnotationGenerator().reset();
            if (this.multiImageOp != null) {
                this.setupMultiImageOp(this.getImages());
            } else {
                this.sceneList = this.orgSceneList;
            }
            this.setFrame(0);
            this._cineEndOffset = this.getNumFrames() - 1;
        }
        this.auto_repaint();
    }

    @Override
    public final XpMultiImageOp getMultiImageOp() {
        return this.multiImageOp;
    }

    public final boolean isSharedRenderAttributes() {
        return this.fixedportIRA;
    }

    public final void setSharedRenderAttributes(boolean sharedRenderAttributes) {
        this.fixedportIRA = sharedRenderAttributes;
        if (this.fixedportIRA) {
            this.getMedicalImageVc().setImageRenderAttributes(this.portIRA);
        }
    }

    private void notifyFrameIndexListeners(int oldIndex, int newIndex) {
        this.frameDispatcher.setValues(this, newIndex);
        SwingUtilities.invokeLater(this.frameDispatcher);
    }

    protected void notifySliceListeners() {
        int len = this.sliceListeners.size();
        if (len > 0) {
            XpImage mi = this.getMedicalImageVc().getFrame();
            XpSlice activeSlice = null;
            if (mi != null) {
                activeSlice = mi.getSlice();
            }
            for (int i = 0; i < len; ++i) {
                SliceListener sl = (SliceListener)this.sliceListeners.get(i);
                sl.setActiveSlice(this, activeSlice);
            }
        }
    }

    @Override
    public void addSliceListener(SliceListener sl) {
        if (this.sliceListeners.contains(sl)) {
            return;
        }
        this.sliceListeners.add(sl);
    }

    @Override
    public void removeSliceListener(SliceListener sl) {
        this.sliceListeners.remove(sl);
    }

    @Override
    public void setActiveSlice(XpSlice slice) {
        XpSlice closest = null;
        int closestIdx = 0;
        double closestDist = Double.MAX_VALUE;
        CPoint ul = slice.ul;
        int nFrames = this.getNumFrames();
        for (int i = 0; i < nFrames; ++i) {
            XpImage image = this.getFrame(i);
            XpSlice miSlice = image.getSlice();
            double dist = miSlice.getPointToSliceDistance(ul);
            if (!(dist < closestDist)) continue;
            closest = miSlice;
            closestDist = dist;
            closestIdx = i;
        }
        this.setFrame(closestIdx);
        this.repaint();
    }

    @Override
    public void setActiveSliceIndex(int sliceIndex) {
        int nSlices = this.getMaxFrame();
        if (sliceIndex >= 0 && sliceIndex < nSlices) {
            this.setFrame(sliceIndex);
            this.repaint();
        }
    }

    @Override
    public int getActiveSliceIndex() {
        return this.getFrameIndex();
    }

    @Override
    public XpSlice[] getSlices() {
        int nFrames = this.getNumSlices();
        XpSlice[] slices = new XpSlice[nFrames];
        for (int i = 0; i < nFrames; ++i) {
            XpSlice miSlice;
            XpImage image = this.getFrame(i);
            slices[i] = miSlice = image.getSlice();
        }
        return slices;
    }

    @Override
    public XpSlice getSlice(int idx) {
        XpSlice slice = null;
        XpImage image = this.getFrame(idx);
        if (image != null) {
            slice = image.getSlice();
        }
        return slice;
    }

    @Override
    public int getNumSlices() {
        return this.getNumFrames();
    }

    public final Object getCineQuality() {
        return this.cineQuality;
    }

    public final void setCineQuality(Object cineQuality) {
        if (cineQuality == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR || cineQuality == RenderingHints.VALUE_INTERPOLATION_BILINEAR || cineQuality == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            this.cineQuality = cineQuality;
        }
    }

    public final boolean isKeyboardPaging() {
        return this.keyboardPaging;
    }

    public final void setKeyboardPaging(boolean keyboardPaging) {
        this.keyboardPaging = keyboardPaging;
    }

    public final boolean isMouseWheelPaging() {
        return this.mousewheelPaging;
    }

    public final void setMouseWheelPaging(boolean mousewheelPaging) {
        this.mousewheelPaging = mousewheelPaging;
    }

    @Override
    public final void setCPI(XpCPI cpi) {
        XpImageScene is;
        double oldZoom = this.getZoom();
        double oldMin = this.getWinMin();
        double oldMax = this.getWinMax();
        double oldPanX = this.getPanX();
        double oldPanY = this.getPanY();
        Point2D.Double oldPan = new Point2D.Double(oldPanX, oldPanY);
        XpImageOrientation oldOrient = this.getImageRenderAttributes().getImageOrientation();
        this.clearGraphics();
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        ira.reset();
        cpi.applyCPI(this.sceneList);
        cpi.applyAnnotationConfig(this);
        XpCPI.BitmapDisplayShutter bds = cpi.getBitmapDisplayShutter();
        if (bds != null) {
            XpCPI.applyBitmapDisplayShutter(bds, ira);
        }
        XpCPI.DisplayShutter ds = cpi.getDisplayShutter(1);
        XpCPI.DisplayShutter ids = cpi.getDisplayShutter(0);
        if (ds != null || ids != null) {
            XpCPI.applyCPI(cpi, this);
        }
        ira = (is = this.getScene(0)) != null ? is.getImageRenderAttributes() : null;
        this.updateXpVisualComponents();
        this.updateAdditionalVcs(cpi.getCpiSerializeables());
        this.updateConvImageOps(cpi.getImageConvOps());
        double zoom = this.getZoom();
        double min = this.getWinMin();
        double max = this.getWinMax();
        double panX = this.getPanX();
        double panY = this.getPanY();
        Point2D.Double pan = new Point2D.Double(panX, panY);
        XpImageOrientation newOrient = this.getImageRenderAttributes().getImageOrientation();
        if (oldZoom != zoom) {
            this.firePropertyChange("zoom", oldZoom, zoom);
        }
        if (oldMin != min) {
            this.firePropertyChange("winMin", oldMin, min);
        }
        if (oldMax != max) {
            this.firePropertyChange("winMax", oldMax, max);
        }
        if (panX != oldPanX || panY != oldPanY) {
            this.firePropertyChange("pan", oldPan, pan);
        }
        if (oldOrient != newOrient) {
            this.firePropertyChange("IMAGE_ORIENTATION", oldOrient, newOrient);
        }
    }

    private void updateConvImageOps(List<String> imageConvOps) {
        for (int i = 0; imageConvOps != null && i < imageConvOps.size(); ++i) {
            String s = imageConvOps.get(i);
            this.addImageOp(XpImageConvolution.create(s));
        }
    }

    private void updateAdditionalVcs(List<String> cpiSerializeables) {
        if (cpiSerializeables != null && cpiSerializeables.size() > 0) {
            for (int i = 0; i < cpiSerializeables.size(); ++i) {
                String cpis = cpiSerializeables.get(i);
                String[] cpisplit = cpis.split(":");
                String cpisClass = cpisplit[1];
                String cpisArgs = cpisplit[2];
                System.out.println("CPI = " + cpisClass);
                try {
                    Class<?> c = Class.forName(cpisClass);
                    Class[] argTypes = new Class[]{String.class};
                    Method m = c.getMethod("createVC", argTypes);
                    Object o = m.invoke(null, cpisArgs);
                    if (!(o instanceof XpVisualComponent)) continue;
                    XpVisualComponent v = (XpVisualComponent)o;
                    this.getMedicalImageVc().getImageVc().add(v);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        this.syncScene();
    }

    @Override
    public final XpCPI getCPI() {
        Dimension d = this.getMedicalImageVc().getImageVc().getSize();
        boolean sharedIRA = this.isSharedRenderAttributes();
        if (sharedIRA) {
            int len = this.getNumScenes();
            for (int i = 0; i < len; ++i) {
                XpImageScene is = this.getScene(i);
                if (is == null) continue;
                is.getImageRenderAttributes().set(this.portIRA);
            }
        }
        XpCPI cpi = XpCPI.createCPI(this.sceneList, d, sharedIRA);
        Component[] comps = this.getMedicalImageVc().getImageVc().getComponents();
        if (comps != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof CPISerializable)) continue;
                CPISerializable cpis = (CPISerializable)((Object)comps[i]);
                cpi.add2cpi(cpis, 0);
            }
        }
        cpi.addImageOps2cpi(this.getImageOps());
        cpi.fillAnnotationModule((AnnotCapable)this.getCapable("com.ge.med.terra.jami.capable.AnnotCapable"));
        Shape cs = this.getClipShape();
        Shape ics = this.getImageClip();
        if (cs != null) {
            XpCPI.addDisplayShutter(cs, 1, 0, cpi);
        }
        if (ics != null) {
            XpCPI.addDisplayShutter(ics, 0, 0, cpi);
        }
        return cpi;
    }

    @Override
    public void clearGraphics() {
        XpCPI.clearGraphics(this.sceneList);
        if (this.multiImageOp != null) {
            XpCPI.clearGraphics(this.orgSceneList);
        }
        this.updateXpVisualComponents();
    }

    @Override
    public final void setGSPS(InputStream gspsStream) {
        XpCPI cpi = XpDMgsps.getCPI(gspsStream);
        if (cpi != null) {
            this.setCPI(cpi);
            this.refreshContents();
        }
    }

    @Override
    public final InputStream getGSPS() {
        XpDMgsps gspsFactory = new XpDMgsps(this);
        return gspsFactory.getGSPS();
    }

    public static JFrame display(XjImage[] imgs) {
        JFrame jf = new JFrame("XpImageViewport");
        XpImageViewport iv = new XpImageViewport();
        iv.setImages(imgs);
        jf.setContentPane(iv);
        jf.setLocation(100, 100);
        jf.setSize(new Dimension(512, 512));
        jf.setVisible(true);
        return jf;
    }

    public static JFrame display(XpMedicalImage[] imgs) {
        JFrame jf = new JFrame("XpImageViewport");
        XpImageViewport iv = new XpImageViewport();
        iv.setImages(imgs);
        jf.setContentPane(iv);
        jf.setLocation(100, 100);
        jf.setSize(new Dimension(512, 512));
        jf.setVisible(true);
        return jf;
    }

    @Override
    public final void setImageRenderSettings(XpImageRenderSettings irs) {
        XpImageRenderAttributes ira;
        IndexOutOfBoundsException re;
        XpImageRenderAttributes ira2;
        XpImageScene is;
        int j;
        IndexOutOfBoundsException re2;
        XpImageScene is2;
        int idx;
        int j2;
        int[] frames;
        XpImageRenderSettings.Frames s;
        int i;
        int len = this.getNumScenes();
        int n = irs.getNumRoiSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getRoiSetting(i);
            frames = s.frames;
            RoiActor[] ras = s.rois;
            for (j2 = 0; j2 < frames.length; ++j2) {
                idx = frames[j2];
                if (idx >= 0 && idx < len) {
                    is2 = this.getScene(idx);
                    RoiActor ra = ras[j2];
                    if (is2 == null) continue;
                    is2.add(ra);
                    continue;
                }
                re2 = new IndexOutOfBoundsException("setImageRenderSettings (Roi): Invalid Scene/Image Index=" + idx);
                throw re2;
            }
        }
        n = irs.getNumUserAnnoSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getUserAnnoSetting(i);
            frames = ((XpImageRenderSettings.UserAnnoSetting)s).frames;
            XpUserAnnotationModel[] vals = ((XpImageRenderSettings.UserAnnoSetting)s).uams;
            for (j2 = 0; j2 < frames.length; ++j2) {
                idx = frames[j2];
                if (idx >= 0 && idx < len) {
                    is2 = this.getScene(idx);
                    XpUserAnnotationModel val = vals[j2];
                    if (is2 == null) continue;
                    is2.add(val);
                    continue;
                }
                re2 = new IndexOutOfBoundsException("setImageRenderSettings (UserAnnotation): Invalid Scene/Image Index=" + idx);
                throw re2;
            }
        }
        n = irs.getNumWWWLSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getWWWLSetting(i);
            frames = ((XpImageRenderSettings.WWWLSetting)s).frames;
            double[] wws = ((XpImageRenderSettings.WWWLSetting)s).ww;
            double[] wls = ((XpImageRenderSettings.WWWLSetting)s).wl;
            for (j = 0; j < frames.length; ++j) {
                int idx2 = frames[j];
                if (idx2 >= 0 && idx2 < len) {
                    is = this.getScene(idx2);
                    if (is == null) continue;
                    ira2 = is.getImageRenderAttributes();
                    ira2.setWindowing(wws[j], wls[j]);
                    is.setImageRenderAttributes(ira2);
                    continue;
                }
                re = new IndexOutOfBoundsException("setImageRenderSettings (ww/wl): Invalid Scene/Image Index=" + idx2);
                throw re;
            }
        }
        n = irs.getNumPanSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getPanSetting(i);
            frames = ((XpImageRenderSettings.PanSetting)s).frames;
            double[] pxs = ((XpImageRenderSettings.PanSetting)s).panX;
            double[] pys = ((XpImageRenderSettings.PanSetting)s).panY;
            for (j = 0; j < frames.length; ++j) {
                int idx3 = frames[j];
                if (idx3 >= 0 && idx3 < len) {
                    is = this.getScene(idx3);
                    if (is == null) continue;
                    ira2 = is.getImageRenderAttributes();
                    ira2.setPan(pxs[j], pys[j]);
                    is.setImageRenderAttributes(ira2);
                    continue;
                }
                re = new IndexOutOfBoundsException("setImageRenderSettings (pan): Invalid Scene/Image Index=" + idx3);
                throw re;
            }
        }
        n = irs.getNumZoomSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getZoomSetting(i);
            frames = ((XpImageRenderSettings.ZoomSetting)s).frames;
            double[] zoom = ((XpImageRenderSettings.ZoomSetting)s).zoom;
            for (int j3 = 0; j3 < frames.length; ++j3) {
                idx = frames[j3];
                if (idx >= 0 && idx < len) {
                    XpImageScene is3 = this.getScene(idx);
                    if (is3 == null) continue;
                    ira = is3.getImageRenderAttributes();
                    ira.setZoom(zoom[j3]);
                    is3.setImageRenderAttributes(ira);
                    continue;
                }
                IndexOutOfBoundsException re3 = new IndexOutOfBoundsException("setImageRenderSettings (zoom): Invalid Scene/Image Index=" + idx);
                throw re3;
            }
        }
        n = irs.getNumIVSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getIVSetting(i);
            frames = ((XpImageRenderSettings.IVSetting)s).frames;
            boolean[] iv = ((XpImageRenderSettings.IVSetting)s).iv;
            for (int j4 = 0; j4 < frames.length; ++j4) {
                idx = frames[j4];
                if (idx >= 0 && idx < len) {
                    XpImageScene is4 = this.getScene(idx);
                    if (is4 == null) continue;
                    ira = is4.getImageRenderAttributes();
                    ira.setVideoInverted(iv[j4]);
                    is4.setImageRenderAttributes(ira);
                    continue;
                }
                IndexOutOfBoundsException re4 = new IndexOutOfBoundsException("setImageRenderSettings (inverse video): Invalid Scene/Image Index=" + idx);
                throw re4;
            }
        }
        n = irs.getNumOverlaySettings();
        for (i = 0; i < n; ++i) {
            s = irs.getCOverlaySetting(i);
            frames = ((XpImageRenderSettings.COverlaySetting)s).frames;
            XpColorOverlay[] co = ((XpImageRenderSettings.COverlaySetting)s).coverlay;
            for (int j5 = 0; j5 < frames.length; ++j5) {
                idx = frames[j5];
                if (idx >= 0 && idx < len) {
                    XpImageScene is5 = this.getScene(idx);
                    if (is5 == null) continue;
                    ira = is5.getImageRenderAttributes();
                    ira.setColorOverlay(co[j5]);
                    is5.setImageRenderAttributes(ira);
                    continue;
                }
                IndexOutOfBoundsException re5 = new IndexOutOfBoundsException("setImageRenderSettings (color overlay): Invalid Scene/Image Index=" + idx);
                throw re5;
            }
        }
        this.updateXpVisualComponents();
        this.repaint();
    }

    @Override
    public void replaceImage(XjImage im, int index) {
        this.replaceImage(XjMedicalImage.createImage(im), index);
    }

    public void replaceImage(XpMedicalImage image, int index) {
        XpImageScene m = this.createScene(image);
        this.sceneList.set(index, m);
        this.repaint();
    }

    private static class AnnotationState {
        private String agm = null;
        private Map aim = new HashMap();
        private String[] str = new String[1];

        private AnnotationState() {
        }

        public final void setAnnotationGroup(String agName, boolean activate) {
            if (activate) {
                this.agm = agName;
            }
        }

        public final void setAnnotationItems(String[] annoItems, boolean activate) {
            for (int i = 0; i < annoItems.length; ++i) {
                Boolean b = activate ? Boolean.TRUE : Boolean.FALSE;
                this.aim.put(annoItems[i], b);
            }
        }

        public final void clear() {
            this.agm = null;
            this.aim.clear();
        }

        public final void applyMIVC(XpMedicalImage2DVc mivc) {
            if (this.agm != null) {
                mivc.setAnnotationGroup(this.agm, true);
            }
            for (Map.Entry me : this.aim.entrySet()) {
                this.str[0] = (String)me.getKey();
                Boolean value = (Boolean)me.getValue();
                mivc.setAnnotationItems(this.str, value);
            }
        }
    }

    private static class KeyboardWheelManager
    extends KeyAdapter
    implements MouseWheelListener {
        private XpImageViewport vp = null;
        private XpImage2DVc mi = null;
        private static final int UNITS = Integer.parseInt(XpPropertiesManager.getProperty("jami.mousewheel.scrollunits", "1"));

        public KeyboardWheelManager(XpImageViewport vp, XpImage2DVc mi) {
            this.vp = vp;
            this.mi = mi;
            mi.addKeyListener(this);
            mi.addMouseWheelListener(this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            if (this.vp.isMouseWheelPaging() && this.vp.getNumFrames() > 1) {
                int units = mwe.getUnitsToScroll();
                if (units > 0) {
                    this.forward(UNITS);
                }
                if (units < 0) {
                    this.back(UNITS);
                }
            }
        }

        private void forward(int n) {
            int frameIdx = this.vp.getFrameIndex();
            int nFrames = this.vp.getMaxFrame();
            frameIdx = (frameIdx + n) % nFrames;
            this.vp.setFrame(frameIdx);
            this.vp.repaint();
        }

        private void back(int n) {
            int frameIdx = this.vp.getFrameIndex() - n;
            int nFrames = this.vp.getMaxFrame();
            frameIdx = frameIdx < 0 ? nFrames + frameIdx : frameIdx;
            this.vp.setFrame(frameIdx);
            this.vp.repaint();
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            int key = ke.getKeyCode();
            if (this.vp.isKeyboardPaging() && this.vp.getNumFrames() > 1) {
                if (key == 34) {
                    this.forward(1);
                } else if (key == 33) {
                    this.back(1);
                } else if (key == 36) {
                    this.vp.setFrame(0);
                    this.vp.repaint();
                } else if (key == 35) {
                    int nFrames = this.vp.getMaxFrame();
                    this.vp.setFrame(nFrames - 1);
                    this.vp.repaint();
                }
            }
        }
    }
}

