/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjImage;
import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.DICOMLut;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.plot.XpPlotModel;
import com.ge.med.terra.jami.plot.XpPlotter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class XpImageUtils {
    public static final double MIN_WL_VALUE = -32767.0;
    public static final double MIN_WW_VALUE = 0.0;
    public static final double DEFAULT_RESCALE_INTERCEPT = 0.0;
    public static final double DEFAULT_RESCALE_SLOPE = 1.0;
    private static XpDicomElement imgtype = new XpDicomElement(8, 8);
    private static XpDicomElement scouttype = new XpDicomElement(39, 4112);
    private static double[] _reg = new double[6];

    public static RenderedImage downSample(BufferedImage input, int nw, int nh) {
        BufferedImage out;
        block7: {
            int scY;
            int scX;
            int offset;
            DataBuffer db;
            int h;
            int w;
            int type;
            block8: {
                block6: {
                    out = input;
                    type = input.getType();
                    w = input.getWidth();
                    h = input.getHeight();
                    db = input.getRaster().getDataBuffer();
                    offset = db.getOffset();
                    scX = (int)((double)w / (double)nw);
                    scY = (int)((double)h / (double)nh);
                    if (type != 0) break block6;
                    DataBufferByte dbb = (DataBufferByte)db;
                    byte[] data = dbb.getData();
                    out = new BufferedImage(nw, nh, 5);
                    DataBufferByte dbo = (DataBufferByte)out.getRaster().getDataBuffer();
                    byte[] outdata = dbo.getData();
                    for (int i = 0; i < nh; ++i) {
                        for (int j = 0; j < nw; ++j) {
                            int ii = scX * i;
                            int jj = scY * j;
                            if (ii < 0 || ii >= h || jj < 0 || jj >= w) continue;
                            outdata[i * (nw * 3) + j * 3] = data[offset + ii * (w * 3) + jj * 3 + 2];
                            outdata[i * (nw * 3) + j * 3 + 1] = data[offset + ii * (w * 3) + jj * 3 + 1];
                            outdata[i * (nw * 3) + j * 3 + 2] = data[offset + ii * (w * 3) + jj * 3];
                        }
                    }
                    break block7;
                }
                if (type != 5) break block8;
                DataBufferByte dbb = (DataBufferByte)db;
                byte[] data = dbb.getData();
                out = new BufferedImage(nw, nh, 5);
                DataBufferByte dbo = (DataBufferByte)out.getRaster().getDataBuffer();
                byte[] outdata = dbo.getData();
                for (int i = 0; i < nh; ++i) {
                    for (int j = 0; j < nw; ++j) {
                        int ii = scX * i;
                        int jj = scY * j;
                        if (ii < 0 || ii >= h || jj < 0 || jj >= w) continue;
                        outdata[i * (nw * 3) + j * 3] = data[offset + ii * (w * 3) + jj * 3];
                        outdata[i * (nw * 3) + j * 3 + 1] = data[offset + ii * (w * 3) + jj * 3 + 1];
                        outdata[i * (nw * 3) + j * 3 + 2] = data[offset + ii * (w * 3) + jj * 3 + 2];
                    }
                }
                break block7;
            }
            if (type != 1) break block7;
            DataBufferInt dbi = (DataBufferInt)db;
            int[] data = dbi.getData();
            out = new BufferedImage(nw, nh, 1);
            DataBufferInt dbo = (DataBufferInt)out.getRaster().getDataBuffer();
            int[] outdata = dbo.getData();
            for (int i = 0; i < nh; ++i) {
                for (int j = 0; j < nw; ++j) {
                    int ii = scX * i;
                    int jj = scY * j;
                    if (ii < 0 || ii >= h || jj < 0 || jj >= w) continue;
                    outdata[i * nw + j] = data[offset + ii * w + jj];
                }
            }
        }
        return out;
    }

    public static PixelDiff diff(BufferedImage op1, BufferedImage op2, BufferedImage res) {
        byte b1;
        byte g1;
        byte r1;
        int i;
        byte[] out;
        Object[] buff2;
        byte[] buff1;
        int type1 = op1.getType();
        int type2 = op2.getType();
        DataBuffer db1 = op1.getRaster().getDataBuffer();
        DataBuffer db2 = op2.getRaster().getDataBuffer();
        DataBuffer dbr = res.getRaster().getDataBuffer();
        PixelDiff ps = new PixelDiff(3);
        if (type1 == 1 && type2 == 0 || type1 == 0 && type2 == 1) {
            buff1 = null;
            buff2 = null;
            out = ((DataBufferByte)dbr).getData();
            if (type1 == 1) {
                buff2 = ((DataBufferInt)db1).getData();
                buff1 = ((DataBufferByte)db2).getData();
            } else {
                buff2 = ((DataBufferInt)db2).getData();
                buff1 = ((DataBufferByte)db1).getData();
            }
            for (i = 0; i < buff2.length; ++i) {
                r1 = buff1[3 * i + 0];
                g1 = buff1[3 * i + 1];
                b1 = buff1[3 * i + 2];
                int pixVal = buff2[i];
                byte r2 = (byte)(pixVal >> 16 & 0xFF);
                byte g2 = (byte)(pixVal >> 8 & 0xFF);
                byte b2 = (byte)(pixVal & 0xFF);
                int dr = r2 - r1;
                int dg = g2 - g1;
                int db = b2 - b1;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
                out[3 * i + 0] = (byte)db;
                out[3 * i + 1] = (byte)dg;
                out[3 * i + 2] = (byte)dr;
            }
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)buff2.length);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)buff2.length);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)buff2.length);
        } else if (type1 == 0 && type2 == 0) {
            buff1 = null;
            buff2 = null;
            out = ((DataBufferByte)dbr).getData();
            buff2 = ((DataBufferByte)db1).getData();
            buff1 = ((DataBufferByte)db2).getData();
            for (i = 0; i < buff2.length; i += 3) {
                r1 = buff1[i + 0];
                g1 = buff1[i + 1];
                b1 = buff1[i + 2];
                byte r2 = buff1[i + 0];
                byte g2 = buff1[i + 1];
                byte b2 = buff1[i + 2];
                int dr = r2 - r1;
                int dg = g2 - g1;
                int db = b2 - b1;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
                out[i + 0] = (byte)db;
                out[i + 1] = (byte)dg;
                out[i + 2] = (byte)dr;
            }
            int len = buff2.length / 3;
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)len);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)len);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)len);
        }
        if (type1 == 1 && type2 == 1) {
            byte[] out2 = ((DataBufferByte)dbr).getData();
            int[] buff12 = ((DataBufferInt)db1).getData();
            int[] buff22 = ((DataBufferInt)db2).getData();
            for (i = 0; i < buff22.length; ++i) {
                int pixVal1 = buff12[i];
                byte r12 = (byte)(pixVal1 >> 16 & 0xFF);
                byte g12 = (byte)(pixVal1 >> 8 & 0xFF);
                byte b12 = (byte)(pixVal1 & 0xFF);
                int pixVal2 = buff22[i];
                byte r2 = (byte)(pixVal2 >> 16 & 0xFF);
                byte g2 = (byte)(pixVal2 >> 8 & 0xFF);
                byte b2 = (byte)(pixVal2 & 0xFF);
                int dr = r2 - r12;
                int dg = g2 - g12;
                int db = b2 - b12;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
                out2[3 * i + 0] = (byte)db;
                out2[3 * i + 1] = (byte)dg;
                out2[3 * i + 2] = (byte)dr;
            }
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)buff22.length);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)buff22.length);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)buff22.length);
        }
        return ps;
    }

    public static void imageSave(RenderedImage rimg, String imgFormat, String fileName) {
        try {
            File f = new File(fileName);
            ImageIO.write(rimg, imgFormat, f);
        }
        catch (IOException ex) {
            System.err.println("ERROR: Writing to " + fileName);
        }
    }

    public static BufferedImage genImage(JComponent jc) {
        BufferedImage bimg = new BufferedImage(jc.getWidth(), jc.getHeight(), 2);
        jc.paint(bimg.getGraphics());
        return bimg;
    }

    public static BufferedImage imageRead(String fileName) {
        BufferedImage readImage = null;
        try {
            File f = new File(fileName);
            readImage = ImageIO.read(f);
        }
        catch (IOException ex) {
            System.err.println("ERROR: Reading from " + fileName);
        }
        return readImage;
    }

    public static boolean getMinMax(XpMedicalImage ximg, double[] minmax) {
        if (ximg == null) {
            return false;
        }
        DICOMLut[] vlut = DICOMLut.loadVoiLuts(ximg);
        if (vlut != null) {
            minmax[0] = vlut[0].getFirstValueMapped();
            minmax[1] = vlut[0].getLastValueMapped();
            return true;
        }
        XpSlice slice = ximg.getSlice();
        int subsample = 16;
        if (slice.width <= 128 && slice.height <= 128) {
            subsample = 4;
        }
        XpImageUtils.getMinMax(ximg, subsample, minmax);
        return true;
    }

    public static boolean getMinMax(XpImage ximg, int subsample, double[] minmax) {
        if (ximg == null) {
            return false;
        }
        try {
            XpPixelStatistics pixStats = XpImageUtils.calcStats(ximg, subsample, null);
            minmax[0] = pixStats.getMin();
            minmax[1] = pixStats.getMax();
        }
        catch (Exception e) {
            minmax[0] = 0.0;
            minmax[1] = 1200.0;
        }
        return true;
    }

    public static JFrame displayImage(RenderedImage bi) {
        return XpImageUtils.displayImage(bi, "Image");
    }

    public static JComponent displayHistogram(int[] hist, int xmin, int xmax, String legend) {
        XpPlotModel mpm = new XpPlotModel();
        XpPlotter mp = new XpPlotter(mpm);
        mpm.clearWaveforms();
        ArrayList<Point2D.Double> waveform = new ArrayList<Point2D.Double>();
        double deltaX = (double)(xmax - xmin + 1) / (double)hist.length;
        waveform.add(new Point2D.Double(0.0, 0.0));
        waveform.add(new Point2D.Double(xmin, 0.0));
        double x = xmin;
        int i = 0;
        while (i < hist.length) {
            Point2D.Double p = new Point2D.Double(x, hist[i]);
            waveform.add(p);
            ++i;
            x += deltaX;
        }
        mpm.addWaveform(waveform, legend);
        JFrame frame = new JFrame("Histogram");
        frame.setContentPane(mp);
        frame.pack();
        frame.setVisible(true);
        return mp;
    }

    public static JComponent displayHistogram(RenderedImage ri, int bSize, String legend) {
        JFrame frame = new JFrame("Histogram");
        JPanel histGraph = XpImageUtils.getHistogram(ri, bSize, legend);
        frame.setContentPane(histGraph);
        frame.pack();
        frame.setVisible(true);
        return histGraph;
    }

    public static JPanel getHistogram(RenderedImage ri, int bSize, String legend) {
        XpPixelStatistics ps = XpImageUtils.calcStats(ri, 1.0, 0.0, 1, 1, null);
        JnHistogram histogram = new JnHistogram(80);
        XpImageUtils.calcHistogram(ri, 1, 1, histogram);
        int[] hist = histogram.histogram;
        double[] minmax = new double[]{ps.getMin(), ps.getMax()};
        int npts = hist.length;
        XpPlotModel mpm = new XpPlotModel();
        XpPlotter mp = new XpPlotter(mpm);
        mpm.clearWaveforms();
        ArrayList<Point2D.Double> waveform = new ArrayList<Point2D.Double>();
        waveform.add(new Point2D.Double(0.0, 0.0));
        waveform.add(new Point2D.Double(minmax[0], 0.0));
        for (int i = 0; i < npts; ++i) {
            Point2D.Double p = new Point2D.Double((double)(bSize * i) + minmax[0], hist[i]);
            waveform.add(p);
        }
        mpm.addWaveform(waveform, legend);
        return mp;
    }

    public static double gehcAzimuth(XpMedicalImage mimg) {
        Integer type;
        int itype;
        int r2;
        String imgType;
        int r1 = mimg.getValue(imgtype);
        if (r1 == 0 && (imgType = "" + XpImageUtils.imgtype.value).indexOf("LOCALIZER") >= 0 && (r2 = mimg.getValue(scouttype)) == 0 && XpImageUtils.scouttype.value instanceof Integer && (itype = (type = (Integer)XpImageUtils.scouttype.value).intValue()) == 2) {
            return 270.0;
        }
        return 0.0;
    }

    public static double calcShapeLength(Shape shape, double pdX, double pdY) {
        double px = 0.0;
        double py = 0.0;
        double len = 0.0;
        boolean prev = false;
        PathIterator pi = shape.getPathIterator(null, 0.5);
        while (!pi.isDone()) {
            pi.currentSegment(_reg);
            double x = _reg[0];
            double y = _reg[1];
            int segType = pi.getWindingRule();
            switch (segType) {
                case 0: {
                    px = x;
                    py = y;
                    prev = true;
                    break;
                }
                case 1: {
                    if (prev) {
                        double dx = (x - px) * pdX;
                        double dy = (y - py) * pdY;
                        double dlen = Math.sqrt(dx * dx + dy * dy);
                        len += dlen;
                    }
                    prev = true;
                    px = x;
                    py = y;
                    break;
                }
            }
            pi.next();
            if (!pi.isDone()) continue;
            break;
        }
        return len;
    }

    public static JFrame displayImage(RenderedImage bi, String title) {
        ImagePanel imgPanel = new ImagePanel(bi);
        JFrame frame = new JFrame(title);
        frame.setContentPane(imgPanel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static JFrame displayImage(XpMedicalImage mi, String title) {
        int w = mi.getSlice().getSliceColumns();
        int h = mi.getSlice().getSliceRows();
        XpImageViewport iv = new XpImageViewport();
        iv.setPreferredSize(new Dimension(w, h));
        iv.addImage(mi);
        JFrame frame = new JFrame(title);
        frame.setContentPane(iv);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static JFrame displayImage(XjImage mi, String title) {
        return XpImageUtils.displayImage(new XjMedicalImage(mi), title);
    }

    public static void printARGB(int argb) {
        long a = argb >> 24 & 0xFF;
        long r = argb >> 16 & 0xFF;
        long g = argb >> 8 & 0xFF;
        long b = argb & 0xFF;
        System.out.println("ALPHA=" + a + " RED=" + r + " GREEN=" + g + " BLUE=" + b);
    }

    private static Raster getRaster(RenderedImage ri) {
        Raster r = null;
        if (ri != null) {
            r = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        return r;
    }

    private static double square(double val) {
        return val * val;
    }

    public static XpPixelStatistics calcStats(XpImage img, int subSample, XpPixelStatistics ps) {
        RenderedImage rimg = img.getPixelData();
        double rescaleSlope = img.getRescaleSlope();
        double rescaleIntercept = img.getRescaleIntercept();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        return XpImageUtils.calcStats(rimg, rescaleSlope, rescaleIntercept, pixelRepresentation, subSample, ps);
    }

    @Deprecated
    public static XpPixelStatistics calcStats(RenderedImage rimg, double rescaleSlope, double rescaleIntercept, int subSample, XpPixelStatistics ps) {
        return XpImageUtils.calcStats(rimg, rescaleSlope, rescaleIntercept, 1, subSample, ps);
    }

    public static XpPixelStatistics calcStats(RenderedImage rimg, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, int subSample, XpPixelStatistics ps) {
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        ps.resetStatistics();
        int imageWidth = rimg.getWidth();
        int imageHeight = rimg.getHeight();
        Raster r = XpImageUtils.getRaster(rimg);
        int x1 = r.getMinX();
        int y1 = r.getMinY();
        int x2 = x1 + imageWidth;
        int y2 = y1 + imageHeight;
        ps.bounds.setBounds(x1, y1, imageWidth, imageHeight);
        DataBuffer db = r.getDataBuffer();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        ps.min = Double.MAX_VALUE;
        ps.max = Double.MIN_VALUE;
        if (sdata != null) {
            for (int y = y1; y < y2; y += subSample) {
                for (int x = x1; x < x2; x += subSample) {
                    int pval;
                    int n = pval = pixelRepresentation != 0 ? sdata[offset + y * imageWidth + x] : sdata[offset + y * imageWidth + x] & 0xFFFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    ps.sumSq += XpImageUtils.square(pval);
                    ps.sum += (double)pval;
                    ++ps.npixels;
                }
            }
        } else if (bdata != null) {
            for (int y = y1; y < y2; y += subSample) {
                for (int x = x1; x < x2; x += subSample) {
                    int pval = bdata[offset + y * imageWidth + x] & 0xFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    ps.sumSq += XpImageUtils.square(pval);
                    ps.sum += (double)pval;
                    ++ps.npixels;
                }
            }
        } else if (idata != null) {
            for (int y = y1; y < y2; y += subSample) {
                for (int x = x1; x < x2; x += subSample) {
                    int pval = idata[offset + y * imageWidth + x];
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    ps.sumSq += XpImageUtils.square(pval);
                    ps.sum += (double)pval;
                    ++ps.npixels;
                }
            }
        }
        ps.min = ps.min == Double.MAX_VALUE ? 0.0 : ps.min;
        ps.max = ps.max == Double.MIN_VALUE ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = ps.mean * rescaleSlope + rescaleIntercept;
        ps.max = ps.max * rescaleSlope + rescaleIntercept;
        ps.min = ps.min * rescaleSlope + rescaleIntercept;
        ps.sumSq = XpImageUtils.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * XpImageUtils.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        return ps;
    }

    public static int getPixelRepresentation(XpImage img) {
        int pixelRepresentation = 1;
        try {
            XpDicomElement de;
            int retval;
            if (img instanceof XpDicomObject && (retval = ((XpDicomObject)((Object)img)).getValue(de = new XpDicomElement(40, 259))) == 0 && de.value != null) {
                pixelRepresentation = Integer.parseInt(de.value.toString());
            }
        }
        catch (NumberFormatException e) {
            XpLog.warning("Pixel representation tag (0x0028,0x0103 ) is not valid number");
        }
        return pixelRepresentation;
    }

    public static int getPixelRepresentation(XjDicomObject obj) {
        Object pixRep;
        int pixelRepresentation = 1;
        if (null != obj && null != (pixRep = obj.getValue(40, 259))) {
            try {
                pixelRepresentation = Integer.parseInt(pixRep.toString());
            }
            catch (NumberFormatException e) {
                XpLog.warning("Pixel representation tag (0x0028,0x0103 ) is not valid number");
            }
        }
        return pixelRepresentation;
    }

    public static int getBitsStored(XjDicomObject obj) {
        int bitsStored = -1;
        if (null != obj) {
            Object bitsStoredObj = obj.getValue(40, 257);
            if (null != bitsStoredObj) {
                try {
                    bitsStored = Integer.parseInt("" + bitsStoredObj);
                }
                catch (NumberFormatException e) {
                    XpLog.warning("Bits Stored tag (0x0028, 0x0101) is not a valid integer, using 0");
                }
            } else {
                bitsStored = XpImageUtils.getBitsAllocated(obj);
            }
        }
        return bitsStored;
    }

    public static int getBitsAllocated(XjDicomObject obj) {
        Object bitsAllocatedObj;
        int bitsAllocated = -1;
        if (null != obj && null != (bitsAllocatedObj = obj.getValue(40, 256))) {
            try {
                bitsAllocated = Integer.parseInt("" + bitsAllocatedObj);
            }
            catch (NumberFormatException e) {
                XpLog.warning("Bits Stored tag (0x0028, 0x0100) is not a valid integer, using 0");
            }
        }
        return bitsAllocated;
    }

    public static String getModality(XjDicomObject obj) {
        Object modalityObj;
        String modality = "XX";
        if (null != obj && null != (modalityObj = obj.getValue(8, 96))) {
            modality = ("" + modalityObj).toUpperCase();
        }
        return modality;
    }

    public static void calcHistogram(XpImage img, int subsample, JnHistogram hist) {
        RenderedImage rimg = img.getPixelData();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        XpImageUtils.calcHistogram(rimg, pixelRepresentation, subsample, hist);
    }

    @Deprecated
    public static void calcHistogram(RenderedImage rimg, int subsample, JnHistogram hist) {
        XpImageUtils.calcHistogram(rimg, 1, subsample, hist);
    }

    public static void calcHistogram(RenderedImage rimg, int pixelRepresentation, int subsample, JnHistogram hist) {
        Raster r = null;
        r = rimg instanceof BufferedImage ? ((BufferedImage)rimg).getRaster() : rimg.getData();
        int imageWidth = rimg.getWidth();
        int imageHeight = rimg.getHeight();
        int x1 = r.getMinX();
        int y1 = r.getMinY();
        int x2 = x1 + imageWidth;
        int y2 = y1 + imageHeight;
        DataBuffer db = r.getDataBuffer();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        XpPixelStatistics ps = XpImageUtils.calcStats(rimg, 1.0, 0.0, pixelRepresentation, subsample, null);
        int[] histogram = hist.histogram;
        Arrays.fill(histogram, 0);
        double bucketSize = (ps.max - ps.min) / (double)histogram.length;
        int maxX = 0;
        int maxY = 0;
        for (int y = y1; y < y2; y += subsample) {
            for (int x = x1; x < x2; x += subsample) {
                int pval = 0;
                if (sdata != null) {
                    pval = pixelRepresentation != 0 ? sdata[offset + y * imageWidth + x] : sdata[offset + y * imageWidth + x] & 0xFFFF;
                } else if (bdata != null) {
                    pval = bdata[offset + y * imageWidth + x] & 0xFF;
                } else if (idata != null) {
                    pval = idata[offset + y * imageWidth + x];
                }
                int bucket = (int)(((double)pval - ps.min) / bucketSize);
                if (bucket < 0) {
                    bucket = 0;
                } else if (bucket >= histogram.length) {
                    bucket = histogram.length - 1;
                }
                int n = bucket;
                histogram[n] = histogram[n] + 1;
                if (histogram[bucket] <= maxY) continue;
                maxY = histogram[bucket];
                maxX = bucket;
            }
        }
        hist.bucketSize = bucketSize;
        hist.startX = ps.min;
        hist.endX = ps.max;
        hist.maximumPt.setLocation(maxX, maxY);
    }

    @Deprecated
    public static void calcHistogram(RenderedImage rimg, XpPixelStatistics ps, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, JnHistogram hist) {
        XpImageUtils.calcHistogram(rimg, ps, bitimg, rescaleSlope, rescaleIntercept, 1, hist);
    }

    public static void calcHistogram(RenderedImage rimg, XpPixelStatistics ps, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, JnHistogram hist) {
        int width = rimg.getWidth();
        int ROWLEN_BITMAP = (width + 7) / 8;
        int[] histogram = hist.histogram;
        Arrays.fill(histogram, 0);
        double maxval = (ps.max - rescaleIntercept) / rescaleSlope;
        double minval = (ps.min - rescaleIntercept) / rescaleSlope;
        double BUCKETSIZE = (maxval - minval) / (double)histogram.length;
        Raster r = XpImageUtils.getRaster(rimg);
        DataBuffer db = r.getDataBuffer();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        int maxX = 0;
        int maxY = 0;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        int sX = ps.bounds.x;
        int sY = ps.bounds.y;
        int eX = ps.bounds.x + ps.bounds.width;
        int eY = ps.bounds.y + ps.bounds.height;
        for (int y = sY; y <= eY; ++y) {
            int idx_offset = y * ROWLEN_BITMAP;
            for (int x = sX; x <= eX; ++x) {
                int bit = x & 7;
                int idx = idx_offset + x / 8;
                int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx];
                if (on == 0) continue;
                int pval = 0;
                if (sdata != null) {
                    pval = pixelRepresentation != 0 ? sdata[y * width + x] : sdata[y * width + x] & 0xFFFF;
                } else if (bdata != null) {
                    pval = bdata[y * width + x] & 0xFF;
                } else if (idata != null) {
                    pval = idata[y * width + x];
                }
                int bucket = (int)(((double)pval - minval) / BUCKETSIZE);
                if (bucket >= histogram.length) {
                    bucket = histogram.length - 1;
                }
                try {
                    int n = bucket;
                    histogram[n] = histogram[n] + 1;
                    if (histogram[bucket] <= maxY) continue;
                    maxY = histogram[bucket];
                    maxX = bucket;
                    continue;
                }
                catch (Exception ex) {
                    XpLog.logger().warning("Histogram Array Indexing problem: bucket=" + bucket + " | min=" + ps.min + " | pval=" + pval + " | BucketSize=" + BUCKETSIZE);
                }
            }
        }
        hist.bucketSize = BUCKETSIZE;
        hist.startX = ps.min;
        hist.endX = ps.max;
        hist.maximumPt.setLocation(maxX, maxY);
    }

    @Deprecated
    public static void calcStats(RenderedImage rimg, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, int x1, int y1, int x2, int y2, XpPixelStatistics ps) {
        XpImageUtils.calcStats(rimg, bitimg, rescaleSlope, rescaleIntercept, 1, x1, y1, x2, y2, ps);
    }

    public static void calcStats(RenderedImage rimg, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, int x1, int y1, int x2, int y2, XpPixelStatistics ps) {
        int width = Math.min(rimg.getWidth(), bitimg.getWidth());
        int height = Math.min(rimg.getHeight(), bitimg.getHeight());
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (x2 >= width) {
            x2 = width - 1;
        }
        if (y2 >= height) {
            y2 = height - 1;
        }
        int RBLEN = width / 8;
        if (width % 8 != 0) {
            ++RBLEN;
        }
        ps.resetStatistics();
        int bx1 = Integer.MAX_VALUE;
        int by1 = Integer.MAX_VALUE;
        int bx2 = Integer.MIN_VALUE;
        int by2 = Integer.MIN_VALUE;
        Raster r = XpImageUtils.getRaster(rimg);
        DataBuffer db = r.getDataBuffer();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        ps.min = Double.MAX_VALUE;
        ps.max = Double.MIN_VALUE;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        if (sdata != null) {
            for (int y = y1; y <= y2; ++y) {
                int idx_offset = y * RBLEN;
                for (int x = x1; x <= x2; ++x) {
                    int pval;
                    int bit = x & 7;
                    int idx = idx_offset + x / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on == 0) continue;
                    int n = pval = pixelRepresentation != 0 ? sdata[offset + y * width + x] : sdata[offset + y * width + x] & 0xFFFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    if (x < bx1) {
                        bx1 = x;
                    }
                    if (y < by1) {
                        by1 = y;
                    }
                    if (x > bx2) {
                        bx2 = x;
                    }
                    if (y > by2) {
                        by2 = y;
                    }
                    ps.sum += (double)pval;
                    ps.sumSq += XpImageUtils.square(pval);
                    ++ps.npixels;
                }
            }
        } else if (bdata != null) {
            for (int y = y1; y <= y2; ++y) {
                int idx_offset = y * RBLEN;
                for (int x = x1; x <= x2; ++x) {
                    int bit = x & 7;
                    int idx = idx_offset + x / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on == 0) continue;
                    int pval = bdata[offset + y * width + x] & 0xFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    if (x < bx1) {
                        bx1 = x;
                    }
                    if (y < by1) {
                        by1 = y;
                    }
                    if (x > bx2) {
                        bx2 = x;
                    }
                    if (y > by2) {
                        by2 = y;
                    }
                    ps.sum += (double)pval;
                    ps.sumSq += XpImageUtils.square(pval);
                    ++ps.npixels;
                }
            }
        } else if (idata != null) {
            for (int y = y1; y <= y2; ++y) {
                int idx_offset = y * RBLEN;
                for (int x = x1; x <= x2; ++x) {
                    int bit = x & 7;
                    int idx = idx_offset + x / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on == 0) continue;
                    int pval = idata[offset + y * width + x];
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    if (x < bx1) {
                        bx1 = x;
                    }
                    if (y < by1) {
                        by1 = y;
                    }
                    if (x > bx2) {
                        bx2 = x;
                    }
                    if (y > by2) {
                        by2 = y;
                    }
                    ps.sum += (double)pval;
                    ps.sumSq += XpImageUtils.square(pval);
                    ++ps.npixels;
                }
            }
        }
        ps.bounds.setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        ps.min = ps.min == Double.MAX_VALUE ? 0.0 : ps.min;
        ps.max = ps.max == Double.MIN_VALUE ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = rescaleSlope * ps.mean + rescaleIntercept;
        ps.max = rescaleSlope * ps.max + rescaleIntercept;
        ps.min = rescaleSlope * ps.min + rescaleIntercept;
        ps.sumSq = XpImageUtils.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * XpImageUtils.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
    }

    public static XpPixelStatistics calcStats(J3DVolumeModel jvm, int subSample, XpPixelStatistics ps) {
        double rescaleSlope = jvm.j_vol.rescaleSlope;
        double rescaleIntercept = jvm.j_vol.rescaleIntercept;
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        ps.resetStatistics();
        int dx = jvm.j_vol.dx;
        int dy = jvm.j_vol.dy;
        int dz = jvm.j_vol.dz;
        int offset = jvm.j_vol.PAD;
        short[] sdata = null;
        byte[] bdata = null;
        if (jvm.j_vol instanceof JVolume.LinearShort) {
            sdata = ((JVolume.LinearShort)jvm.j_vol).volume;
        } else if (jvm.j_vol instanceof JVolume.LinearByte) {
            bdata = ((JVolume.LinearByte)jvm.j_vol).volume;
        }
        ps.min = Double.MAX_VALUE;
        ps.max = Double.MIN_VALUE;
        int pgsize = dy * dx;
        if (sdata != null) {
            for (int z = 0; z < dz; z += subSample) {
                for (int y = 0; y < dy; y += subSample) {
                    for (int x = 0; x < dx; x += subSample) {
                        short pval = sdata[offset + z * pgsize + y * dx + x];
                        if ((double)pval < ps.min) {
                            ps.min = pval;
                        }
                        if ((double)pval > ps.max) {
                            ps.max = pval;
                        }
                        ps.sumSq += XpImageUtils.square(pval);
                        ps.sum += (double)pval;
                        ++ps.npixels;
                    }
                }
            }
        } else if (bdata != null) {
            for (int z = 0; z < dz; z += subSample) {
                for (int y = 0; y < dy; y += subSample) {
                    for (int x = 0; x < dx; x += subSample) {
                        int pval = bdata[offset + z * pgsize + y * dx + x] & 0xFF;
                        if ((double)pval < ps.min) {
                            ps.min = pval;
                        }
                        if ((double)pval > ps.max) {
                            ps.max = pval;
                        }
                        ps.sumSq += XpImageUtils.square(pval);
                        ps.sum += (double)pval;
                        ++ps.npixels;
                    }
                }
            }
        }
        ps.min = ps.min == Double.MAX_VALUE ? 0.0 : ps.min;
        ps.max = ps.max == Double.MIN_VALUE ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = ps.mean * rescaleSlope + rescaleIntercept;
        ps.max = ps.max * rescaleSlope + rescaleIntercept;
        ps.min = ps.min * rescaleSlope + rescaleIntercept;
        ps.sumSq = XpImageUtils.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * XpImageUtils.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        return ps;
    }

    public static Object getPixelValue(RenderedImage rimg, int x, int y) {
        Number pixelvalue = null;
        DataBuffer db = rimg.getData().getDataBuffer();
        int imageWidth = rimg.getWidth();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
            pixelvalue = sdata[offset + y * imageWidth + x] & 0xFFFF;
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
            pixelvalue = sdata[offset + y * imageWidth + x];
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
            pixelvalue = bdata[offset + y * imageWidth + x];
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
            pixelvalue = idata[offset + y * imageWidth + x];
        }
        return pixelvalue;
    }

    private XpImageUtils() {
    }

    public static BufferedImage loadColorPalette(XpMedicalImage img, BufferedImage result) {
        BufferedImage bimg;
        block21: {
            int len;
            int offset;
            DataBuffer db;
            int minVal;
            int numEntries;
            XpDicomElement[] tags;
            block19: {
                byte[] bluePalette;
                byte[] greenPalette;
                byte[] redPalette;
                block20: {
                    int width = img.getSlice().width;
                    int height = img.getSlice().height;
                    BufferedImage piximage = (BufferedImage)img.getPixelData();
                    int ncolors = piximage.getColorModel().getColorSpace().getNumComponents();
                    if (ncolors > 1) {
                        return piximage;
                    }
                    boolean RedPaletteColorLookupTableDescriptor = false;
                    boolean GreenPaletteColorLookupTableDescriptor = true;
                    int BluePaletteColorLookupTableDescriptor = 2;
                    int RedPaletteColorLookupTableData = 3;
                    int GreenPaletteColorLookupTableData = 4;
                    int BluePaletteColorLookupTableData = 5;
                    tags = new XpDicomElement[]{new XpDicomElement(40, 4353), new XpDicomElement(40, 4354), new XpDicomElement(40, 4355), new XpDicomElement(40, 4609), new XpDicomElement(40, 4610), new XpDicomElement(40, 4611)};
                    img.getValues(tags);
                    if (tags[0].value == null || tags[1].value == null || tags[2].value == null || tags[3].value == null || tags[4].value == null || tags[5].value == null) {
                        XpLog.warning("Invalid Palette Color Tags. Returning original image.");
                        return piximage;
                    }
                    XpLog.info("Color palette handled by JAMI, not TAP.");
                    bimg = result;
                    if (bimg == null || result.getWidth() != width || result.getHeight() != height) {
                        bimg = new BufferedImage(width, height, 1);
                    }
                    int[] rgb = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData();
                    Integer[] descriptor = (Integer[])tags[0].value;
                    numEntries = descriptor[0];
                    if (numEntries == 0) {
                        numEntries = 65536;
                    }
                    minVal = descriptor[1];
                    int numBits = descriptor[2];
                    db = piximage.getRaster().getDataBuffer();
                    offset = db.getOffset();
                    len = width * height;
                    if (numBits != 8 || !(tags[3].value instanceof byte[])) break block19;
                    redPalette = (byte[])tags[3].value;
                    greenPalette = (byte[])tags[4].value;
                    bluePalette = (byte[])tags[5].value;
                    if (!(db instanceof DataBufferByte)) break block20;
                    byte[] pixelData = ((DataBufferByte)db).getData();
                    for (int i = offset; i < offset + len; ++i) {
                        int idx = pixelData[i] & 0xFF;
                        int newidx = idx - minVal;
                        if (newidx < 0) {
                            newidx = 0;
                        }
                        if (newidx >= numEntries) {
                            newidx = numEntries - 1;
                        }
                        int rval = redPalette[newidx] & 0xFF;
                        int gval = greenPalette[newidx] & 0xFF;
                        int bval = bluePalette[newidx] & 0xFF;
                        rgb[i] = rval << 16 | gval << 8 | bval;
                    }
                    break block21;
                }
                if (!(db instanceof DataBufferUShort)) break block21;
                short[] pixelData = ((DataBufferUShort)db).getData();
                for (int i = offset; i < offset + len; ++i) {
                    int idx = pixelData[i] & 0xFFFF;
                    int newidx = idx - minVal;
                    if (newidx < 0) {
                        newidx = 0;
                    }
                    if (newidx >= numEntries) {
                        newidx = numEntries - 1;
                    }
                    int rval = redPalette[newidx] & 0xFF;
                    int gval = greenPalette[newidx] & 0xFF;
                    int bval = bluePalette[newidx] & 0xFF;
                    rgb[i] = rval << 16 | gval << 8 | bval;
                }
                break block21;
            }
            short[] redPalette = (short[])tags[3].value;
            short[] greenPalette = (short[])tags[4].value;
            short[] bluePalette = (short[])tags[5].value;
            if (db instanceof DataBufferByte) {
                byte[] pixelData = ((DataBufferByte)db).getData();
                for (int i = offset; i < offset + len; ++i) {
                    int idx = pixelData[i] & 0xFF;
                    int newidx = idx - minVal;
                    if (newidx < 0) {
                        newidx = 0;
                    }
                    if (newidx >= numEntries) {
                        newidx = numEntries - 1;
                    }
                    int rval = redPalette[newidx] >> 8 & 0xFF;
                    int gval = greenPalette[newidx] >> 8 & 0xFF;
                    int bval = bluePalette[newidx] >> 8 & 0xFF;
                    rgb[i] = rval << 16 | gval << 8 | bval;
                }
            } else if (db instanceof DataBufferUShort) {
                short[] pixelData = ((DataBufferUShort)db).getData();
                for (int i = offset; i < offset + len; ++i) {
                    int idx = pixelData[i] & 0xFFFF;
                    int newidx = idx - minVal;
                    if (newidx < 0) {
                        newidx = 0;
                    }
                    if (newidx >= numEntries) {
                        newidx = numEntries - 1;
                    }
                    int rval = redPalette[newidx] >> 8 & 0xFF;
                    int gval = greenPalette[newidx] >> 8 & 0xFF;
                    int bval = bluePalette[newidx] >> 8 & 0xFF;
                    rgb[i] = rval << 16 | gval << 8 | bval;
                }
            }
        }
        return bimg;
    }

    private static double parseValue(Object obj) {
        double value = Double.NEGATIVE_INFINITY;
        if (null != obj) {
            try {
                if (obj instanceof String) {
                    StringTokenizer st = new StringTokenizer((String)obj, "\\");
                    String token = st.nextToken();
                    value = Double.parseDouble(token);
                } else if (obj instanceof Number) {
                    value = ((Number)obj).doubleValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static double parseImageWL(Object obj) {
        double deflevel = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == deflevel) {
            deflevel = -32767.0;
            XpLog.fine("Could not parse window level");
        }
        return deflevel;
    }

    public static double parseImageWW(Object obj) {
        double defwidth = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == defwidth) {
            defwidth = -1.0;
            XpLog.fine("Could not parse window width");
        }
        return defwidth;
    }

    public static double parseImageRescaleIntercept(Object obj) {
        double rescaleIntercept = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == rescaleIntercept) {
            rescaleIntercept = 0.0;
            XpLog.fine("Could not parse rescale intercept, using default");
        }
        return rescaleIntercept;
    }

    public static double parseImageRescaleSlope(Object obj) {
        double rescaleSlope = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == rescaleSlope) {
            rescaleSlope = 1.0;
            XpLog.fine("Could not parse rescale slope, using default");
        }
        return rescaleSlope;
    }

    public static class ImagePanel
    extends JPanel {
        private RenderedImage image = null;

        public ImagePanel(RenderedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawRenderedImage(this.image, null);
        }
    }

    public static final class PixelDiff {
        public long[] diff = null;
        public double[] rms = null;
        public int nbanks = 0;

        public PixelDiff(int nBanks) {
            this.nbanks = nBanks;
            this.diff = new long[this.nbanks];
            this.rms = new double[this.nbanks];
        }

        public String toString() {
            int i;
            String str = "absdiff=[";
            for (i = 0; i < this.nbanks; ++i) {
                str = str + this.diff[i];
                if (i >= this.nbanks - 1) continue;
                str = str + ",";
            }
            str = str + "]";
            str = str + "  rms=[";
            for (i = 0; i < this.nbanks; ++i) {
                str = str + this.rms[i];
                if (i >= this.nbanks - 1) continue;
                str = str + ",";
            }
            str = str + "]";
            return str;
        }
    }
}

