/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;

public class XpImageGrid
extends XpRoiHandleContainer
implements Replicable {
    private double _gridSpacing = 50.0;
    private double _tickSpacing = 10.0;
    private double _tickLength = 5.0;
    private boolean _gridLinesON = true;
    private String _lineStyle = null;
    private int _numberOfTickLines = 0;
    private int _numberOfPolyLines = 0;
    private int _numberOfAxis = 0;
    private int _numberOfTexts = 0;
    private double _centerX = 0.0;
    private double _centerY = 0.0;
    private int _rectWidth = 0;
    private int _rectHeight = 0;
    private double _zoom = 0.0;
    private double _pixelSizeX = 0.0;
    private double _pixelSizeY = 0.0;
    private int _xTextOffset = 0;
    private int _yTextOffset = 0;
    private CTransform imgDispTrans = null;
    private CTransform dispImgTras = null;
    private XpSingularPort vp = null;
    private CPoint[] _polyLine = null;
    private CPoint[] _axis = null;
    private CPoint[] _text = null;
    private CPoint[] _tickLine = null;
    private String[] _textValue = null;
    private CPoint centerImagePoint = new CPoint(0);
    private CPoint oneImageTick = new CPoint(0);
    private CPoint oneImageGrid = new CPoint(0);
    private CPoint imageTickDelta = new CPoint(0);
    private CPoint centerPoint = new CPoint(1);
    private CPoint oneTick = new CPoint(1);
    private CPoint oneGrid = new CPoint(1);
    private CPoint tickDelta = new CPoint(1);
    private CPoint p1 = new CPoint(1);
    private CPoint p2 = new CPoint(1);
    private CPoint p3 = new CPoint(1);
    private CPoint p4 = new CPoint(1);
    private Color col = Color.WHITE;
    private static final DecimalFormat df = new DecimalFormat("0.0");
    private boolean mousedrag = false;
    private static final String DOTTEDLINE = "DOTTED";
    CPoint disp = new CPoint(1);
    CPoint imp = new CPoint(0);
    XpHandle moveHandle = null;
    private boolean selected = true;
    double cmWidth;
    double cmHeight;
    int nbOfCmW;
    int nbOfCmH;
    double zoom;
    double cmWidth_o;
    double cmHeight_o;
    double cmTHeight;
    double cmTWidth;
    double tickDeltaX;
    double tickDeltaY;
    int nbOfCmTH;
    int nbOfCmTW;
    double height_2;
    double width_2;
    boolean showHandle = false;
    float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
    BasicStroke dottedStrk = new BasicStroke(1.0f, 0, 0, 10.0f, this.dashPattern, 0.0f);
    private XpGeomUtils gu = new XpGeomUtils();
    private CTransform transform = new CTransform();
    private CTransform _tempTrans = new CTransform();
    private Rectangle viewport = new Rectangle();
    private AffineTransform tx = new AffineTransform();
    XpSingularPort colneVp = null;
    XpImageRenderAttributes orgattr = null;
    int vp_w = 512;
    int vp_h = 512;
    int w = 256;
    int h = 256;

    public XpImageGrid(XpSingularPort obj) {
        this._lineStyle = DOTTEDLINE;
        this.vp = obj;
    }

    @Override
    public Object clone() {
        XpImageGrid ccr = new XpImageGrid(null);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o) {
        XpImageGrid is = (XpImageGrid)o;
        int cnt = this._polyLine.length;
        CPoint[] _cpolyLine = new CPoint[cnt];
        for (int i = 0; i < cnt; ++i) {
            _cpolyLine[i] = new CPoint(0);
            _cpolyLine[i] = (CPoint)this._polyLine[i].clone();
        }
        is._polyLine = _cpolyLine;
        cnt = this._axis.length;
        CPoint[] _caxis = new CPoint[cnt];
        for (int i = 0; i < cnt; ++i) {
            _caxis[i] = new CPoint(0);
            _caxis[i] = (CPoint)this._axis[i].clone();
        }
        is._axis = _caxis;
        cnt = this._text.length;
        CPoint[] _ctext = new CPoint[cnt];
        for (int i = 0; i < cnt; ++i) {
            _ctext[i] = new CPoint(0);
            _ctext[i] = (CPoint)this._text[i].clone();
        }
        is._text = _ctext;
        cnt = this._textValue.length;
        String[] _ctextValue = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            _ctextValue[i] = new String(this._textValue[i].toString());
        }
        is._textValue = _ctextValue;
        is.centerImagePoint = (CPoint)this.centerImagePoint.clone();
        is.oneImageTick = (CPoint)this.oneImageTick.clone();
        is.oneImageGrid = (CPoint)this.oneImageGrid.clone();
        is.imageTickDelta = (CPoint)this.imageTickDelta.clone();
        is.centerPoint = (CPoint)this.centerPoint.clone();
        is.oneTick = (CPoint)this.oneTick.clone();
        is.oneGrid = (CPoint)this.oneGrid.clone();
        is.tickDelta = (CPoint)this.tickDelta.clone();
        is.p1 = (CPoint)this.p1.clone();
        is.p2 = (CPoint)this.p2.clone();
        is.p3 = (CPoint)this.p3.clone();
        is.p4 = (CPoint)this.p4.clone();
        is.viewport = (Rectangle)this.viewport.clone();
    }

    public XpImageGrid(XpSingularPort obj, boolean show) {
        this.showHandle = show;
        this._lineStyle = DOTTEDLINE;
        this.vp = obj;
        if (this.showHandle) {
            this.moveHandle = new XpHandle((XpAnchorable)this, 0, 16);
            this.moveHandle.setFilled(false);
            this.add(this.moveHandle);
        }
    }

    public void initPaint(XpVisualComponent vc) {
        int i;
        if (this.vp == null || this.vp.getMedicalImageVc().getImageVc().getImage() == null) {
            if (vc.getParent().getParent().getParent() != null) {
                this.colneVp = (XpSingularPort)vc.getParent().getParent().getParent();
                this.orgattr = this.colneVp.getImageRenderAttributes();
                this.colneVp.getBounds(this.viewport);
                this.w = this.colneVp.getMedicalImageVc().getImageVc().getImage().getWidth();
                this.h = this.colneVp.getMedicalImageVc().getImageVc().getImage().getHeight();
                this.vp_w = this.colneVp.getMedicalImageVc().getWidth();
                this.vp_h = this.colneVp.getMedicalImageVc().getHeight();
                this._pixelSizeX = this.colneVp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionX();
                this._pixelSizeY = this.colneVp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionY();
            }
        } else {
            this.orgattr = this.vp.getImageRenderAttributes();
            this.vp.getBounds(this.viewport);
            this.w = this.vp.getMedicalImageVc().getImageVc().getImage().getWidth();
            this.h = this.vp.getMedicalImageVc().getImageVc().getImage().getHeight();
            this.vp_w = this.vp.getMedicalImageVc().getWidth();
            this.vp_h = this.vp.getMedicalImageVc().getHeight();
            this._pixelSizeX = this.vp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionX();
            this._pixelSizeY = this.vp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionY();
        }
        XpImageRenderAttributes defAttr = new XpImageRenderAttributes(this.orgattr);
        XpImageOrientation defOrnt = new XpImageOrientation();
        defAttr.setImageOrientation(defOrnt);
        this.gu.calcAffineTransform(this.viewport, defAttr, this.w, this.h, 0.0, true, this._pixelSizeX, this._pixelSizeY, this.tx);
        this.transform.load(this.tx);
        this._rectWidth = this.vp_w;
        this._rectHeight = this.vp_h;
        this._centerX = this._rectWidth / 2;
        this._centerY = this._rectHeight / 2;
        this._yTextOffset = 0;
        this._xTextOffset = 0;
        this.imgDispTrans = this.transform;
        this.transform.inverse(this._tempTrans);
        this.dispImgTras = this._tempTrans;
        this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
        this.imgDispTrans.transform(this.centerImagePoint, this.centerPoint);
        this.oneImageTick.setLocation(this._tickSpacing / this._pixelSizeX, this._tickSpacing / this._pixelSizeY, 0.0);
        this.imgDispTrans.transform(this.oneImageTick, this.oneTick);
        this.oneImageGrid.setLocation(this._gridSpacing / this._pixelSizeX, this._gridSpacing / this._pixelSizeY, 0.0);
        this.imgDispTrans.transform(this.oneImageGrid, this.oneGrid);
        this.imageTickDelta.setLocation(this._tickLength / 2.0 / this._pixelSizeX, this._tickLength / 2.0 / this._pixelSizeY, 0.0);
        this.imgDispTrans.transform(this.imageTickDelta, this.tickDelta);
        this.cmWidth_o = Math.abs(this.oneGrid.x - this.centerPoint.x);
        this.cmHeight_o = Math.abs(this.oneGrid.y - this.centerPoint.y);
        this.cmTHeight = Math.abs(this.oneTick.y - this.centerPoint.y);
        this.cmTWidth = Math.abs(this.oneTick.x - this.centerPoint.x);
        this.tickDeltaX = Math.abs(this.tickDelta.x - this.centerPoint.x);
        this.tickDeltaY = Math.abs(this.tickDelta.y - this.centerPoint.y);
        this._zoom = this.cmWidth_o / this.oneImageGrid.x;
        this.zoom = this._zoom + 0.01 < 1.0 ? 1.0 / (Math.floor(2.0 / this._zoom) + 1.0) : Math.floor(this._zoom / 4.0) + 1.0;
        this.cmWidth = this.cmWidth_o / this.zoom;
        this.nbOfCmW = (int)Math.floor((double)this._rectWidth / this.cmWidth);
        this.cmHeight = this.cmHeight_o / this.zoom;
        this.nbOfCmH = (int)Math.floor((double)this._rectHeight / this.cmHeight);
        this.nbOfCmTH = (int)Math.floor((double)this._rectHeight / this.cmTHeight);
        this.nbOfCmTW = (int)Math.floor((double)this._rectWidth / this.cmTWidth);
        this.height_2 = (double)this._rectHeight / 2.0;
        this.width_2 = (double)this._rectWidth / 2.0;
        this.initLines(this.nbOfCmW, this.nbOfCmH, this.nbOfCmTW, this.nbOfCmTH);
        double x = this._centerX;
        double y1 = this._centerY - this.height_2;
        double y2 = this._centerY + this.height_2;
        this.p1.setLocation(x, y1, 0.0);
        this.p2.setLocation(x, y2, 0.0);
        this._axis[0] = this.p1;
        this._axis[1] = this.p2;
        ++this._numberOfAxis;
        double y = this._centerY;
        double x1 = this._centerX - this.width_2;
        double x2 = this._centerX + this.width_2;
        this.p3.setLocation(x1, y, 0.0);
        this.p4.setLocation(x2, y, 0.0);
        this._axis[2] = this.p3;
        this._axis[3] = this.p4;
        ++this._numberOfAxis;
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmW / 2.0); ++i) {
            x1 = this._centerX + (double)i * this.cmWidth;
            x2 = this._centerX - (double)i * this.cmWidth;
            y1 = this._centerY - this.height_2;
            y2 = this._centerY + this.height_2;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x1, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value = this._gridSpacing * (double)i / (10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(x1) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this._polyLine[this._numberOfPolyLines].setLocation(x2, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value1 = this._gridSpacing * (double)i / (-10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value1);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(x2) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmH / 2.0); ++i) {
            x1 = this._centerX - this.width_2;
            x2 = this._centerX + this.width_2;
            y1 = this._centerY + (double)i * this.cmHeight;
            y2 = this._centerY - (double)i * this.cmHeight;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y1, 0.0);
            this._numberOfPolyLines += 2;
            double value2 = this._gridSpacing * (double)i / (-10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value2);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y1) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y2, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value3 = this._gridSpacing * (double)i / (10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value3);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y2) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmTH / 2.0); ++i) {
            x1 = this._centerX - this.tickDeltaX;
            x2 = this._centerX + this.tickDeltaX;
            y1 = this._centerY + (double)i * this.cmTHeight;
            y2 = this._centerY - (double)i * this.cmTHeight;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y1, 0.0);
            this._numberOfTickLines += 2;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y2, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfTickLines += 2;
        }
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmTW / 2.0); ++i) {
            y1 = this._centerY - this.tickDeltaY;
            y2 = this._centerY + this.tickDeltaY;
            x1 = this._centerX + (double)i * this.cmTWidth;
            x2 = this._centerX - (double)i * this.cmTWidth;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x1, y2, 0.0);
            this._numberOfTickLines += 2;
            this._tickLine[this._numberOfTickLines].setLocation(x2, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfTickLines += 2;
        }
    }

    public void initLines(int nbOfCmW, int nbOfCmH, int nbOfCmTW, int nbOfCmTH) {
        int i;
        this._polyLine = null;
        this._text = null;
        this._axis = null;
        this._tickLine = null;
        this._numberOfPolyLines = 0;
        this._numberOfTickLines = 0;
        this._numberOfTexts = 0;
        this._numberOfAxis = 0;
        this._polyLine = new CPoint[((int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._polyLine.length; ++i) {
            this._polyLine[i] = new CPoint(0);
        }
        this._axis = new CPoint[4];
        for (i = 0; i < this._axis.length; ++i) {
            this._axis[i] = new CPoint(0);
        }
        this._text = new CPoint[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        this._textValue = new String[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        for (i = 0; i < this._text.length; ++i) {
            this._text[i] = new CPoint(0);
            this._textValue[i] = new String();
        }
        this._tickLine = new CPoint[((int)(Math.floor((double)nbOfCmTW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmTH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._tickLine.length; ++i) {
            this._tickLine[i] = new CPoint(0);
        }
    }

    @Override
    public void paintShape(XpVisualComponent vc, Graphics2D g) {
        int i;
        Graphics2D g2 = g;
        g2.setColor(this.col);
        if (!this.mousedrag) {
            this.initPaint(vc);
        }
        if (this._gridLinesON) {
            for (i = 0; i < this._polyLine.length; i += 2) {
                this.drawLine(g2, this._polyLine[i], this._polyLine[i + 1], 0);
            }
        }
        for (i = 0; i <= this._axis.length - 2; i += 2) {
            this.drawLine(g2, this._axis[i], this._axis[i + 1], 0);
        }
        for (i = 0; i < this._tickLine.length - 2; i += 2) {
            this.drawLine(g2, this._tickLine[i], this._tickLine[i + 1], 0);
        }
        for (i = 0; i < this._text.length; ++i) {
            g.drawString(this._textValue[i], (int)this._text[i].x, (int)this._text[i].y);
        }
        if (this.showHandle) {
            this.setAnchorPoint();
        }
    }

    private int doubleToint(double x) {
        int val = (int)Math.floor(x + 0.5);
        return val;
    }

    public void setLineStyle(String style) {
        this._lineStyle = style;
    }

    public void setGridLinesON(boolean gridON) {
        this._gridLinesON = gridON;
    }

    public void setGridSpacing(double grSpacing) {
        this._gridSpacing = grSpacing;
    }

    public void setTickSpacing(double tkSpacing) {
        this._tickSpacing = tkSpacing;
    }

    public void setTickLength(double tkLength) {
        this._tickLength = tkLength;
    }

    public void drawLine(Graphics2D g, CPoint p0, CPoint p1, int offset) {
        if (this._lineStyle == DOTTEDLINE) {
            g.setStroke(this.dottedStrk);
        }
        g.drawLine(offset + (int)p0.x, offset + (int)p0.y, offset + (int)p1.x, offset + (int)p1.y);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        double dy1;
        double dx1;
        double dy;
        double dx;
        int i;
        this.mousedrag = true;
        this._centerX += drag.x;
        this._centerY += drag.y;
        double x1 = drag.x;
        double y1 = drag.y;
        XpVisualComponent vc = (XpVisualComponent)e.getSource();
        for (i = 0; i < this._polyLine.length; i += 2) {
            dx = this._polyLine[i].point2D().getX() + x1;
            dy = this._polyLine[i].point2D().getY() + y1;
            this._polyLine[i].set(dx, dy, 0.0);
            dx1 = this._polyLine[i + 1].point2D().getX() + x1;
            dy1 = this._polyLine[i + 1].point2D().getY() + y1;
            this._polyLine[i + 1].set(dx1, dy1, 0.0);
        }
        for (i = 0; i <= this._axis.length - 2; i += 2) {
            dx = this._axis[i].point2D().getX() + x1;
            dy = this._axis[i].point2D().getY() + y1;
            this._axis[i].set(dx, dy, 0.0);
            dx1 = this._axis[i + 1].point2D().getX() + x1;
            dy1 = this._axis[i + 1].point2D().getY() + y1;
            this._axis[i + 1].set(dx1, dy1, 0.0);
        }
        for (i = 0; i < this._tickLine.length - 2; i += 2) {
            dx = this._tickLine[i].point2D().getX() + x1;
            dy = this._tickLine[i].point2D().getY() + y1;
            this._tickLine[i].set(dx, dy, 0.0);
            dx1 = this._tickLine[i + 1].point2D().getX() + x1;
            dy1 = this._tickLine[i + 1].point2D().getY() + y1;
            this._tickLine[i + 1].set(dx1, dy1, 0.0);
        }
        for (i = 0; i < this._text.length; ++i) {
            dx = this._text[i].point2D().getX() + x1;
            dy = this._text[i].point2D().getY() + y1;
            this._text[i].set(dx, dy, 0.0);
        }
        vc.repaint();
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
        this.setColor(Color.cyan);
    }

    @Override
    public void anchorReleased(MouseEvent e, Object source) {
        this.mousedrag = false;
        this.setColor(Color.white);
    }

    public void setColor(Color c) {
        this.col = c;
    }

    public void setAnchorPoint() {
        this.disp.setLocation(this._centerX, this._centerY, 0.0);
        this.dispImgTras.transform(this.disp, this.imp);
        this.get(0).setLocation(this.imp.x, this.imp.y);
    }

    @Override
    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }
}

