/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderSettings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.util.Arrays;

public class XpImageContourer
extends XpVisualComponent {
    private BufferedImage bi = null;
    private BufferedImage bo = null;
    private int type = 0;
    private int m_width = 0;
    private int m_height = 0;
    private Raster m_ro = null;
    private boolean m_trace = false;
    private long m_milliStart = 0L;
    public static int FINE = 3;
    public static int MEDIUM = 5;
    public static int COARSE = 7;
    IndexColorModel cm = XpImageContourer.generateColorModel();
    DataBufferByte outDataBuffer = null;
    short[] inData = null;
    private boolean in_flag = false;
    private boolean on_flag = false;
    private byte contour_label = 1;
    private boolean fill_flag = true;
    private int fill_mode = MEDIUM;

    public XpImageContourer(int width, int height) {
        this.m_width = width;
        this.m_height = height;
        this.bi = new BufferedImage(width, height, 11);
        this.inData = new short[width * height];
        this.bo = new BufferedImage(width, height, 13, this.cm);
        this.outDataBuffer = new DataBufferByte(width * height);
    }

    public void doContouring(int label_mask) {
        this.doContours(0, 0, this.bi.getWidth(), this.bi.getHeight(), label_mask);
    }

    private void doContours(int minx, int miny, int widthx, int widthy, int in_label) {
        if (this.m_trace) {
            this.m_milliStart = System.currentTimeMillis();
        }
        boolean needsNewRaster = false;
        if (this.m_ro != null) {
            Rectangle rect = this.m_ro.getBounds();
            if (rect.x != minx || rect.y != miny || rect.width != widthx || rect.height != widthy) {
                needsNewRaster = true;
            }
        } else {
            needsNewRaster = true;
        }
        if (needsNewRaster) {
            this.m_ro = Raster.createPackedRaster(this.outDataBuffer, widthx, widthy, 8, null);
        }
        byte[] outData = this.outDataBuffer.getData();
        Arrays.fill(outData, (byte)0);
        for (int iy = miny + 1; iy < miny + widthy; ++iy) {
            for (int ix = minx + 1; ix < minx + widthx; ++ix) {
                if (this.inData[widthx * iy + ix] >= in_label && this.inData[widthx * iy + ix - 1] < in_label) {
                    outData[widthx * iy + ix] = this.contour_label;
                    this.in_flag = true;
                }
                if (this.inData[widthx * iy + ix] < in_label && this.inData[widthx * iy + ix - 1] >= in_label) {
                    outData[widthx * iy + ix - 1] = this.contour_label;
                    this.in_flag = false;
                }
                if (this.inData[widthx * iy + ix] >= in_label && this.inData[widthx * (iy - 1) + ix] < in_label) {
                    outData[widthx * iy + ix] = this.contour_label;
                }
                if (this.inData[widthx * iy + ix] < in_label && this.inData[widthx * (iy - 1) + ix] >= in_label) {
                    outData[widthx * (iy - 1) + ix] = this.contour_label;
                }
                if (!this.fill_flag || !this.in_flag || ix % this.fill_mode != 0) continue;
                outData[widthx * iy + ix] = this.contour_label;
            }
        }
        this.bo.setData(this.m_ro);
        if (this.m_trace) {
            this.m_milliStart = System.currentTimeMillis() - this.m_milliStart;
            System.out.println("ContourTime:" + this.m_milliStart);
        }
    }

    private static IndexColorModel generateColorModel() {
        byte[] r = new byte[16];
        byte[] g = new byte[16];
        byte[] b = new byte[16];
        byte[] a = new byte[16];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        a[0] = 0;
        r[1] = 0;
        g[1] = 0;
        b[1] = -64;
        a[1] = -1;
        r[2] = 0;
        g[2] = 0;
        b[2] = -1;
        a[2] = -1;
        r[3] = 0;
        g[3] = -64;
        b[3] = 0;
        a[3] = -1;
        r[4] = 0;
        g[4] = -1;
        b[4] = 0;
        a[4] = -1;
        r[5] = 0;
        g[5] = -64;
        b[5] = -64;
        a[5] = -1;
        r[6] = 0;
        g[6] = -1;
        b[6] = -1;
        a[6] = -1;
        r[7] = -64;
        g[7] = 0;
        b[7] = 0;
        a[7] = -1;
        r[8] = -1;
        g[8] = 0;
        b[8] = 0;
        a[8] = -1;
        r[9] = -64;
        g[9] = 0;
        b[9] = -64;
        a[9] = -1;
        r[10] = -1;
        g[10] = 0;
        b[10] = -1;
        a[10] = -1;
        r[11] = -64;
        g[11] = -64;
        b[11] = 0;
        a[11] = -1;
        r[12] = -1;
        g[12] = -1;
        b[12] = 0;
        a[12] = -1;
        r[13] = 80;
        g[13] = 80;
        b[13] = 80;
        a[13] = -1;
        r[14] = -64;
        g[14] = -64;
        b[14] = -64;
        a[14] = -1;
        r[15] = -1;
        g[15] = -1;
        b[15] = -1;
        a[15] = -1;
        return new IndexColorModel(4, 16, r, g, b, a);
    }

    public BufferedImage getOutputImage() {
        return this.bo;
    }

    public boolean isFillRegionEnabled() {
        return this.fill_flag;
    }

    public void setContourLabel(byte value) {
        this.contour_label = value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFillMode(int mode) {
        if (mode == FINE) {
            if (mode == MEDIUM) {
                if (mode == COARSE) {
                    this.fill_mode = mode;
                    return;
                }
            }
        }
        this.fill_mode = MEDIUM;
    }

    public void setFillRegion(boolean flag) {
        this.fill_flag = flag;
    }

    public void setInputImage(short[] pixeldata, int width, int height) {
        if (this.m_width != width || this.m_height != height) {
            this.m_width = width;
            this.m_height = height;
            this.bi = new BufferedImage(this.m_width, this.m_height, 11);
            this.inData = new short[this.m_width * this.m_height];
            this.bo = new BufferedImage(this.m_width, this.m_height, 13, this.cm);
            this.outDataBuffer = new DataBufferByte(this.m_width * this.m_height);
        }
        this.inData = pixeldata;
    }

    public void setInputImage(BufferedImage in) {
        if (this.m_width != in.getWidth() || this.m_height != in.getHeight()) {
            this.m_width = in.getWidth();
            this.m_height = in.getHeight();
            this.bi = new BufferedImage(this.m_width, this.m_height, 11);
            this.inData = new short[this.m_width * this.m_height];
            this.bo = new BufferedImage(this.m_width, this.m_height, 13, this.cm);
            this.outDataBuffer = new DataBufferByte(this.m_width * this.m_height);
        }
        this.bi = in;
        this.inData = ((DataBufferUShort)this.bi.getRaster().getDataBuffer()).getData();
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension dim = this.getSize();
        if (this.bo != null) {
            g2d.drawImage((Image)this.bo, 0, 0, null);
        }
    }

    public XpColorOverlay createOverlayContour() {
        short[] outData = ((DataBufferUShort)this.bo.getRaster().getDataBuffer()).getData();
        XpImageRenderSettings newirs = new XpImageRenderSettings();
        XpColorOverlay overlays = null;
        int[] overlayColorMap = new int[256];
        for (int i = 0; i < 255; ++i) {
            overlayColorMap[i] = 0;
        }
        overlayColorMap[1] = -251723776;
        byte[] overlayImage = this.getOverlayMaskPixels(this.bo);
        if (overlayImage != null) {
            overlays = new XpColorOverlay(overlayImage, overlayColorMap, this.bo.getWidth(), this.bo.getHeight());
        }
        return overlays;
    }

    private byte[] getOverlayMaskPixels(BufferedImage bmap) {
        byte[] maskPixels = null;
        int width = bmap.getWidth();
        int height = bmap.getHeight();
        maskPixels = new byte[width * height];
        Arrays.fill(maskPixels, (byte)0);
        short[] pixels = ((DataBufferUShort)bmap.getRaster().getDataBuffer()).getData();
        int minY = 0;
        int maxY = height;
        int minX = 0;
        int maxX = width;
        int count = 0;
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                count = y * width + x;
                if (pixels[count] <= 0) continue;
                maskPixels[count] = 1;
            }
        }
        return maskPixels;
    }

    private void printDebugPoints(short[] in, byte[] out, int y, int threshold) {
        int count;
        int x;
        System.out.print("Iy: " + (y - 1) + " x: ");
        for (x = 0; x < this.bi.getWidth(); ++x) {
            count = this.bi.getWidth() * (y - 1) + x;
            if (in[count] < threshold) continue;
            System.out.print(x + " ");
        }
        System.out.println("");
        System.out.print("Iy: " + y + " x: ");
        for (x = 0; x < this.bi.getWidth(); ++x) {
            count = this.bi.getWidth() * y + x;
            if (in[count] < threshold) continue;
            System.out.print(x + " ");
        }
        System.out.println("");
        System.out.print("Oy: " + y + " x: ");
        for (x = 0; x < this.bi.getWidth(); ++x) {
            count = this.bi.getWidth() * y + x;
            if (out[count] <= 0) continue;
            System.out.print(x + " ");
        }
        System.out.println("");
    }

    public XpImageContourer() {
    }
}

