/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.CTransformCapable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XpHandle
implements Serializable {
    private transient Shape shape = HANDLE_BOX;
    private CPoint location = new CPoint(0);
    private XpAnchorable anchorable = null;
    private int anchorPtIndex = -1;
    private boolean visable = true;
    public static Shape DEFAULT_SHAPE;
    public static Shape HANDLE_CROSSHAIR;
    public static transient Shape HANDLE_BOX;
    private transient Shape containmentShape = DEFAULT_SHAPE;
    private int mModifier = 28;
    private boolean filled = true;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private transient Point2D dispPoint = new Point2D.Double();
    private static Color handleColor;
    private static final Cursor SELECTION_CURSOR;
    private CPoint tmpPoint = new CPoint();
    private CPoint dispPt = new CPoint(1);
    private CPoint _dragV = new CPoint();
    private transient Point pMouse = null;
    private Cursor cursor = SELECTION_CURSOR;
    private boolean isDragOn = false;

    public double getX() {
        return this.location.x;
    }

    public double getY() {
        return this.location.y;
    }

    public void setLocation(double x, double y) {
        this.location.setLocation(x, y, 0.0);
    }

    public void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(double x, double y, double z) {
        this.location.setLocation(x, y, z);
    }

    public void setLocation(CPoint p) {
        if (p.csystem == this.location.csystem) {
            this.setLocation(p.x, p.y, p.z);
        }
    }

    public Color getForeground() {
        return handleColor;
    }

    public void setShape(Shape s, Shape containmentShape) {
        this.shape = s;
        this.containmentShape = containmentShape;
    }

    public Shape getDrawShape() {
        return this.shape;
    }

    public Shape getContainsShape() {
        return this.containmentShape;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex) {
        this.anchorable = anchorable;
        this.anchorPtIndex = ptIndex;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex, int mModifier) {
        this(anchorable, ptIndex);
        this.mModifier = mModifier;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex, byte bCoordSys) {
        this.location = new CPoint(bCoordSys);
        this.anchorable = anchorable;
        this.anchorPtIndex = ptIndex;
    }

    public XpHandle(XpAnchorable anchorable, int ptIndex, int mModifier, byte bCoordSys) {
        this(anchorable, ptIndex, bCoordSys);
        this.mModifier = mModifier;
    }

    public void paintHandle(XpVisualComponent vc, Graphics2D g) {
        if (!this.visable) {
            return;
        }
        vc.transform(this.location, this.dispPt, (byte)1);
        g.setColor(handleColor);
        g.translate(this.dispPt.x, this.dispPt.y);
        if (this.filled) {
            g.fill(this.shape);
        } else {
            g.draw(this.shape);
        }
        g.translate(-this.dispPt.x, -this.dispPt.y);
    }

    public boolean contains(XpVisualComponent vc, int x, int y) {
        if (this.isDragOn) {
            return true;
        }
        if (!this.visable) {
            return false;
        }
        this.dispPoint.setLocation((double)x - this.dispPt.x, (double)y - this.dispPt.y);
        boolean inside = this.containmentShape.contains(this.dispPoint);
        return inside;
    }

    public final void getDisplayLocation(XpVisualComponent vc, Point2D p) {
        vc.transform(this.location, this.tmpPoint, (byte)1);
        p.setLocation(this.tmpPoint.x, this.tmpPoint.y);
    }

    public final Point2D getDisplayLocation(XpVisualComponent vc) {
        Point2D.Double p = new Point2D.Double();
        this.getDisplayLocation(vc, p);
        return p;
    }

    public final Point2D getDisplayLocation() {
        return new Point2D.Double(this.dispPt.x, this.dispPt.y);
    }

    public void handlePressed(MouseEvent e) {
        this.isDragOn = true;
        boolean processDrag = this.buttonTrigger(e);
        if (processDrag) {
            this.anchorable.anchorPressed(e, this);
        }
        this.pMouse = e.getPoint();
    }

    public void handleClicked(MouseEvent e) {
    }

    public void handleExited(MouseEvent e) {
        e.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    public void handleEntered(MouseEvent e) {
        e.getComponent().setCursor(this.cursor);
    }

    public void handleReleased(MouseEvent e) {
        boolean processDrag = this.buttonTrigger(e);
        if (processDrag) {
            this.anchorable.anchorReleased(e, this);
        }
        e.getComponent().setCursor(Cursor.getDefaultCursor());
        this.pMouse = null;
        this.isDragOn = false;
    }

    public boolean buttonTrigger(MouseEvent e) {
        boolean processEvent = false;
        int modifiers = e.getModifiers();
        int mbutton1 = this.mModifier & 0x10;
        int mbutton2 = this.mModifier & 8;
        int mbutton3 = this.mModifier & 4;
        int button1 = modifiers & 0x10;
        int button2 = modifiers & 8;
        int button3 = modifiers & 4;
        if (mbutton1 != 0 && button1 != 0) {
            processEvent = true;
        }
        if (mbutton2 != 0 && button2 != 0) {
            processEvent = true;
        }
        if (mbutton3 != 0 && button3 != 0) {
            processEvent = true;
        }
        return processEvent;
    }

    public void handleDragged(MouseEvent e) {
        boolean processDrag;
        this.isDragOn = true;
        if (this.pMouse != null && (processDrag = this.buttonTrigger(e))) {
            this.gu.calcDragVector(e.getPoint(), this.pMouse, this.location.csystem, (CTransformCapable)((Object)e.getComponent()), this._dragV);
            this.anchorable.anchorDragged(e, this._dragV, this);
        }
        this.pMouse = e.getPoint();
    }

    public void handleMove(MouseEvent e) {
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public static Color getHandleColor() {
        return handleColor;
    }

    public static void setHandleColor(Color handleColor) {
        XpHandle.handleColor = handleColor;
    }

    public int getAnchorPointIndex() {
        return this.anchorPtIndex;
    }

    public void setVisible(boolean visable) {
        this.visable = visable;
    }

    public boolean isVisible() {
        return this.visable;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            s.defaultWriteObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.gu = new XpGeomUtils();
        this.dispPoint = new Point2D.Double();
        this.shape = HANDLE_BOX;
        HANDLE_BOX = DEFAULT_SHAPE;
        this.containmentShape = DEFAULT_SHAPE;
    }

    static {
        int[] idims;
        int crosshair = 4;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, -crosshair);
        gp.lineTo(0.0f, crosshair);
        gp.moveTo(-crosshair, 0.0f);
        gp.lineTo(crosshair, 0.0f);
        HANDLE_CROSSHAIR = gp;
        String dims = XpPropertiesManager.getProperty("jami.handlesize");
        int x = -3;
        int y = -3;
        int w = 7;
        int h = 7;
        if (dims != null && (idims = XpPropertiesManager.parseIntList(dims, ", ")) != null && idims.length >= 4) {
            x = idims[0];
            y = idims[1];
            w = idims[2];
            h = idims[3];
        }
        HANDLE_BOX = DEFAULT_SHAPE = new Rectangle(x, y, w, h);
        handleColor = Color.red;
        SELECTION_CURSOR = new Cursor(1);
    }
}

