/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class XpDicomElement {
    public int group;
    public int element;
    public Object value;

    public XpDicomElement(int group, int element) {
        this.group = group;
        this.element = element;
        this.value = null;
    }

    public XpDicomElement(int group, int element, Object value) {
        this(group, element);
        this.value = value;
    }

    public XpDicomElement() {
        this(0, 0);
    }

    public int getIntValue() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.value instanceof String) {
            try {
                return Integer.parseInt((String)this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public double getDoubleValue() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Float) {
            return ((Float)this.value).doubleValue();
        }
        if (this.value instanceof String) {
            try {
                return Double.parseDouble((String)this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public String getStringValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public double[] getDoubleArrayValue() {
        String s = this.getStringValue();
        if (s != null) {
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s, " ,\\\t\n");
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            double[] result = new double[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                try {
                    result[i] = Double.parseDouble((String)l.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return result;
        }
        return null;
    }

    public String toString() {
        return "(0x" + Integer.toHexString(this.group) + ",0x" + Integer.toHexString(this.element) + ")=" + this.value;
    }
}

