/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ActiveAnnotationCapable;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.ClipCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.DynamicLoadCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.FusionCapable;
import com.ge.med.idc.GSPSCapable;
import com.ge.med.idc.OnPortCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.SceneSelectionCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.Sortable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.DICOMLut;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpCineMotor;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpDynamicGridLayout;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImageListListener;
import com.ge.med.terra.jami.XpOnPortLayoutManager;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportManager;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.CPICapable;
import com.ge.med.terra.jami.capable.CPISerializable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.capable.MultiImageOpCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.RenderSettingsCapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.filter.XpMultiImageOp;
import com.ge.med.terra.jami.image.JVolumeImage;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.platform.dm.XpDMgsps;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.render.XpImageRenderSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

public abstract class XpCompositePort
extends XpViewport
implements CPICapable,
GSPSCapable,
AnnotCapable,
OnPortCapable,
RowColCapable,
SelectionCapable,
XpImageRenderAttributesOwner,
SceneSelectionCapable,
PanZoomCapable,
ClipCapable,
WindowLevelCapable,
ROICapable,
UserAnnoCapable,
ComponentCapable,
ColorMapCapable,
RenderSettingsCapable,
ImageOpCapable,
Sortable,
XpMedicalImageListListener,
FramePositioningCapable,
FrameCapable,
MultiImageOpCapable,
CineCapable,
DynamicLoadCapable,
ActiveAnnotationCapable,
FusionCapable {
    public static final Border PRIMARY_SELECTION = BorderFactory.createLineBorder(Color.cyan, 1);
    public static final Border SECONDARY_SELECTION = BorderFactory.createLineBorder(Color.yellow, 1);
    public static final int SCENE_SELECTION_MODE = 1;
    public static final int PORT_SELECTION_MODE = 2;
    private int selectionMode = 1;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTI_SELECTION = 2;
    private int selectionPolicy = 1;
    private Border primaryBorder = PRIMARY_SELECTION;
    private Border secondaryBorder = SECONDARY_SELECTION;
    private XpDynamicGridLayout gridLayout = null;
    private List portList = new ArrayList();
    private List sceneList = new ArrayList();
    private List orgSceneList = this.sceneList;
    private boolean invalidatePending = false;
    private String rendererType = null;
    private XpMultiImageOp mio = null;
    private int[] portSelectedState = new int[4];
    private int selPort = -1;
    private int selSceneIdx = -1;
    private Object interpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private Object cineQuality = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private Object prevInterpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private int[] colorMap = null;
    private Shape clipShape = null;
    private Shape imageClipShape = null;
    private Map activeAnnotation = new HashMap();
    private Map opControlMap = new HashMap();
    private Class layoutMgrClass = XpOnPortLayoutManager.class;
    private Color annotationColor = null;
    private boolean annotVisible = true;
    private Class agClass = null;
    private Properties props = null;
    private AnnotationState annoState = new AnnotationState();
    private XpImagePixelAttributes[] layerIPA = new XpImagePixelAttributes[16];
    private XpImageRenderAttributes sharedIRA = new XpImageRenderAttributes();
    private XpImageRenderAttributes oldIRA = new XpImageRenderAttributes();
    private boolean isSharedIRA = false;
    private boolean isSyncIRA = true;
    private boolean fitToViewport = true;
    private boolean clipGraphics = true;
    private XpViewportManager vpManager = null;
    private Integer[] sortMap = null;
    private PortComparator pComparator = new PortComparator();
    private Comparator sortComparator = null;
    private boolean debug = false;
    private double winUpperLimit = Double.MAX_VALUE;
    private double winLowerLimit = -1.7976931348623157E308;
    private boolean annotTooltip = true;
    private boolean mousewheelPaging = true;
    private boolean keyboardPaging = true;
    private KeyboardWheelManager kwManager = new KeyboardWheelManager(this);
    private XpCineMotor projector = new XpCineMotor(this, 10);
    private boolean cineOn = false;
    private int cineRate = 10;
    private int startOffset = 0;
    private int endOffset = 0;
    private int cineSkip = 1;
    private int cineMode = 0;
    private XjFusionPixelCombiner fpc = null;
    private ArrayList mwListeners = new ArrayList();
    private ArrayList mListeners = new ArrayList();
    private ArrayList mmListeners = new ArrayList();
    private ArrayList kbListeners = new ArrayList();
    private PropertyChangeListener miopSyncPCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            XpCompositePort.this.refresh();
        }
    };
    private PropertyChangeListener componentPCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            Object obj = pce.getNewValue();
            String pname = pce.getPropertyName();
            if (obj instanceof RoiActor) {
                if (pname.equals("COMPONENT_ADDED")) {
                    XpCompositePort.this.firePropertyChange("ROI_ADDED", null, obj, pce.getSource());
                } else if (pname.equals("COMPONENT_REMOVED")) {
                    XpCompositePort.this.firePropertyChange("ROI_REMOVED", null, obj, pce.getSource());
                }
            } else if (obj instanceof XpUserAnnotationModel) {
                if (pname.equals("COMPONENT_ADDED")) {
                    XpCompositePort.this.firePropertyChange("USERANNO_ADDED", null, obj, pce.getSource());
                } else if (pname.equals("COMPONENT_REMOVED")) {
                    XpCompositePort.this.firePropertyChange("USERANNO_REMOVED", null, obj, pce.getSource());
                }
            }
        }
    };
    private RmRenderSession renderSession = null;
    private J3DVolumeModel j3d_vm = null;
    private boolean skipComponentSelectionChangeFiring_ = false;

    public XpCompositePort() {
        this.init();
    }

    public XpCompositePort(int selectionPolicy, int selectionMode) {
        this.selectionPolicy = selectionPolicy;
        this.selectionMode = selectionMode;
        this.init();
    }

    public XpCompositePort(String rendererType) {
        this.rendererType = rendererType;
        this.init();
    }

    public XpCompositePort(String rendererType, int selectionPolicy, int selectionMode) {
        this.selectionPolicy = selectionPolicy;
        this.selectionMode = selectionMode;
        this.rendererType = rendererType;
        this.init();
    }

    public XpCompositePort(RmRenderSession rs, String remote2DRenderer) {
        this.renderSession = rs;
        this.rendererType = remote2DRenderer;
        this.init();
    }

    protected void initListeners() {
        this.addMouseListener(new PortMouseListener());
    }

    private void init() {
        this.gridLayout = this.createGridLayout();
        this.setLayout(this.gridLayout);
        this.initListeners();
    }

    protected XpDynamicGridLayout createGridLayout() {
        return new XpDynamicGridLayout(2, 2);
    }

    protected void copyObject(Object o) {
        XpCompositePort cp = (XpCompositePort)o;
        cp.setSize(this.getSize());
        cp.setPreferredSize(this.getPreferredSize());
        XpMedicalImage[] imgs = this.getImages();
        int frameIndex = this.getFrameIndex();
        cp.setSharedRenderAttributes(this.isSharedRenderAttributes());
        cp.setSyncRenderAttributes(this.isSyncRenderAttributes());
        cp.setImages(imgs);
        if (this.mio != null) {
            cp.setMultiImageOp(this.mio);
        }
        cp.setRowCol(this.getRows(), this.getCols());
        cp.setFrameIndex(frameIndex);
        XpImageScene.copyScenes(this.orgSceneList, cp.orgSceneList);
        if (this.mio != null) {
            XpImageScene.copyScenes(this.sceneList, cp.sceneList);
        } else {
            cp.sceneList = cp.orgSceneList;
        }
        int nports = this.getNumPorts();
        for (int i = 0; i < nports; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            XpFrameVisualizer newport = cp.getPort(i);
            if (port == null || newport == null) continue;
            port.copyObject(newport);
        }
        cp.doLayoutPorts();
    }

    @Override
    public void setImages(XpMedicalImage[] imageList) {
        if (this.getCine()) {
            return;
        }
        this.sortMap = null;
        this.colorMap = null;
        this.sharedIRA.reset();
        this.annoState.clear();
        this.orgSceneList = this.createScenes(imageList);
        if (this.mio != null) {
            this.setupMultiImageOp();
        } else {
            this.sceneList = this.orgSceneList;
        }
    }

    public final void setImages(XjImage[] imgList) {
        this.setImages(XjMedicalImage.createImages(imgList));
    }

    public final void setVolume(XjVolume volume) {
        J3DVolumeModel vm = null;
        if (volume != null) {
            vm = new J3DVolumeModel(volume);
        }
        this.setVolumeModel(vm);
    }

    public XjVolumeModel getVolumeModel() {
        return this.j3d_vm;
    }

    public void setVolumeModel(XjVolumeModel vm) {
        this.j3d_vm = (J3DVolumeModel)vm;
        if (this.j3d_vm != null) {
            XpMedicalImage[] imgs = JVolumeImage.getImages(this.j3d_vm.j_vol);
            this.setImages(imgs);
            if (this.j3d_vm.j_vol instanceof JVolume.LinearByte) {
                JVolume.LinearByte jlb = (JVolume.LinearByte)this.j3d_vm.j_vol;
                int[] cmap = jlb.cmap;
                if (cmap != null) {
                    this.setColorMap(cmap);
                }
                this.setWinMinMax(0.0, 255.0);
            }
        } else {
            this.setImages((XpMedicalImage[])null);
        }
    }

    @Override
    public int addImage(XjImage image) {
        return this.addImage(XjMedicalImage.createImage(image));
    }

    public int addImage(XpMedicalImage image) {
        if (this.getCine() || this.mio != null) {
            return -1;
        }
        XpImageScene m = this.createScene(image);
        this.sceneList.add(m);
        this.syncComparator();
        this.sync();
        this.layoutImages();
        return this.getNumFrames() - 1;
    }

    @Override
    public void replaceImage(XjImage im, int index) {
        this.replaceImage(XjMedicalImage.createImage(im), index);
    }

    public void replaceImage(XpMedicalImage image, int index) {
        boolean isvisible = this.isSceneVisible(index);
        XpImageScene m = this.createScene(image);
        this.sceneList.set(index, m);
        if (isvisible) {
            this.layoutImages();
        }
    }

    protected boolean isSceneVisible(int idx) {
        XpImageScene scene2 = (XpImageScene)this.sceneList.get(idx);
        int visibleports = this.getRows() * this.getCols();
        for (int i = 0; i < visibleports; ++i) {
            XpImageScene is;
            XpFrameVisualizer fv = this.getPort(i);
            if (fv == null || (is = fv.getScene()) != scene2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int addImages(XjImage[] images) {
        return this.addImages(XjMedicalImage.createImages(images));
    }

    public int addImages(XpMedicalImage[] images) {
        if (this.getCine() || this.mio != null) {
            return -1;
        }
        int oldLength = this.getNumFrames();
        for (int i = 0; i < images.length; ++i) {
            XpImageScene m = this.createScene(images[i]);
            this.sceneList.add(m);
        }
        this.syncComparator();
        this.sync();
        this.layoutImages();
        return oldLength;
    }

    @Override
    public int addImage(XjImage image, int index) {
        return this.addImage(XjMedicalImage.createImage(image), index);
    }

    public int addImage(XpMedicalImage image, int index) {
        if (this.getCine() || this.mio != null) {
            return -1;
        }
        XpImageScene m = this.createScene(image);
        this.sceneList.add(index, m);
        this.syncComparator();
        this.sync();
        this.layoutImages();
        return index;
    }

    @Override
    public int addImages(XjImage[] images, int index) {
        return this.addImages(XjMedicalImage.createImages(images), index);
    }

    public int addImages(XpMedicalImage[] images, int index) {
        if (this.getCine() || this.mio != null) {
            return -1;
        }
        for (int i = images.length - 1; i >= 0; --i) {
            XpImageScene m = this.createScene(images[i]);
            this.sceneList.add(index, m);
        }
        this.syncComparator();
        this.sync();
        this.layoutImages();
        return index;
    }

    @Override
    public int removeImage(int index) {
        if (this.getCine() || this.mio != null) {
            return -1;
        }
        this.sceneList.remove(index);
        if (this.getEndOffset() >= this.getNumFrames()) {
            this.setEndOffset(this.getNumFrames() - 1);
        }
        this.syncComparator();
        this.layoutImages();
        return index;
    }

    protected final void resetSharedIRA(double ww, double wl) {
        if (this.debug) {
            System.out.println("**** INITIALIZING WW/WL");
        }
        this.sharedIRA.reset();
        this.sharedIRA.setWindowing(ww, wl);
    }

    @Override
    public void refreshContents() {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            if (fv == null) continue;
            fv.refreshContents();
        }
        this.doLayoutPorts();
    }

    @Override
    protected void applyAnnotationLanguage(String lang) {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer vp = this.getPort(i);
            vp.setAnnotationLanguage(lang);
        }
    }

    public boolean isKeyboardPaging() {
        return this.keyboardPaging;
    }

    public void setKeyboardPaging(boolean keyboardPaging) {
        this.keyboardPaging = keyboardPaging;
    }

    public boolean isMouseWheelPaging() {
        return this.mousewheelPaging;
    }

    public void setMouseWheelPaging(boolean mousewheelPaging) {
        this.mousewheelPaging = mousewheelPaging;
    }

    private XpFrameVisualizer createChildPort(int slotIdx) {
        EventListener l;
        int i;
        XpFrameVisualizer fv = null;
        fv = this.renderSession != null ? new XpFrameVisualizer(this.renderSession, this.rendererType) : (this.rendererType != null ? new XpFrameVisualizer(this.rendererType) : new XpFrameVisualizer());
        fv.setBackground(this.getBackground());
        fv.setOnPortLayoutManager(this.layoutMgrClass);
        for (Class c : this.opControlMap.keySet()) {
            Object location = this.opControlMap.get(c);
            fv.addPortControl(c, location);
        }
        XpImage2DVc ivc = fv.getMedicalImageVc().getImageVc();
        ivc.addMouseListener(XpAppContext.instance().getSelectionManager());
        ivc.addKeyListener(this.kwManager);
        ivc.addMouseWheelListener(this.kwManager);
        MouseListener selHandler = this.getSelectionHandler(slotIdx);
        if (selHandler != null) {
            ivc.addMouseListener(selHandler);
        }
        for (i = 0; i < this.kbListeners.size(); ++i) {
            l = (KeyListener)this.kbListeners.get(i);
            fv.addKeyListener((KeyListener)l);
        }
        for (i = 0; i < this.mListeners.size(); ++i) {
            l = (MouseListener)this.mListeners.get(i);
            fv.addMouseListener((MouseListener)l);
        }
        for (i = 0; i < this.mmListeners.size(); ++i) {
            l = (MouseMotionListener)this.mmListeners.get(i);
            fv.addMouseMotionListener((MouseMotionListener)l);
        }
        for (i = 0; i < this.mwListeners.size(); ++i) {
            l = (MouseWheelListener)this.mwListeners.get(i);
            fv.addMouseWheelListener((MouseWheelListener)l);
        }
        fv.setAnnotationVisible(this.annotVisible);
        if (this.annotationColor != null) {
            fv.setAnnotationColor(this.annotationColor);
        }
        if (this.agClass != null) {
            fv.setAnnotationGenerator(this.agClass, this.props);
        }
        fv.setWinLowerLimit(this.winLowerLimit);
        fv.setWinUpperLimit(this.winUpperLimit);
        fv.setAnnotationTooltip(this.annotTooltip);
        fv.setInterpolationHint(this.interpolationHint);
        fv.setFitToViewport(this.fitToViewport);
        fv.setClipGraphics(this.clipGraphics);
        fv.setAnnotationLanguage(this.getAnnotationLanguage());
        fv.setPrimaryBorder(this.getPrimaryBorder());
        fv.setSecondaryBorder(this.getSecondaryBorder());
        if (slotIdx > 0) {
            if (this.clipShape != null) {
                fv.setClipShape(this.clipShape);
            }
            if (this.imageClipShape != null) {
                fv.setImageClip(this.imageClipShape);
            }
        }
        this.annoState.applyViewport(fv);
        for (Map.Entry me : this.activeAnnotation.entrySet()) {
            String segment = (String)me.getKey();
            List l2 = (List)me.getValue();
            MouseInputListener mil = (MouseInputListener)l2.get(0);
            String tooltip = (String)l2.get(1);
            fv.setActiveAnnotationListener(segment, mil, tooltip);
        }
        if (this.vpManager != null) {
            this.vpManager.createViewportCB(fv);
        }
        this.add(fv);
        if (this.fpc != null) {
            fv.setPixelCombiner(this.fpc);
        }
        fv.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                String propName;
                Object source_fv;
                XpFrameVisualizer fv = XpCompositePort.this.getSelectedPort();
                if (fv == (source_fv = pce.getSource()) && !(propName = pce.getPropertyName()).equals("ancestor")) {
                    XpCompositePort.this.firePropertyChange(propName, pce.getOldValue(), pce.getNewValue());
                }
            }
        });
        return fv;
    }

    protected void syncPortsCB() {
    }

    public final int getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public final int getSelectionMode() {
        return this.selectionMode;
    }

    public final int getPortSelection(int portIdx) {
        if (portIdx >= 0 && portIdx < this.portSelectedState.length) {
            return this.portSelectedState[portIdx];
        }
        return 0;
    }

    protected void syncPorts() {
        XpFrameVisualizer fv;
        int portListLen;
        int rows = this.getRows();
        int cols = this.getCols();
        int idx = portListLen = this.getNumPorts();
        int configLen = rows * cols;
        if (portListLen < configLen) {
            int numberToCreate = configLen - portListLen;
            for (int i = 0; i < numberToCreate; ++i) {
                fv = this.createChildPort(idx++);
                this.addPort(fv);
            }
        }
        if (this.isVisible()) {
            for (int j = 0; j < configLen; ++j) {
                XpFrameVisualizer fv2 = this.getPort(j);
                fv2.setVisible(true);
            }
        }
        int nports = this.getNumPorts();
        for (int j = configLen; j < nports; ++j) {
            fv = this.getPort(j);
            boolean focus = fv.getMedicalImageVc().getImageVc().hasFocus();
            if (focus) {
                this.requestFocus();
            }
            fv.setVisible(false);
        }
        this.syncPortsCB();
        portListLen = this.getNumPorts();
        if (this.portSelectedState.length != portListLen) {
            int[] pSelState = new int[portListLen];
            int newLen = Math.min(portListLen, this.portSelectedState.length);
            for (int i = 0; i < newLen; ++i) {
                pSelState[i] = this.portSelectedState[i];
            }
            this.portSelectedState = pSelState;
        }
        if (this.selectionMode == 2 && this.selPort >= configLen) {
            this.portSelectedState[0] = 1;
            this.portSelectedState[this.selPort] = 0;
            this.selPort = 0;
        }
        this.layoutImages();
        this.doInvalidate();
        this.callRepaint();
    }

    private final void clearSelections() {
        int size = this.getNumScenes();
        for (int i = 0; i < size; ++i) {
            XpImageScene fs = this.getScene(i);
            fs.setSelectedState(0);
        }
    }

    private final void unselectAllScenesExcept(XpImageScene scene2) {
        int size = this.getNumScenes();
        for (int i = 0; i < size; ++i) {
            XpImageScene fs = this.getScene(i);
            if (fs == scene2) continue;
            fs.setSelectedState(0);
        }
    }

    private final void unselectAllPortsExcept(XpFrameVisualizer port) {
        int size = this.getNumPorts();
        for (int i = 0; i < size; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            if (port == fv) continue;
            this.portSelectedState[i] = 0;
        }
    }

    public final void setSyncRenderAttributes(boolean sync) {
        this.isSyncIRA = sync;
    }

    public final boolean isSyncRenderAttributes() {
        return this.isSyncIRA;
    }

    public final void setSharedRenderAttributes(boolean shared) {
        this.isSharedIRA = shared;
    }

    public final boolean isSharedRenderAttributes() {
        return this.isSharedIRA;
    }

    protected final XpImageRenderAttributes getSharedIRA() {
        return this.sharedIRA;
    }

    @Override
    public final void setSceneSelection(int sceneIdx, int selectionState) {
        XpImageScene fs = this.getScene(sceneIdx);
        if (fs != null) {
            fs.setSelectedState(selectionState);
        }
    }

    @Override
    public final int getSceneSelection(int sceneIdx) {
        XpImageScene fs = this.getScene(sceneIdx);
        return fs.getSelectedState();
    }

    private void setNoSelection() {
        this.clearSelections();
        this.resetPortSelection();
        this.layoutImages();
    }

    public final void setPortSelection(int portIdx, int selection, boolean doubleclick) {
        this.setPortSelection(portIdx, selection, doubleclick, false);
    }

    private void setPortSelection(int portIdx, int selection, boolean doubleclick, boolean skipComponentSelectionChangeFiring) {
        if (portIdx < 0) {
            this.setNoSelection();
            return;
        }
        XpFrameVisualizer fv = this.getPort(portIdx);
        XpImageScene is = fv.getScene();
        if (is != null && (selection == 1 || selection == 2)) {
            if (is.getSelectedState() != selection) {
                XpImageScene sis;
                int sceneIdx = this.getSceneIndexAtPort(portIdx);
                int oldSelScene = -1;
                XpFrameVisualizer sfv = this.getSelectedPort();
                if (sfv != null && (sis = sfv.getScene()) != null) {
                    oldSelScene = this.getSceneIndexAtPort(this.getSelectedPortIndex());
                }
                if (oldSelScene == -1) {
                    oldSelScene = this.selSceneIdx;
                }
                this.portSelectedState[portIdx] = selection;
                if (this.selectionPolicy == 1) {
                    selection = 1;
                    if (portIdx != this.selPort && sfv != null) {
                        this.portSelectedState[this.selPort] = 0;
                    }
                    this.setSceneSelection(oldSelScene, 0);
                } else if (this.selectionPolicy == 2) {
                    if (selection == 1 && doubleclick) {
                        this.clearSelections();
                    } else if (selection == 1 && !doubleclick) {
                        if (sfv != null) {
                            this.portSelectedState[this.selPort] = 2;
                        }
                        this.setSceneSelection(oldSelScene, 2);
                    }
                }
                if (selection == 1) {
                    this.selPort = portIdx;
                    this.selSceneIdx = sceneIdx;
                    if (!skipComponentSelectionChangeFiring) {
                        this.firePropertyChange("ComponentSelection", -1, portIdx);
                    }
                }
                this.setSceneSelection(sceneIdx, selection);
                this.layoutImages();
                if (this.debug) {
                    for (int i = 0; i < this.portSelectedState.length; ++i) {
                        System.out.println("SelState[" + i + "] = " + this.portSelectedState[i]);
                    }
                    System.out.println("--------------------------");
                }
            } else {
                if (doubleclick) {
                    if (this.selectionMode == 1) {
                        this.unselectAllScenesExcept(is);
                    } else if (this.selectionMode == 2) {
                        this.unselectAllPortsExcept(fv);
                    }
                    this.layoutImages();
                }
                if (!skipComponentSelectionChangeFiring) {
                    this.firePropertyChange("ComponentSelection", -1, portIdx);
                }
            }
        } else {
            this.portSelectedState[portIdx] = 0;
        }
    }

    public final XpFrameVisualizer getPort(int idx) {
        int len = this.portList.size();
        if (idx >= 0 && idx < len) {
            return (XpFrameVisualizer)this.portList.get(idx);
        }
        return null;
    }

    public final int getNumPorts() {
        if (this.portList != null) {
            return this.portList.size();
        }
        return 0;
    }

    @Override
    public int getNumScenes() {
        return this.sceneList.size();
    }

    @Override
    public int getNumFrames() {
        return this.getNumScenes();
    }

    public final XpImageScene getScene(int i) {
        int n = this.getNumScenes();
        if (i >= 0 && i < n) {
            if (this.sortMap != null) {
                i = this.sortMap[i];
            }
            return (XpImageScene)this.sceneList.get(i);
        }
        return null;
    }

    public final XpImageScene getSceneAtPort(int i) {
        int n = this.portList.size();
        if (i >= 0 && i < n) {
            XpFrameVisualizer fv = (XpFrameVisualizer)this.portList.get(i);
            XpImageScene fs = fv.getScene();
            return fs;
        }
        return null;
    }

    public abstract int getSceneIndexAtPort(int var1);

    public final void addPort(XpFrameVisualizer fv) {
        this.portList.add(fv);
    }

    public final Iterator getPorts() {
        return this.portList.iterator();
    }

    protected void layoutImages() {
        this.doLayoutPorts();
        if (this.selectionMode == 1) {
            int nPorts = this.getNumPorts();
            boolean foundSelected = false;
            for (int i = 0; i < nPorts; ++i) {
                int selState = 0;
                XpFrameVisualizer fv = this.getPort(i);
                if (fv != null) {
                    XpImageScene is = fv.getScene();
                    if (is != null) {
                        selState = is.getSelectedState();
                        if (selState == 1) {
                            this.selPort = i;
                            foundSelected = true;
                        }
                    } else {
                        fv.refreshSelection();
                    }
                }
                this.portSelectedState[i] = selState;
            }
            if (!foundSelected) {
                this.selPort = -1;
            }
        } else {
            XpImageScene is;
            boolean reselect0 = false;
            int nPorts = this.getNumPorts();
            for (int i = 0; i < nPorts; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                if (fv == null) continue;
                XpImageScene is2 = fv.getScene();
                if (is2 != null) {
                    int state = this.portSelectedState[i];
                    is2.setSelectedState(state);
                } else {
                    if (this.portSelectedState[i] == 1) {
                        reselect0 = true;
                    }
                    this.portSelectedState[i] = 0;
                }
                fv.refreshSelection();
            }
            if (reselect0 && (is = this.getPort(0).getScene()) != null) {
                boolean state = true;
                this.portSelectedState[0] = 1;
                is.setSelectedState(1);
                this.selPort = 0;
                this.getPort(0).refreshSelection();
            }
        }
        int selPort = this.getSelectedPortIndex();
        if (selPort >= 0) {
            this.selSceneIdx = this.getSceneIndexAtPort(selPort);
        }
        if (this.isAutoRepaint()) {
            this.callRepaint();
        }
    }

    protected abstract void doLayoutPorts();

    protected abstract MouseListener getSelectionHandler(int var1);

    @Override
    public void setCPI(XpCPI cpi) {
        double oldZoom = this.getZoom();
        double oldMin = this.getWinMin();
        double oldMax = this.getWinMax();
        double oldPanX = this.getPanX();
        double oldPanY = this.getPanY();
        Point2D.Double oldPan = new Point2D.Double(oldPanX, oldPanY);
        XpImageOrientation oldOrient = this.getImageRenderAttributes().getImageOrientation();
        this.clearGraphics();
        this.resetIRA();
        cpi.applyCPI(this.sceneList);
        cpi.applyAnnotationConfig(this);
        XpCPI.BitmapDisplayShutter bds = cpi.getBitmapDisplayShutter();
        if (bds != null) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            XpCPI.applyBitmapDisplayShutter(bds, ira);
        }
        XpCPI.DisplayShutter ds = cpi.getDisplayShutter(1);
        XpCPI.DisplayShutter ids = cpi.getDisplayShutter(0);
        if (ds != null || ids != null) {
            XpCPI.applyCPI(cpi, this);
        }
        this.layoutImages();
        this.updateAdditionalVcs(cpi.getCpiSerializeables());
        double zoom = this.getZoom();
        double min = this.getWinMin();
        double max = this.getWinMax();
        double panX = this.getPanX();
        double panY = this.getPanY();
        Point2D.Double pan = new Point2D.Double(panX, panY);
        XpImageOrientation newOrient = this.getImageRenderAttributes().getImageOrientation();
        if (oldZoom != zoom) {
            this.firePropertyChange("zoom", oldZoom, zoom);
        }
        if (oldMin != min) {
            this.firePropertyChange("winMin", oldMin, min);
        }
        if (oldMax != max) {
            this.firePropertyChange("winMax", oldMax, max);
        }
        if (panX != oldPanX || panY != oldPanY) {
            this.firePropertyChange("pan", oldPan, pan);
        }
        if (oldOrient != newOrient) {
            this.firePropertyChange("IMAGE_ORIENTATION", oldOrient, newOrient);
        }
    }

    private void updateAdditionalVcs(List<String> cpiSerializeables) {
        if (cpiSerializeables != null && cpiSerializeables.size() > 0) {
            for (int i = 0; i < cpiSerializeables.size(); ++i) {
                String cpis = cpiSerializeables.get(i);
                String[] cpisplit = cpis.split(":");
                int portNo = Integer.parseInt(cpisplit[0]);
                String cpisClass = cpisplit[1];
                String cpisArgs = cpisplit[2];
                System.out.println("CPI = " + cpisClass);
                try {
                    Class<?> c = Class.forName(cpisClass);
                    Class[] argTypes = new Class[]{String.class};
                    Method m = c.getMethod("createVC", argTypes);
                    Object o = m.invoke(null, cpisArgs);
                    if (!(o instanceof XpVisualComponent)) continue;
                    XpVisualComponent v = (XpVisualComponent)o;
                    XpFrameVisualizer port = (XpFrameVisualizer)this.portList.get(portNo);
                    port.getMedicalImageVc().getImageVc().add(v);
                    port.syncScene();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public XpCPI getCPI() {
        XpFrameVisualizer fv = this.getPort(0);
        Dimension d = fv.getMedicalImageVc().getImageVc().getSize();
        XpCPI cpi = XpCPI.createCPI(this.sceneList, d, false);
        for (int i = 0; i < this.portList.size(); ++i) {
            XpFrameVisualizer port = (XpFrameVisualizer)this.portList.get(i);
            Component[] comps = port.getMedicalImageVc().getImageVc().getComponents();
            if (comps == null || comps.length <= 0) continue;
            for (int j = 0; j < comps.length; ++j) {
                if (!(comps[j] instanceof CPISerializable)) continue;
                CPISerializable cpis = (CPISerializable)((Object)comps[j]);
                cpi.add2cpi(cpis, i);
            }
        }
        cpi.fillAnnotationModule((AnnotCapable)this.getCapable("com.ge.med.terra.jami.capable.AnnotCapable"));
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        XpColorOverlay co = ira.getColorOverlay();
        if (co != null) {
            XpCPI.setBitmapDisplayShutter(co, 0, cpi);
        }
        Shape cs = this.getClipShape();
        Shape ics = this.getImageClip();
        if (cs != null) {
            XpCPI.addDisplayShutter(cs, 1, 0, cpi);
        }
        if (ics != null) {
            XpCPI.addDisplayShutter(ics, 0, 0, cpi);
        }
        return cpi;
    }

    @Override
    public void clearGraphics() {
        XpCPI.clearGraphics(this.sceneList);
        if (this.mio != null) {
            XpCPI.clearGraphics(this.orgSceneList);
        }
        this.layoutImages();
    }

    @Override
    public void setGSPS(InputStream gspsStream) {
        XpCPI cpi = XpDMgsps.getCPI(gspsStream);
        if (cpi != null) {
            this.setCPI(cpi);
            this.repaint();
        }
    }

    @Override
    public final InputStream getGSPS() {
        XpDMgsps gspsFactory = new XpDMgsps(this);
        return gspsFactory.getGSPS();
    }

    @Override
    public void setImageRenderSettings(XpImageRenderSettings irs) {
        XpImageRenderAttributes ira;
        IndexOutOfBoundsException re;
        XpImageRenderAttributes ira2;
        XpImageScene is;
        int j;
        IndexOutOfBoundsException re2;
        XpImageScene is2;
        int idx;
        int j2;
        int[] frames;
        XpImageRenderSettings.Frames s;
        int i;
        int len = this.getNumScenes();
        int n = irs.getNumRoiSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getRoiSetting(i);
            frames = s.frames;
            RoiActor[] ras = s.rois;
            for (j2 = 0; j2 < frames.length; ++j2) {
                idx = frames[j2];
                if (idx >= 0 && idx < len) {
                    is2 = this.getScene(idx);
                    RoiActor ra = ras[j2];
                    if (is2 == null) continue;
                    is2.add(ra);
                    continue;
                }
                re2 = new IndexOutOfBoundsException("setImageRenderSettings (roi): Invalid Scene/Image Index=" + idx);
                throw re2;
            }
        }
        n = irs.getNumUserAnnoSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getUserAnnoSetting(i);
            frames = ((XpImageRenderSettings.UserAnnoSetting)s).frames;
            XpUserAnnotationModel[] vals = ((XpImageRenderSettings.UserAnnoSetting)s).uams;
            for (j2 = 0; j2 < frames.length; ++j2) {
                idx = frames[j2];
                if (idx >= 0 && idx < len) {
                    is2 = this.getScene(idx);
                    XpUserAnnotationModel val = vals[j2];
                    if (is2 == null) continue;
                    is2.add(val);
                    continue;
                }
                re2 = new IndexOutOfBoundsException("setImageRenderSettings (user annotation): Invalid Scene/Image Index=" + idx);
                throw re2;
            }
        }
        n = irs.getNumWWWLSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getWWWLSetting(i);
            frames = ((XpImageRenderSettings.WWWLSetting)s).frames;
            double[] wws = ((XpImageRenderSettings.WWWLSetting)s).ww;
            double[] wls = ((XpImageRenderSettings.WWWLSetting)s).wl;
            for (j = 0; j < frames.length; ++j) {
                int idx2 = frames[j];
                if (idx2 >= 0 && idx2 < len) {
                    is = this.getScene(idx2);
                    if (is == null) continue;
                    ira2 = is.getImageRenderAttributes();
                    ira2.setWindowing(wws[j], wls[j]);
                    is.setImageRenderAttributes(ira2);
                    continue;
                }
                re = new IndexOutOfBoundsException("setImageRenderSettings (ww/wl): Invalid Scene/Image Index=" + idx2);
                throw re;
            }
        }
        n = irs.getNumPanSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getPanSetting(i);
            frames = ((XpImageRenderSettings.PanSetting)s).frames;
            double[] pxs = ((XpImageRenderSettings.PanSetting)s).panX;
            double[] pys = ((XpImageRenderSettings.PanSetting)s).panY;
            for (j = 0; j < frames.length; ++j) {
                int idx3 = frames[j];
                if (idx3 >= 0 && idx3 < len) {
                    is = this.getScene(idx3);
                    if (is == null) continue;
                    ira2 = is.getImageRenderAttributes();
                    ira2.setPan(pxs[j], pys[j]);
                    is.setImageRenderAttributes(ira2);
                    continue;
                }
                re = new IndexOutOfBoundsException("setImageRenderSettings (pan): Invalid Scene/Image Index=" + idx3);
                throw re;
            }
        }
        n = irs.getNumZoomSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getZoomSetting(i);
            frames = ((XpImageRenderSettings.ZoomSetting)s).frames;
            double[] zoom = ((XpImageRenderSettings.ZoomSetting)s).zoom;
            for (int j3 = 0; j3 < frames.length; ++j3) {
                idx = frames[j3];
                if (idx >= 0 && idx < len) {
                    XpImageScene is3 = this.getScene(idx);
                    if (is3 == null) continue;
                    ira = is3.getImageRenderAttributes();
                    ira.setZoom(zoom[j3]);
                    is3.setImageRenderAttributes(ira);
                    continue;
                }
                IndexOutOfBoundsException re3 = new IndexOutOfBoundsException("setImageRenderSettings (zoom): Invalid Scene/Image Index=" + idx);
                throw re3;
            }
        }
        n = irs.getNumIVSettings();
        for (i = 0; i < n; ++i) {
            s = irs.getIVSetting(i);
            frames = ((XpImageRenderSettings.IVSetting)s).frames;
            boolean[] iv = ((XpImageRenderSettings.IVSetting)s).iv;
            for (int j4 = 0; j4 < frames.length; ++j4) {
                idx = frames[j4];
                if (idx >= 0 && idx < len) {
                    XpImageScene is4 = this.getScene(idx);
                    if (is4 == null) continue;
                    ira = is4.getImageRenderAttributes();
                    ira.setVideoInverted(iv[j4]);
                    is4.setImageRenderAttributes(ira);
                    continue;
                }
                IndexOutOfBoundsException re4 = new IndexOutOfBoundsException("setImageRenderSettings (inverse video): Invalid Scene/Image Index=" + idx);
                throw re4;
            }
        }
        n = irs.getNumOverlaySettings();
        for (i = 0; i < n; ++i) {
            s = irs.getCOverlaySetting(i);
            frames = ((XpImageRenderSettings.COverlaySetting)s).frames;
            XpColorOverlay[] co = ((XpImageRenderSettings.COverlaySetting)s).coverlay;
            for (int j5 = 0; j5 < frames.length; ++j5) {
                idx = frames[j5];
                if (idx >= 0 && idx < len) {
                    XpImageScene is5 = this.getScene(idx);
                    if (is5 == null) continue;
                    ira = is5.getImageRenderAttributes();
                    ira.setColorOverlay(co[j5]);
                    is5.setImageRenderAttributes(ira);
                    continue;
                }
                IndexOutOfBoundsException re5 = new IndexOutOfBoundsException("setImageRenderSettings (color overlay): Invalid Scene/Image Index=" + idx);
                throw re5;
            }
        }
        this.layoutImages();
        this.repaint();
    }

    private void fireRowColChangeEvent(int oldR, int oldC) {
        int r = this.gridLayout.getRows();
        int c = this.gridLayout.getColumns();
        Dimension oldD = new Dimension(oldC, oldR);
        Dimension newD = new Dimension(c, r);
        this.firePropertyChange("RowColumnProperty", oldD, newD);
    }

    public void setRowsAndColumns(int rows, int columns) {
        if (this.getCine()) {
            return;
        }
        int oldR = this.gridLayout.getRows();
        int oldC = this.gridLayout.getColumns();
        this.gridLayout.setRows(rows);
        this.gridLayout.setColumns(columns);
        this.syncPorts();
        this.fireRowColChangeEvent(oldR, oldC);
    }

    @Override
    public void setRows(int rows) {
        if (this.getCine()) {
            return;
        }
        int oldR = this.gridLayout.getRows();
        int oldC = this.gridLayout.getColumns();
        this.gridLayout.setRows(rows);
        this.syncPorts();
        this.fireRowColChangeEvent(oldR, oldC);
    }

    @Override
    public void setCols(int columns) {
        if (this.getCine()) {
            return;
        }
        int oldR = this.gridLayout.getRows();
        int oldC = this.gridLayout.getColumns();
        this.gridLayout.setColumns(columns);
        this.syncPorts();
        this.fireRowColChangeEvent(oldR, oldC);
    }

    @Override
    public void setRowCol(int row, int col) {
        if (this.getCine()) {
            return;
        }
        this.setRowsAndColumns(row, col);
    }

    @Override
    public final int getRows() {
        return this.gridLayout.getRows();
    }

    @Override
    public final int getCols() {
        return this.gridLayout.getColumns();
    }

    protected void doInvalidate() {
        this.invalidatePending = true;
    }

    protected final void callRepaint() {
        if (this.invalidatePending) {
            this.invalidate();
            this.validate();
            this.invalidatePending = false;
        }
        this.request_repaint();
    }

    @Override
    public String[] getAnnotationGroups() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationGroups();
        }
        return null;
    }

    @Override
    public String getAnnotationGroup() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationGroup();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationItems();
        }
        return null;
    }

    public Map getAnnotationItemStates() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationItemStates();
        }
        return null;
    }

    @Override
    public void setAnnotationGroup(String agName, boolean activate) {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setAnnotationGroup(agName, activate);
        }
        this.annoState.setAnnotationGroup(agName, activate);
    }

    @Override
    public void setAnnotationItems(String[] annoItems, boolean activate) {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setAnnotationItems(annoItems, activate);
        }
        this.annoState.setAnnotationItems(annoItems, activate);
    }

    @Override
    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.queryAnnotationItems(annoItems, queryRes);
        }
    }

    @Override
    public boolean queryAnnotationItem(String aiName) {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.queryAnnotationItem(aiName);
        }
        return false;
    }

    @Override
    public String[] getAnnotationItems(String agName) {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationItems(agName);
        }
        return null;
    }

    @Override
    public void setAnnotationColor(Color c) {
        int nports = this.getNumPorts();
        for (int i = 0; i < nports; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setAnnotationColor(c);
        }
        this.annotationColor = c;
    }

    @Override
    public Color getAnnotationColor() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationColor();
        }
        return null;
    }

    @Override
    public void setAnnotationVisible(boolean annotVisible) {
        int nports = this.getNumPorts();
        for (int i = 0; i < nports; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setAnnotationVisible(annotVisible);
        }
        this.annotVisible = annotVisible;
    }

    @Override
    public boolean isAnnotationVisible() {
        return this.annotVisible;
    }

    @Override
    public void setAnnotationGenerator(Class agClass, Properties props) {
        this.agClass = agClass;
        this.props = props;
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setAnnotationGenerator(agClass, props);
        }
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null) {
            return fv.getAnnotationGenerator();
        }
        return null;
    }

    public final int getSelectedSceneIndex() {
        return this.selSceneIdx;
    }

    public final XpFrameVisualizer getSelectedPort() {
        if (this.getNumPorts() > 0) {
            return this.getPort(this.selPort);
        }
        return null;
    }

    private final int getSelectedPortIndex() {
        return this.selPort;
    }

    public final int getPrimarySelectedIndex() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            XpImageScene is = fv.getScene();
            return this.getSceneIndexAtPort(this.getSelectedPortIndex());
        }
        return -1;
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            fv.setImageRenderAttributes(attr);
        } else {
            int idx = this.getSelectedSceneIndex();
            XpImageScene is = this.getScene(idx);
            if (is != null) {
                is.setImageRenderAttributes(attr);
            }
        }
        this.updatePropRenderAttributes();
    }

    @Override
    public XpImageRenderAttributes getImageRenderAttributes() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getImageRenderAttributes();
        }
        int idx = this.getSelectedSceneIndex();
        XpImageScene is = this.getScene(idx);
        if (is != null) {
            return is.getImageRenderAttributes();
        }
        return null;
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getImagePixelAttributes(layer);
        }
        int idx = this.getSelectedSceneIndex();
        XpImageScene is = this.getScene(idx);
        if (is != null) {
            int len;
            if (layer == 0) {
                return is.getImageRenderAttributes().getImagePixelAttributes();
            }
            List layers = is.getImageLayers();
            if (layers != null && layer <= (len = layers.size())) {
                XpImageLayer img_layer = (XpImageLayer)layers.get(layer - 1);
                XpImagePixelAttributes ipa = img_layer.getImagePixelAttributes();
                return ipa;
            }
        }
        return null;
    }

    @Override
    public final void addPortControl(Class onPortComp, Object location) {
        this.opControlMap.put(onPortComp, location);
        Iterator i = this.getPorts();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof OnPortCapable)) continue;
            OnPortCapable oplm = (OnPortCapable)o;
            oplm.addPortControl(onPortComp, location);
        }
    }

    @Override
    public final void setOnPortLayoutManager(Class layoutMgrClass) {
        if (layoutMgrClass.isAssignableFrom(LayoutManager.class)) {
            this.layoutMgrClass = layoutMgrClass;
            Iterator i = this.getPorts();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof OnPortCapable)) continue;
                OnPortCapable oplm = (OnPortCapable)o;
                oplm.setOnPortLayoutManager(layoutMgrClass);
            }
        }
    }

    @Override
    public final void removePortControl(Class onPortComp) {
        this.opControlMap.remove(onPortComp);
        Iterator i = this.getPorts();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof OnPortCapable)) continue;
            OnPortCapable oplm = (OnPortCapable)o;
            oplm.removePortControl(onPortComp);
        }
    }

    public void updatePropRenderAttributes() {
        XpImageRenderAttributes ira = null;
        XpFrameVisualizer selFv = this.getSelectedPort();
        boolean change = false;
        if (this.isSyncRenderAttributes() && !this.isSharedRenderAttributes()) {
            change = false;
            if (selFv != null) {
                ira = selFv.getImageRenderAttributes();
            }
            if (ira != null) {
                XpImageScene selScene = selFv.getScene();
                int slen = this.getNumScenes();
                for (int i = 0; i < slen; ++i) {
                    XpImageScene is = this.getScene(i);
                    int selected = is.getSelectedState();
                    if (is == selScene || selected <= 0) continue;
                    XpImageRenderAttributes attr = is.getImageRenderAttributes();
                    attr.set(ira);
                    is.setImageRenderAttributes(attr);
                }
                change = true;
            }
        } else if (this.isSharedRenderAttributes()) {
            change = true;
        }
        if (selFv != null) {
            ira = selFv.getImageRenderAttributes();
            double oldWMAX = this.oldIRA.getWindowMax();
            double oldWMIN = this.oldIRA.getWindowMin();
            double newWMAX = ira.getWindowMax();
            double newWMIN = ira.getWindowMin();
            XpImageOrientation oldOrient = this.oldIRA.getImageOrientation();
            XpImageOrientation newOrient = ira.getImageOrientation();
            if (this.oldIRA.getPanX() != ira.getPanX() || this.oldIRA.getPanY() != ira.getPanY()) {
                this.firePropertyChange("pan", null, ira.getPan());
            }
            if (this.oldIRA.getZoom() != ira.getZoom()) {
                this.firePropertyChange("zoom", this.oldIRA.getZoom(), ira.getZoom());
            }
            if (oldWMAX != newWMAX) {
                this.firePropertyChange("winMax", oldWMAX, newWMAX);
            }
            if (oldWMIN != newWMIN) {
                this.firePropertyChange("winMin", oldWMIN, newWMIN);
            }
            if (oldOrient != newOrient) {
                this.firePropertyChange("IMAGE_ORIENTATION", oldOrient, newOrient);
            }
            this.oldIRA.set(ira);
        }
        if (change) {
            this.refreshImageRenderAttributes();
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    protected final void refreshImageRenderAttributes() {
        int np = this.getNumPorts();
        for (int i = 0; i < np; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            if (fv == null) continue;
            fv.getMedicalImageVc().refreshImageRenderAttributes();
        }
    }

    @Override
    public final int getNumComponents() {
        return this.getNumPorts();
    }

    @Override
    public final int getComponentSelection() {
        return this.selPort;
    }

    protected final void resetPortSelection() {
        int size = this.getNumPorts();
        for (int j = 0; j < size; ++j) {
            this.portSelectedState[j] = 0;
        }
        this.selPort = -1;
    }

    protected final void setComponentSelection(int selection, boolean skipComponentSelectionChangeFiring) {
        int idx = this.getComponentSelection();
        int size = this.getNumPorts();
        if (idx != selection && selection < size) {
            this.setPortSelection(selection, 1, false, skipComponentSelectionChangeFiring);
        } else if (idx == selection && !skipComponentSelectionChangeFiring) {
            this.firePropertyChange("ComponentSelection", -99, selection);
        }
    }

    @Override
    public final void setComponentSelection(int selection) {
        this.setComponentSelection(selection, false);
    }

    @Override
    public final JComponent getViewportComponent(int selection) {
        XpFrameVisualizer comp = null;
        int size = this.getNumPorts();
        if (selection >= 0 && selection < size) {
            comp = this.getPort(selection);
        }
        return comp;
    }

    @Override
    public void setZoom(double zoom) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            ira.setZoom(zoom);
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    public void setActiveVoiLutIndex(int idx) {
        XpImageRenderAttributes ira;
        if ((double)idx != this.getActiveVoiLutIndex() && (ira = this.getImageRenderAttributes()) != null) {
            ira.setActiveVoiLutIndex(idx);
            XpImage img = this.getImageAt(this.getSelectedSceneIndex());
            if (idx == -1) {
                ira.setWindowing(img.getDefaultWindowWidth(), img.getDefaultWindowLevel());
            } else if (img instanceof XpMedicalImage) {
                XpMedicalImage mimg = (XpMedicalImage)img;
                int[][] descriptors = DICOMLut.getVoiLUTDescriptors(mimg);
                ira.setWindowMinMax(0.0, 1 << descriptors[idx][2]);
            }
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public final double getZoom() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            return ira.getZoom();
        }
        return 1.0;
    }

    public final double getActiveVoiLutIndex() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            return ira.getActiveVoiLutIndex();
        }
        return -1.0;
    }

    @Override
    public void setRotate(double rotate) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            rotate = Math.toRadians(rotate);
            ira.setAngle(rotate);
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public final double getRotate() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            return Math.toDegrees(ira.getAngle());
        }
        return 0.0;
    }

    @Override
    public void setPan(double pan_x, double pan_y) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            ira.setPan(pan_x, pan_y);
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public void setPanY(double pan_y) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            double pan_x = ira.getPanX();
            ira.setPan(pan_x, pan_y);
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public final double getPanY() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            return ira.getPanY();
        }
        return 0.0;
    }

    @Override
    public void setPanX(double pan_x) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            double pan_y = ira.getPanY();
            ira.setPan(pan_x, pan_y);
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public final double getPanX() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            return ira.getPanX();
        }
        return 0.0;
    }

    @Override
    public void flipVertical() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            ira.getImageOrientation().flipVertical();
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public void flipHorizontal() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            ira.getImageOrientation().flipHorizontal();
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
        }
    }

    @Override
    public void resetPanZoom() {
        int ns = this.getNumScenes();
        for (int i = 0; i < ns; ++i) {
            XpImageScene is = this.getScene(i);
            XpImageRenderAttributes ira = is.getImageRenderAttributes();
            ira.resetAffine();
            is.setImageRenderAttributes(ira);
        }
        this.updatePropRenderAttributes();
        this.refreshImageRenderAttributes();
        if (this.isAutoRepaint()) {
            this.callRepaint();
        }
    }

    public void resetIRA() {
        if (this.isSharedIRA) {
            this.sharedIRA.reset();
        } else {
            int ns = this.getNumScenes();
            for (int i = 0; i < ns; ++i) {
                XpImageScene is = this.getScene(i);
                is.resetIRA();
            }
        }
        this.refreshImageRenderAttributes();
    }

    @Override
    public double[] getRange() {
        XpImage img = this.getImageAt(0);
        double ww = img.getDefaultWindowWidth();
        double wl = img.getDefaultWindowLevel();
        return new double[]{wl - ww / 2.0, wl + ww / 2.0};
    }

    private void setWinMinMax(int layer, double min, double max) {
        if (min < this.winLowerLimit) {
            min = this.winLowerLimit;
        } else if (min > this.winUpperLimit) {
            min = this.winUpperLimit;
        }
        if (max > this.winUpperLimit) {
            max = this.winUpperLimit;
        } else if (max < this.winLowerLimit) {
            max = this.winLowerLimit;
        }
        if (min >= this.winLowerLimit && max <= this.winUpperLimit && min <= max) {
            double ww = max - min;
            double wl = (max + min) * 0.5;
            double oldMin = this.getWinMin();
            double oldMax = this.getWinMax();
            if (layer == 0) {
                XpImageRenderAttributes ira = this.getImageRenderAttributes();
                if (ira != null) {
                    ira.setWindowing(ww, wl);
                    this.setImageRenderAttributes(ira);
                }
            } else {
                this.setImageLayerWindowing(layer, ww, wl);
            }
            if (min != oldMin) {
                this.firePropertyChange("winMin", oldMin, min);
            }
            if (max != oldMax) {
                this.firePropertyChange("winMax", oldMax, max);
            }
            this.auto_repaint();
        }
    }

    @Override
    public void setWinMinMax(double min, double max) {
        int layer = this.getImageLayer();
        this.setWinMinMax(layer, min, max);
    }

    @Override
    public double getWinMin() {
        int layer = this.getImageLayer();
        if (layer == 0) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            if (ira != null) {
                return ira.getWindowMin();
            }
        } else {
            XpImageLayer il = this.getImageLayer(layer);
            if (il != null) {
                return il.getWindowMin();
            }
        }
        return 0.0;
    }

    @Override
    public void setWinMin(double min) {
        double max = this.getWinMax();
        this.setWinMinMax(min, max);
    }

    @Override
    public double getWinMax() {
        int layer = this.getImageLayer();
        if (layer == 0) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            if (ira != null) {
                return ira.getWindowMax();
            }
        } else {
            XpImageLayer il = this.getImageLayer(layer);
            if (il != null) {
                return il.getWindowMax();
            }
        }
        return 255.0;
    }

    @Override
    public void resetWindowing() {
        int ns = this.getNumScenes();
        for (int i = 0; i < ns; ++i) {
            XpImageScene is = this.getScene(i);
            XpImage img = is.getFrame();
            if (img == null) continue;
            double ww = img.getDefaultWindowWidth();
            double wl = img.getDefaultWindowLevel();
            double min = wl - ww / 2.0;
            double max = wl + ww / 2.0;
            if (min < this.winLowerLimit) {
                min = this.winLowerLimit;
            }
            if (max > this.winUpperLimit) {
                max = this.winUpperLimit;
            }
            ww = max - min;
            wl = (max + min) * 0.5;
            XpImageRenderAttributes ira = is.getImageRenderAttributes();
            ira.resetPixel(ww, wl);
            is.setImageRenderAttributes(ira);
        }
        this.updatePropRenderAttributes();
        this.refreshImageRenderAttributes();
    }

    @Override
    public void setWinMax(double max) {
        double min = this.getWinMin();
        this.setWinMinMax(min, max);
    }

    public void setWindowing(double width, double level) {
        double min = level - width / 2.0;
        double max = level + width / 2.0;
        this.setWinMinMax(min, max);
    }

    public void setWindowing(int layer, double width, double level) {
        double min = level - width / 2.0;
        double max = level + width / 2.0;
        this.setWinMinMax(layer, min, max);
    }

    public void setVideoInverted(int layer, boolean inverted) {
        boolean old_inverted = this.isVideoInverted();
        if (layer == 0) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            if (ira != null) {
                ira.setVideoInverted(inverted);
                this.setImageRenderAttributes(ira);
            }
        } else {
            this.setImageLayerVideoInverted(layer, inverted);
        }
        this.firePropertyChange("videoInverted", old_inverted, inverted);
        this.auto_repaint();
    }

    @Override
    public void setVideoInverted(boolean inverted) {
        int layer = this.getImageLayer();
        this.setVideoInverted(layer, inverted);
    }

    @Override
    public void setWinUpperLimit(double wuLimit) {
        if (wuLimit >= this.winLowerLimit) {
            this.winUpperLimit = wuLimit;
            double max = this.getWinMax();
            if (max > this.winUpperLimit) {
                this.setWinMax(this.winUpperLimit);
            }
            int nports = this.getNumPorts();
            for (int i = 0; i < nports; ++i) {
                XpFrameVisualizer sp = this.getPort(i);
                sp.setWinUpperLimit(wuLimit);
            }
        }
    }

    @Override
    public double getWinUpperLimit() {
        return this.winUpperLimit;
    }

    @Override
    public void setWinLowerLimit(double wlLimit) {
        if (wlLimit <= this.winUpperLimit) {
            this.winLowerLimit = wlLimit;
            double min = this.getWinMax();
            if (min < this.winLowerLimit) {
                this.setWinMin(this.winLowerLimit);
            }
            int nports = this.getNumPorts();
            for (int i = 0; i < nports; ++i) {
                XpFrameVisualizer sp = this.getPort(i);
                sp.setWinLowerLimit(wlLimit);
            }
        }
    }

    @Override
    public double getWinLowerLimit() {
        return this.winLowerLimit;
    }

    @Override
    public boolean isVideoInverted() {
        int layer = this.getImageLayer();
        if (layer == 0) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            if (ira != null) {
                return ira.isVideoInverted();
            }
        } else {
            XpImageLayer il = this.getImageLayer(layer);
            if (il != null) {
                return il.isVideoInverted();
            }
        }
        return false;
    }

    @Override
    public final Shape getClipShape() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getMedicalImageVc().getClipShape();
        }
        return null;
    }

    @Override
    public final void setImageClip(Shape s) {
        this.imageClipShape = s;
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.getMedicalImageVc().setImageClip(s);
        }
    }

    @Override
    public final Shape getImageClip() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getMedicalImageVc().getImageClip();
        }
        return null;
    }

    @Override
    public final void setClipShape(Shape clipShape) {
        this.clipShape = clipShape;
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.getMedicalImageVc().setClipShape(clipShape);
        }
    }

    public final void setFitToViewport(boolean fToViewport) {
        if (this.fitToViewport != fToViewport) {
            this.fitToViewport = fToViewport;
            int len = this.getNumPorts();
            for (int i = 0; i < len; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                fv.setFitToViewport(this.fitToViewport);
            }
        }
    }

    public final boolean getFitToViewport() {
        return this.fitToViewport;
    }

    public final void setClipGraphics(boolean clipGraphics) {
        if (this.clipGraphics != clipGraphics) {
            this.clipGraphics = clipGraphics;
            int len = this.getNumPorts();
            for (int i = 0; i < len; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                fv.setClipGraphics(clipGraphics);
            }
        }
    }

    public final boolean isClipGraphics() {
        return this.clipGraphics;
    }

    @Override
    public String[] getAnnotationSegments() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getAnnotationSegments();
        }
        return null;
    }

    @Override
    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil) {
        if (annotSegment != null) {
            int len = this.getNumPorts();
            for (int i = 0; i < len; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                fv.setActiveAnnotationListener(annotSegment, mil);
            }
            ArrayList<MouseInputListener> l = new ArrayList<MouseInputListener>();
            l.add(mil);
            l.add(null);
            this.activeAnnotation.put(annotSegment, l);
        }
    }

    @Override
    public void setActiveAnnotationListener(String annotSegment, MouseInputListener mil, String tooltip) {
        if (annotSegment != null) {
            int len = this.getNumPorts();
            for (int i = 0; i < len; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                fv.setActiveAnnotationListener(annotSegment, mil, tooltip);
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(mil);
            l.add(tooltip);
            this.activeAnnotation.put(annotSegment, l);
        }
    }

    @Override
    public void clearActiveAnnotationListener(String annotSegment) {
        if (annotSegment != null) {
            int len = this.getNumPorts();
            for (int i = 0; i < len; ++i) {
                XpFrameVisualizer fv = this.getPort(i);
                fv.clearActiveAnnotationListener(annotSegment);
            }
            this.activeAnnotation.remove(annotSegment);
        }
    }

    @Override
    public void clearActiveAnnotationListeners() {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.clearActiveAnnotationListeners();
        }
        this.activeAnnotation.clear();
    }

    @Override
    public void add(RoiActor m) {
        if (this.getCine()) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null) {
            fv.add(m);
            fv.repaint();
        }
    }

    @Override
    public boolean remove(RoiActor ra) {
        XpImageScene is;
        int nPorts = this.getNumPorts();
        for (int i = 0; i < nPorts; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            if (fv == null || (is = fv.getScene()) == null || !is.remove(ra)) continue;
            fv.syncScene();
            fv.repaint();
            return true;
        }
        int nScenes = this.getNumScenes();
        for (int i = 0; i < nScenes; ++i) {
            is = this.getScene(i);
            if (is == null || !is.remove(ra)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final List getRois() {
        XpImageScene scene2;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (scene2 = fv.getScene()) != null) {
            return scene2.getRois();
        }
        return null;
    }

    @Override
    public final RoiActor getRoi() {
        XpImageScene scene2;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (scene2 = fv.getScene()) != null) {
            return scene2.getRoi();
        }
        return null;
    }

    @Override
    public void add(XpUserAnnotationModel m) {
        if (this.getCine()) {
            return;
        }
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null) {
            fv.add(m);
            fv.repaint();
        }
    }

    @Override
    public boolean remove(XpUserAnnotationModel m) {
        XpImageScene is;
        int nPorts = this.getNumPorts();
        for (int i = 0; i < nPorts; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            if (fv == null || (is = fv.getScene()) == null || !is.remove(m)) continue;
            fv.syncScene();
            fv.repaint();
            return true;
        }
        int nScenes = this.getNumScenes();
        for (int i = 0; i < nScenes; ++i) {
            is = this.getScene(i);
            if (is == null || !is.remove(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final List getUserAnnos() {
        XpImageScene scene2;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (scene2 = fv.getScene()) != null) {
            return scene2.getUserAnnos();
        }
        return null;
    }

    @Override
    public final ComponentCreator getComponentCreator() {
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv != null) {
            return fv.getComponentCreator();
        }
        return null;
    }

    @Override
    public final void setComponentCreator(ComponentCreator rc) {
        if (this.getCine()) {
            return;
        }
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setComponentCreator(rc);
        }
    }

    @Override
    public final void addImageOp(XpImageOp imageOp) {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            ira.addImageOperation(imageOp);
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
            this.firePropertyChange("IMAGEOP_ADDED", null, imageOp);
        }
    }

    @Override
    public final List getImageOps() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            return ira.getImageOperations();
        }
        return null;
    }

    @Override
    public final void clearImageOps() {
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        if (ira != null) {
            ira.clearImageOperations();
            this.setImageRenderAttributes(ira);
            if (this.isAutoRepaint()) {
                this.callRepaint();
            }
            this.firePropertyChange("IMAGEOPS_CLEARED", null, this);
        }
    }

    @Override
    public final void setColorMap(int[] cMap) {
        int layer = this.getImageLayer();
        this.setColorMap(layer, cMap);
    }

    public final void setColorMap(int layer, int[] cMap) {
        int[] oldMap = null;
        if (layer == 0) {
            XpViewport.JamiIndexColorModel colorModel = null;
            if (cMap != null) {
                colorModel = new XpViewport.JamiIndexColorModel(cMap);
            }
            oldMap = this.colorMap;
            this.colorMap = cMap;
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            if (ira != null) {
                ira.setColormap(colorModel);
                this.setImageRenderAttributes(ira);
            }
        } else {
            XpImageLayer il = this.getImageLayer(layer);
            if (il != null) {
                oldMap = il.getColorMapTable();
            }
            this.setImageLayerColorMap(layer, cMap);
        }
        this.auto_repaint();
        this.firePropertyChange("COLOR_MAP", oldMap, cMap);
    }

    @Override
    public final int[] getColorMap() {
        int layer = this.getImageLayer();
        if (layer == 0) {
            return this.colorMap;
        }
        XpImageLayer il = this.getImageLayer(layer);
        if (il != null) {
            return il.getColorMapTable();
        }
        return null;
    }

    public final XpViewportManager getViewportManager() {
        return this.vpManager;
    }

    public final void setViewportManager(XpViewportManager vm) {
        this.vpManager = vm;
        if (vm != null) {
            for (int i = 0; i < this.portList.size(); ++i) {
                XpFrameVisualizer fv = (XpFrameVisualizer)this.portList.get(i);
                vm.createViewportCB(fv);
            }
        }
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.sortComparator = comparator;
        this.syncComparator();
    }

    @Override
    public Comparator getComparator() {
        return this.sortComparator;
    }

    public void syncComparator() {
        if (this.sortComparator != null) {
            int len = this.getNumScenes();
            this.sortMap = new Integer[len];
            for (int i = 0; i < len; ++i) {
                this.sortMap[i] = new Integer(i);
            }
            Arrays.sort(this.sortMap, this.pComparator);
        } else {
            this.sortMap = null;
        }
        this.layoutImages();
    }

    public final void setDebug(boolean dbg) {
        this.debug = dbg;
    }

    public final Border getPrimaryBorder() {
        return this.primaryBorder;
    }

    public final void setPrimaryBorder(Border bd) {
        this.primaryBorder = bd;
        for (int i = 0; i < this.getNumPorts(); ++i) {
            this.getPort(i).setPrimaryBorder(this.primaryBorder);
        }
        this.syncPorts();
    }

    public final Border getSecondaryBorder() {
        return this.secondaryBorder;
    }

    public final void setSecondaryBorder(Border bd) {
        this.secondaryBorder = bd;
        for (int i = 0; i < this.getNumPorts(); ++i) {
            this.getPort(i).setSecondaryBorder(this.secondaryBorder);
        }
        this.syncPorts();
    }

    @Override
    public void dispose() {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer vp = this.getPort(i);
            ((XpViewport)vp).dispose();
        }
    }

    public final boolean isAnnotationTooltip() {
        return this.annotTooltip;
    }

    public final void setAnnotationTooltip(boolean annotTooltip) {
        this.annotTooltip = annotTooltip;
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer sp = this.getPort(i);
            sp.setAnnotationTooltip(annotTooltip);
        }
    }

    public final Object getInterpolationHint() {
        return this.interpolationHint;
    }

    public final void setInterpolationHint(Object interpolationHint) {
        if (interpolationHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR || interpolationHint == RenderingHints.VALUE_INTERPOLATION_BILINEAR || interpolationHint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            this.interpolationHint = interpolationHint;
            int len = this.getNumPorts();
            for (int i = 0; i < len; ++i) {
                XpFrameVisualizer sp = this.getPort(i);
                sp.setInterpolationHint(interpolationHint);
            }
        }
    }

    public final void setCineQuality(Object cineQuality) {
        if (cineQuality == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR || cineQuality == RenderingHints.VALUE_INTERPOLATION_BILINEAR || cineQuality == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            this.cineQuality = cineQuality;
        }
    }

    public final Object getCineQuality() {
        return this.cineQuality;
    }

    public final boolean isSquareViewports() {
        return this.gridLayout.isSquareComponents();
    }

    public final void setSquareViewports(boolean squareViewports) {
        boolean old = this.isSquareViewports();
        if (old != squareViewports) {
            this.gridLayout.setSquareComponents(squareViewports);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public final void forward(int n) {
        int offset = this.getOffset();
        int nFrames = this.getMaxFrame();
        offset = (offset += n) >= nFrames ? nFrames - 1 : offset;
        this.setOffset(offset);
        this.repaint();
    }

    public final void back(int n) {
        int offset = this.getOffset() - n;
        int nFrames = this.getMaxFrame();
        offset = offset < 0 ? 0 : offset;
        this.setOffset(offset);
        this.repaint();
    }

    public void pageDown() {
        int nshown = this.getRows() * this.getCols();
        this.forward(nshown);
    }

    public void pageUp() {
        int nshown = this.getRows() * this.getCols();
        this.back(nshown);
    }

    public String getRendererType() {
        return this.rendererType;
    }

    @Override
    public final XpImage getFrame() {
        int size = this.getNumFrames();
        int index = this.getFrameIndex();
        XpImage img = null;
        if (index >= 0 && index < size) {
            img = this.getFrame(index);
        }
        return img;
    }

    @Override
    public final XpImage getFrame(int idx) {
        return this.getImageAt(idx);
    }

    @Override
    public XpImage getImageAt(int idx) {
        if (idx >= 0 && idx < this.getNumScenes()) {
            return this.getScene(idx).getFrame();
        }
        return null;
    }

    @Override
    public final XpMedicalImage[] getImages() {
        int len = this.orgSceneList.size();
        XpMedicalImage[] imgs = new XpMedicalImage[len];
        for (int i = 0; i < len; ++i) {
            imgs[i] = (XpMedicalImage)((XpImageScene)this.orgSceneList.get(i)).getFrame();
        }
        return imgs;
    }

    public final int getNumberMedicalImages() {
        return this.orgSceneList.size();
    }

    protected void defaultSharedIRA() {
        XpImage img = this.getFrame(0);
        if (img != null) {
            double ww = img.getDefaultWindowWidth();
            double wl = img.getDefaultWindowLevel();
            this.resetSharedIRA(ww, wl);
        }
    }

    protected abstract void sync();

    @Override
    public final void setMultiImageOp(XpMultiImageOp multiImageOp) {
        if (this.getCine()) {
            return;
        }
        if (this.mio == multiImageOp) {
            return;
        }
        this.mio = multiImageOp;
        this.loadMultiImageOp();
        if (this.mio != null) {
            this.mio.addPropertyChangeListener("MULTI_IMAGE_OP_SYNC", this.miopSyncPCL);
        }
    }

    private void loadMultiImageOp() {
        if (this.mio != null) {
            this.setupMultiImageOp();
        } else {
            this.sceneList = this.orgSceneList;
        }
        this.defaultSharedIRA();
        this.sync();
        this.init();
        this.setComponentSelection(0);
    }

    @Override
    public final XpMultiImageOp getMultiImageOp() {
        return this.mio;
    }

    public void refresh() {
        XpMultiImageOp mio;
        XpMedicalImage[] images = this.getImages();
        if (images.length > 0 && (mio = this.getMultiImageOp()) != null) {
            this.setImages(images);
        }
    }

    private XpImageScene createScene(XpImage img) {
        XpImageScene is = null;
        is = this.isSharedRenderAttributes() ? new XpImageScene(img, this.getSharedIRA()) : new XpImageScene(img);
        is.addPropertyChangeListener("COMPONENT_ADDED", this.componentPCL);
        is.addPropertyChangeListener("COMPONENT_REMOVED", this.componentPCL);
        return is;
    }

    private List createScenes(XpImage[] imgs) {
        int len = 0;
        if (imgs != null) {
            len = imgs.length;
        }
        ArrayList<XpImageScene> scenes = new ArrayList<XpImageScene>();
        for (int i = 0; i < len; ++i) {
            XpImageScene is = this.createScene(imgs[i]);
            scenes.add(i, is);
        }
        return scenes;
    }

    private void setupMultiImageOp() {
        this.mio.setFrames(this.getImages());
        XpImage[] miopImages = this.createMultiImageOpImages();
        this.sceneList = this.createScenes(miopImages);
    }

    private XpImage[] createMultiImageOpImages() {
        int numFrames = this.mio.getNumFrames();
        XpImage[] miopImages = new XpImage[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            miopImages[i] = new XpViewport.MultiImageOpImage(this.mio, i);
        }
        return miopImages;
    }

    protected final XpDicomObject getDicomSource(int idx) {
        if (this.mio != null) {
            return this.mio.getDicomSource(idx);
        }
        if (idx >= 0 && idx < this.getNumScenes()) {
            return (XpMedicalImage)this.getScene(idx).getFrame();
        }
        return null;
    }

    @Override
    public void setCine(boolean cine) {
        boolean prevCine = this.getCine();
        this.cineOn = cine;
        if (!prevCine && cine) {
            this.setAutoRepaint(false);
            this.prevInterpolationHint = this.getInterpolationHint();
            this.setInterpolationHint(this.cineQuality);
            this.enableDrawBorder(false);
            this.projector.setCineRate(this.getCineRate());
            this.projector.start();
        }
        if (!cine) {
            this.setInterpolationHint(this.prevInterpolationHint);
            this.projector.stopProjection();
            this.enableDrawBorder(true);
            this.setAutoRepaint(true);
            this.repaint();
        }
        this.firePropertyChange("Cine", prevCine, cine);
    }

    @Override
    public boolean getCine() {
        return this.cineOn;
    }

    @Override
    public void setCineRate(int rate) {
        int oldRate = this.getCineRate();
        if (rate == oldRate) {
            return;
        }
        this.cineRate = rate;
        if (this.projector != null) {
            this.projector.setCineRate(rate);
        }
        this.firePropertyChange("CineRate", oldRate, rate);
    }

    @Override
    public int getCineRate() {
        return this.cineRate;
    }

    @Override
    public void setOffset(int offset) {
        this.setFrameIndex(offset);
    }

    @Override
    public void setEndOffset(int offset) {
        int len = this.getMaxFrame();
        if (offset >= 0 && offset >= this.startOffset && offset < len) {
            this.endOffset = offset;
        }
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setStartOffset(int offset) {
        int len = this.getMaxFrame();
        if (offset >= 0 && offset <= this.endOffset && offset < len) {
            this.startOffset = offset;
        }
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getOffset() {
        return this.getFrameIndex();
    }

    @Override
    public int getMaxFrame() {
        return this.getNumFrames();
    }

    @Override
    public final int getNumberShown() {
        int nc = this.getNumComponents();
        int rc = this.getRows() * this.getCols();
        return Math.min(nc, rc);
    }

    @Override
    public int getCineSkip() {
        return this.cineSkip;
    }

    @Override
    public void setCineSkip(int cineSkip) {
        this.cineSkip = cineSkip;
    }

    @Override
    public final void setCineMode(int cineMode) {
        if (cineMode != this.cineMode) {
            int old = this.cineMode;
            this.cineMode = cineMode;
            this.firePropertyChange("CineMode", old, cineMode);
        }
    }

    @Override
    public final int getCineMode() {
        return this.cineMode;
    }

    private void enableDrawBorder(boolean drawBorder) {
        int n = this.getNumPorts();
        for (int i = 0; i < n; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.setDrawBorder(drawBorder);
            fv.refreshSelection();
        }
    }

    @Override
    public Capable getCapable(String capableIFName) {
        try {
            XpFrameVisualizer fv;
            Class<?> cl = Class.forName(capableIFName);
            if (cl == FusionCapable.class && (fv = this.getPort(0)).getMedicalImageVc().getImageVc().isFusionCapable()) {
                return this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.getCapable(capableIFName);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.kbListeners.add(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).addKeyListener(l);
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.mListeners.add(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).addMouseListener(l);
        }
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.mmListeners.add(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).addMouseMotionListener(l);
        }
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        super.addMouseWheelListener(l);
        this.mwListeners.add(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).addMouseWheelListener(l);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.kbListeners.remove(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).removeKeyListener(l);
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.mListeners.remove(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).removeMouseListener(l);
        }
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.mmListeners.remove(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).removeMouseMotionListener(l);
        }
    }

    @Override
    public synchronized void removeMouseWheelListener(MouseWheelListener l) {
        super.removeMouseWheelListener(l);
        this.mwListeners.remove(l);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer port = this.getPort(i);
            ((Component)port).removeMouseWheelListener(l);
        }
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        int size = this.kbListeners.size();
        KeyListener[] l = new KeyListener[size];
        for (int i = 0; i < size; ++i) {
            l[i] = (KeyListener)this.kbListeners.get(i);
        }
        return l;
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        int size = this.mListeners.size();
        MouseListener[] l = new MouseListener[size];
        for (int i = 0; i < size; ++i) {
            l[i] = (MouseListener)this.mListeners.get(i);
        }
        return l;
    }

    @Override
    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        int size = this.mmListeners.size();
        MouseMotionListener[] l = new MouseMotionListener[size];
        for (int i = 0; i < size; ++i) {
            l[i] = (MouseMotionListener)this.mmListeners.get(i);
        }
        return l;
    }

    @Override
    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        int size = this.mwListeners.size();
        MouseWheelListener[] l = new MouseWheelListener[size];
        for (int i = 0; i < size; ++i) {
            l[i] = (MouseWheelListener)this.mwListeners.get(i);
        }
        return l;
    }

    protected void setImageLayerWindowing(int layer, double ww, double wl) {
        XpImage2DVc ivc;
        List l;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (l = (ivc = fv.getMedicalImageVc().getImageVc()).getImageLayers()) != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.setWindowing(ww, wl);
        }
    }

    protected void setImageLayerVideoInverted(int layer, boolean ivvideo) {
        XpImage2DVc ivc;
        List l;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (l = (ivc = fv.getMedicalImageVc().getImageVc()).getImageLayers()) != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.setVideoInverted(ivvideo);
        }
    }

    protected void setImageLayerColorMap(int layer, int[] cmap) {
        XpImage2DVc ivc;
        List l;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (l = (ivc = fv.getMedicalImageVc().getImageVc()).getImageLayers()) != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.setColorMap(cmap);
        }
    }

    protected void resetImageLayerWindowing(int layer) {
        XpImage2DVc ivc;
        List l;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (l = (ivc = fv.getMedicalImageVc().getImageVc()).getImageLayers()) != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer - 1);
            il.resetWindowing();
        }
    }

    private XpImageLayer getImageLayer(int layer_no) {
        XpImage2DVc ivc;
        List l;
        XpFrameVisualizer fv = this.getSelectedPort();
        if (fv == null) {
            fv = this.getPort(0);
        }
        if (fv != null && (l = (ivc = fv.getMedicalImageVc().getImageVc()).getImageLayers()) != null) {
            XpImageLayer il = (XpImageLayer)l.get(layer_no - 1);
            return il;
        }
        return null;
    }

    public int addImageLayer(XpMedicalImage[] imgs) {
        int len = Math.min(this.getNumScenes(), imgs.length);
        for (int i = 0; i < len; ++i) {
            XpImageScene is = this.getScene(i);
            XpImageLayer il = null;
            if (this.isSharedRenderAttributes()) {
                int nlayers = is.getNumLayers();
                if (this.layerIPA[nlayers] == null) {
                    this.layerIPA[nlayers] = new XpImagePixelAttributes();
                }
                il = new XpImageLayer(imgs[i], this.layerIPA[nlayers]);
            } else {
                il = new XpImageLayer(imgs[i]);
            }
            is.addImageLayer(il);
            if (imgs[i] == null) continue;
            il.setWindowing(imgs[i].getDefaultWindowWidth(), imgs[i].getDefaultWindowLevel());
        }
        XpImageScene is = this.getScene(0);
        int layer = is.getNumLayers() - 1;
        this.syncPorts();
        return layer;
    }

    @Override
    public int addImageLayer(XjImage[] imgs) {
        return this.addImageLayer(XjMedicalImage.createImages(imgs));
    }

    @Override
    public int removeImageLayer(int layer) {
        XpImageScene is;
        int nscenes = this.getNumScenes();
        int ret = -1;
        for (int i = 0; i < nscenes && (ret = (is = this.getScene(i)).removeImageLayer(layer)) != -1; ++i) {
        }
        if (ret != -1) {
            this.refreshContents();
            this.repaint();
        }
        return ret;
    }

    @Override
    public void selectImageLayer(int layer) {
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer sp = this.getPort(i);
            sp.getMedicalImageVc().getImageVc().selectImageLayer(layer);
        }
    }

    @Override
    public int getImageLayer() {
        XpFrameVisualizer sp = this.getPort(0);
        if (sp != null) {
            return sp.getMedicalImageVc().getImageVc().getImageLayer();
        }
        return 0;
    }

    @Override
    public int getNumImageLayers() {
        XpFrameVisualizer sp = this.getPort(0);
        if (sp != null) {
            return sp.getMedicalImageVc().getImageVc().getNumImageLayers();
        }
        return 0;
    }

    @Override
    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        int len = this.getNumPorts();
        this.fpc = fpc;
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer sp = this.getPort(i);
            sp.getMedicalImageVc().getImageVc().setPixelCombiner(fpc);
        }
    }

    @Override
    public XjFusionPixelCombiner getPixelCombiner() {
        return this.fpc;
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        int len = this.getNumPorts();
        for (int i = 0; i < len; ++i) {
            XpFrameVisualizer sp = this.getPort(i);
            sp.setBackground(background);
        }
    }

    public Class getAnnotationClass() {
        return this.agClass;
    }

    public void setProjector(XpCineMotor projector) {
        this.projector = projector;
    }

    protected static class KeyboardWheelManager
    extends KeyAdapter
    implements MouseWheelListener {
        private XpCompositePort vp = null;
        private static final int UNITS = Integer.parseInt(XpPropertiesManager.getProperty("jami.mousewheel.scrollunits", "1"));

        public KeyboardWheelManager(XpCompositePort vp) {
            this.vp = vp;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            if (this.vp.isMouseWheelPaging()) {
                int units = mwe.getUnitsToScroll();
                if (units > 0) {
                    this.vp.forward(UNITS);
                }
                if (units < 0) {
                    this.vp.back(UNITS);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            int key = ke.getKeyCode();
            if (this.vp.isKeyboardPaging()) {
                int nshown = this.vp.getRows() * this.vp.getCols();
                if (key == 34) {
                    this.vp.pageDown();
                } else if (key == 33) {
                    this.vp.pageUp();
                } else if (key == 36) {
                    this.vp.setOffset(0);
                    this.vp.repaint();
                } else if (key == 35) {
                    int nFrames = this.vp.getMaxFrame();
                    int idx = nFrames - 1;
                    this.vp.setOffset(idx < 0 ? 0 : idx);
                    this.vp.repaint();
                } else if (key == 39) {
                    this.vp.forward(1);
                } else if (key == 37) {
                    this.vp.back(1);
                }
            }
        }
    }

    protected static class PortMouseListener
    extends MouseAdapter {
        protected PortMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            JComponent jc = (JComponent)me.getSource();
            jc.requestFocus();
        }
    }

    private class PortComparator
    implements Comparator {
        private PortComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer idx1 = (Integer)o1;
            Integer idx2 = (Integer)o2;
            XpImageScene s1 = (XpImageScene)XpCompositePort.this.sceneList.get(idx1);
            XpImageScene s2 = (XpImageScene)XpCompositePort.this.sceneList.get(idx2);
            XpImage i1 = s1.getFrame();
            XpImage i2 = s2.getFrame();
            return XpCompositePort.this.sortComparator.compare(i1, i2);
        }
    }

    private static class AnnotationState {
        private String agm = null;
        private Map aim = new HashMap();
        private String[] str = new String[1];

        private AnnotationState() {
        }

        public final void setAnnotationGroup(String agName, boolean activate) {
            if (activate) {
                this.agm = agName;
            }
        }

        public final void setAnnotationItems(String[] annoItems, boolean activate) {
            for (int i = 0; i < annoItems.length; ++i) {
                Boolean b = activate ? Boolean.TRUE : Boolean.FALSE;
                this.aim.put(annoItems[i], b);
            }
        }

        public final void clear() {
            this.agm = null;
            this.aim.clear();
        }

        public final void applyViewport(XpFrameVisualizer fv) {
            if (fv == null) {
                return;
            }
            if (this.agm != null) {
                fv.setAnnotationGroup(this.agm, true);
            }
            for (Map.Entry me : this.aim.entrySet()) {
                this.str[0] = (String)me.getKey();
                Boolean value = (Boolean)me.getValue();
                fv.setAnnotationItems(this.str, value);
            }
        }
    }
}

