/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpSelectableOwner;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.filter.XpImageLut;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.jami.render.XpPipeline;
import com.ge.med.terra.jami.roi.XpImageMatte;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

public class ScreenSave {
    private static final short BG_VAL = 0;
    private int width = 0;
    private int height = 0;
    private XpComponentSave cs = new XpComponentSave();
    private XpDicomElement dobj = new XpDicomElement(40, 259);

    public ScreenSave(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private Vector<Component> hideChildren(JComponent jc) {
        Vector<Component> v = new Vector<Component>();
        for (int i = 0; i < jc.getComponentCount(); ++i) {
            Component c = jc.getComponent(i);
            if (!c.isVisible()) continue;
            c.setVisible(false);
            v.add(c);
        }
        return v;
    }

    public BufferedImage generate(XpSingularPort vp) {
        XpSingularPort clonevp = (XpSingularPort)vp.clone();
        XpImage img = vp.getFrame();
        RenderedImage rimg = img.getPixelData();
        BufferedImage imgout = null;
        int[] cc = rimg.getColorModel().getComponentSize();
        XpImageRenderAttributes ira = vp.getImageRenderAttributes();
        int nChannels = cc.length;
        boolean isLuminance = true;
        IndexColorModel icm = ira.getColormap();
        if (nChannels == 1 && ira.getColorOverlay() == null && (icm == null || icm instanceof XpImageLut.ColorModel)) {
            boolean annotState = clonevp.isAnnotationVisible();
            clonevp.setAnnotationVisible(false);
            BufferedImage renderImg = this.cs.renderOffscreen(clonevp, this.width, this.height, 0);
            clonevp.setAnnotationVisible(annotState);
            int[] renderImgPixels = ((DataBufferInt)renderImg.getRaster().getDataBuffer()).getData();
            AffineTransform at = clonevp.getMedicalImageVc().getImageVc().getAffineTransform();
            XpImage ximg = clonevp.getFrame();
            double rescaleSlope = ximg.getRescaleSlope();
            double rescaleIntercept = ximg.getRescaleIntercept();
            double winMin = (clonevp.getWinMin() - rescaleIntercept) / rescaleSlope;
            double winMax = (clonevp.getWinMax() - rescaleIntercept) / rescaleSlope;
            boolean iVideo = clonevp.isVideoInverted();
            int minval = -32767;
            int maxval = Short.MAX_VALUE;
            double minmax_ww = 65534.0;
            imgout = this.renderLuminance(img, ira, at, this.width, this.height);
            short[] imglayer = ((DataBufferUShort)imgout.getRaster().getDataBuffer()).getData();
            this.matteImgLayer(clonevp.getMedicalImageVc(), imglayer, this.width, this.height);
            clonevp.setAnnotationItems(new String[]{"Windowing"}, false);
            Vector<Component> children = this.hideChildren(clonevp.getMedicalImageVc().getImageVc());
            for (int i = 0; i < children.size(); ++i) {
                children.get(i).setVisible(true);
            }
            BufferedImage annotation = new BufferedImage(this.width, this.height, 2);
            int[] annotlayer = ((DataBufferInt)annotation.getRaster().getDataBuffer()).getData();
            Arrays.fill(annotlayer, 0);
            Graphics g = annotation.getGraphics();
            clonevp.getMedicalImageVc().getAnnotationVc().paint(g);
            for (int i = 0; i < imglayer.length; ++i) {
                int annot_color = annotlayer[i];
                if (annot_color == 0) continue;
                int v = annot_color & 0xFF;
                imglayer[i] = v > 0 ? Short.MAX_VALUE : -32767;
            }
            BufferedImage colImg = new BufferedImage(this.width, this.height, 2);
            int[] cdata = ((DataBufferInt)colImg.getRaster().getDataBuffer()).getData();
            int[] graphic_buff = new int[this.width * this.height];
            Graphics2D sgc = (Graphics2D)colImg.getGraphics();
            int NOVAL = -999999;
            double wl = (winMax + winMin) * 0.5;
            double ww = winMax - winMin;
            for (int idx = 0; idx < children.size(); ++idx) {
                int ii;
                Selectable[] selectables;
                JComponent jc = (JComponent)children.get(idx);
                boolean grayscaleMode = false;
                if (!jc.isVisible()) continue;
                Arrays.fill(cdata, 0);
                Arrays.fill(graphic_buff, -999999);
                if (jc instanceof Selectable) {
                    ((Selectable)((Object)jc)).setSelected(false);
                } else if (jc instanceof XpSelectableOwner) {
                    selectables = ((XpSelectableOwner)((Object)jc)).getSelectable();
                    for (ii = 0; selectables != null && ii < selectables.length; ++ii) {
                        selectables[ii].setSelected(false);
                    }
                }
                if (jc instanceof GrayScaleCapable) {
                    ((GrayScaleCapable)((Object)jc)).setGrayScaleMode(true);
                    grayscaleMode = true;
                } else if (jc instanceof XpSelectableOwner) {
                    selectables = ((XpSelectableOwner)((Object)jc)).getSelectable();
                    for (ii = 0; selectables != null && ii < selectables.length; ++ii) {
                        if (!(selectables[ii] instanceof GrayScaleCapable)) continue;
                        ((GrayScaleCapable)((Object)selectables[ii])).setGrayScaleMode(true);
                        grayscaleMode = true;
                    }
                }
                jc.paint(sgc);
                double[] pixstats = ScreenSave.getPixelStats(cdata, renderImgPixels, imglayer, this.width, this.height);
                if (pixstats == null) continue;
                XpLog.fine("PIXSTATS: minmax=[" + pixstats[0] + " " + pixstats[1] + "] mean=" + pixstats[2] + " stddev=" + pixstats[3]);
                XpLog.fine("RGBSTATS: minmax=[" + pixstats[4] + " " + pixstats[5] + "] mean=" + pixstats[6] + " stddev=" + pixstats[7]);
                int miny = 999999;
                int maxy = -999999;
                for (int i = 0; i < cdata.length; ++i) {
                    int yval;
                    int cval = cdata[i];
                    if (cval == 0) continue;
                    graphic_buff[i] = yval = ScreenSave.getY(cval, -32767.0, 32767.0);
                    if (yval > maxy) {
                        maxy = yval;
                    }
                    if (yval >= miny) continue;
                    miny = yval;
                }
                double mean_render = pixstats[6];
                double stddev_render = pixstats[7];
                double roi_wl = Math.min(32767.0, wl + 0.5 * ww);
                if (mean_render > 200.0 && stddev_render < 40.0) {
                    XpLog.fine("white background...");
                    roi_wl = iVideo ? Math.min(32767.0, wl + ww) : Math.max(-32767.0, wl - 0.75 * ww);
                } else if (mean_render < 20.0) {
                    roi_wl = iVideo ? Math.max(-32767.0, wl - ww) : Math.min(32767.0, wl + 0.75 * ww);
                    XpLog.fine("black background: " + roi_wl);
                }
                for (int i = 0; i < graphic_buff.length; ++i) {
                    int yval = graphic_buff[i];
                    if (yval == -999999) continue;
                    float alpha = (float)((cdata[i] & 0xFF000000) >> 24 & 0xFF) / 255.0f;
                    if (grayscaleMode) {
                        int ival = (double)imglayer[i] <= winMin ? 0 : ((double)imglayer[i] >= winMax ? 255 : (int)(((double)imglayer[i] - winMin) / ww * 255.0));
                        int cval = (int)((float)(cdata[i] & 0xFF) * alpha + (float)ival * (1.0f - alpha));
                        cval = (int)((iVideo ? 1.0 - (double)cval / 255.0 : (double)cval / 255.0) * ww + winMin);
                        imglayer[i] = (short)Math.min(Math.max(cval, -32767), Short.MAX_VALUE);
                        continue;
                    }
                    int pval = ScreenSave.scale((double)(yval - -32767) / 65534.0, ww, roi_wl, iVideo);
                    imglayer[i] = (short)((float)Math.min(Short.MAX_VALUE, Math.max(-32767, pval)) * alpha + (float)imglayer[i] * (1.0f - alpha));
                }
                XpLog.fine("------------------------------------------------------------");
            }
        } else {
            imgout = this.cs.renderOffscreen(clonevp, this.width, this.height, 0);
            isLuminance = false;
        }
        Container container = vp.getContentPane();
        this.generateSubViewports(container, isLuminance, ira, imgout);
        this.generateSubViewports(vp.getMedicalImageVc(), isLuminance, ira, imgout);
        return imgout;
    }

    private static int scale(double value, double ww, double wl, boolean iVideo) {
        double min = wl - 0.5 * ww;
        double theval = value;
        if (iVideo) {
            theval = 1.0 - value;
        }
        return (int)(min + theval * ww);
    }

    /*
     * WARNING - void declaration
     */
    private static double[] getPixelStats(int[] pixdata, int[] imgpixels, short[] background, int width, int height) {
        void var10_11;
        int x0 = width;
        int y0 = height;
        int x1 = 0;
        int y1 = 0;
        boolean isBB = false;
        boolean bl = false;
        while (var10_11 < height) {
            void var11_14 = var10_11 * width;
            for (int x = 0; x < width; ++x) {
                int cval = pixdata[var11_14 + x];
                if (cval == 0) continue;
                if (x < x0) {
                    x0 = x;
                }
                if (var10_11 < y0) {
                    y0 = var10_11;
                }
                if (x > x1) {
                    x1 = x;
                }
                if (var10_11 > y1) {
                    y1 = var10_11;
                }
                isBB = true;
            }
            ++var10_11;
        }
        if (isBB) {
            short s;
            short s2;
            int n = 9999999;
            int n2 = -9999999;
            int minrgb = 9999999;
            int maxrgb = -9999999;
            double rgbsum = 0.0;
            double sum = 0.0;
            int npixels = 0;
            int nrgbpixels = 0;
            for (int y = y0; y <= y1; ++y) {
                int yoffset = y * width;
                for (int x = x0; x <= x1; ++x) {
                    short lumval = background[yoffset + x];
                    if (lumval < s2) {
                        s2 = lumval;
                    }
                    if (lumval > s) {
                        s = lumval;
                    }
                    sum += (double)lumval;
                    ++npixels;
                    int gval = ScreenSave.getGray(imgpixels[yoffset + x]);
                    if (gval < 0) continue;
                    if (gval < minrgb) {
                        minrgb = gval;
                    }
                    if (gval > maxrgb) {
                        maxrgb = gval;
                    }
                    rgbsum += (double)gval;
                    ++nrgbpixels;
                }
            }
            double rgbmean = nrgbpixels > 0 ? rgbsum / (double)nrgbpixels : 0.0;
            double mean = npixels > 0 ? sum / (double)npixels : 0.0;
            sum = 0.0;
            rgbsum = 0.0;
            for (int y = y0; y <= y1; ++y) {
                int yoffset = y * width;
                for (int x = x0; x <= x1; ++x) {
                    short lumval = background[yoffset + x];
                    double diff = mean - (double)lumval;
                    sum += diff * diff;
                    int gval = ScreenSave.getGray(imgpixels[yoffset + x]);
                    if (gval < 0) continue;
                    double diffrgb = rgbmean - (double)gval;
                    rgbsum += diffrgb * diffrgb;
                }
            }
            double stddev = npixels - 1 > 0 ? Math.sqrt(sum / (double)(npixels - 1)) : 0.0;
            double rgbstddev = nrgbpixels - 1 > 0 ? Math.sqrt(rgbsum / (double)(nrgbpixels - 1)) : 0.0;
            return new double[]{s2, s, mean, stddev, minrgb, maxrgb, rgbmean, rgbstddev};
        }
        return null;
    }

    private static int getGray(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        if (r == g && g == b) {
            return r;
        }
        return -1;
    }

    private static int getY(int rgb, double min, double max) {
        double r = (double)(rgb >> 16 & 0xFF) / 255.0;
        double g = (double)(rgb >> 8 & 0xFF) / 255.0;
        double b = (double)(rgb & 0xFF) / 255.0;
        double Y = 0.299 * r + 0.587 * g + 0.114 * b;
        int iY = (int)(min + (max - min) * Y);
        return (int)Math.max(min, Math.min((double)iY, max));
    }

    private static void rgb2yuv_int(int rgb, int[] yuv) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int Y = Math.min(Math.abs(r * 2104 + g * 4130 + b * 802 + 4096 + 131072) >> 13, 235);
        int U = Math.min(Math.abs(r * -1214 + g * -2384 + b * 3598 + 4096 + 0x100000) >> 13, 240);
        int V = Math.min(Math.abs(r * 3598 + g * -3013 + b * -585 + 4096 + 0x100000) >> 13, 240);
        yuv[0] = Y;
        yuv[1] = U;
        yuv[2] = V;
    }

    private static void rgb2yuv_int(int r, int g, int b, int[] yuv) {
        int Y = Math.min(Math.abs(r * 2104 + g * 4130 + b * 802 + 4096 + 131072) >> 13, 235);
        int U = Math.min(Math.abs(r * -1214 + g * -2384 + b * 3598 + 4096 + 0x100000) >> 13, 240);
        int V = Math.min(Math.abs(r * 3598 + g * -3013 + b * -585 + 4096 + 0x100000) >> 13, 240);
        yuv[0] = Y;
        yuv[1] = U;
        yuv[2] = V;
    }

    private void generateSubViewports(Container container, boolean isLuminance, XpImageRenderAttributes ira, BufferedImage imgout) {
        Component[] children = container.getComponents();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof XpSingularPort) {
                    XpSingularPort subport = (XpSingularPort)children[i];
                    Rectangle r = subport.getBounds();
                    int outw = imgout.getWidth();
                    int outh = imgout.getHeight();
                    int origX = (int)((double)outw * 0.5 - (double)r.width * 0.5);
                    int origY = outh - r.height - 20;
                    if (isLuminance) {
                        double min = ira.getWindowMin();
                        double max = ira.getWindowMax();
                        BufferedImage subimg = new BufferedImage(r.width, r.height, 11);
                        Graphics2D g2 = (Graphics2D)subimg.getGraphics();
                        subport.paint(g2);
                        short[] data = ((DataBufferUShort)imgout.getRaster().getDataBuffer()).getData();
                        short[] subdata = ((DataBufferUShort)subimg.getRaster().getDataBuffer()).getData();
                        double minv = 0.0;
                        double maxv = 65535.0;
                        for (int y = 0; y < r.height; ++y) {
                            int yyoffset = (origY + y) * imgout.getWidth();
                            for (int x = 0; x < r.width; ++x) {
                                int xx = origX + x;
                                int subval = subdata[y * r.width + x] & 0xFFFF;
                                double ww = max - min;
                                double subww = maxv - minv;
                                subval = (short)(((double)subval - minv) / subww * ww + min);
                                data[yyoffset + xx] = (short)subval;
                            }
                        }
                        continue;
                    }
                    XpSingularPort clonesubvp = (XpSingularPort)subport.clone();
                    BufferedImage subimg = this.cs.renderOffscreen(clonesubvp, r.width, r.height, 0);
                    Graphics2D g2 = (Graphics2D)imgout.getGraphics();
                    g2.drawImage((Image)subimg, origX, origY, null);
                    continue;
                }
                if (!(children[i] instanceof Container)) continue;
                this.generateSubViewports((Container)children[i], isLuminance, ira, imgout);
            }
        }
    }

    private void matteImgLayer(Container c, short[] imglayer, int width, int height) {
        int BGVAL = 65535;
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof XpImageRoiVc) {
                int pixval;
                int k;
                XpImageRoiVc roivc = (XpImageRoiVc)children[i];
                RoiActor ra = roivc.getRoiActor();
                if (!(ra instanceof XpImageMatte)) continue;
                BufferedImage img = new BufferedImage(width, height, 11);
                short[] mattelayer = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                Arrays.fill(mattelayer, (short)-1);
                Graphics g = img.getGraphics();
                roivc.paint(g);
                for (k = 0; k < mattelayer.length; ++k) {
                    pixval = mattelayer[k] & 0xFFFF;
                    if (pixval <= 4096) continue;
                    mattelayer[k] = -1;
                }
                for (k = 0; k < imglayer.length; ++k) {
                    pixval = mattelayer[k] & 0xFFFF;
                    if (pixval >= 65535) continue;
                    double w = (double)pixval / 65535.0;
                    imglayer[k] = (short)(w * 2048.0);
                }
                continue;
            }
            if (!(children[i] instanceof Container)) continue;
            this.matteImgLayer((Container)children[i], imglayer, width, height);
        }
    }

    public BufferedImage renderLuminance(XpSingularPort vp, int vpWidth, int vpHeight) {
        int i;
        XpImage2DVc ivc = vp.getMedicalImageVc().getImageVc();
        int nchild = ivc.getComponentCount();
        boolean[] state = new boolean[nchild];
        for (int i2 = 0; i2 < nchild; ++i2) {
            Component c = ivc.getComponent(i2);
            state[i2] = c.isVisible();
            c.setVisible(false);
        }
        double slope = vp.getFrame().getRescaleSlope();
        double intercept = vp.getFrame().getRescaleIntercept();
        slope = slope == 0.0 ? 1.0 : slope;
        double wmax = (vp.getWinMax() - intercept) / slope;
        double wmin = (vp.getWinMin() - intercept) / slope;
        BufferedImage bimg = this.cs.renderOffscreen(vp.getMedicalImageVc().getImageVc(), vpWidth, vpHeight, 1);
        int MAX = 65536;
        boolean MIN = false;
        short[] sdata = ((DataBufferUShort)bimg.getRaster().getDataBuffer()).getData();
        double max = 0.0;
        for (i = 0; i < sdata.length; ++i) {
            int v = sdata[i] & 0xFFFF;
            if ((double)v > max) {
                max = v;
            }
            double nv = (double)(v - 0) / 65536.0;
            double sv = wmin + (wmax - wmin) * nv;
            sdata[i] = (short)sv;
        }
        XpLog.fine("********* max = " + max);
        for (i = 0; i < nchild; ++i) {
            Component c = ivc.getComponent(i);
            c.setVisible(state[i]);
        }
        return bimg;
    }

    public BufferedImage renderLuminance(XpImage srcimg, XpImageRenderAttributes ira, AffineTransform at, int vpWidth, int vpHeight) {
        int retval;
        RenderedImage srcImage = srcimg.getPixelData();
        double rescaleSlope = srcimg.getRescaleSlope();
        double rescaleIntercept = srcimg.getRescaleIntercept();
        BufferedImage destImage = null;
        short[] shortoutput = null;
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        AffineTransform inverse = new AffineTransform();
        double[] itx = new double[6];
        double[] tx = new double[6];
        IndexColorModel icm = ira.getColormap();
        double pscale = 0.0;
        short[] plut = null;
        if (icm instanceof XpImageLut.ColorModel) {
            XpImageLut.ColorModel cm = (XpImageLut.ColorModel)icm;
            XpImageLut imglut = cm.getImageLut();
            pscale = imglut.getScale();
            plut = imglut.getPLUT();
        }
        int[] cc = srcImage.getColorModel().getComponentSize();
        int pixelRepresentation = 1;
        int img_bpp = cc[0];
        if (srcimg instanceof XpDicomObject && (retval = ((XpDicomObject)((Object)srcimg)).getValue(this.dobj)) == 0) {
            pixelRepresentation = Integer.parseInt("" + this.dobj.value);
        }
        XpGeomUtils gu = new XpGeomUtils();
        XpPipeline.RowBuffer rbuffer = new XpPipeline.RowBuffer(vpWidth, vpHeight);
        gu.calcInverse(at, inverse);
        inverse.getMatrix(itx);
        at.getMatrix(tx);
        srcImage = this.doImageOperations(srcImage, ira.getImageOperations());
        DataBuffer db = XpImageData.getDataBuffer(srcImage);
        int dataOffset = db.getOffset();
        int dataLength = db.getSize();
        if (img_bpp > 8) {
            boolean zeroFlag;
            short[] in = null;
            in = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
            destImage = new BufferedImage(vpWidth, vpHeight, 11);
            shortoutput = ((DataBufferUShort)destImage.getRaster().getDataBuffer()).getData();
            double dx = itx[0] * 1.0 + itx[2] * 0.0;
            double dy = itx[1] * 1.0 + itx[3] * 0.0;
            double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
            double deg = Math.toDegrees(angle) * 10000.0;
            int ideg = (int)deg;
            boolean uprightFlag = false;
            boolean bl = zeroFlag = ideg % 3600000 == 0;
            if (zeroFlag) {
                dx = itx[0] * 1.0 + itx[2] * 1.0;
                dy = itx[1] * 1.0 + itx[3] * 1.0;
                if (dx > 0.0 && dy > 0.0) {
                    uprightFlag = true;
                }
            }
            if (uprightFlag) {
                XpJPipeline.doBilinearShortToShortUpright(tx, itx, in, dataOffset, w, h, pixelRepresentation, img_bpp, shortoutput, vpWidth, vpHeight, (short)0);
            } else {
                XpJPipeline.doBilinearShortToShortBox(tx, itx, in, dataOffset, w, h, pixelRepresentation, img_bpp, shortoutput, vpWidth, vpHeight, rbuffer, (short)0);
            }
        } else if (img_bpp <= 8) {
            // empty if block
        }
        if (shortoutput != null) {
            double ww = ira.getWindowWidth() / rescaleSlope;
            double wl = (ira.getWindowLevel() - rescaleIntercept) / rescaleSlope;
            double min = wl - ww * 0.5;
            double max = wl + ww * 0.5;
            if (ira.isVideoInverted()) {
                for (int i = 0; i < shortoutput.length; ++i) {
                    shortoutput[i] = (short)(max - ((double)shortoutput[i] - min));
                }
            }
        }
        return destImage;
    }

    private RenderedImage doImageOperations(RenderedImage inputImage, List opList) {
        BufferedImage opImg1 = null;
        BufferedImage opImg2 = null;
        int opListLen = opList.size();
        if (opListLen > 0) {
            opImg1 = XpImageData.createCompatibleBufferedImage(inputImage);
            if (opListLen > 1) {
                opImg2 = XpImageData.createCompatibleBufferedImage(inputImage);
            }
            RenderedImage input = inputImage;
            RenderedImage output = opImg1;
            RenderedImage result = input;
            for (int i = 0; i < opListLen; ++i) {
                XpImageOp iop = (XpImageOp)opList.get(i);
                if (iop == null) continue;
                iop.execute(input, output);
                result = output;
                if (i == 0) {
                    input = opImg1;
                    output = opImg2;
                    continue;
                }
                RenderedImage tmp = input;
                input = output;
                output = tmp;
            }
            return result;
        }
        return inputImage;
    }
}

