/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjDynamicVolume;
import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjMultiChannelVolume;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.DownSampledVolume;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class JVolume
implements PropertyChangeListener {
    public static final String VOLUME_LOAD = "VolumeLoad";
    public static final String IMAGE_LOADED = "IMAGE_LOADED";
    private boolean verbose = true;
    public JnVector3d origin = new JnVector3d();
    public JnVector3d dir_x = new JnVector3d();
    public JnVector3d dir_y = new JnVector3d();
    public JnVector3d dir_z = new JnVector3d();
    public int dx;
    public int dy;
    public int dz;
    public double ras_dx;
    public double ras_dy;
    public double ras_dz;
    public double ras_spx;
    public double ras_spy;
    public double ras_spz;
    public JnVector3d center = new JnVector3d();
    public JnVector3d[] bbox = new JnVector3d[2];
    public JnVector3d min = new JnVector3d();
    public JnVector3d max = new JnVector3d();
    public double rescaleIntercept = 1024.0;
    public double ratio = 1.0;
    public double tilt = 0.0;
    public double initWW = 0.0;
    public double initWL = 0.0;
    public double rescaleSlope = 1.0;
    public boolean normalize = false;
    protected boolean defined_wwwl = false;
    public XjVolumeInfo vol = null;
    public String modality = "CT";
    public double[] slopes = null;
    public double[] zpos = null;
    public XpSlice[] slices = null;
    public int pixelRepresentation = 1;
    private List taskMonitors = new ArrayList();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public JVolume(XjVolumeInfo vol) {
        this.vol = vol;
        this.rescaleIntercept = XpImageUtils.parseImageRescaleIntercept(vol.getValue(40, 4178));
        this.rescaleSlope = XpImageUtils.parseImageRescaleSlope(vol.getValue(40, 4179));
        this.pixelRepresentation = XpImageUtils.getPixelRepresentation(vol);
        this.modality = XpImageUtils.getModality(vol);
        if (this.modality.toUpperCase().equals("MR") && this.rescaleIntercept != 0.0) {
            System.err.println("JVolume: Is this right?? MR images rescale intercept=" + this.rescaleIntercept);
            this.rescaleIntercept = 0.0;
        }
        this.bbox[0] = new JnVector3d();
        this.bbox[1] = new JnVector3d();
        this.loadImages(vol);
        if (vol instanceof XjDynamicVolume) {
            ((XjDynamicVolume)vol).addPropertyChangeListener("IMAGE_ADDED", this);
        }
    }

    protected JVolume() {
    }

    protected void copy(JVolume copy) {
        copy.verbose = this.verbose;
        copy.origin.set(this.origin);
        copy.dir_x.set(this.dir_x);
        copy.dir_y.set(this.dir_y);
        copy.dir_z.set(this.dir_z);
        copy.dx = this.dx;
        copy.dy = this.dy;
        copy.dz = this.dz;
        copy.ras_dx = this.ras_dx;
        copy.ras_dy = this.ras_dy;
        copy.ras_dz = this.ras_dz;
        copy.ras_spx = this.ras_spx;
        copy.ras_spy = this.ras_spy;
        copy.ras_spz = this.ras_spz;
        copy.center.set(this.center);
        copy.min.set(this.min);
        copy.max.set(this.max);
        copy.ratio = this.ratio;
        copy.initWL = this.initWL;
        copy.initWW = this.initWW;
        copy.tilt = this.tilt;
        copy.rescaleIntercept = this.rescaleIntercept;
        copy.rescaleSlope = this.rescaleSlope;
        copy.normalize = this.normalize;
        copy.modality = this.modality;
        copy.vol = this.vol;
        for (int i = 0; i < this.bbox.length; ++i) {
            copy.bbox[i] = new JnVector3d();
            copy.bbox[i].set(this.bbox[i]);
        }
        copy.slopes = new double[this.slopes.length];
        System.arraycopy(this.slopes, 0, copy.slopes, 0, this.slopes.length);
        copy.zpos = new double[this.zpos.length];
        System.arraycopy(this.zpos, 0, copy.zpos, 0, this.zpos.length);
        copy.slices = new XpSlice[this.slices.length];
        System.arraycopy(this.slices, 0, copy.slices, 0, this.slices.length);
    }

    public Object clone() {
        JVolume jv = this.dupVolume();
        this.copy(jv);
        return jv;
    }

    protected abstract JVolume dupVolume();

    public final String getModality() {
        return this.modality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVolumeDescriptor(XjVolume vol, String fileName) {
        FileOutputStream f = null;
        PrintStream ps = null;
        try {
            int[] dims = vol.getVolumeDimensions(null);
            double[] dirx = vol.getXDirectionRAS(null);
            double[] diry = vol.getYDirectionRAS(null);
            double[] dirz = vol.getZDirectionRAS(null);
            double spx = JnVector3d.length(dirx);
            double spy = JnVector3d.length(diry);
            double spz = JnVector3d.length(dirz);
            f = new FileOutputStream(fileName);
            ps = new PrintStream(f);
            ps.println("" + dims[0] + " " + dims[1] + " " + dims[2] + " " + spx + " " + spy + " " + spz);
            for (int i = 0; i < dims[2]; ++i) {
                String path = vol.getVSlicePath(i);
                long offset = vol.getVSliceOffset(i);
                ps.println("" + offset + " " + path);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (f != null) {
                    f.close();
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    protected double getSliceRescaleSlope(int idx) {
        Object o = this.vol.getVSliceValue(idx, 40, 4179);
        return XpImageUtils.parseImageRescaleSlope(o);
    }

    protected double getSliceRescaleIntercept(int idx) {
        Object o = this.vol.getVSliceValue(idx, 40, 4178);
        return XpImageUtils.parseImageRescaleIntercept(o);
    }

    private void loadImages(XjVolumeInfo vol) {
        int i;
        double tmp;
        int[] dims = vol.getVolumeDimensions(null);
        this.dx = dims[0];
        this.dy = dims[1];
        this.dz = dims[2];
        this.defined_wwwl = false;
        Object vobj = vol.getVSliceValue(this.dz >> 1, 40, 4176);
        this.initWL = XpImageUtils.parseImageWL(vobj);
        if (this.initWL <= -32767.0) {
            this.initWL = 600.0;
        }
        vobj = vol.getVSliceValue(this.dz >> 1, 40, 4177);
        this.initWW = XpImageUtils.parseImageWW(vobj);
        if (this.initWW < 0.0) {
            this.initWW = 1200.0;
        }
        this.defined_wwwl = true;
        this.min = new JnVector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.max = new JnVector3d(-999999.0, -999999.0, -999999.0);
        this.origin.set(vol.getRASOfOrigin(null));
        this.dir_x.set(vol.getXDirectionRAS(null));
        this.dir_y.set(vol.getYDirectionRAS(null));
        this.dir_z.set(vol.getZDirectionRAS(null));
        this.bbox[0].set(this.origin);
        this.bbox[1].set(this.origin);
        this.bbox[1].scaleAdd((double)(this.dx - 1), this.dir_x);
        this.bbox[1].scaleAdd((double)(this.dy - 1), this.dir_y);
        this.bbox[1].scaleAdd((double)(this.dz - 1), this.dir_z);
        this.min.set(this.bbox[0]);
        this.max.set(this.bbox[1]);
        if (this.min.x > this.max.x) {
            tmp = this.max.x;
            this.max.x = this.min.x;
            this.min.x = tmp;
        }
        if (this.min.y > this.max.y) {
            tmp = this.max.y;
            this.max.y = this.min.y;
            this.min.y = tmp;
        }
        if (this.min.z > this.max.z) {
            tmp = this.max.z;
            this.max.z = this.min.z;
            this.min.z = tmp;
        }
        double[] vol_center = new double[3];
        XjVolumeUtils.getVolumeCenterRAS(this.origin.generateArray(), this.dir_x.generateArray(), this.dir_y.generateArray(), this.dir_z.generateArray(), dims, vol_center);
        this.center.set(vol_center);
        this.ras_spx = this.dir_x.length();
        this.ras_spy = this.dir_y.length();
        this.ras_spz = this.dir_z.length();
        this.ras_dx = this.ras_spx * (double)this.dx;
        this.ras_dy = this.ras_spy * (double)this.dy;
        this.ras_dz = this.ras_spz * (double)this.dz;
        double inith = this.ras_dy;
        this.ratio = this.ras_spz / ((this.ras_spx + this.ras_spy) * 0.5);
        this.tilt = XjVolumeUtils.calculateTilt(vol);
        this.slopes = new double[this.dz];
        if (this.modality.equals("PT")) {
            for (i = 0; i < this.dz; ++i) {
                double d;
                this.slopes[i] = d = this.getSliceRescaleSlope(i);
                if (i == 0) {
                    this.rescaleSlope = d;
                    continue;
                }
                if (this.rescaleSlope != d) {
                    this.normalize = true;
                }
                if (!(this.rescaleSlope < d)) continue;
                this.rescaleSlope = d;
            }
            XpLog.logger().config("-- PET RESCALE SLOPE=" + this.rescaleSlope);
        } else {
            Arrays.fill(this.slopes, 1.0);
        }
        this.slices = new XpSlice[this.dz];
        this.zpos = new double[this.dz];
        for (i = 0; i < this.dz; ++i) {
            SliceObject so = new SliceObject(i);
            XpSlice sl = this.slices[i] = new XpSlice(so);
            this.zpos[i] = (sl.ul.z + sl.br.z) * 0.5;
        }
        if (this.verbose) {
            XpLog.logger().config("WORLD BOUNDS : min=" + this.bbox[0] + "  max=" + this.bbox[1]);
            XpLog.logger().config("VIEW HEIGHT  : " + inith);
            XpLog.logger().config("VOLUME DIMS  : " + this.dx + " : " + this.dy + " : " + this.dz);
            XpLog.logger().config("VOLUME PARAMS: [SLOPE=" + this.rescaleSlope + " INTERCEPT=" + this.rescaleIntercept + "]");
            XpLog.logger().config("VOLUME WW/WL : [WW=" + this.initWW + " WL=" + this.initWL + "]");
            XpLog.logger().config("VOXEL SPACING: " + this.ras_spx + " : " + this.ras_spy + " : " + this.ras_spz);
            XpLog.logger().config("VOXEL DIMS   : " + this.ras_dx + " : " + this.ras_dy + " : " + this.ras_dz);
            XpLog.logger().config("VOLUME TILT  : " + this.tilt);
            XpLog.logger().config("Origin       : " + this.origin);
            XpLog.logger().config("xdir         : " + this.dir_x);
            XpLog.logger().config("ydir         : " + this.dir_y);
            XpLog.logger().config("zdir         : " + this.dir_z);
            XpLog.logger().config("------------------------------------------------------------------------------------");
            System.err.println("WORLD BOUNDS : min=" + this.bbox[0] + "  max=" + this.bbox[1]);
            System.err.println("VIEW HEIGHT  : " + inith);
            System.err.println("VOLUME DIMS  : " + this.dx + " : " + this.dy + " : " + this.dz);
            System.err.println("VOLUME PARAMS: [SLOPE=" + this.rescaleSlope + " INTERCEPT=" + this.rescaleIntercept + "]");
            System.err.println("VOLUME WW/WL : [WW=" + this.initWW + " WL=" + this.initWL + "]");
            System.err.println("VOXEL SPACING: " + this.ras_spx + " : " + this.ras_spy + " : " + this.ras_spz);
            System.err.println("VOXEL DIMS   : " + this.ras_dx + " : " + this.ras_dy + " : " + this.ras_dz);
            System.err.println("VOLUME TILT  : " + this.tilt);
            System.err.println("Origin       : " + this.origin);
            System.err.println("xdir         : " + this.dir_x);
            System.err.println("ydir         : " + this.dir_y);
            System.err.println("zdir         : " + this.dir_z);
            System.err.println("------------------------------------------------------------------------------------");
        }
    }

    public final void getBounds(JnVector3d[] bounds) {
        bounds[0].set(this.min);
        bounds[1].set(this.max.x, this.min.y, this.min.z);
        bounds[2].set(this.max.x, this.max.y, this.min.z);
        bounds[3].set(this.min.x, this.max.y, this.min.z);
        bounds[4].set(this.min.x, this.min.y, this.max.z);
        bounds[5].set(this.max.x, this.min.y, this.max.z);
        bounds[6].set(this.max);
        bounds[7].set(this.min.x, this.max.y, this.max.z);
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillVolumeSlice(XjVolume v, short[] data, int sliceLen, int doffset, int idx, int pixelRepresentation, double rescaleSlope, double sliceRescaleSlope, boolean normalize) {
        String fpath = v.getVSlicePath(idx);
        if (fpath != null) {
            FileInputStream fi = null;
            try {
                double slope;
                double cfactor;
                fi = new FileInputStream(new File(fpath));
                long offset = v.getVSliceOffset(idx);
                FileChannel fc = fi.getChannel();
                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, sliceLen * 2);
                ByteOrder byteOrd = v.isVolumeLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                mbb.order(byteOrd);
                mbb.asShortBuffer().get(data, doffset, sliceLen);
                fc.close();
                fi.close();
                if (normalize && (cfactor = (slope = sliceRescaleSlope) / rescaleSlope) < 1.0) {
                    int lim = doffset + sliceLen;
                    if (pixelRepresentation == 1) {
                        for (int i = doffset; i < lim; ++i) {
                            double val = (double)data[i] * cfactor;
                            data[i] = (short)val;
                        }
                    } else {
                        for (int i = doffset; i < lim; ++i) {
                            int voxval = data[i] & 0xFFFF;
                            double val = (double)voxval * cfactor;
                            data[i] = (short)val;
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                XpLog.logger().severe("Error reading volume slice: " + fpath + " [" + sliceLen + "," + doffset + "," + idx + "]");
                ex.printStackTrace();
            }
            finally {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillVolumeSlice(XjMultiChannelVolume v, short[][] data, int[] channels, int sliceLen, int doffset, int idx, double[] rescaleSlope, double[] sliceRescaleSlope, boolean[] normalize) {
        int nchannels = channels.length;
        FileInputStream fi = null;
        AbstractInterruptibleChannel fc = null;
        String prevPath = "";
        String fpath = null;
        try {
            for (int i = 0; i < nchannels; ++i) {
                double slope;
                double cfactor;
                fpath = v.getVSlicePath(channels[i], idx);
                if (fpath == null) continue;
                if (!fpath.equals(prevPath)) {
                    if (fc != null) {
                        fc.close();
                    }
                    if (fi != null) {
                        fi.close();
                    }
                    fi = new FileInputStream(new File(fpath));
                    fc = fi.getChannel();
                }
                prevPath = fpath;
                long offset = v.getVSliceOffset(channels[i], idx);
                if (fc == null) continue;
                MappedByteBuffer mbb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, offset, sliceLen * 2);
                ByteOrder byteOrd = v.isVolumeLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                mbb.order(byteOrd);
                mbb.asShortBuffer().get(data[i], doffset, sliceLen);
                if (!normalize[i] || !((cfactor = (slope = sliceRescaleSlope[i]) / rescaleSlope[i]) < 1.0)) continue;
                int lim = doffset + sliceLen;
                for (int j = doffset; j < lim; ++j) {
                    double val = (double)data[i][j] * cfactor;
                    data[i][j] = (short)val;
                }
            }
        }
        catch (Exception ex) {
            XpLog.logger().severe("Error reading volume slice: " + fpath + " [" + sliceLen + "," + doffset + "," + idx + "]");
            ex.printStackTrace();
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void fillVolumeSlice(XjVolume v, byte[] data, int sliceLen, int doffset, int idx) {
        String fpath = v.getVSlicePath(idx);
        FileInputStream fi = null;
        FileChannel fc = null;
        if (fpath != null) {
            try {
                fi = new FileInputStream(new File(fpath));
                long offset = v.getVSliceOffset(idx);
                fc = fi.getChannel();
                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, sliceLen);
                ByteOrder byteOrd = v.isVolumeLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                mbb.order(byteOrd);
                mbb.get(data, doffset, sliceLen);
            }
            catch (Exception ex) {
                XpLog.logger().severe("Error reading volume slice: " + fpath + " [" + sliceLen + "," + doffset + "," + idx + "]");
                ex.printStackTrace();
            }
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            XpLog.logger().severe("Error reading slice: " + fpath + " [" + sliceLen + "," + doffset + "," + idx + "]");
        }
    }

    private static int LN_2(int val) {
        for (int i = 0; i < 24; ++i) {
            if (val > 1 << i) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downsampleLinear(XjVolume v, short[] data) {
        DownSampledVolume dsv = (DownSampledVolume)((Object)v);
        int[] odims = dsv.getOriginalDimensions(null);
        int dfactor_xy = dsv.getDownSampleXY();
        int dfactor_z = dsv.getDownSampleZ();
        int odx = odims[0];
        int ody = odims[1];
        int odz = odims[2];
        int sliceLen = odx * ody;
        int smallSliceLen = this.dx * this.dy;
        int[] avg = new int[smallSliceLen];
        short[] temp = new short[sliceLen];
        int shift_2xy = JVolume.LN_2(dfactor_xy);
        int shift_2z = JVolume.LN_2(dfactor_z);
        int data_offset = 0;
        Arrays.fill(avg, 0);
        for (int idx = 0; idx < odz; ++idx) {
            String fpath = v.getVSlicePath(idx);
            FileInputStream fi = null;
            if (fpath == null) continue;
            try {
                double slope;
                double cfactor;
                fi = new FileInputStream(new File(fpath));
                long offset = v.getVSliceOffset(idx);
                FileChannel fc = fi.getChannel();
                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, sliceLen * 2);
                ByteOrder byteOrd = v.isVolumeLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                mbb.order(byteOrd);
                mbb.asShortBuffer().get(temp, 0, sliceLen);
                fc.close();
                fi.close();
                if (this.normalize && (cfactor = (slope = this.getSliceRescaleSlope(idx)) / this.rescaleSlope) < 1.0) {
                    for (int i = 0; i < sliceLen; ++i) {
                        double val = (double)temp[i] * cfactor;
                        temp[i] = (short)val;
                    }
                }
                for (int y = 0; y < ody; ++y) {
                    int yoffset = y * odx;
                    int ys_offset = (y >> shift_2xy) * this.dx;
                    for (int x = 0; x < odx; ++x) {
                        short val = temp[yoffset + x];
                        int xs = x >> shift_2xy;
                        int n = ys_offset + xs;
                        avg[n] = avg[n] + val;
                    }
                }
                if (idx % dfactor_z != dfactor_z - 1) continue;
                for (int i = 0; i < smallSliceLen; ++i) {
                    data[data_offset + i] = (short)(avg[i] >> 2 * shift_2xy + shift_2z);
                }
                Arrays.fill(avg, 0);
                data_offset += smallSliceLen;
                continue;
            }
            catch (Exception ex) {
                XpLog.logger().severe("Error reading volume slice: " + fpath + " [" + sliceLen + "," + idx + "]");
                ex.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("IMAGE_ADDED")) {
            Integer i = (Integer)evt.getNewValue();
            int idx = i;
            this.newSlice(idx);
            this.pcs.firePropertyChange(IMAGE_LOADED, -1, idx);
        }
    }

    protected void newSlice(int idx) {
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskProgress(String taskName, int units) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskProgress(taskName, units);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    public static final class MCShort
    extends JVolume {
        public static final int mcBits = 5;
        public static final int mcMask = 31;
        public static final int mcDim = 32;
        public static final int mcSize = 32768;
        public int mcDimx;
        public int mcDimy;
        public int mcDimz;
        public int PAD;
        public short[] volume;
        private short[] buffer = null;

        public MCShort(XjVolumeInfo vol) {
            super(vol);
            if (!(vol instanceof XjVolume)) {
                throw new RuntimeException("Unsupported XjVolumeInfo implementation");
            }
            this.loadPixelData((XjVolume)vol);
        }

        private MCShort() {
        }

        @Override
        protected final JVolume dupVolume() {
            MCShort jv = new MCShort();
            jv.volume = new short[this.volume.length];
            jv.mcDimx = this.mcDimx;
            jv.mcDimy = this.mcDimy;
            jv.mcDimz = this.mcDimz;
            jv.PAD = this.PAD;
            return jv;
        }

        public final int lookup(int x, int y, int z) {
            int volOffset = 32768 * (((z >> 5) * this.mcDimy + (y >> 5)) * this.mcDimx + (x >> 5));
            int mcOffset = (((z & 0x1F) << 5) + (y & 0x1F) << 5) + (x & 0x1F);
            return this.PAD + volOffset + mcOffset;
        }

        public final int lookup1(int x, int y, int z) {
            return this.PAD + (z * this.mcDimx + y) * this.mcDimx + x;
        }

        public void test(int x, int y, int z) {
            System.out.println("zyx=" + z + "," + y + "," + x);
            int mcx = x & 0x1F;
            System.out.println("mcx=" + mcx);
            int mcy = y & 0x1F;
            System.out.println("mcy=" + mcy);
            int mcz = z & 0x1F;
            System.out.println("mcz=" + mcz);
            int vx = x >> 5;
            System.out.println("vx=" + vx);
            int vy = y >> 5;
            System.out.println("vy=" + vy);
            int vz = z >> 5;
            System.out.println("vz=" + vz);
            int volOffset = 32768 * ((vz * this.mcDimy + vy) * this.mcDimx + vx);
            System.out.println("volOffset" + volOffset);
            int mcOffset = ((mcz << 5) + mcy << 5) + mcx;
            System.out.println("mcOffset=" + mcOffset);
        }

        @Override
        protected void newSlice(int idx) {
            int sliceLen = this.dx * this.dy;
            if (this.buffer == null || this.buffer.length != sliceLen) {
                this.buffer = new short[sliceLen];
            }
            if (this.vol instanceof XjVolume) {
                MCShort.fillVolumeSlice((XjVolume)this.vol, this.buffer, this.buffer.length, 0, idx, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(idx), this.normalize);
            }
            int i = 0;
            for (int y = 0; y < this.dy; ++y) {
                for (int x = 0; x < this.dx; ++x) {
                    int mcidx = this.lookup(x, y, idx);
                    this.volume[mcidx] = this.buffer[i];
                    ++i;
                }
            }
        }

        private void loadPixelData(XjVolume vol) {
            this.mcDimx = this.dx / 32 + (0 == this.dx % 32 ? 0 : 1);
            this.mcDimy = this.dy / 32 + (0 == this.dy % 32 ? 0 : 1);
            this.mcDimz = this.dz / 32 + (0 == this.dz % 32 ? 0 : 1);
            this.PAD = 3 * this.dx * this.dy;
            int len = this.mcDimx * this.mcDimy * this.mcDimz * 32768;
            System.out.println("MICROCUBE: " + this.mcDimx + " " + this.mcDimy + " " + this.mcDimz);
            System.out.println("-- " + this.dx + " : " + this.dy + " : " + this.dz);
            this.volume = new short[len + 2 * this.PAD];
            short[] data = new short[this.dx * this.dy];
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            for (int z = 0; z < this.dz; ++z) {
                if (z % 4 == 0) {
                    this.notifyTaskProgress(JVolume.VOLUME_LOAD, z);
                }
                MCShort.fillVolumeSlice(vol, data, data.length, 0, z, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(z), this.normalize);
                int i = 0;
                for (int y = 0; y < this.dy; ++y) {
                    for (int x = 0; x < this.dx; ++x) {
                        int idx = this.lookup(x, y, z);
                        this.volume[idx] = data[i];
                        ++i;
                    }
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }
    }

    public static final class OctalShort
    extends JVolume {
        public static final int NBLOCKS = 8;
        public static final int SHIFT_DX = 1;
        public static final int SHIFT_DY = 1;
        public static final int SHIFT_DZ = 1;
        public static final int OVERLAP = 2;
        public short[] volume = null;
        public int[] blocks = new int[3];
        public int o_dx = 0;
        public int o_dy = 0;
        public int o_dz = 0;
        public int ln_odx = 0;
        public int ln_ody = 0;
        public int XDIM = 0;
        public int YDIM = 0;
        public int ZDIM = 0;
        public int PHYSPAGE = 0;
        public int ZPAD = 0;

        private OctalShort(XjVolumeInfo vol) {
            super(vol);
            this.o_dx = this.dx >> 1;
            this.o_dy = this.dy >> 1;
            this.o_dz = this.dz + 1 >> 1;
            this.XDIM = this.o_dx + 4;
            this.YDIM = this.o_dy + 4;
            this.ZDIM = this.o_dz + 4;
            this.ln_odx = JVolume.LN_2(this.o_dx);
            this.ln_ody = JVolume.LN_2(this.o_dy);
            this.PHYSPAGE = this.XDIM * this.YDIM;
            this.ZPAD = 2 * this.PHYSPAGE;
        }

        public static OctalShort[] createVols(XjVolume vol) {
            OctalShort[] vols = new OctalShort[8];
            for (int i = 0; i < vols.length; ++i) {
                vols[i] = new OctalShort(vol);
            }
            int idx = 0;
            int dx = vols[0].dx;
            int dy = vols[0].dy;
            int dz = vols[0].dz;
            int o_dx = vols[0].o_dx;
            int o_dy = vols[0].o_dy;
            int o_dz = vols[0].o_dz;
            for (int z = 0; z < dz; z += o_dz) {
                for (int y = 0; y < dy; y += o_dy) {
                    for (int x = 0; x < dx; x += o_dx) {
                        vols[idx].blocks[0] = x;
                        vols[idx].blocks[1] = y;
                        vols[idx].blocks[2] = z;
                        ++idx;
                    }
                }
            }
            OctalShort.loadPixelData(vol, vols);
            return vols;
        }

        private OctalShort() {
        }

        @Override
        protected final JVolume dupVolume() {
            OctalShort jv = new OctalShort();
            jv.volume = new short[this.volume.length];
            return jv;
        }

        public short getValue(int x, int y, int z) {
            int bz = z / this.o_dz;
            int by = y >> this.ln_ody;
            int bx = x >> this.ln_odx;
            int zz = z % this.o_dz;
            int yy = y % this.o_dy;
            int xx = x % this.o_dx;
            return this.volume[this.ZPAD + zz * this.PHYSPAGE + yy * this.XDIM + 2 + xx];
        }

        private static void loadOctalSlice(XjVolume v, OctalShort[] vols, short[] tempbuff, int z_idx) {
            String fpath = v.getVSlicePath(z_idx);
            int dx = vols[0].dx;
            int dy = vols[0].dy;
            int XDIM = vols[0].XDIM;
            int ZPAD = vols[0].ZPAD;
            int PHYSPAGE = vols[0].PHYSPAGE;
            int o_dx = vols[0].o_dx;
            int o_dy = vols[0].o_dy;
            int o_dz = vols[0].o_dz;
            int ln_ody = vols[0].ln_ody;
            int sliceLen = dx * dy;
            if (fpath != null) {
                FileInputStream fi = null;
                FileChannel fc = null;
                boolean closed = false;
                try {
                    fi = new FileInputStream(new File(fpath));
                    long offset = v.getVSliceOffset(z_idx);
                    fc = fi.getChannel();
                    MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, sliceLen * 2);
                    ByteOrder byteOrd = v.isVolumeLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                    mbb.order(byteOrd);
                    mbb.asShortBuffer().get(tempbuff, 0, sliceLen);
                    fc.close();
                    fi.close();
                    closed = true;
                    int bz = z_idx / o_dz;
                    int zz = z_idx % o_dz;
                    int yoffset = 0;
                    int y = 0;
                    while (y < dy) {
                        int by = y >> ln_ody;
                        int yy = y % o_dy;
                        int octblock0 = (bz << 2) + (by << 1);
                        int octblock1 = (bz << 2) + (by << 1) + 1;
                        System.arraycopy(tempbuff, yoffset, vols[octblock0].volume, ZPAD + zz * PHYSPAGE + yy * XDIM + 2, dx >> 1);
                        System.arraycopy(tempbuff, yoffset + o_dx, vols[octblock1].volume, ZPAD + zz * PHYSPAGE + yy * XDIM + 2, dx >> 1);
                        ++y;
                        yoffset += dx;
                    }
                }
                catch (Exception ex) {
                    XpLog.logger().severe("Error reading volume slice: " + fpath + " [" + sliceLen + "," + z_idx + "]");
                    ex.printStackTrace();
                }
                if (!closed) {
                    try {
                        if (fc != null) {
                            fc.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (fi != null) {
                            fi.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private static void loadPixelData(XjVolume vol, OctalShort[] osv) {
            int blockSize = osv[0].XDIM * osv[0].YDIM * osv[0].ZDIM;
            for (int i = 0; i < 8; ++i) {
                osv[i].volume = new short[blockSize];
            }
            short[] tempbuff = new short[osv[0].dx * osv[0].dy];
            for (int i = 0; i < osv[0].dz; ++i) {
                OctalShort.loadOctalSlice(vol, osv, tempbuff, i);
            }
        }
    }

    public static final class LinearByte
    extends LinearVolume {
        public byte[] volume;
        public int[] cmap;

        public LinearByte(XjVolumeInfo vol) {
            super(vol);
            this.PAD = 2 * this.dx * this.dy;
            Object obcmap = vol.getValue(1, 83);
            byte[] bcmap = null;
            if (obcmap instanceof byte[]) {
                bcmap = (byte[])vol.getValue(1, 83);
            }
            if (bcmap != null) {
                this.cmap = new int[bcmap.length / 3];
                int idx = 0;
                int i = 0;
                while (i < bcmap.length) {
                    int red = bcmap[i] & 0xFF;
                    int green = bcmap[i + 1] & 0xFF;
                    int blue = bcmap[i + 2] & 0xFF;
                    this.cmap[idx] = 0xFF000000 | red << 16 | green << 8 | blue;
                    i += 3;
                    ++idx;
                }
            } else {
                this.cmap = new int[256];
                for (int i = 0; i < this.cmap.length; ++i) {
                    this.cmap[i] = 0xFF000000 | (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
                }
            }
            long t0 = System.currentTimeMillis();
            if (vol instanceof XjVolume) {
                this.loadPixelData((XjVolume)vol);
            } else if (vol instanceof XjMemVolume) {
                this.setupVolume((XjMemVolume)vol);
            } else {
                throw new RuntimeException("Unsupported XjVolumeInfo implementation");
            }
            long t1 = System.currentTimeMillis();
            if (!this.defined_wwwl) {
                this.defined_wwwl = true;
                int sum = 0;
                boolean sqrsum = false;
                int nvox = 0;
                for (int i = 0; i < this.volume.length - this.PAD; ++i) {
                    int v = this.volume[this.PAD + i] & 0xFF;
                    sum += v;
                    ++nvox;
                }
                this.initWL = (double)sum / (double)nvox;
                this.initWW = 150.0;
                System.err.println("JVolume.LinearByte: Defined ww/wl as [" + this.initWW + "," + this.initWL + "]  min/max=[" + this.min + "," + this.max + "] [" + this.modality + "]");
            }
            long t2 = System.currentTimeMillis();
            System.err.println("JVolume.LinearByte Load: " + (t1 - t0) + " + " + (t2 - t1));
        }

        private LinearByte() {
        }

        @Override
        public Object getVolumeData() {
            return this.volume;
        }

        @Override
        protected final JVolume dupVolume() {
            LinearByte jv = new LinearByte();
            jv.volume = new byte[this.volume.length];
            jv.PAD = this.PAD;
            return jv;
        }

        public void setupVolume(XjMemVolume v) {
            boolean isByte;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            int ptype = v.getPixelType();
            boolean bl = isByte = v.getBitsPerVoxel() == 8 && (ptype == 0 || ptype == 1 || ptype == 3);
            if (v.isContiguous() && isByte) {
                this.PAD = v.getSliceOffset(0);
                this.volume = (byte[])v.getSliceData(0);
            } else if (!v.isContiguous() && isByte) {
                int len = this.dx * this.dy * this.dz;
                this.volume = new byte[len + 2 * this.PAD];
                for (int i = 0; i < this.dz; ++i) {
                    byte[] data = (byte[])v.getSliceData(i);
                    int offset = v.getSliceOffset(i);
                    System.arraycopy(data, offset, this.volume, i * this.dx * this.dy + this.PAD, this.dx * this.dy);
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        private void loadPixelData(XjVolume vol) {
            int len = this.dx * this.dy * this.dz;
            int sliceLen = this.dx * this.dy;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            this.volume = new byte[len + 2 * this.PAD];
            for (int i = 0; i < this.dz; ++i) {
                if (i % 4 == 0) {
                    this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                }
                LinearByte.fillVolumeSlice(vol, this.volume, sliceLen, sliceLen * i + this.PAD, i);
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        @Override
        protected void newSlice(int idx) {
            int sliceLen = this.dx * this.dy;
            if (this.vol instanceof XjVolume) {
                LinearByte.fillVolumeSlice((XjVolume)this.vol, this.volume, sliceLen, idx * sliceLen + this.PAD, idx);
            } else if (this.vol instanceof XjMemVolume) {
                boolean isByteLuminance;
                XjMemVolume memVol = (XjMemVolume)this.vol;
                boolean bl = isByteLuminance = this.vol.getBitsPerVoxel() <= 8 && (this.vol.getPixelType() == 0 || this.vol.getPixelType() == 1);
                if (!memVol.isContiguous() && isByteLuminance) {
                    byte[] data = (byte[])memVol.getSliceData(idx);
                    int offset = memVol.getSliceOffset(idx);
                    System.arraycopy(data, offset, this.volume, idx * this.dx * this.dy + this.PAD, this.dx * this.dy);
                }
            }
        }
    }

    public static class LinearShort
    extends LinearVolume {
        public short[] volume;
        private boolean downsampled = false;

        public LinearShort(XjVolumeInfo vol) {
            super(vol);
            this.PAD = 2 * this.dx * this.dy;
            long t0 = System.currentTimeMillis();
            if (vol instanceof XjVolume) {
                this.loadPixelData((XjVolume)vol);
            } else if (vol instanceof XjMemVolume) {
                this.setupVolume((XjMemVolume)vol);
            } else {
                throw new RuntimeException("Unsupported XjVolumeInfo implementation");
            }
            long t1 = System.currentTimeMillis();
            if (!this.defined_wwwl) {
                this.defined_wwwl = true;
                int sum = 0;
                boolean sqrsum = false;
                int nvox = 0;
                for (int i = 0; i < this.volume.length - this.PAD; ++i) {
                    short v = this.volume[this.PAD + i];
                    sum += v;
                    ++nvox;
                }
                this.initWL = (double)sum / (double)nvox;
                this.initWW = 150.0;
                System.err.println("JVolume.LinearShort: Defined ww/wl as [" + this.initWW + "," + this.initWL + "]  min/max=[" + this.min + "," + this.max + "] [" + this.modality + "]");
            }
            long t2 = System.currentTimeMillis();
            System.err.println("JVolume.LinearShort Load: " + (t1 - t0) + " + " + (t2 - t1));
        }

        private LinearShort() {
        }

        @Override
        public Object getVolumeData() {
            return this.volume;
        }

        @Override
        protected final JVolume dupVolume() {
            LinearShort jv = new LinearShort();
            jv.volume = new short[this.volume.length];
            jv.PAD = this.PAD;
            jv.downsampled = this.downsampled;
            return jv;
        }

        public void setupVolume(XjMemVolume v) {
            boolean isShortLuminance;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            boolean bl = isShortLuminance = v.getBitsPerVoxel() == 16 && (v.getPixelType() == 0 || v.getPixelType() == 1);
            if (v.isContiguous() && isShortLuminance) {
                this.PAD = v.getSliceOffset(0);
                this.volume = (short[])v.getSliceData(0);
            } else if (!v.isContiguous() && isShortLuminance) {
                int len = this.dx * this.dy * this.dz;
                this.volume = new short[len + 2 * this.PAD];
                for (int i = 0; i < this.dz; ++i) {
                    short[] data = (short[])v.getSliceData(i);
                    int offset = v.getSliceOffset(i);
                    System.arraycopy(data, offset, this.volume, i * this.dx * this.dy + this.PAD, this.dx * this.dy);
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        private void loadPixelData(XjVolume vol) {
            int len = this.dx * this.dy * this.dz;
            this.volume = new short[len + 2 * this.PAD];
            int sliceLen = this.dx * this.dy;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            this.downsampled = vol instanceof DownSampledVolume;
            if (this.downsampled) {
                this.downsampleLinear(vol, this.volume);
            } else {
                boolean natural = Boolean.getBoolean("natural.order");
                if (natural) {
                    HashMap<String, Integer> pathIndMap = new HashMap<String, Integer>(this.dz * 4 / 3);
                    for (int i = 0; i < this.dz; ++i) {
                        pathIndMap.put(vol.getVSlicePath(i), new Integer(i));
                    }
                    File dir = new File(vol.getVSlicePath(0)).getParentFile();
                    if (dir != null) {
                        String[] naturalOrderedFiles = dir.list();
                        for (int i = 0; i < naturalOrderedFiles.length; ++i) {
                            String fullname = dir.getAbsolutePath() + File.separator + naturalOrderedFiles[i];
                            if (pathIndMap.get(fullname) == null) continue;
                            if (i % 4 == 0) {
                                this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                            }
                            int realInd = (Integer)pathIndMap.get(fullname);
                            LinearShort.fillVolumeSlice(vol, this.volume, sliceLen, sliceLen * realInd + this.PAD, realInd, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(i), this.normalize);
                        }
                    }
                } else {
                    int i;
                    boolean isMultiFrame = true;
                    String basePath = vol.getVSlicePath(0);
                    for (i = 1; i < this.dz; ++i) {
                        String fpath = vol.getVSlicePath(i);
                        if (fpath == null || fpath.equals(basePath)) continue;
                        isMultiFrame = false;
                    }
                    if (isMultiFrame) {
                        LinearShort.fillVolumeSlice(vol, this.volume, sliceLen * this.dz, this.PAD, 0, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(0), this.normalize);
                    } else {
                        for (i = 0; i < this.dz; ++i) {
                            if (i % 4 == 0) {
                                this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                            }
                            LinearShort.fillVolumeSlice(vol, this.volume, sliceLen, sliceLen * i + this.PAD, i, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(i), this.normalize);
                        }
                    }
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        @Override
        protected void newSlice(int idx) {
            int sliceLen = this.dx * this.dy;
            if (this.vol instanceof XjVolume) {
                LinearShort.fillVolumeSlice((XjVolume)this.vol, this.volume, sliceLen, idx * sliceLen + this.PAD, idx, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(idx), this.normalize);
            } else if (this.vol instanceof XjMemVolume) {
                boolean isShortLuminance;
                XjMemVolume memVol = (XjMemVolume)this.vol;
                boolean bl = isShortLuminance = this.vol.getBitsPerVoxel() == 16 && (this.vol.getPixelType() == 0 || this.vol.getPixelType() == 1);
                if (!memVol.isContiguous() && isShortLuminance) {
                    short[] data = (short[])memVol.getSliceData(idx);
                    int offset = memVol.getSliceOffset(idx);
                    System.arraycopy(data, offset, this.volume, idx * this.dx * this.dy + this.PAD, this.dx * this.dy);
                }
            }
        }
    }

    public static abstract class LinearVolume
    extends JVolume {
        public int PAD;

        public LinearVolume(XjVolumeInfo vol) {
            super(vol);
        }

        protected LinearVolume() {
        }

        public abstract Object getVolumeData();
    }

    public static abstract class SlicedVolume
    extends JVolume {
        public int PAD;

        public SlicedVolume(XjVolumeInfo vol) {
            super(vol);
        }

        protected SlicedVolume() {
        }

        public abstract Object getVolumeData();
    }

    public static final class MCByte
    extends JVolume {
        public static final int mcBits = 5;
        public static final int mcMask = 31;
        public static final int mcDim = 32;
        public static final int mcSize = 32768;
        public int mcDimx;
        public int mcDimy;
        public int mcDimz;
        public int PAD;
        public byte[] volume;

        public MCByte(XjVolumeInfo vol) {
            super(vol);
            this.loadPixelData();
        }

        private MCByte() {
        }

        @Override
        protected final JVolume dupVolume() {
            MCByte jv = new MCByte();
            jv.volume = new byte[this.volume.length];
            jv.mcDimx = this.mcDimx;
            jv.mcDimy = this.mcDimy;
            jv.mcDimz = this.mcDimz;
            jv.PAD = this.PAD;
            return jv;
        }

        public final int lookup(int x, int y, int z) {
            int volOffset = 32768 * (((z >> 5) * this.mcDimy + (y >> 5)) * this.mcDimx + (x >> 5));
            int mcOffset = (((z & 0x1F) << 5) + (y & 0x1F) << 5) + (x & 0x1F);
            return this.PAD + volOffset + mcOffset;
        }

        public final int lookup1(int x, int y, int z) {
            return this.PAD + (z * this.mcDimx + y) * this.mcDimx + x;
        }

        public void test(int x, int y, int z) {
            System.out.println("zyx=" + z + "," + y + "," + x);
            int mcx = x & 0x1F;
            System.out.println("mcx=" + mcx);
            int mcy = y & 0x1F;
            System.out.println("mcy=" + mcy);
            int mcz = z & 0x1F;
            System.out.println("mcz=" + mcz);
            int vx = x >> 5;
            System.out.println("vx=" + vx);
            int vy = y >> 5;
            System.out.println("vy=" + vy);
            int vz = z >> 5;
            System.out.println("vz=" + vz);
            int volOffset = 32768 * ((vz * this.mcDimy + vy) * this.mcDimx + vx);
            System.out.println("volOffset" + volOffset);
            int mcOffset = ((mcz << 5) + mcy << 5) + mcx;
            System.out.println("mcOffset=" + mcOffset);
        }

        private void loadPixelData() {
            this.mcDimx = this.dx / 32 + (0 == this.dx % 32 ? 0 : 1);
            this.mcDimy = this.dy / 32 + (0 == this.dy % 32 ? 0 : 1);
            this.mcDimz = this.dz / 32 + (0 == this.dz % 32 ? 0 : 1);
            this.PAD = 3 * this.dx * this.dy;
            int len = this.mcDimx * this.mcDimy * this.mcDimz * 32768;
            System.out.println("MICROCUBE: " + this.mcDimx + " " + this.mcDimy + " " + this.mcDimz);
            System.out.println("-- " + this.dx + " : " + this.dy + " : " + this.dz);
            this.volume = new byte[len + 2 * this.PAD];
            for (int i = 0; i < this.volume.length; ++i) {
                this.volume[i] = 0;
            }
        }
    }

    public static final class Short
    extends SlicedVolume {
        public short[][] volume;

        public Short(XjVolumeInfo vol) {
            super(vol);
            long t0 = System.currentTimeMillis();
            if (vol instanceof XjVolume) {
                this.loadPixelData((XjVolume)vol);
            } else if (vol instanceof XjMemVolume) {
                this.setupVolume((XjMemVolume)vol);
            } else {
                throw new RuntimeException("Unsupported XjVolumeInfo implementation");
            }
            long t1 = System.currentTimeMillis();
            int sliceLen = this.dx * this.dy;
            if (!this.defined_wwwl) {
                this.defined_wwwl = true;
                int sum = 0;
                int nvox = 0;
                for (int z = 0; z < this.volume.length; ++z) {
                    for (int xy = 0; xy < sliceLen; ++xy) {
                        short v = this.volume[z][xy];
                        sum += v;
                        ++nvox;
                    }
                }
                this.initWL = (double)sum / (double)nvox;
                this.initWW = 150.0;
                System.err.println("JVolume.Short: Defined ww/wl as [" + this.initWW + "," + this.initWL + "]  min/max=[" + this.min + "," + this.max + "] [" + this.modality + "]");
            }
            long t2 = System.currentTimeMillis();
            System.err.println("JVolume.Short Load: " + (t1 - t0) + " + " + (t2 - t1));
        }

        private Short() {
        }

        @Override
        public Object getVolumeData() {
            return this.volume;
        }

        @Override
        protected final JVolume dupVolume() {
            Short jv = new Short();
            int dimy = this.volume.length;
            int dimxy = this.volume[0].length;
            jv.volume = new short[dimy][dimxy];
            return jv;
        }

        public void setupVolume(XjMemVolume v) {
            boolean isShortLuminance;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            boolean bl = isShortLuminance = v.getBitsPerVoxel() == 16 && (v.getPixelType() == 0 || v.getPixelType() == 1);
            if (v.isContiguous() && isShortLuminance) {
                throw new RuntimeException("XJMemVolume must be non-contiguous");
            }
            if (!v.isContiguous() && isShortLuminance) {
                int sliceLen = this.dx * this.dy;
                this.volume = new short[this.dz][sliceLen];
                for (int i = 0; i < this.dz; ++i) {
                    if (i % 4 == 0) {
                        this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                    }
                    this.volume[i] = (short[])v.getSliceData(i);
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        private void loadPixelData(XjVolume vol) {
            int sliceLen = this.dx * this.dy;
            this.volume = new short[this.dz][];
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            boolean natural = Boolean.getBoolean("natural.order");
            if (natural) {
                HashMap<String, Integer> pathIndMap = new HashMap<String, Integer>(this.dz * 4 / 3);
                for (int i = 0; i < this.dz; ++i) {
                    pathIndMap.put(vol.getVSlicePath(i), new Integer(i));
                }
                File dir = new File(vol.getVSlicePath(0)).getParentFile();
                if (dir != null) {
                    String[] naturalOrderedFiles = dir.list();
                    for (int i = 0; i < naturalOrderedFiles.length; ++i) {
                        String fullname = dir.getAbsolutePath() + File.separator + naturalOrderedFiles[i];
                        if (pathIndMap.get(fullname) == null) continue;
                        this.volume[i] = new short[sliceLen];
                        if (i % 4 == 0) {
                            this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                        }
                        int realInd = (Integer)pathIndMap.get(fullname);
                        Short.fillVolumeSlice(vol, this.volume[i], sliceLen, 0, realInd, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(i), this.normalize);
                    }
                }
            } else {
                int i;
                boolean isMultiFrame = true;
                String basePath = vol.getVSlicePath(0);
                for (i = 1; i < this.dz; ++i) {
                    String fpath = vol.getVSlicePath(i);
                    if (fpath == null || fpath.equals(basePath)) continue;
                    isMultiFrame = false;
                }
                if (isMultiFrame) {
                    for (i = 0; i < this.dz; ++i) {
                        this.volume[i] = new short[sliceLen];
                        if (i % 4 == 0) {
                            this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                        }
                        Short.fillVolumeSlice(vol, this.volume[i], sliceLen, sliceLen * i, 0, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(0), this.normalize);
                    }
                } else {
                    for (i = 0; i < this.dz; ++i) {
                        this.volume[i] = new short[sliceLen];
                        if (i % 4 == 0) {
                            this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                        }
                        Short.fillVolumeSlice(vol, this.volume[i], sliceLen, 0, i, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(i), this.normalize);
                    }
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        @Override
        protected void newSlice(int idx) {
            if (this.vol instanceof XjVolume) {
                Short.fillVolumeSlice((XjVolume)this.vol, this.volume[idx], this.dx * this.dy, 0, idx, this.pixelRepresentation, this.rescaleSlope, this.getSliceRescaleSlope(idx), this.normalize);
            } else if (this.vol instanceof XjMemVolume) {
                boolean isShortLuminance;
                XjMemVolume memVol = (XjMemVolume)this.vol;
                boolean bl = isShortLuminance = this.vol.getBitsPerVoxel() == 16 && (this.vol.getPixelType() == 0 || this.vol.getPixelType() == 1);
                if (!memVol.isContiguous() && isShortLuminance) {
                    this.volume[idx] = (short[])memVol.getSliceData(idx);
                }
            }
        }
    }

    public static final class Byte
    extends SlicedVolume {
        public byte[][] volume;
        public int[] cmap;

        public Byte(XjVolumeInfo vol) {
            super(vol);
            Object obcmap = vol.getValue(1, 83);
            byte[] bcmap = null;
            if (obcmap instanceof byte[]) {
                bcmap = (byte[])vol.getValue(1, 83);
            }
            if (bcmap != null) {
                this.cmap = new int[bcmap.length / 3];
                int idx = 0;
                int i = 0;
                while (i < bcmap.length) {
                    int red = bcmap[i] & 0xFF;
                    int green = bcmap[i + 1] & 0xFF;
                    int blue = bcmap[i + 2] & 0xFF;
                    this.cmap[idx] = 0xFF000000 | red << 16 | green << 8 | blue;
                    i += 3;
                    ++idx;
                }
            } else {
                this.cmap = new int[256];
                for (int i = 0; i < this.cmap.length; ++i) {
                    this.cmap[i] = 0xFF000000 | (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
                }
            }
            long t0 = System.currentTimeMillis();
            if (vol instanceof XjVolume) {
                this.loadPixelData((XjVolume)vol);
            } else if (vol instanceof XjMemVolume) {
                this.setupVolume((XjMemVolume)vol);
            } else {
                throw new RuntimeException("Unsupported XjVolumeInfo implementation");
            }
            long t1 = System.currentTimeMillis();
            int sliceLen = this.dx * this.dy;
            if (!this.defined_wwwl) {
                this.defined_wwwl = true;
                int sum = 0;
                int nvox = 0;
                for (int z = 0; z < this.volume.length; ++z) {
                    for (int xy = 0; xy < sliceLen; ++xy) {
                        byte v = this.volume[z][xy];
                        sum += v;
                        ++nvox;
                    }
                }
                this.initWL = (double)sum / (double)nvox;
                this.initWW = 150.0;
                System.err.println("JVolume.Byte: Defined ww/wl as [" + this.initWW + "," + this.initWL + "]  min/max=[" + this.min + "," + this.max + "] [" + this.modality + "]");
            }
            long t2 = System.currentTimeMillis();
            System.err.println("JVolume.Byte Load: " + (t1 - t0) + " + " + (t2 - t1));
        }

        private Byte() {
        }

        @Override
        public Object getVolumeData() {
            return this.volume;
        }

        @Override
        protected final JVolume dupVolume() {
            Byte jv = new Byte();
            int dimy = this.volume.length;
            int dimx = this.volume[0].length;
            jv.volume = new byte[dimy][dimx];
            return jv;
        }

        public void setupVolume(XjMemVolume v) {
            boolean isShortLuminance;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            boolean bl = isShortLuminance = v.getBitsPerVoxel() == 16 && (v.getPixelType() == 0 || v.getPixelType() == 1);
            if (v.isContiguous() && isShortLuminance) {
                throw new RuntimeException("XJMemVolume must be non-contiguous");
            }
            if (!v.isContiguous() && isShortLuminance) {
                int sliceLen = this.dx * this.dy;
                this.volume = new byte[this.dz][sliceLen];
                for (int i = 0; i < this.dz; ++i) {
                    if (i % 4 == 0) {
                        this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                    }
                    this.volume[i] = (byte[])v.getSliceData(i);
                }
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        private void loadPixelData(XjVolume vol) {
            this.volume = new byte[this.dz][];
            int sliceLen = this.dx * this.dy;
            this.notifyTaskBegin(JVolume.VOLUME_LOAD, this.dz);
            for (int i = 0; i < this.dz; ++i) {
                this.volume[i] = new byte[sliceLen];
                if (i % 4 == 0) {
                    this.notifyTaskProgress(JVolume.VOLUME_LOAD, i);
                }
                Byte.fillVolumeSlice(vol, this.volume[i], sliceLen, 0, i);
            }
            this.notifyTaskDone(JVolume.VOLUME_LOAD);
        }

        @Override
        protected void newSlice(int idx) {
            int sliceLen = this.dx * this.dy;
            if (this.vol instanceof XjVolume) {
                Byte.fillVolumeSlice((XjVolume)this.vol, this.volume[idx], sliceLen, 0, idx);
            } else if (this.vol instanceof XjMemVolume) {
                boolean isShortLuminance;
                XjMemVolume memVol = (XjMemVolume)this.vol;
                boolean bl = isShortLuminance = this.vol.getBitsPerVoxel() == 16 && (this.vol.getPixelType() == 0 || this.vol.getPixelType() == 1);
                if (!memVol.isContiguous() && isShortLuminance) {
                    this.volume[idx] = (byte[])memVol.getSliceData(idx);
                }
            }
        }
    }

    private class SliceObject
    implements XpDicomObject {
        private int idx = 0;

        public SliceObject(int idx) {
            this.idx = idx;
        }

        @Override
        public final int getValues(XpDicomElement[] values) {
            boolean allLoaded = true;
            for (int i = 0; i < values.length; ++i) {
                int result = this.getValue(values[i]);
                if (result != 1) continue;
                allLoaded = false;
            }
            if (allLoaded) {
                return 0;
            }
            return 1;
        }

        @Override
        public final int getValue(XpDicomElement value) {
            value.value = JVolume.this.vol.getVSliceValue(this.idx, value.group, value.element);
            return value.value != null ? 0 : 1;
        }
    }
}

