/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.XjSeqItem;
import com.ge.med.idc.XjSequence;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpLog;

public class DICOMLut {
    private int voiTableLength = 0;
    private int firstValueMapped = 0;
    private int numBits = 0;
    private int[] lutdata = null;
    private String lutExplanation = null;
    private int pixelRepresentation = 1;
    private int minVal = 0;
    private int maxVal = 0;

    public DICOMLut(Object lut, Integer[] lutdescriptor, int pixelRep) {
        this(lut, lutdescriptor, pixelRep, "");
    }

    public DICOMLut(Object lut, Integer[] lutdescriptor, int pixelRep, String explanation) {
        Object[] slut;
        int i;
        Object[] ilut;
        this.lutExplanation = explanation;
        this.voiTableLength = lutdescriptor[0];
        if (this.voiTableLength == 0) {
            this.voiTableLength = 65536;
        }
        this.firstValueMapped = lutdescriptor[1];
        this.numBits = lutdescriptor[2];
        this.pixelRepresentation = pixelRep;
        if (lut instanceof int[]) {
            if (this.pixelRepresentation == 0) {
                ilut = (int[])lut;
                this.lutdata = new int[ilut.length];
                for (i = 0; i < ilut.length; ++i) {
                    this.lutdata[i] = ilut[i] & 0xFFFF;
                }
            } else {
                this.lutdata = (int[])lut;
            }
        } else if (lut instanceof Integer[]) {
            ilut = (Integer[])lut;
            this.lutdata = new int[ilut.length];
            if (this.pixelRepresentation == 0) {
                for (i = 0; i < ilut.length; ++i) {
                    this.lutdata[i] = ilut[i].intValue() & 0xFFFF;
                }
            } else {
                for (i = 0; i < ilut.length; ++i) {
                    this.lutdata[i] = ilut[i].intValue();
                }
            }
        } else if (lut instanceof short[]) {
            slut = (short[])lut;
            this.lutdata = new int[slut.length];
            if (this.pixelRepresentation == 0) {
                for (i = 0; i < slut.length; ++i) {
                    this.lutdata[i] = slut[i] & 0xFFFF;
                }
            } else {
                for (i = 0; i < slut.length; ++i) {
                    this.lutdata[i] = slut[i];
                }
            }
        } else if (lut instanceof Short[]) {
            slut = (Short[])lut;
            this.lutdata = new int[slut.length];
            if (this.pixelRepresentation == 0) {
                for (i = 0; i < slut.length; ++i) {
                    this.lutdata[i] = slut[i].shortValue() & 0xFFFF;
                }
            } else {
                for (i = 0; i < slut.length; ++i) {
                    this.lutdata[i] = slut[i].shortValue();
                }
            }
        }
        if (this.lutdata != null) {
            this.minVal = this.lutdata[0];
            this.maxVal = this.lutdata[0];
            for (int i2 = 1; i2 < this.lutdata.length; ++i2) {
                if (this.lutdata[i2] < this.minVal) {
                    this.minVal = this.lutdata[i2];
                }
                if (this.lutdata[i2] <= this.maxVal) continue;
                this.maxVal = this.lutdata[i2];
            }
        }
    }

    public int getVoiLength() {
        return this.voiTableLength;
    }

    public int getFirstValueMapped() {
        return this.firstValueMapped;
    }

    public int getLastValueMapped() {
        return this.firstValueMapped + this.voiTableLength - 1;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int[] getLutdata() {
        return this.lutdata;
    }

    public String getLutExplanation() {
        return this.lutExplanation;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getMinVal() {
        return this.minVal;
    }

    public int getMaxVal() {
        return this.maxVal;
    }

    private static DICOMLut createLut(XjSequence seq, int idx) {
        int pixelRep = 0;
        XjSeqItem item = seq.getItem(idx);
        if (item != null) {
            Integer[] lutdescriptor = (Integer[])item.getValue(40, 12290);
            Object lut = item.getValue(40, 12294);
            String explanation = (String)item.getValue(40, 12291);
            Object pixRepObj = item.getValue(40, 259);
            if (null != pixRepObj) {
                pixelRep = (Integer)pixRepObj;
            }
            return new DICOMLut(lut, lutdescriptor, pixelRep, explanation);
        }
        return null;
    }

    public static DICOMLut[] loadVoiLuts(XpDicomObject mimg) {
        XpDicomElement voiLutSeq = new XpDicomElement(40, 12304);
        voiLutSeq.value = null;
        mimg.getValue(voiLutSeq);
        if (voiLutSeq.value != null && voiLutSeq.value instanceof XjSequence) {
            XjSequence voilut = (XjSequence)voiLutSeq.value;
            int nItems = voilut.getNumberOfItems();
            DICOMLut[] retvals = new DICOMLut[nItems];
            for (int i = 0; i < nItems; ++i) {
                retvals[i] = DICOMLut.createLut(voilut, i);
                XpLog.info("###### DICOMLut: Loading DICOMLut: Explanation=" + retvals[i].getLutExplanation() + " FirstValueMapped=" + retvals[i].getFirstValueMapped() + " LastValueMapped=" + retvals[i].getLastValueMapped() + " MinVal=" + retvals[i].getMinVal() + " MaxVal=" + retvals[i].getMaxVal() + " TableLength=" + retvals[i].getVoiLength() + " NumBits=" + retvals[i].getNumBits());
            }
            return retvals;
        }
        return null;
    }

    public static int[][] getVoiLUTDescriptors(XpDicomObject mimg) {
        XpDicomElement voiLutSeq = new XpDicomElement(40, 12304);
        voiLutSeq.value = null;
        mimg.getValue(voiLutSeq);
        if (voiLutSeq.value != null && voiLutSeq.value instanceof XjSequence) {
            XjSequence voilut = (XjSequence)voiLutSeq.value;
            int nItems = voilut.getNumberOfItems();
            int[][] retvals = new int[nItems][];
            for (int i = 0; i < nItems; ++i) {
                XjSeqItem item = voilut.getItem(i);
                Integer[] descriptor = (Integer[])item.getValue(40, 12290);
                retvals[i] = new int[descriptor.length];
                for (int j = 0; j < descriptor.length; ++j) {
                    retvals[i][j] = descriptor[j];
                }
            }
            return retvals;
        }
        return null;
    }

    public static String[] getVoiLUTExplanations(XpDicomObject mimg) {
        XpDicomElement voiLutSeq = new XpDicomElement(40, 12304);
        voiLutSeq.value = null;
        mimg.getValue(voiLutSeq);
        if (voiLutSeq.value != null && voiLutSeq.value instanceof XjSequence) {
            XjSequence voilut = (XjSequence)voiLutSeq.value;
            int nItems = voilut.getNumberOfItems();
            String[] retvals = new String[nItems];
            for (int i = 0; i < nItems; ++i) {
                XjSeqItem item = voilut.getItem(i);
                retvals[i] = (String)item.getValue(40, 12291);
            }
            return retvals;
        }
        return null;
    }

    public static DICOMLut loadModalityLut(XpDicomObject mimg) {
        XpDicomElement modLutSeq = new XpDicomElement(40, 12288);
        modLutSeq.value = null;
        mimg.getValue(modLutSeq);
        if (modLutSeq.value != null && modLutSeq instanceof XjSequence) {
            XjSequence modlut = (XjSequence)modLutSeq.value;
            XpLog.info("###### DICOMLut: Found a Modality LUT table ");
            return DICOMLut.createLut(modlut, 0);
        }
        return null;
    }
}

