/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.wl;

public abstract class Legall53WaveletBase {
    public static Subband forward(short[] data, int w, int h, int nlevels) {
        return Legall53WaveletBase.forward(data, w, h, 0, 0, w, h, nlevels);
    }

    public static Subband forward(byte[] data, int offset, short[] result, int w, int h, int nlevels) {
        return Legall53WaveletBase.forward(data, offset, result, w, h, 0, 0, w, h, nlevels);
    }

    public static Subband forward(short[] data, int width, int height, int x, int y, int w, int h, int nlevels) {
        Subband r = new Subband();
        r.ulcx = x;
        r.ulcy = y;
        r.x = x;
        r.y = y;
        r.width = w;
        r.height = h;
        short[] tmpVector = new short[Math.max(w, h)];
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, r, 0, nlevels, tmpVector);
        return r;
    }

    public static Subband forward(byte[] data, int offset, short[] result, int width, int height, int x, int y, int w, int h, int nlevels) {
        Subband r = new Subband();
        r.ulcx = x;
        r.ulcy = y;
        r.x = x;
        r.y = y;
        r.width = w;
        r.height = h;
        short[] tmpVector = new short[Math.max(w, h)];
        Legall53WaveletBase.waveletTreeDecomposition(data, offset, result, width, height, r, 0, nlevels, tmpVector);
        return r;
    }

    public static Subband forward(int[] data, int w, int h, int nlevels) {
        Subband r = new Subband();
        r.ulcy = 0;
        r.ulcx = 0;
        r.x = 0;
        r.y = 0;
        r.width = w;
        r.height = h;
        Legall53WaveletBase.waveletTreeDecomposition(data, w, h, r, 0, nlevels);
        return r;
    }

    private static void waveletTreeDecomposition(int[] data, int width, int height, Subband sbband, int level, int nlevels) {
        if (level == nlevels) {
            return;
        }
        Legall53WaveletBase.wavelet2DDecomposition(data, width, height, sbband);
        Subband ll = sbband.ll = new Subband();
        Subband hl = sbband.hl = new Subband();
        Subband lh = sbband.lh = new Subband();
        Subband hh = sbband.hh = new Subband();
        ll.ulcx = sbband.ulcx + 1 >> 1;
        ll.ulcy = sbband.ulcy + 1 >> 1;
        hl.ulcx = sbband.ulcx >> 1;
        hl.ulcy = ll.ulcy;
        lh.ulcx = ll.ulcx;
        lh.ulcy = sbband.ulcy >> 1;
        hh.ulcx = hl.ulcx;
        hh.ulcy = lh.ulcy;
        ll.x = sbband.x;
        ll.y = sbband.y;
        ll.width = (sbband.ulcx + sbband.width + 1 >> 1) - ll.ulcx;
        ll.height = (sbband.ulcy + sbband.height + 1 >> 1) - ll.ulcy;
        hl.x = sbband.x + ll.width;
        hl.y = sbband.y;
        hl.width = (sbband.ulcx + sbband.width >> 1) - (sbband.ulcx >> 1);
        hl.height = ll.height;
        lh.x = sbband.x;
        lh.y = sbband.y + ll.height;
        lh.width = ll.width;
        lh.height = (sbband.ulcy + sbband.height >> 1) - (sbband.ulcy >> 1);
        hh.x = hl.x;
        hh.y = lh.y;
        hh.width = hl.width;
        hh.height = lh.height;
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, hh, level + 1, nlevels);
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, lh, level + 1, nlevels);
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, hl, level + 1, nlevels);
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, ll, level + 1, nlevels);
    }

    private static void waveletTreeDecomposition(short[] data, int width, int height, Subband sbband, int level, int nlevels, short[] tmpVector) {
        if (level == nlevels) {
            return;
        }
        Legall53WaveletBase.wavelet2DDecomposition(data, width, height, sbband, tmpVector);
        Subband ll = sbband.ll = new Subband();
        Subband hl = sbband.hl = new Subband();
        Subband lh = sbband.lh = new Subband();
        Subband hh = sbband.hh = new Subband();
        ll.ulcx = sbband.ulcx + 1 >> 1;
        ll.ulcy = sbband.ulcy + 1 >> 1;
        hl.ulcx = sbband.ulcx >> 1;
        hl.ulcy = ll.ulcy;
        lh.ulcx = ll.ulcx;
        lh.ulcy = sbband.ulcy >> 1;
        hh.ulcx = hl.ulcx;
        hh.ulcy = lh.ulcy;
        ll.x = sbband.x;
        ll.y = sbband.y;
        ll.width = (sbband.ulcx + sbband.width + 1 >> 1) - ll.ulcx;
        ll.height = (sbband.ulcy + sbband.height + 1 >> 1) - ll.ulcy;
        hl.x = sbband.x + ll.width;
        hl.y = sbband.y;
        hl.width = (sbband.ulcx + sbband.width >> 1) - (sbband.ulcx >> 1);
        hl.height = ll.height;
        lh.x = sbband.x;
        lh.y = sbband.y + ll.height;
        lh.width = ll.width;
        lh.height = (sbband.ulcy + sbband.height >> 1) - (sbband.ulcy >> 1);
        hh.x = hl.x;
        hh.y = lh.y;
        hh.width = hl.width;
        hh.height = lh.height;
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, hh, level + 1, nlevels, tmpVector);
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, lh, level + 1, nlevels, tmpVector);
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, hl, level + 1, nlevels, tmpVector);
        Legall53WaveletBase.waveletTreeDecomposition(data, width, height, ll, level + 1, nlevels, tmpVector);
    }

    private static void waveletTreeDecomposition(byte[] data, int offset, short[] result, int width, int height, Subband sbband, int level, int nlevels, short[] tmpVector) {
        if (level == nlevels) {
            return;
        }
        Legall53WaveletBase.wavelet2DDecomposition(data, offset, result, width, height, sbband, tmpVector);
        Subband ll = sbband.ll = new Subband();
        Subband hl = sbband.hl = new Subband();
        Subband lh = sbband.lh = new Subband();
        Subband hh = sbband.hh = new Subband();
        ll.ulcx = sbband.ulcx + 1 >> 1;
        ll.ulcy = sbband.ulcy + 1 >> 1;
        hl.ulcx = sbband.ulcx >> 1;
        hl.ulcy = ll.ulcy;
        lh.ulcx = ll.ulcx;
        lh.ulcy = sbband.ulcy >> 1;
        hh.ulcx = hl.ulcx;
        hh.ulcy = lh.ulcy;
        ll.x = sbband.x;
        ll.y = sbband.y;
        ll.width = (sbband.ulcx + sbband.width + 1 >> 1) - ll.ulcx;
        ll.height = (sbband.ulcy + sbband.height + 1 >> 1) - ll.ulcy;
        hl.x = sbband.x + ll.width;
        hl.y = sbband.y;
        hl.width = (sbband.ulcx + sbband.width >> 1) - (sbband.ulcx >> 1);
        hl.height = ll.height;
        lh.x = sbband.x;
        lh.y = sbband.y + ll.height;
        lh.width = ll.width;
        lh.height = (sbband.ulcy + sbband.height >> 1) - (sbband.ulcy >> 1);
        hh.x = hl.x;
        hh.y = lh.y;
        hh.width = hl.width;
        hh.height = lh.height;
        Legall53WaveletBase.waveletTreeDecomposition(data, offset, result, width, height, hh, level + 1, nlevels, tmpVector);
        Legall53WaveletBase.waveletTreeDecomposition(data, offset, result, width, height, lh, level + 1, nlevels, tmpVector);
        Legall53WaveletBase.waveletTreeDecomposition(data, offset, result, width, height, hl, level + 1, nlevels, tmpVector);
        Legall53WaveletBase.waveletTreeDecomposition(data, offset, result, width, height, ll, level + 1, nlevels, tmpVector);
    }

    private static void wavelet2DDecomposition(int[] data, int width, int height, Subband sbband) {
        int i;
        int offset;
        int j;
        if (sbband.width == 0 || sbband.height == 0) {
            return;
        }
        int ulx = sbband.x;
        int uly = sbband.y;
        int w = sbband.width;
        int h = sbband.height;
        int band_w = width;
        int band_h = height;
        int[] tmpVector = new int[Math.max(w, h)];
        if (sbband.ulcy % 2 == 0) {
            for (j = 0; j < w; ++j) {
                offset = uly * band_w + ulx + j;
                for (i = 0; i < h; ++i) {
                    tmpVector[i] = data[offset + i * band_w];
                }
                Legall53WaveletBase.analyze_lpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + (h + 1) / 2 * band_w, band_w);
            }
        } else {
            for (j = 0; j < w; ++j) {
                offset = uly * band_w + ulx + j;
                for (i = 0; i < h; ++i) {
                    tmpVector[i] = data[offset + i * band_w];
                }
                Legall53WaveletBase.analyze_hpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + h / 2 * band_w, band_w);
            }
        }
        if (sbband.ulcx % 2 == 0) {
            for (i = 0; i < h; ++i) {
                offset = (uly + i) * band_w + ulx;
                for (j = 0; j < w; ++j) {
                    tmpVector[j] = data[offset + j];
                }
                Legall53WaveletBase.analyze_lpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + (w + 1) / 2, 1);
            }
        } else {
            for (i = 0; i < h; ++i) {
                offset = (uly + i) * band_w + ulx;
                for (j = 0; j < w; ++j) {
                    tmpVector[j] = data[offset + j];
                }
                Legall53WaveletBase.analyze_hpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + w / 2, 1);
            }
        }
    }

    private static void wavelet2DDecomposition(short[] data, int width, int height, Subband sbband, short[] tmpVector) {
        int i;
        int offset;
        int j;
        if (sbband.width == 0 || sbband.height == 0) {
            return;
        }
        int ulx = sbband.x;
        int uly = sbband.y;
        int w = sbband.width;
        int h = sbband.height;
        int band_w = width;
        int band_h = height;
        if (sbband.ulcy % 2 == 0) {
            for (j = 0; j < w; ++j) {
                offset = uly * band_w + ulx + j;
                for (i = 0; i < h; ++i) {
                    tmpVector[i] = data[offset + i * band_w];
                }
                Legall53WaveletBase.analyze_lpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + (h + 1) / 2 * band_w, band_w);
            }
        } else {
            for (j = 0; j < w; ++j) {
                offset = uly * band_w + ulx + j;
                for (i = 0; i < h; ++i) {
                    tmpVector[i] = data[offset + i * band_w];
                }
                Legall53WaveletBase.analyze_hpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + h / 2 * band_w, band_w);
            }
        }
        if (sbband.ulcx % 2 == 0) {
            for (i = 0; i < h; ++i) {
                offset = (uly + i) * band_w + ulx;
                for (j = 0; j < w; ++j) {
                    tmpVector[j] = data[offset + j];
                }
                Legall53WaveletBase.analyze_lpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + (w + 1) / 2, 1);
            }
        } else {
            for (i = 0; i < h; ++i) {
                offset = (uly + i) * band_w + ulx;
                for (j = 0; j < w; ++j) {
                    tmpVector[j] = data[offset + j];
                }
                Legall53WaveletBase.analyze_hpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + w / 2, 1);
            }
        }
    }

    private static void wavelet2DDecomposition(byte[] data, int dataOffset, short[] result, int width, int height, Subband sbband, short[] tmpVector) {
        int i;
        int offset;
        int j;
        if (sbband.width == 0 || sbband.height == 0) {
            return;
        }
        int ulx = sbband.x;
        int uly = sbband.y;
        int w = sbband.width;
        int h = sbband.height;
        int band_w = width;
        int band_h = height;
        for (int y = uly; y < uly + h; ++y) {
            int yoffset = y * band_w;
            for (int x = ulx; x < ulx + w; ++x) {
                result[yoffset + x] = (short)(data[dataOffset + yoffset + x] & 0xFF);
            }
        }
        if (sbband.ulcy % 2 == 0) {
            for (j = 0; j < w; ++j) {
                offset = uly * band_w + ulx + j;
                for (i = 0; i < h; ++i) {
                    tmpVector[i] = result[offset + i * band_w];
                }
                Legall53WaveletBase.analyze_lpf(tmpVector, 0, h, 1, result, offset, band_w, result, offset + (h + 1) / 2 * band_w, band_w);
            }
        } else {
            for (j = 0; j < w; ++j) {
                offset = uly * band_w + ulx + j;
                for (i = 0; i < h; ++i) {
                    tmpVector[i] = result[offset + i * band_w];
                }
                Legall53WaveletBase.analyze_hpf(tmpVector, 0, h, 1, result, offset, band_w, result, offset + h / 2 * band_w, band_w);
            }
        }
        if (sbband.ulcx % 2 == 0) {
            for (i = 0; i < h; ++i) {
                offset = (uly + i) * band_w + ulx;
                for (j = 0; j < w; ++j) {
                    tmpVector[j] = result[offset + j];
                }
                Legall53WaveletBase.analyze_lpf(tmpVector, 0, w, 1, result, offset, 1, result, offset + (w + 1) / 2, 1);
            }
        } else {
            for (i = 0; i < h; ++i) {
                offset = (uly + i) * band_w + ulx;
                for (j = 0; j < w; ++j) {
                    tmpVector[j] = result[offset + j];
                }
                Legall53WaveletBase.analyze_hpf(tmpVector, 0, w, 1, result, offset, 1, result, offset + w / 2, 1);
            }
        }
    }

    public static void analyze_lpf(int[] inSig, int inOff, int inLen, int inStep, int[] lowSig, int lowOff, int lowStep, int[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff + inStep;
        int hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            highSig[hk] = inSig[ik] - (inSig[ik - inStep] + inSig[ik + inStep] >> 1);
            ik += iStep;
            hk += highStep;
        }
        if (inLen % 2 == 0) {
            highSig[hk] = inSig[ik] - (2 * inSig[ik - inStep] >> 1);
        }
        ik = inOff;
        int lk = lowOff;
        hk = highOff;
        lowSig[lk] = inLen > 1 ? inSig[ik] + (highSig[hk] + 1 >> 1) : inSig[ik];
        ik += iStep;
        lk += lowStep;
        hk += highStep;
        for (i = 2; i < inLen - 1; i += 2) {
            lowSig[lk] = inSig[ik] + (highSig[hk - highStep] + highSig[hk] + 2 >> 2);
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen > 2) {
            lowSig[lk] = inSig[ik] + (2 * highSig[hk - highStep] + 2 >> 2);
        }
    }

    public static void analyze_lpf(short[] inSig, int inOff, int inLen, int inStep, short[] lowSig, int lowOff, int lowStep, short[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff + inStep;
        int hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            highSig[hk] = (short)(inSig[ik] - (inSig[ik - inStep] + inSig[ik + inStep] >> 1));
            ik += iStep;
            hk += highStep;
        }
        if (inLen % 2 == 0) {
            highSig[hk] = (short)(inSig[ik] - (2 * inSig[ik - inStep] >> 1));
        }
        ik = inOff;
        int lk = lowOff;
        hk = highOff;
        lowSig[lk] = inLen > 1 ? (short)(inSig[ik] + (highSig[hk] + 1 >> 1)) : inSig[ik];
        ik += iStep;
        lk += lowStep;
        hk += highStep;
        for (i = 2; i < inLen - 1; i += 2) {
            lowSig[lk] = (short)(inSig[ik] + (highSig[hk - highStep] + highSig[hk] + 2 >> 2));
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen % 2 == 1 && inLen > 2) {
            lowSig[lk] = (short)(inSig[ik] + (2 * highSig[hk - highStep] + 2 >> 2));
        }
    }

    public static void analyze_hpf(int[] inSig, int inOff, int inLen, int inStep, int[] lowSig, int lowOff, int lowStep, int[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff;
        int hk = highOff;
        highSig[hk] = inLen > 1 ? inSig[ik] - inSig[ik + inStep] : inSig[ik] << 1;
        ik += iStep;
        hk += highStep;
        if (inLen > 3) {
            for (i = 2; i < inLen - 1; i += 2) {
                highSig[hk] = inSig[ik] - (inSig[ik - inStep] + inSig[ik + inStep] >> 1);
                ik += iStep;
                hk += highStep;
            }
        }
        if (inLen % 2 == 1 && inLen > 1) {
            highSig[hk] = inSig[ik] - inSig[ik - inStep];
        }
        ik = inOff + inStep;
        int lk = lowOff;
        hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            lowSig[lk] = inSig[ik] + (highSig[hk] + highSig[hk + highStep] + 2 >> 2);
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen > 1 && inLen % 2 == 0) {
            lowSig[lk] = inSig[ik] + (2 * highSig[hk] + 2 >> 2);
        }
    }

    public static void analyze_hpf(short[] inSig, int inOff, int inLen, int inStep, short[] lowSig, int lowOff, int lowStep, short[] highSig, int highOff, int highStep) {
        int i;
        int iStep = 2 * inStep;
        int ik = inOff;
        int hk = highOff;
        highSig[hk] = inLen > 1 ? (short)(inSig[ik] - inSig[ik + inStep]) : (short)(inSig[ik] << 1);
        ik += iStep;
        hk += highStep;
        if (inLen > 3) {
            for (i = 2; i < inLen - 1; i += 2) {
                highSig[hk] = (short)(inSig[ik] - (inSig[ik - inStep] + inSig[ik + inStep] >> 1));
                ik += iStep;
                hk += highStep;
            }
        }
        if (inLen % 2 == 1 && inLen > 1) {
            highSig[hk] = (short)(inSig[ik] - inSig[ik - inStep]);
        }
        ik = inOff + inStep;
        int lk = lowOff;
        hk = highOff;
        for (i = 1; i < inLen - 1; i += 2) {
            lowSig[lk] = (short)(inSig[ik] + (highSig[hk] + highSig[hk + highStep] + 2 >> 2));
            ik += iStep;
            lk += lowStep;
            hk += highStep;
        }
        if (inLen > 1 && inLen % 2 == 0) {
            lowSig[lk] = (short)(inSig[ik] + (2 * highSig[hk] + 2 >> 2));
        }
    }

    public static void synthetize_lpf(int[] lowSig, int lowOff, int lowLen, int lowStep, int[] highSig, int highOff, int highLen, int highStep, int[] outSig, int outOff, int outStep) {
        int i;
        int outLen = lowLen + highLen;
        int iStep = 2 * outStep;
        int lk = lowOff;
        int hk = highOff;
        int ik = outOff;
        outSig[ik] = outLen > 1 ? lowSig[lk] - (highSig[hk] + 1 >> 1) : lowSig[lk];
        lk += lowStep;
        hk += highStep;
        ik += iStep;
        for (i = 2; i < outLen - 1; i += 2) {
            outSig[ik] = lowSig[lk] - (highSig[hk - highStep] + highSig[hk] + 2 >> 2);
            lk += lowStep;
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 1 && outLen > 2) {
            outSig[ik] = lowSig[lk] - (2 * highSig[hk - highStep] + 2 >> 2);
        }
        hk = highOff;
        ik = outOff + outStep;
        for (i = 1; i < outLen - 1; i += 2) {
            outSig[ik] = highSig[hk] + (outSig[ik - outStep] + outSig[ik + outStep] >> 1);
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 0 && outLen > 1) {
            outSig[ik] = highSig[hk] + outSig[ik - outStep];
        }
    }

    public static void synthetize_hpf(int[] lowSig, int lowOff, int lowLen, int lowStep, int[] highSig, int highOff, int highLen, int highStep, int[] outSig, int outOff, int outStep) {
        int i;
        int outLen = lowLen + highLen;
        int iStep = 2 * outStep;
        int lk = lowOff;
        int hk = highOff;
        int ik = outOff + outStep;
        for (i = 1; i < outLen - 1; i += 2) {
            outSig[ik] = lowSig[lk] - (highSig[hk] + highSig[hk + highStep] + 2 >> 2);
            lk += lowStep;
            hk += highStep;
            ik += iStep;
        }
        if (outLen > 1 && outLen % 2 == 0) {
            outSig[ik] = lowSig[lk] - (2 * highSig[hk] + 2 >> 2);
        }
        hk = highOff;
        ik = outOff;
        outSig[ik] = outLen > 1 ? highSig[hk] + outSig[ik + outStep] : highSig[hk] >> 1;
        hk += highStep;
        ik += iStep;
        for (i = 2; i < outLen - 1; i += 2) {
            outSig[ik] = highSig[hk] + (outSig[ik - outStep] + outSig[ik + outStep] >> 1);
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 1 && outLen > 1) {
            outSig[ik] = highSig[hk] + outSig[ik - outStep];
        }
    }

    public static void synthetize_lpf(short[] lowSig, int lowOff, int lowLen, int lowStep, short[] highSig, int highOff, int highLen, int highStep, short[] outSig, int outOff, int outStep) {
        int i;
        int outLen = lowLen + highLen;
        int iStep = 2 * outStep;
        int lk = lowOff;
        int hk = highOff;
        int ik = outOff;
        outSig[ik] = outLen > 1 ? (short)(lowSig[lk] - (highSig[hk] + 1 >> 1)) : lowSig[lk];
        lk += lowStep;
        hk += highStep;
        ik += iStep;
        for (i = 2; i < outLen - 1; i += 2) {
            outSig[ik] = (short)(lowSig[lk] - (highSig[hk - highStep] + highSig[hk] + 2 >> 2));
            lk += lowStep;
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 1 && outLen > 2) {
            outSig[ik] = (short)(lowSig[lk] - (2 * highSig[hk - highStep] + 2 >> 2));
        }
        hk = highOff;
        ik = outOff + outStep;
        for (i = 1; i < outLen - 1; i += 2) {
            outSig[ik] = (short)(highSig[hk] + (outSig[ik - outStep] + outSig[ik + outStep] >> 1));
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 0 && outLen > 1) {
            outSig[ik] = (short)(highSig[hk] + outSig[ik - outStep]);
        }
    }

    public static void synthetize_hpf(short[] lowSig, int lowOff, int lowLen, int lowStep, short[] highSig, int highOff, int highLen, int highStep, short[] outSig, int outOff, int outStep) {
        int i;
        int outLen = lowLen + highLen;
        int iStep = 2 * outStep;
        int lk = lowOff;
        int hk = highOff;
        int ik = outOff + outStep;
        for (i = 1; i < outLen - 1; i += 2) {
            outSig[ik] = (short)(lowSig[lk] - (highSig[hk] + highSig[hk + highStep] + 2 >> 2));
            lk += lowStep;
            hk += highStep;
            ik += iStep;
        }
        if (outLen > 1 && outLen % 2 == 0) {
            outSig[ik] = (short)(lowSig[lk] - (2 * highSig[hk] + 2 >> 2));
        }
        hk = highOff;
        ik = outOff;
        outSig[ik] = outLen > 1 ? (short)(highSig[hk] + outSig[ik + outStep]) : (short)(highSig[hk] >> 1);
        hk += highStep;
        ik += iStep;
        for (i = 2; i < outLen - 1; i += 2) {
            outSig[ik] = (short)(highSig[hk] + (outSig[ik - outStep] + outSig[ik + outStep] >> 1));
            hk += highStep;
            ik += iStep;
        }
        if (outLen % 2 == 1 && outLen > 1) {
            outSig[ik] = (short)(highSig[hk] + outSig[ik - outStep]);
        }
    }

    private static void print(int[] data, int w, int h) {
        for (int y = 0; y < h; ++y) {
            int yoffset = y * w;
            for (int x = 0; x < w; ++x) {
                System.err.print(" " + data[yoffset + x]);
            }
            System.err.println();
        }
    }

    public static class Subband {
        public int ulcx;
        public int ulcy;
        public int x;
        public int y;
        public int width;
        public int height;
        public Subband ll = null;
        public Subband hh = null;
        public Subband hl = null;
        public Subband lh = null;

        public String toString() {
            return "[x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height + "]    (ulcx=" + this.ulcx + ",ulcy=" + this.ulcy + ")";
        }
    }
}

