/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.Rectangle3D;
import com.ge.med.jnu.geom.Shape3D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public abstract class Rectangular3DShape
implements Cloneable,
Shape3D {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double width = 0.0;
    public double height = 0.0;
    public double depth = 0.0;

    public Rectangular3DShape() {
    }

    public Rectangular3DShape(double x, double y, double z, double w, double h, double d) {
        this.setRect(x, y, z, w, h, d);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getDepth() {
        return this.depth;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0 || this.depth <= 0.0;
    }

    public void setRect(double x, double y, double z, double w, double h, double d) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = w;
        this.height = h;
        this.depth = d;
    }

    public final void setRect(Rectangular3DShape r) {
        this.setRect(r.getX(), r.getY(), r.getZ(), r.getWidth(), r.getHeight(), r.getDepth());
    }

    public final void setFrame(double x, double y, double z, double w, double h, double d) {
        this.setRect(x, y, z, w, h, d);
    }

    @Override
    public final Rectangle3D getBounds3D() {
        return new Rectangle3D(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    @Override
    public final void getBounds3D(Rectangle3D r3d) {
        r3d.setRect(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    @Override
    public final boolean contains(JnVector3d p) {
        return this.contains(p.x, p.y, p.z);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        double x0 = this.getX();
        double y0 = this.getY();
        double z0 = this.getZ();
        return x >= x0 && y >= y0 && z >= z0 && x < x0 + this.getWidth() && y < y0 + this.getHeight() && z < z0 + this.getDepth();
    }

    @Override
    public final boolean intersects(Rectangle3D r) {
        return this.intersects(r.getX(), r.getY(), r.getZ(), r.getWidth(), r.getHeight(), r.getDepth());
    }

    @Override
    public boolean intersects(double x, double y, double z, double w, double h, double d) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0 || d <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        double z0 = this.getZ();
        return x + w > x0 && y + h > y0 && z + d > z0 && x < x0 + this.getWidth() && y < y0 + this.getHeight() && z < z0 + this.getDepth();
    }

    @Override
    public final boolean contains(Rectangle3D r) {
        return this.contains(r.getX(), r.getY(), r.getZ(), r.getWidth(), r.getHeight(), r.getDepth());
    }

    @Override
    public boolean contains(double x, double y, double z, double w, double h, double d) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0 || d <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        double z0 = this.getZ();
        return x >= x0 && y >= y0 && z >= z0 && x + w <= x0 + this.getWidth() && y + h <= y0 + this.getHeight() && z + d <= z0 + this.getDepth();
    }

    public Shape intersection(JnVector3d ul, JnVector3d ur, JnVector3d bl) {
        GeneralPath gp = new GeneralPath();
        return gp;
    }

    public final void getCenter(JnVector3d center) {
        center.x = this.x + this.width * 0.5;
        center.y = this.y + this.height * 0.5;
        center.z = this.z + this.depth * 0.5;
    }

    public final double getCenterX() {
        return this.x + this.width * 0.5;
    }

    public final double getCenterY() {
        return this.y + this.height * 0.5;
    }

    public final double getCenterZ() {
        return this.z + this.depth * 0.5;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",w=" + this.width + ",h=" + this.height + ",d=" + this.depth + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangular3DShape) {
            Rectangular3DShape r3d = (Rectangular3DShape)obj;
            return this.getX() == r3d.getX() && this.getY() == r3d.getY() && this.getZ() == r3d.getZ() && this.getWidth() == r3d.getWidth() && this.getHeight() == r3d.getHeight() && this.getDepth() == r3d.getDepth();
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getZ()) * 43L;
        bits += Double.doubleToLongBits(this.getWidth()) * 47L;
        bits += Double.doubleToLongBits(this.getHeight()) * 53L;
        return (int)(bits += Double.doubleToLongBits(this.getDepth()) * 59L) ^ (int)(bits >> 32);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

