/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.IntersectionPath;
import com.ge.med.jnu.geom.PathIterator3D;
import com.ge.med.jnu.geom.Rectangular3DShape;
import com.ge.med.jnu.geom.ShapeDescriptor;

public class Rectangle3D
extends Rectangular3DShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public static final int OUT_FRONT = 16;
    public static final int OUT_BACK = 32;
    private JnVector3d normal = new JnVector3d();
    private JnVector3d v0 = new JnVector3d();
    private JnVector3d v1 = new JnVector3d();
    private JnVector3d res = new JnVector3d();
    private boolean[] facepos = new boolean[32];
    private static final double EPSILON = 1.0E-5;

    public Rectangle3D() {
    }

    public Rectangle3D(double x, double y, double z, double w, double h, double d) {
        super(x, y, z, w, h, d);
    }

    public int outcode(double x, double y, double z) {
        int out = 0;
        if (this.width <= 0.0) {
            out |= 5;
        } else if (x < this.x) {
            out |= 1;
        } else if (x > this.x + this.width) {
            out |= 4;
        }
        if (this.height <= 0.0) {
            out |= 0xA;
        } else if (y < this.y) {
            out |= 2;
        } else if (y > this.y + this.height) {
            out |= 8;
        }
        if (this.depth <= 0.0) {
            out |= 0x30;
        } else if (z < this.z) {
            out |= 0x10;
        } else if (z > this.z + this.depth) {
            out |= 0x20;
        }
        return out;
    }

    public int outcode(JnVector3d p) {
        return this.outcode(p.x, p.y, p.z);
    }

    @Override
    public ShapeDescriptor getShapeDescriptor() {
        return new RectShapeDescriptor();
    }

    private void rayPlane(double a, double b, double c, double d, JnVector3d from, JnVector3d to, JnVector3d res) {
        double dx = to.x - from.x;
        double dy = to.y - from.y;
        double dz = to.z - from.z;
        double denom = a * dx + b * dy + c * dz;
        double num = d - a * from.x - b * from.y - c * from.z;
        double t = num / denom;
        res.set(from.x + t * dx, from.y + t * dy, from.z + t * dz);
    }

    @Override
    public PathIterator3D getIntersection(JnVector3d ul, JnVector3d ur, JnVector3d bl) {
        this.v0.sub(ur, ul);
        this.v1.sub(bl, ul);
        JnVector3d.cross(this.v0, this.v1, this.normal);
        this.normal.normalize();
        double a = this.normal.x;
        double b = this.normal.y;
        double c = this.normal.z;
        double d = a * ul.x + b * ul.y + c * ul.z;
        IntersectionPath pit = new IntersectionPath();
        RectShapeDescriptor rsd = new RectShapeDescriptor();
        int nFaces = rsd.getNumFaces();
        for (int i = 0; i < nFaces; ++i) {
            int[] face = rsd.getFace(i);
            boolean intersects = true;
            int above = 0;
            int below = 0;
            for (int j = 0; j < face.length; ++j) {
                rsd.getPoint(face[j], this.v0);
                boolean bl2 = this.facepos[j] = d - a * this.v0.x - b * this.v0.y - c * this.v0.z > 0.0;
                if (this.facepos[j]) {
                    ++above;
                    continue;
                }
                ++below;
            }
            if (above == face.length || below == face.length) continue;
            int npts = 0;
            int lface = face.length;
            for (int j = 0; j < face.length; ++j) {
                if ((!this.facepos[j % lface] || this.facepos[(j + 1) % lface]) && (this.facepos[j % lface] || !this.facepos[(j + 1) % lface])) continue;
                rsd.getPoint(face[j % lface], this.v0);
                rsd.getPoint(face[(j + 1) % lface], this.v1);
                this.rayPlane(a, b, c, d, this.v0, this.v1, this.res);
                if (npts == 0) {
                    pit.add(0, this.res.x, this.res.y, this.res.z);
                } else {
                    pit.add(1, this.res.x, this.res.y, this.res.z);
                }
                ++npts;
            }
        }
        return pit;
    }

    public class RectShapeDescriptor
    implements ShapeDescriptor.Polygonal {
        double[][] pts;
        int[][] faces;

        public RectShapeDescriptor() {
            this.pts = new double[][]{{Rectangle3D.this.x, Rectangle3D.this.y, Rectangle3D.this.z}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y, Rectangle3D.this.z}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z}, {Rectangle3D.this.x, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z}, {Rectangle3D.this.x, Rectangle3D.this.y, Rectangle3D.this.z + Rectangle3D.this.depth}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y, Rectangle3D.this.z + Rectangle3D.this.depth}, {Rectangle3D.this.x + Rectangle3D.this.width, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z + Rectangle3D.this.depth}, {Rectangle3D.this.x, Rectangle3D.this.y + Rectangle3D.this.height, Rectangle3D.this.z + Rectangle3D.this.depth}};
            this.faces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 1, 5, 4}, {2, 3, 7, 6}, {0, 3, 7, 4}, {1, 2, 6, 5}};
        }

        @Override
        public final void getPoint(int pointIdx, JnVector3d result) {
            result.x = this.pts[pointIdx][0];
            result.y = this.pts[pointIdx][1];
            result.z = this.pts[pointIdx][2];
        }

        @Override
        public final int[] getFace(int faceIdx) {
            return this.faces[faceIdx];
        }

        @Override
        public int getNumFaces() {
            return 6;
        }
    }
}

