/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.ParametricCurve3D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class PolyLine3D
implements ParametricCurve3D {
    private static final Logger LOGGER = Logger.getLogger(PolyLine3D.class.getName());
    private List points = null;
    private double[] points_t = null;
    private double[] lengths = null;
    private JnVector3d[] velocities = null;
    private double total_length = 0.0;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public synchronized void refresh() {
        this.update();
    }

    private void update() {
        if (this.points != null && this.points.size() > 0) {
            int i;
            this.lengths = new double[this.points.size() - 1];
            this.velocities = new JnVector3d[this.points.size() - 1];
            this.total_length = 0.0;
            for (i = 0; i < this.lengths.length; ++i) {
                JnVector3d temp = new JnVector3d();
                this.lengths[i] = temp.sub((double[])this.points.get(i + 1), (double[])this.points.get(i)).magnitude();
                this.velocities[i] = temp;
                this.total_length += this.lengths[i];
            }
            this.points_t = new double[this.points.size()];
            this.points_t[0] = 0.0;
            for (i = 0; i < this.points.size() - 1; ++i) {
                this.points_t[i + 1] = this.lengths[i] / this.total_length;
                this.velocities[i].multiplyBy(1.0 / this.points_t[i + 1]);
                int n = i + 1;
                this.points_t[n] = this.points_t[n] + this.points_t[i];
            }
            this.points_t[this.points.size() - 1] = 1.0;
        } else {
            this.lengths = null;
            this.velocities = null;
            this.total_length = 0.0;
        }
    }

    @Override
    public void positionAt(double t, double[] position) {
        if (this.points != null && this.points.size() > 0) {
            if (this.points_t.length == 1) {
                System.arraycopy(this.points.get(0), 0, position, 0, 3);
                return;
            }
            for (int i = 0; i < this.points_t.length - 1; ++i) {
                if (!(t < this.points_t[i + 1])) continue;
                System.arraycopy(this.points.get(i), 0, position, 0, 3);
                double scale = t - this.points_t[i];
                position[0] = position[0] + scale * this.velocities[i].x;
                position[1] = position[1] + scale * this.velocities[i].y;
                position[2] = position[2] + scale * this.velocities[i].z;
                return;
            }
            if (t == 1.0) {
                System.arraycopy(this.points.get(this.points.size() - 1), 0, position, 0, 3);
                return;
            }
        }
        throw new RuntimeException("Error in curve position at t=" + t);
    }

    @Override
    public void velocityAt(double t, double[] velocity) {
        for (int i = 0; i < this.points_t.length - 1; ++i) {
            if (!(t < this.points_t[i + 1])) continue;
            velocity[0] = this.velocities[i].x;
            velocity[1] = this.velocities[i].y;
            velocity[2] = this.velocities[i].z;
            return;
        }
        throw new RuntimeException("Error in curve velocity at t=" + t);
    }

    @Override
    public synchronized double length() {
        return this.total_length;
    }

    @Override
    public List getControlPoints() {
        return this.points;
    }

    @Override
    public synchronized void setControlPoints(List points) {
        this.points = points;
        Iterator itr = this.points.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            LOGGER.warning("Null value in control point list. The null control point has been removed.");
            itr.remove();
        }
        this.update();
        this.pcs.firePropertyChange("CURVE_PROPERTY", null, this);
    }

    @Override
    public synchronized Object clone() {
        PolyLine3D copy;
        try {
            copy = (PolyLine3D)super.clone();
        }
        catch (CloneNotSupportedException e) {
            copy = new PolyLine3D();
        }
        copy.points = new ArrayList(this.points.size());
        Iterator itr = this.points.iterator();
        while (itr.hasNext()) {
            copy.points.add(((double[])itr.next()).clone());
        }
        copy.points_t = this.points_t;
        copy.lengths = this.lengths;
        copy.velocities = this.velocities;
        copy.total_length = this.total_length;
        return copy;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(prop, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }
}

