/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.jnu.geom.JnRectangle2D;
import com.ge.med.jnu.geom.JnShape;

public abstract class JnLine2D
implements JnShape {
    protected JnLine2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract JnPoint2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract JnPoint2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(JnPoint2D p1, JnPoint2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(JnLine2D l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(JnPoint2D p) {
        return false;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new JnRectangle2D.Double(x, y, w, h));
    }

    public boolean intersects(JnRectangle2D r) {
        return r.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(JnRectangle2D r) {
        return false;
    }

    @Override
    public JnRectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public static class Double
    extends JnLine2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Double(JnPoint2D p1, JnPoint2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public JnPoint2D getP1() {
            return new JnPoint2D.Double(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public JnPoint2D getP2() {
            return new JnPoint2D.Double(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            double h;
            double y;
            double w;
            double x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new JnRectangle2D.Double(x, y, w, h);
        }
    }

    public static class Float
    extends JnLine2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Float(JnPoint2D p1, JnPoint2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public JnPoint2D getP1() {
            return new JnPoint2D.Float(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public JnPoint2D getP2() {
            return new JnPoint2D.Float(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            float h;
            float y;
            float w;
            float x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new JnRectangle2D.Float(x, y, w, h);
        }
    }
}

