/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.PathIterator3D;

public class IntersectionPath
implements PathIterator3D {
    private static String[] types = new String[]{"MOVETO", "LINETO"};
    private boolean done = false;
    private int maxpts = 0;
    private int numpts = 0;
    private JnVector3d[] pts = null;
    private int[] type = null;
    private int cIdx = 0;

    public IntersectionPath() {
        this.resize(128);
        this.reset();
    }

    public final JnVector3d get(int idx) {
        return this.pts[idx];
    }

    private void resize(int newmax) {
        int i;
        JnVector3d[] newpts = new JnVector3d[newmax];
        int[] newtype = new int[newmax];
        for (i = this.maxpts; i < newmax; ++i) {
            newpts[i] = new JnVector3d();
        }
        for (i = 0; i < this.maxpts; ++i) {
            newpts[i] = this.pts[i];
            newtype[i] = this.type[i];
        }
        this.pts = newpts;
        this.type = newtype;
        this.maxpts = newmax;
    }

    public void add(int typeval, double x, double y, double z) {
        this.pts[this.numpts].setLocation(x, y, z);
        this.type[this.numpts] = typeval;
        ++this.numpts;
    }

    public final int getNumPts() {
        return this.numpts;
    }

    @Override
    public void reset() {
        this.done = false;
        this.cIdx = 0;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        ++this.cIdx;
        if (this.cIdx >= this.numpts) {
            this.done = true;
        }
    }

    @Override
    public int currentSegment(JnVector3d pos) {
        pos.setLocation(this.pts[this.cIdx]);
        return this.type[this.cIdx];
    }

    public String toString() {
        String str = "IntersectionPath[" + this.numpts + "]\n----------------------\n";
        for (int i = 0; i < this.numpts; ++i) {
            str = str + types[this.type[i]] + "   :   " + this.pts[i] + "\n";
        }
        return str;
    }
}

