/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;

public class Frustum {
    private double[] v_pt = new double[3];
    private double[] temprow = new double[3];
    private double[] pt = new double[3];

    public void genFrustumView(int width, int height, double[] ulhc_pt, double[] eyept, double[] xdir, double[] ydir, double[] zdir, float[] directions) {
        this.temprow[0] = ulhc_pt[0];
        this.temprow[1] = ulhc_pt[1];
        this.temprow[2] = ulhc_pt[2];
        double step_len = JnVector3d.length(zdir);
        int rowlen = width * 3;
        for (int y = 0; y < height; ++y) {
            int yoffset = y * rowlen;
            int xx = 0;
            this.pt[0] = this.temprow[0];
            this.pt[1] = this.temprow[1];
            this.pt[2] = this.temprow[2];
            int x = 0;
            while (x < width) {
                int idx = yoffset + xx;
                JnVector3d.sub(this.pt, eyept, this.v_pt);
                double lenscale = step_len / JnVector3d.length(this.v_pt);
                directions[idx] = (float)(this.v_pt[0] * lenscale);
                directions[idx + 1] = (float)(this.v_pt[1] * lenscale);
                directions[idx + 2] = (float)(this.v_pt[2] * lenscale);
                this.pt[0] = this.pt[0] + xdir[0];
                this.pt[1] = this.pt[1] + xdir[1];
                this.pt[2] = this.pt[2] + xdir[2];
                ++x;
                xx += 3;
            }
            this.temprow[0] = this.temprow[0] + ydir[0];
            this.temprow[1] = this.temprow[1] + ydir[1];
            this.temprow[2] = this.temprow[2] + ydir[2];
        }
    }

    public static void main(String[] args) {
        int ITER = 200;
        int DIM = 1024;
        Frustum fr = new Frustum();
        float[] dir = new float[0x300000];
        double[] ulhc = new double[]{-512.0, -512.0, 0.0};
        double[] xdir = new double[]{1.0, 0.0, 0.0};
        double[] ydir = new double[]{0.0, 1.0, 0.0};
        double[] zdir = new double[]{0.0, 0.0, 1.0};
        double[] eyept = new double[]{0.0, 0.0, -10.0};
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 200; ++i) {
            fr.genFrustumView(1024, 1024, ulhc, eyept, xdir, ydir, zdir, dir);
        }
        long t1 = System.currentTimeMillis();
        long t = t1 - t0;
        double avgtime = (double)t / 200.0;
        System.err.println("Avg Frustum Generation: " + avgtime);
    }
}

