/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnUtils;

public class JnVector4d
implements Cloneable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 0.0;

    public JnVector4d() {
    }

    public JnVector4d(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public final double[] toArray() {
        return new double[]{this.x, this.y, this.z, this.w};
    }

    public final void get(double[] v) {
        v[0] = this.x;
        v[1] = this.y;
        v[2] = this.z;
        if (v.length > 3) {
            v[3] = this.w;
        }
    }

    public final void set(JnVector4d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public final void set(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
        this.w = v.length > 3 ? v[3] : 1.0;
    }

    public final void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final void add(JnVector4d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.w += v.w;
    }

    public final void add(JnVector4d v1, JnVector4d v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
        this.w = v1.w + v2.w;
    }

    public final void sub(JnVector4d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        this.w -= v.w;
    }

    public final void sub(JnVector4d v1, JnVector4d v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
        this.w = v1.w - v2.w;
    }

    public final void add(double[] v) {
        this.x += v[0];
        this.y += v[1];
        this.z += v[2];
        this.w += v[3];
    }

    public final void add(double[] v1, double[] v2) {
        this.x = v1[0] + v2[0];
        this.y = v1[1] + v2[1];
        this.z = v1[2] + v2[2];
        this.w = v1.length > 3 ? v1[3] + v2[3] : 1.0;
    }

    public final void sub(double[] v) {
        this.x -= v[0];
        this.y -= v[1];
        this.z -= v[2];
        this.w -= v.length > 3 ? v[3] : 1.0;
    }

    public final void sub(double[] v1, double[] v2) {
        this.x = v1[0] - v2[0];
        this.y = v1[1] - v2[1];
        this.z = v1[2] - v2[2];
        this.w = v1.length > 3 ? v1[3] - v2[3] : 1.0;
    }

    public final void scale(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
    }

    public final void scaleAdd(double s, JnVector4d v) {
        this.x += s * v.x;
        this.y += s * v.y;
        this.z += s * v.z;
        this.w += s * v.w;
    }

    public final void scaleAdd(double s, JnVector4d v1, JnVector4d v2) {
        this.x = s * v1.x + v2.x;
        this.y = s * v1.y + v2.y;
        this.z = s * v1.z + v2.z;
        this.w = s * v1.w + v2.w;
    }

    public final void scaleAdd(double s, double[] v) {
        this.x += s * v[0];
        this.y += s * v[1];
        this.z += s * v[2];
        this.w += s * v[3];
    }

    public final void scaleAdd(double s, double[] v1, double[] v2) {
        this.x = s * v1[0] + v2[0];
        this.y = s * v1[1] + v2[1];
        this.z = s * v1[2] + v2[2];
        this.w = s * v1[3] + v2[3];
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double dot(JnVector4d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public final double angle(JnVector4d v) {
        double dotVal = this.dot(v);
        double l1 = this.length();
        double l2 = v.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final void normalize() {
        double len = this.length();
        this.x /= len;
        this.y /= len;
        this.z /= len;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        JnVector4d v3d = (JnVector4d)other;
        if (v3d != null) {
            return this.x == v3d.x && this.y == v3d.y && this.z == v3d.z && this.w == v3d.w;
        }
        return false;
    }

    public final String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "," + this.w + "]";
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.x);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.y);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.z);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.w);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

