/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnTuple3i;

public class JnVector3i
extends JnTuple3i {
    public JnVector3i() {
    }

    public JnVector3i(int x, int y, int z) {
        this.set(x, y, z);
    }

    public JnVector3i(int[] v) {
        this.set(v);
    }

    public final void get(int[] v) {
        v[0] = this.x;
        v[1] = this.y;
        v[2] = this.z;
    }

    public final void set(JnVector3i v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void set(int[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    public final void add(JnVector3i v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public final void add(JnVector3i v1, JnVector3i v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
    }

    public final void sub(JnVector3i v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public final void sub(JnVector3i v1, JnVector3i v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
    }

    public final void scale(int s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public final void scaleAdd(int s, JnVector3i v) {
        this.x += s * v.x;
        this.y += s * v.y;
        this.z += s * v.z;
    }

    public final void scaleAdd(int s, JnVector3i v1, JnVector3i v2) {
        this.x = s * v1.x + v2.x;
        this.y = s * v1.y + v2.y;
        this.z = s * v1.z + v2.z;
    }

    public final int lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final int dot(JnVector3i v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public static JnVector3i cross(JnVector3i v1, JnVector3i v2) {
        JnVector3i result = new JnVector3i();
        JnVector3i.cross(v1, v2, result);
        return result;
    }

    public static void cross(JnVector3i v1, JnVector3i v2, JnVector3i result) {
        result.x = v1.y * v2.z - v1.z * v2.y;
        result.y = v1.z * v2.x - v1.x * v2.z;
        result.z = v1.x * v2.y - v1.y * v2.x;
    }

    public static JnVector3i cross(int[] v1, int[] v2) {
        JnVector3i result = new JnVector3i();
        result.x = v1[1] * v2[2] - v1[2] * v2[1];
        result.y = v1[2] * v2[0] - v1[0] * v2[2];
        result.z = v1[0] * v2[1] - v1[1] * v2[0];
        return result;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        JnVector3i v3d = (JnVector3i)other;
        if (v3d != null) {
            return this.x == v3d.x && this.y == v3d.y && this.z == v3d.z;
        }
        return false;
    }

    public final double angle(JnVector3i v) {
        double dotVal = this.dot(v);
        double l1 = this.length();
        double l2 = v.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final int[] generateArray() {
        int[] a = new int[]{this.x, this.y, this.z};
        return a;
    }

    public final String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public final void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void setLocation(JnVector3i v) {
        this.setLocation(v.x, v.y, v.z);
    }

    public final int magnitudeSq() {
        return this.lengthSquared();
    }

    public final double magnitude() {
        return this.length();
    }

    public final void subtract(JnVector3i p) {
        this.sub(p);
    }

    public final void multiplyBy(int d) {
        this.scale(d);
    }

    public final double distance(JnVector3i p) {
        return Math.sqrt(this.sqDistance(p));
    }

    public final int sqDistance(JnVector3i p) {
        int dx = p.x - this.x;
        int dy = p.y - this.y;
        int dz = p.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final void fillArray(int[] array, int offset, int stride) {
        array[offset] = this.x;
        array[offset + stride] = this.y;
        array[offset + 2 * stride] = this.z;
    }

    public final void fillArray(int[] array, int offset) {
        this.fillArray(array, offset, 1);
    }

    public final Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }
}

