/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnUtils;
import java.io.PrintStream;
import java.util.Arrays;

public class JnVector {
    public double[] data = null;

    public JnVector(int n) {
        this.data = new double[n];
    }

    public JnVector(double[] d) {
        this.data = new double[d.length];
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public JnVector(JnVector v) {
        this.data = new double[v.data.length];
        this.set(v);
    }

    public final int getSize() {
        return this.data.length;
    }

    public final boolean set(double[] data) {
        if (this.data.length != data.length) {
            return false;
        }
        System.arraycopy(data, 0, this.data, 0, data.length);
        return true;
    }

    public final boolean equals(Object o) {
        JnVector m = (JnVector)o;
        if (m != null) {
            for (int i = 0; i < this.data.length; ++i) {
                double val = Math.abs(this.data[i] - m.data[i]);
                if (JnUtils.zero(val)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final void set(JnVector v) {
        if (v.data.length != this.data.length) {
            return;
        }
        System.arraycopy(v.data, 0, this.data, 0, this.data.length);
    }

    public final void add(JnVector v) {
        if (v.data.length != this.data.length) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.data[i];
        }
    }

    public final void add(JnVector v1, JnVector v2) {
        if (v1.data.length != this.data.length) {
            return;
        }
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = v1.data[i] + v2.data[i];
        }
    }

    public final void sub(JnVector v) {
        if (v.data.length != this.data.length) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - v.data[i];
        }
    }

    public final void sub(JnVector v1, JnVector v2) {
        if (v1.data.length != this.data.length) {
            return;
        }
        if (v2.data.length != this.data.length) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = v1.data[i] - v2.data[i];
        }
    }

    public final void scale(double s) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * s;
        }
    }

    public final void scaleAdd(double s, JnVector v) {
        if (v.data.length != this.data.length) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + s * v.data[i];
        }
    }

    public final double lengthSquared() {
        double val = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            val += this.data[i] * this.data[i];
        }
        return val;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double dot(JnVector v) {
        if (v.data.length != this.data.length) {
            return Double.NaN;
        }
        double val = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            val += this.data[i] * v.data[i];
        }
        return val;
    }

    public final double angle(JnVector v) {
        double dotVal = this.dot(v);
        double l1 = this.length();
        double l2 = v.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final void normalize() {
        double len = this.length();
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] / len;
        }
    }

    public final void printVector() {
        this.printVector(System.out);
    }

    public final void printVector(PrintStream ps) {
        for (int i = 0; i < this.data.length; ++i) {
            String val = JnUtils.format(this.data[i]);
            ps.print(val + " ");
            ps.println();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

