/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnSingularMatrixException;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector3d;
import java.io.PrintStream;

public class JnMatrix3d
implements Cloneable {
    private static double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    public double m00 = 0.0;
    public double m01 = 0.0;
    public double m02 = 0.0;
    public double m10 = 0.0;
    public double m11 = 0.0;
    public double m12 = 0.0;
    public double m20 = 0.0;
    public double m21 = 0.0;
    public double m22 = 0.0;

    public JnMatrix3d() {
    }

    public JnMatrix3d(JnMatrix3d m) {
        this.set(m);
    }

    public JnMatrix3d(double[] data) {
        this.set(data);
    }

    public final boolean equals(Object o) {
        JnMatrix3d m = (JnMatrix3d)o;
        if (m != null) {
            boolean r1 = this.m00 == m.m00 && this.m01 == m.m01 && this.m02 == m.m02;
            boolean r2 = this.m10 == m.m10 && this.m11 == m.m11 && this.m12 == m.m12;
            boolean r3 = this.m20 == m.m20 && this.m21 == m.m21 && this.m22 == m.m22;
            return r1 && r2 && r3;
        }
        return false;
    }

    public final void set(double[] data) {
        this.m00 = data[0];
        this.m01 = data[1];
        this.m02 = data[2];
        this.m10 = data[3];
        this.m11 = data[4];
        this.m12 = data[5];
        this.m20 = data[6];
        this.m21 = data[7];
        this.m22 = data[8];
    }

    public final void set(JnMatrix3d m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
    }

    public final void get(double[] data) {
        data[0] = this.m00;
        data[1] = this.m01;
        data[2] = this.m02;
        data[3] = this.m10;
        data[4] = this.m11;
        data[5] = this.m12;
        data[6] = this.m20;
        data[7] = this.m21;
        data[8] = this.m22;
    }

    public final void setRotate(double angle, double x, double y, double z) {
        double length = Math.sqrt(x * x + y * y + z * z);
        double xx = x / length;
        double yy = y / length;
        double zz = z / length;
        double cosa = Math.cos(angle);
        double sina = Math.sin(angle);
        this.m00 = xx * xx;
        this.m01 = xx * yy;
        this.m02 = xx * zz;
        this.m10 = yy * xx;
        this.m11 = yy * yy;
        this.m12 = yy * zz;
        this.m20 = zz * xx;
        this.m21 = zz * yy;
        this.m22 = zz * zz;
        this.m00 += cosa * (1.0 - this.m00);
        this.m01 += cosa * -this.m01 + sina * -zz;
        this.m02 += cosa * -this.m02 + sina * yy;
        this.m10 += cosa * -this.m10 + sina * zz;
        this.m11 += cosa * (1.0 - this.m11);
        this.m12 += cosa * -this.m12 + sina * -xx;
        this.m20 += cosa * -this.m20 + sina * -yy;
        this.m21 += cosa * -this.m21 + sina * xx;
        this.m22 += cosa * (1.0 - this.m22);
    }

    public final void rotX(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.m00 = 1.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = c;
        this.m12 = -s;
        this.m20 = 0.0;
        this.m21 = s;
        this.m22 = c;
    }

    public final void rotY(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.m00 = c;
        this.m01 = 0.0;
        this.m02 = s;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = -s;
        this.m21 = 0.0;
        this.m22 = c;
    }

    public final void rotZ(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = 0.0;
        this.m10 = s;
        this.m11 = c;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void add(double scalar) {
        this.m00 += scalar;
        this.m01 += scalar;
        this.m02 += scalar;
        this.m10 += scalar;
        this.m11 += scalar;
        this.m12 += scalar;
        this.m20 += scalar;
        this.m21 += scalar;
        this.m22 += scalar;
    }

    public final void add(double scalar, JnMatrix3d m1) {
        this.m00 = m1.m00 + scalar;
        this.m01 = m1.m01 + scalar;
        this.m02 = m1.m02 + scalar;
        this.m10 = m1.m10 + scalar;
        this.m11 = m1.m11 + scalar;
        this.m12 = m1.m12 + scalar;
        this.m20 = m1.m20 + scalar;
        this.m21 = m1.m21 + scalar;
        this.m22 = m1.m22 + scalar;
    }

    public final void setIdentity() {
        this.set(identity);
    }

    public final void setScale(double s) {
        this.set(identity);
        this.m00 = s;
        this.m11 = s;
        this.m22 = s;
    }

    public final JnMatrix3d transpose() {
        double d01 = this.m01;
        double d02 = this.m02;
        double d10 = this.m10;
        double d12 = this.m12;
        double d20 = this.m20;
        double d21 = this.m21;
        this.m01 = d10;
        this.m10 = d01;
        this.m02 = d20;
        this.m20 = d02;
        this.m12 = d21;
        this.m21 = d12;
        return this;
    }

    public final JnVector3d getRow(int row, JnVector3d result) {
        if (result == null) {
            result = new JnVector3d();
        }
        double[] elems = new double[9];
        this.get(elems);
        int rowStart = row + row + row;
        result.set(elems[rowStart], elems[rowStart + 1], elems[rowStart + 2]);
        return result;
    }

    public final JnVector3d getCol(int col, JnVector3d result) {
        if (result == null) {
            result = new JnVector3d();
        }
        double[] elems = new double[9];
        this.get(elems);
        result.set(elems[col], elems[col + 3], elems[col + 6]);
        return result;
    }

    public final void transform(JnVector3d t) {
        double x = this.m00 * t.x + this.m01 * t.y + this.m02 * t.z;
        double y = this.m10 * t.x + this.m11 * t.y + this.m12 * t.z;
        double z = this.m20 * t.x + this.m21 * t.y + this.m22 * t.z;
        t.x = x;
        t.y = y;
        t.z = z;
    }

    public final void transform(JnVector3d t, double p_x, double p_y, double p_z) {
        double tx = t.x - p_x;
        double ty = t.y - p_y;
        double tz = t.z - p_z;
        double x = this.m00 * tx + this.m01 * ty + this.m02 * tz;
        double y = this.m10 * tx + this.m11 * ty + this.m12 * tz;
        double z = this.m20 * tx + this.m21 * ty + this.m22 * tz;
        t.x = x + p_x;
        t.y = y + p_y;
        t.z = z + p_y;
    }

    public final void transform(double[] t, double p_x, double p_y, double p_z) {
        double tx = t[0] - p_x;
        double ty = t[1] - p_y;
        double tz = t[2] - p_z;
        double x = this.m00 * tx + this.m01 * ty + this.m02 * tz;
        double y = this.m10 * tx + this.m11 * ty + this.m12 * tz;
        double z = this.m20 * tx + this.m21 * ty + this.m22 * tz;
        t[0] = x + p_x;
        t[1] = y + p_y;
        t[2] = z + p_z;
    }

    public final void transform(double[] t) {
        double tx = t[0];
        double ty = t[1];
        double tz = t[2];
        double x = this.m00 * tx + this.m01 * ty + this.m02 * tz;
        double y = this.m10 * tx + this.m11 * ty + this.m12 * tz;
        double z = this.m20 * tx + this.m21 * ty + this.m22 * tz;
        t[0] = x;
        t[1] = y;
        t[2] = z;
    }

    public final void transform(JnVector3d t, JnVector3d res) {
        res.x = this.m00 * t.x + this.m01 * t.y + this.m02 * t.z;
        res.y = this.m10 * t.x + this.m11 * t.y + this.m12 * t.z;
        res.z = this.m20 * t.x + this.m21 * t.y + this.m22 * t.z;
    }

    public final void mul(double scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
    }

    public final void mul(double scalar, JnMatrix3d m) {
        this.m00 = m.m00 * scalar;
        this.m01 = m.m01 * scalar;
        this.m02 = m.m02 * scalar;
        this.m10 = m.m10 * scalar;
        this.m11 = m.m11 * scalar;
        this.m12 = m.m12 * scalar;
        this.m20 = m.m20 * scalar;
        this.m21 = m.m21 * scalar;
        this.m22 = m.m22 * scalar;
    }

    public final void mul(JnMatrix3d m1, JnMatrix3d m2) {
        double d00 = m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20;
        double d01 = m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21;
        double d02 = m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22;
        double d10 = m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20;
        double d11 = m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21;
        double d12 = m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22;
        double d20 = m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20;
        double d21 = m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21;
        double d22 = m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22;
        this.set(d00, d01, d02, d10, d11, d12, d20, d21, d22);
    }

    public final void set(double d00, double d01, double d02, double d10, double d11, double d12, double d20, double d21, double d22) {
        this.m00 = d00;
        this.m01 = d01;
        this.m02 = d02;
        this.m10 = d10;
        this.m11 = d11;
        this.m12 = d12;
        this.m20 = d20;
        this.m21 = d21;
        this.m22 = d22;
    }

    public final void mul(JnMatrix3d m1) {
        double d00 = m1.m00 * this.m00 + m1.m01 * this.m10 + m1.m02 * this.m20;
        double d01 = m1.m00 * this.m01 + m1.m01 * this.m11 + m1.m02 * this.m21;
        double d02 = m1.m00 * this.m02 + m1.m01 * this.m12 + m1.m02 * this.m22;
        double d10 = m1.m10 * this.m00 + m1.m11 * this.m10 + m1.m12 * this.m20;
        double d11 = m1.m10 * this.m01 + m1.m11 * this.m11 + m1.m12 * this.m21;
        double d12 = m1.m10 * this.m02 + m1.m11 * this.m12 + m1.m12 * this.m22;
        double d20 = m1.m20 * this.m00 + m1.m21 * this.m10 + m1.m22 * this.m20;
        double d21 = m1.m20 * this.m01 + m1.m21 * this.m11 + m1.m22 * this.m21;
        double d22 = m1.m20 * this.m02 + m1.m21 * this.m12 + m1.m22 * this.m22;
        this.set(d00, d01, d02, d10, d11, d12, d20, d21, d22);
    }

    public final void negate() {
        this.mul(-1.0);
    }

    public final double determinant() {
        return this.m00 * this.m11 * this.m22 - this.m00 * this.m12 * this.m21 + this.m01 * this.m12 * this.m20 - this.m01 * this.m10 * this.m22 + this.m02 * this.m10 * this.m21 - this.m02 * this.m11 * this.m20;
    }

    public final void invert() {
        double det = this.determinant();
        double absDet = Math.abs(det);
        if (absDet < 1.0E-10) {
            throw new JnSingularMatrixException("SingularMatrixException Determinant=" + det);
        }
        det = 1.0 / det;
        double d00 = det * (this.m11 * this.m22 - this.m21 * this.m12);
        double d01 = det * (this.m02 * this.m21 - this.m22 * this.m01);
        double d02 = det * (this.m01 * this.m12 - this.m11 * this.m02);
        double d10 = det * (this.m12 * this.m20 - this.m22 * this.m10);
        double d11 = det * (this.m00 * this.m22 - this.m20 * this.m02);
        double d12 = det * (this.m02 * this.m10 - this.m12 * this.m00);
        double d20 = det * (this.m10 * this.m21 - this.m20 * this.m11);
        double d21 = det * (this.m01 * this.m20 - this.m21 * this.m00);
        double d22 = det * (this.m00 * this.m11 - this.m10 * this.m01);
        this.set(d00, d01, d02, d10, d11, d12, d20, d21, d22);
    }

    public final void invert(JnMatrix3d m) {
        this.set(m);
        this.invert();
    }

    public final void printMatrix() {
        this.printMatrix(System.out);
    }

    public final void printMatrix(PrintStream ps) {
        double[] data = new double[9];
        this.get(data);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String val = JnUtils.format(data[i * 3 + j]);
                ps.print(val + " ");
            }
            ps.println();
        }
    }

    public final String toString() {
        return "[ " + this.m00 + "," + this.m01 + "," + this.m02 + "," + this.m10 + "," + this.m11 + "," + this.m12 + "," + this.m20 + "," + this.m21 + "," + this.m22 + " ]";
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.m00);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m01);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m02);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m10);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m11);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m12);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m20);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m21);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m22);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

