/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import sun.font.CompositeFont;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontAccess;
import sun.font.FontManagerFactory;
import sun.font.PhysicalFont;
import sun.font.SunFontManager;

public class Fonts {
    private static SunFontManager fontManager_ = (SunFontManager)FontManagerFactory.getInstance();
    private static Collection<String> javaLogicalFamilies_ = Arrays.asList("Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput");
    private static Logger logger_ = Logger.getLogger(Fonts.class.getName());
    private static Map<String, String> familyIndex_ = new HashMap<String, String>();
    private static Set<String> platformFontFamilyNames_ = null;
    private static Set<String> unavailableFamilyNames_ = new HashSet<String>();

    public static Font getFontUIResource(Font base) {
        if (base instanceof FontWrapper.PublicFont) {
            return ((FontWrapper.PublicFont)base).getFontUIResource();
        }
        if (base instanceof FontUIResource) {
            return base;
        }
        return new FontUIResource(base);
    }

    private static String join(List<String> list) {
        StringBuffer sb = new StringBuffer();
        String separator = " + ";
        for (String s : list) {
            sb.append(s).append(separator);
        }
        return sb.delete(Math.max(sb.length() - separator.length(), 0), sb.length()).toString();
    }

    public static Font getFont(List<String> families, int style) {
        FontWrapper fw;
        String joinedFamilies = Fonts.join(families);
        String family = familyIndex_.get(joinedFamilies);
        logger_.log(Level.FINE, "Loading font " + joinedFamilies + " (" + family + ") " + style);
        if (family != null && (fw = FontWrapper.get(family, style)) != null) {
            return fw.getPublicFont();
        }
        LinkedHashSet<FontWrapper> simpleFontWrappers = new LinkedHashSet<FontWrapper>();
        for (String f : families) {
            fw = Fonts.getSimple(f, style);
            if (fw == null) continue;
            simpleFontWrappers.add(fw);
        }
        if (simpleFontWrappers.isEmpty()) {
            family = "Dialog";
            familyIndex_.put(joinedFamilies, "Dialog");
            logger_.log(Level.SEVERE, "No fonts for " + joinedFamilies + ", returning " + family + ".");
            return Fonts.getSimple(family, style).getPublicFont();
        }
        if (simpleFontWrappers.size() == 1) {
            fw = (FontWrapper)simpleFontWrappers.iterator().next();
            family = fw.family_;
            familyIndex_.put(joinedFamilies, family);
            logger_.log(Level.FINE, "Simple font located for " + joinedFamilies + ", returning " + family + ".");
            return fw.getPublicFont();
        }
        LinkedList<String> nameList = new LinkedList<String>();
        LinkedList<String> fileList = new LinkedList<String>();
        LinkedList<String> fallbackNameList = new LinkedList<String>();
        LinkedList<String> fallbackFileList = new LinkedList<String>();
        Iterator i = simpleFontWrappers.iterator();
        while (i.hasNext()) {
            String file;
            String name;
            fw = (FontWrapper)i.next();
            Font2D f2d = FontAccess.getFontAccess().getFont2D(fw.getInternalFont());
            logger_.log(Level.FINE, "Listing physical fonts for " + fw + ".");
            int flSize = fileList.size() + fallbackFileList.size();
            boolean logical = javaLogicalFamilies_.contains(fw.family_);
            boolean last = !i.hasNext();
            for (FileFont ff : Fonts.getFileFonts(f2d, logical && last ? FileFontType.NONE : FileFontType.CORE)) {
                name = ff.getFontName(null);
                file = Fonts.getFileName(ff);
                if (name == null || file == null || nameList.contains(name) && fileList.contains(file)) continue;
                logger_.log(Level.FINE, "Adding core physical font " + name + " (" + file + ")");
                nameList.add(name);
                fileList.add(file);
            }
            for (FileFont ff : Fonts.getFileFonts(f2d, logical && last ? FileFontType.ALL : FileFontType.FALLBACK)) {
                name = ff.getFontName(null);
                file = Fonts.getFileName(ff);
                if (name == null || file == null || fallbackNameList.contains(name) && fallbackFileList.contains(file)) continue;
                logger_.log(Level.FINE, "Adding fallback physical font " + name + " (" + file + ")");
                fallbackNameList.add(name);
                fallbackFileList.add(file);
            }
            if (fileList.size() + fallbackFileList.size() != flSize) continue;
            i.remove();
        }
        Iterator fni = fallbackNameList.iterator();
        Iterator ffi = fallbackFileList.iterator();
        while (fni.hasNext() && ffi.hasNext()) {
            String name = (String)fni.next();
            String file = (String)ffi.next();
            if (!nameList.contains(name) && !fileList.contains(file)) continue;
            fni.remove();
            ffi.remove();
        }
        if (simpleFontWrappers.isEmpty() || fileList.isEmpty() && fallbackFileList.isEmpty()) {
            family = "Dialog";
            familyIndex_.put(joinedFamilies, "Dialog");
            logger_.log(Level.SEVERE, "No accessible font files for " + joinedFamilies + ", returning " + family + ".");
            return Fonts.getSimple(family, style).getPublicFont();
        }
        LinkedList<String> fwf = new LinkedList<String>();
        for (FontWrapper w : simpleFontWrappers) {
            fwf.add(w.family_);
        }
        family = Fonts.join(fwf);
        familyIndex_.put(joinedFamilies, family);
        fw = FontWrapper.get(family, style);
        if (fw != null) {
            logger_.log(Level.FINE, "Previously loaded font located for " + joinedFamilies + ", returning " + family + ".");
            return fw.getPublicFont();
        }
        if (simpleFontWrappers.size() == 1) {
            fw = (FontWrapper)simpleFontWrappers.iterator().next();
            family = fw.family_;
            familyIndex_.put(joinedFamilies, family);
            logger_.log(Level.FINE, "Simple (single physical font) font located for " + joinedFamilies + ", returning " + family + ".");
            return fw.getPublicFont();
        }
        logger_.log(Level.INFO, "Creating new composite font for " + joinedFamilies + " (" + family + ").");
        int coreCount = Math.max(fileList.size(), 1);
        nameList.addAll(fallbackNameList);
        fileList.addAll(fallbackFileList);
        String[] names = nameList.toArray(new String[0]);
        String[] files = fileList.toArray(new String[0]);
        HashMap<TextAttribute, String> attributes = new HashMap<TextAttribute, String>();
        attributes.put(TextAttribute.FAMILY, family);
        Font composite = new Font(attributes);
        CompositeFont composite2D = new CompositeFont(family, files, names, coreCount, null, null, false, fontManager_);
        FontAccess.getFontAccess().setFont2D(composite, new Font2DHandle(composite2D));
        Font font = new CompositeFontWrapper(simpleFontWrappers, files, names, composite2D, composite, family, style).getPublicFont();
        FontAccess.getFontAccess().setCreatedFont(font);
        GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        return font;
    }

    private static FontWrapper getSimple(String family, int style) {
        if (unavailableFamilyNames_.contains(family)) {
            return null;
        }
        FontWrapper fw = FontWrapper.get(family, style);
        if (fw != null) {
            return fw;
        }
        Font font = new Font(family, style, 13);
        if (!family.equals(font.getFamily())) {
            logger_.log(Level.WARNING, "Font " + family + " not available.");
            unavailableFamilyNames_.add(family);
            return null;
        }
        logger_.log(Level.INFO, "Font " + family + " loaded.");
        return new SimpleFontWrapper(font, family, style, 13.0f);
    }

    public static boolean addURLFont(String family, int style, URL url) {
        if (FontWrapper.get(family, style) != null) {
            return true;
        }
        new URLFontWrapper(url, family, style);
        return true;
    }

    private static int getCoreFontCount(CompositeFont compositeFont) {
        try {
            Field f = CompositeFont.class.getDeclaredField("numMetricsSlots");
            f.setAccessible(true);
            return f.getInt(compositeFont);
        }
        catch (Exception ex) {
            logger_.log(Level.SEVERE, "Access to non-public field sun.font.CompositeFont.numMetricsSlots failed.", ex);
            return 1;
        }
    }

    private static String getFileName(FileFont fileFont) {
        try {
            Method m = FileFont.class.getDeclaredMethod("getPublicFileName", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)fileFont, new Object[0]);
        }
        catch (Exception ex) {
            logger_.log(Level.SEVERE, "Access to non-public method sun.font.FileFont.getPublicFileName failed.", ex);
            String s = fileFont.toString();
            return s.substring(s.indexOf(" fileName=") + " fileName=".length()).trim();
        }
    }

    private static Set<FileFont> getFileFonts(Font2D font2D, FileFontType ... fileFontType) {
        LinkedHashSet<FileFont> fileFonts = new LinkedHashSet<FileFont>();
        if (fileFontType[0] == FileFontType.NONE) {
            return fileFonts;
        }
        if (font2D instanceof FileFont && (fileFontType[0] == FileFontType.ALL || fileFontType.length == 1 && fileFontType[0] == FileFontType.CORE || fileFontType.length == 2 && fileFontType[0] == fileFontType[1])) {
            fileFonts.add((FileFont)font2D);
        }
        if (font2D instanceof CompositeFont) {
            CompositeFont compositeFont = (CompositeFont)font2D;
            int coreFontCount = Fonts.getCoreFontCount(compositeFont);
            for (int i = 0; i < compositeFont.getNumSlots(); ++i) {
                PhysicalFont f2D = compositeFont.getSlotFont(i);
                FileFontType fft = i < coreFontCount ? FileFontType.CORE : FileFontType.FALLBACK;
                fileFonts.addAll(Fonts.getFileFonts(f2D, fileFontType[0], fft));
            }
        }
        return fileFonts;
    }

    public static void showFont(Level level, Font font) {
        if (font == null) {
            return;
        }
        logger_.log(level, font + " (" + font.getClass().getName() + " " + "0x" + Integer.toHexString(System.identityHashCode(font)) + ")" + (font instanceof UIResource ? " UIResource" : ""));
        for (Map.Entry<TextAttribute, ?> a : font.getAttributes().entrySet()) {
            TextAttribute ta = a.getKey();
            Object v = a.getValue();
            if (v == null) continue;
            logger_.log(level, "" + ta + "\t" + v);
        }
        for (FileFont ff : Fonts.getFileFonts(FontAccess.getFontAccess().getFont2D(font), FileFontType.CORE)) {
            logger_.log(level, "===== core ===== " + ff.getFontName(null) + "\t" + Fonts.getFileName(ff));
        }
        for (FileFont ff : Fonts.getFileFonts(FontAccess.getFontAccess().getFont2D(font), FileFontType.FALLBACK)) {
            logger_.log(level, "--- fallback ---- " + ff.getFontName(null) + "\t" + Fonts.getFileName(ff));
        }
    }

    private static enum FileFontType {
        ALL,
        CORE,
        FALLBACK,
        NONE;

    }

    private static class CompositeFontWrapper
    extends FontWrapper {
        public final Set<FontWrapper> fonts_ = new LinkedHashSet<FontWrapper>();
        public final String[] files_;
        public final String[] names_;
        public final Font2D font2D_;

        public CompositeFontWrapper(Set<FontWrapper> fonts, String[] files, String[] names, Font2D font2D, Font font, String family, int style, float size) {
            super(font, family, style, size);
            this.fonts_.addAll(fonts);
            this.files_ = files;
            this.names_ = names;
            this.font2D_ = font2D;
        }

        public CompositeFontWrapper(Set<FontWrapper> fonts, String[] files, String[] names, Font2D font2D, Font font, String family, int style) {
            super(font, family, style);
            this.fonts_.addAll(fonts);
            this.files_ = files;
            this.names_ = names;
            this.font2D_ = font2D;
        }

        @Override
        public FontWrapper deriveFont(int style) {
            FontWrapper fw = super.deriveFont(style);
            if (fw != null) {
                return fw;
            }
            LinkedList<String> families = new LinkedList<String>();
            for (FontWrapper f : this.fonts_) {
                families.add(f.family_);
            }
            Fonts.getFont(families, style);
            fw = super.deriveFont(style);
            return fw;
        }

        @Override
        public FontWrapper deriveFont(float size) {
            FontWrapper fw = super.deriveFont(size);
            if (fw != null) {
                return fw;
            }
            LinkedHashSet<FontWrapper> fonts = new LinkedHashSet<FontWrapper>();
            for (FontWrapper f : this.fonts_) {
                fonts.add(f.deriveFont(size));
            }
            HashMap attributes = new HashMap(this.getInternalFont().getAttributes());
            attributes.put(TextAttribute.SIZE, Float.valueOf(size));
            Font font = new Font(attributes);
            FontAccess.getFontAccess().setFont2D(font, new Font2DHandle(this.font2D_));
            return new CompositeFontWrapper(fonts, this.files_, this.names_, this.font2D_, font, this.family_, this.style_, size);
        }
    }

    private static class URLFontWrapper
    extends SimpleFontWrapper {
        private final URL url_;

        public URLFontWrapper(URL url, String family, int style) {
            super(null, family, style, 1.0f);
            this.url_ = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Font getInternalFont() {
            Font font = super.getInternalFont();
            if (font == null) {
                InputStream in = null;
                try {
                    in = this.url_.openStream();
                    font = Font.createFont(0, in);
                    GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                }
                catch (Exception ex) {
                    font = new Font(this.family_, this.style_, 1);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                this.setInternalFont(font);
            }
            return font;
        }
    }

    private static class SimpleFontWrapper
    extends FontWrapper {
        public SimpleFontWrapper(Font font, String family, int style, float size) {
            super(font, family, style, size);
        }

        public SimpleFontWrapper(Font font, String family, int style) {
            super(font, family, style);
        }

        @Override
        public FontWrapper deriveFont(int style) {
            FontWrapper fw = super.deriveFont(style);
            return fw != null ? fw : new SimpleFontWrapper(this.getInternalFont().deriveFont(style), this.family_, style, this.size_);
        }

        @Override
        public FontWrapper deriveFont(float size) {
            FontWrapper fw = super.deriveFont(size);
            return fw != null ? fw : new SimpleFontWrapper(this.getInternalFont().deriveFont(size), this.family_, this.style_, size);
        }
    }

    private static abstract class FontWrapper {
        private static Map<String, Map<Float, FontWrapper>[]> index_ = new HashMap<String, Map<Float, FontWrapper>[]>();
        public final String family_;
        public final int style_;
        public final float size_;
        private Font internalFont_ = null;
        private Font publicFont_ = null;
        private Font fontUIResource_ = null;

        private static void index(String family, int style, float size, FontWrapper fw) {
            Map<Float, FontWrapper> sizes;
            Map<Float, FontWrapper>[] styles = index_.get(family);
            if (styles == null) {
                styles = new Map[4];
                index_.put(family, styles);
            }
            if ((sizes = styles[style]) == null) {
                styles[style] = sizes = new LinkedHashMap<Float, FontWrapper>();
            }
            sizes.put(Float.valueOf(size), fw);
        }

        protected static FontWrapper get(String family, int style, float size) {
            Map<Float, FontWrapper>[] styles = index_.get(family);
            Map<Float, FontWrapper> sizes = styles == null ? null : styles[style];
            return sizes == null ? null : sizes.get(Float.valueOf(size));
        }

        protected static FontWrapper get(String family, int style) {
            Map<Float, FontWrapper>[] styles = index_.get(family);
            Map<Float, FontWrapper> sizes = styles == null ? null : styles[style];
            return sizes == null ? null : sizes.values().iterator().next();
        }

        protected static FontWrapper get(String family) {
            Map<Float, FontWrapper>[] styles = index_.get(family);
            return styles == null ? null : styles[styles[0] != null ? 0 : (styles[1] != null ? 1 : (styles[2] != null ? 2 : 3))].values().iterator().next();
        }

        public FontWrapper(Font font, String family, int style, float size) {
            this.internalFont_ = font;
            this.family_ = family;
            this.style_ = style;
            this.size_ = size;
            FontWrapper.index(this.family_, this.style_, this.size_, this);
        }

        public FontWrapper(Font font, String family, int style) {
            this(font, family, style, font != null ? font.getSize2D() : 1.0f);
        }

        public FontWrapper deriveFont(int style) {
            if (style == this.style_) {
                return this;
            }
            FontWrapper fw = FontWrapper.get(this.family_, style, this.size_);
            if (fw != null) {
                return fw;
            }
            fw = FontWrapper.get(this.family_, style);
            if (fw != null) {
                return fw.deriveFont(this.size_);
            }
            return null;
        }

        public FontWrapper deriveFont(float size) {
            if (size == this.size_) {
                return this;
            }
            FontWrapper fw = FontWrapper.get(this.family_, this.style_, size);
            return fw != null ? fw : null;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.family_ + "-" + this.style_ + "-" + this.size_;
        }

        public Font getInternalFont() {
            return this.internalFont_;
        }

        protected void setInternalFont(Font font) {
            this.internalFont_ = font;
        }

        public Font getPublicFont() {
            this.publicFont_ = this.publicFont_ != null ? this.publicFont_ : new PublicFont(this.getInternalFont());
            return this.publicFont_;
        }

        public Font getFontUIResource() {
            this.fontUIResource_ = this.fontUIResource_ != null ? this.fontUIResource_ : new FontUIResource(this.getInternalFont());
            return this.fontUIResource_;
        }

        public class FontUIResource
        extends PublicFont
        implements UIResource {
            public FontUIResource(Font font) {
                super(font);
            }
        }

        public class PublicFont
        extends Font {
            public PublicFont(Font font) {
                super(font);
            }

            @Override
            public Font deriveFont(int style) {
                return FontWrapper.this.deriveFont(style).getPublicFont();
            }

            @Override
            public Font deriveFont(float size) {
                return FontWrapper.this.deriveFont(size).getPublicFont();
            }

            @Override
            public Font deriveFont(int style, float size) {
                return this.deriveFont(style).deriveFont(size);
            }

            public Font getFontUIResource() {
                return FontWrapper.this.getFontUIResource();
            }

            @Override
            public String toString() {
                return super.toString() + " " + FontWrapper.this.toString();
            }
        }
    }
}

