/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.util;

import com.ge.med.iungo.laf.CSSLookAndFeel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class Configuration {
    private static final Logger logger_ = Logger.getLogger(Configuration.class.getName());
    private static final String PROPERTY_PREFIX = "iungo.";
    private static final Preferences preferences_;

    public static String get(String key, String defaultValue) {
        String s = System.getProperty(PROPERTY_PREFIX + key);
        if (s != null) {
            String value = s;
            Configuration.set(key, value);
            return value;
        }
        try {
            return preferences_.get(key, defaultValue);
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception accessing preference:" + preferences_ + " key:" + key + ", returning default value:" + defaultValue + ".", ex);
            return defaultValue;
        }
    }

    public static void set(String key, String value) {
        try {
            preferences_.put(key, value);
            preferences_.flush();
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception storing preference:" + preferences_ + " key:" + key + " value:" + value + ".", ex);
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String s = System.getProperty(PROPERTY_PREFIX + key);
        if (s != null && !s.isEmpty()) {
            boolean value = Boolean.parseBoolean(s);
            Configuration.set(key, value);
            return value;
        }
        try {
            return preferences_.getBoolean(key, defaultValue);
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception accessing preference:" + preferences_ + " key:" + key + ", returning default value:" + defaultValue + ".", ex);
            return defaultValue;
        }
    }

    public static void set(String key, boolean value) {
        try {
            preferences_.putBoolean(key, value);
            preferences_.flush();
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception storing preference:" + preferences_ + " key:" + key + " value:" + value + ".", ex);
        }
    }

    public static int getInt(String key, int defaultValue) {
        String s = System.getProperty(PROPERTY_PREFIX + key);
        if (s != null && !s.isEmpty()) {
            try {
                int value = Integer.parseInt(s);
                Configuration.set(key, value);
                return value;
            }
            catch (Exception exx) {
                logger_.log(Level.WARNING, "Exception parsing integer system property key:iungo." + key + " value:" + s + ".", exx);
            }
        }
        try {
            return preferences_.getInt(key, defaultValue);
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception accessing preference:" + preferences_ + " key:" + key + ", returning default value:" + defaultValue + ".", ex);
            return defaultValue;
        }
    }

    public static void set(String key, int value) {
        try {
            preferences_.putInt(key, value);
            preferences_.flush();
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception storing preference:" + preferences_ + " key:" + key + " value:" + value + ".", ex);
        }
    }

    public static double getDouble(String key, double defaultValue) {
        String s = System.getProperty(PROPERTY_PREFIX + key);
        if (s != null && !s.isEmpty()) {
            try {
                double value = Double.parseDouble(s);
                Configuration.set(key, value);
                return value;
            }
            catch (Exception exx) {
                logger_.log(Level.WARNING, "Exception parsing numeric system property key:iungo." + key + " value:" + s + ".", exx);
            }
        }
        try {
            return preferences_.getDouble(key, defaultValue);
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception accessing preference:" + preferences_ + " key:" + key + ", returning default value:" + defaultValue + ".", ex);
            return defaultValue;
        }
    }

    public static void set(String key, double value) {
        try {
            preferences_.putDouble(key, value);
            preferences_.flush();
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception storing preference:" + preferences_ + " key:" + key + " value:" + value + ".", ex);
        }
    }

    public static void clear(String ... keys) {
        for (String key : keys) {
            try {
                preferences_.remove(key);
            }
            catch (Exception ex) {
                logger_.log(Level.WARNING, "Exception clearing preference:" + preferences_ + " key:" + key + ".", ex);
            }
        }
        try {
            if (keys.length == 0) {
                preferences_.clear();
                logger_.log(Level.INFO, "User preferences in com.ge.med.iungo.laf cleared.");
            }
            preferences_.flush();
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "Exception clearing preferences.", ex);
        }
    }

    public static void main(String[] argv) {
    }

    static {
        Preferences preferences = null;
        try {
            preferences = Preferences.userNodeForPackage(CSSLookAndFeel.class);
        }
        catch (Throwable t) {
            logger_.log(Level.SEVERE, "Error accessing user preferences for package:" + CSSLookAndFeel.class.getName() + ".", t);
        }
        preferences_ = preferences;
        if (Boolean.getBoolean("iungo.newConfiguration")) {
            Configuration.clear(new String[0]);
        }
    }
}

