/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.shape;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.util.NoSuchElementException;

public class RoundCornerRectangle
extends RoundRectangle2D.Double {
    public double[] arcWidthArray_;
    public double[] arcHeightArray_;
    private boolean useBase_;

    public String toString() {
        return this.getClass().getName() + "[" + this.getBounds2D() + "," + this.arcWidthArray_[0] + "x" + this.arcHeightArray_[0] + "," + this.arcWidthArray_[1] + "x" + this.arcHeightArray_[1] + "," + this.arcWidthArray_[2] + "x" + this.arcHeightArray_[2] + "," + this.arcWidthArray_[3] + "x" + this.arcHeightArray_[3] + "]";
    }

    public RoundCornerRectangle(double x, double y, double w, double h, double[] arcw, double[] arch) {
        super(x, y, w, h, Math.max(Math.max(arcw[0], arcw[1]), Math.max(arcw[2], arcw[3])), Math.max(Math.max(arch[0], arch[1]), Math.max(arch[2], arch[3])));
        this.arcWidthArray_ = arcw;
        this.arcHeightArray_ = arch;
        for (int i = 0; i < 4; ++i) {
            if (this.arcWidthArray_[i] <= 0.0) {
                this.arcHeightArray_[i] = 0.0;
            }
            if (!(this.arcHeightArray_[i] <= 0.0)) continue;
            this.arcWidthArray_[i] = 0.0;
        }
        this.useBase_ = this.arcWidthArray_[0] == this.arcWidthArray_[1] && this.arcWidthArray_[0] == this.arcWidthArray_[2] && this.arcWidthArray_[0] == this.arcWidthArray_[3] && this.arcHeightArray_[0] == this.arcHeightArray_[1] && this.arcHeightArray_[0] == this.arcHeightArray_[2] && this.arcHeightArray_[0] == this.arcHeightArray_[3];
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.isEmpty()) {
            return false;
        }
        if (super.contains(x, y)) {
            return true;
        }
        double left = this.getX();
        double top = this.getY();
        double right = left + this.getWidth();
        double bottom = top + this.getHeight();
        if (x < left || y < top || x >= right || y >= bottom) {
            return false;
        }
        if (x <= left + this.arcWidthArray_[0] / 2.0 && y <= top + this.arcHeightArray_[0] / 2.0) {
            return (x = 1.0 - (x - left) / (this.arcWidthArray_[0] / 2.0)) * x + (y = 1.0 - (y - top) / (this.arcHeightArray_[0] / 2.0)) * y <= 1.0;
        }
        if (x <= left + this.arcWidthArray_[1] / 2.0 && y >= bottom - this.arcHeightArray_[1] / 2.0) {
            return (x = 1.0 - (x - left) / (this.arcWidthArray_[1] / 2.0)) * x + (y = 1.0 - (bottom - y) / (this.arcHeightArray_[1] / 2.0)) * y <= 1.0;
        }
        if (x >= right - this.arcWidthArray_[2] / 2.0 && y >= bottom - this.arcHeightArray_[2] / 2.0) {
            return (x = 1.0 - (right - x) / (this.arcWidthArray_[2] / 2.0)) * x + (y = 1.0 - (bottom - y) / (this.arcHeightArray_[2] / 2.0)) * y <= 1.0;
        }
        if (x >= right - this.arcWidthArray_[3] / 2.0 && y <= top + this.arcHeightArray_[3] / 2.0) {
            return (x = 1.0 - (right - x) / (this.arcWidthArray_[3] / 2.0)) * x + (y = 1.0 - (y - top) / (this.arcHeightArray_[3] / 2.0)) * y <= 1.0;
        }
        return true;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.useBase_ ? super.getPathIterator(at) : new RoundCornerRectIterator(this, at);
    }

    protected static class RoundCornerRectIterator
    implements PathIterator {
        public double x;
        public double y;
        public double w;
        public double h;
        public AffineTransform affine;
        public int index;
        public double[] aw_ = new double[4];
        public double[] ah_ = new double[4];
        private static final double angle = 0.7853981633974483;
        private static final double a = 1.0 - Math.cos(0.7853981633974483);
        private static final double b = Math.tan(0.7853981633974483);
        private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
        private static final double cv = 1.3333333333333333 * a * b / c;
        private static final double acv = (1.0 - cv) / 2.0;
        private static double[][] ctrlpts = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
        private static int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};
        private static int[] corner = new int[]{0, 1, 1, 2, 2, 3, 3, 0, 0, 0};

        public RoundCornerRectIterator(RoundCornerRectangle rr, AffineTransform at) {
            this.x = rr.getX();
            this.y = rr.getY();
            this.w = rr.getWidth();
            this.h = rr.getHeight();
            System.arraycopy(rr.arcWidthArray_, 0, this.aw_, 0, 4);
            System.arraycopy(rr.arcHeightArray_, 0, this.ah_, 0, 4);
            this.affine = at;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index >= ctrlpts.length;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException("roundcornerrect iterator out of bounds");
            }
            if (types[this.index] == 3 && (this.aw_[corner[this.index]] == 0.0 || this.ah_[corner[this.index]] == 0.0)) {
                ++this.index;
            }
            double[] ctrls = ctrlpts[this.index];
            int nc = 0;
            for (int i = 0; i < ctrls.length; i += 4) {
                coords[nc++] = (float)(this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aw_[corner[this.index]]);
                coords[nc++] = (float)(this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ah_[corner[this.index]]);
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, nc / 2);
            }
            return types[this.index];
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException("roundcornerrect iterator out of bounds");
            }
            if (types[this.index] == 3 && (this.aw_[corner[this.index]] == 0.0 || this.ah_[corner[this.index]] == 0.0)) {
                ++this.index;
            }
            double[] ctrls = ctrlpts[this.index];
            int nc = 0;
            for (int i = 0; i < ctrls.length; i += 4) {
                coords[nc++] = this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aw_[corner[this.index]];
                coords[nc++] = this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ah_[corner[this.index]];
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, nc / 2);
            }
            return types[this.index];
        }
    }
}

