/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.util.Configuration;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;

public class ThemeFactory {
    private static MetalTheme instance = null;
    private static final Logger logger_ = Logger.getLogger(ThemeFactory.class.getName());
    private static String secondary3color = Configuration.get("secondary3.color", null);
    private static ColorUIResource secondary3 = null;

    private ThemeFactory() {
        if (secondary3color != null) {
            try {
                Color c = Color.decode(secondary3color);
                secondary3 = new ColorUIResource(c);
            }
            catch (Exception e) {
                logger_.log(Level.INFO, "secondary3 color is not a proper hexadecimal : " + e);
            }
        }
    }

    public static synchronized MetalTheme getThemeInstance() {
        if (instance == null) {
            new ThemeFactory();
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf instanceof MetalLookAndFeel) {
                MetalTheme t = MetalLookAndFeel.getCurrentTheme();
                if ("Steel".equalsIgnoreCase(t.getName())) {
                    instance = new HDxMetal();
                } else if ("Ocean".equalsIgnoreCase(t.getName())) {
                    instance = new HDxOcean();
                }
            }
        }
        return instance;
    }

    private static class HDxMetal
    extends DefaultMetalTheme {
        private HDxMetal() {
        }

        @Override
        protected synchronized ColorUIResource getSecondary3() {
            return secondary3 != null ? secondary3 : super.getSecondary3();
        }
    }

    private static class HDxOcean
    extends OceanTheme {
        private HDxOcean() {
        }

        @Override
        protected synchronized ColorUIResource getSecondary3() {
            return secondary3 != null ? secondary3 : super.getSecondary3();
        }
    }
}

