/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;

public class CSSViewportUI
extends BasicViewportUI {
    private static final Logger LOGGER = Logger.getLogger(CSSViewportUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JViewport);
        LOGGER.entering(CSSViewportUI.class.getName(), "createUI");
        return new CSSViewportUI(component);
    }

    protected CSSViewportUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSViewportUI.class.getName(), "installUI");
        super.installUI(component);
        component.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Graphics2D g2 = (Graphics2D)g;
            Composite composite = g2.getComposite();
            BackgroundInfo info = CSS.getInfo(component);
            BufferedImage bi = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D big = bi.createGraphics();
            big.setClip(new Rectangle(component.getWidth(), component.getHeight()));
            ((CSSBorder)border).paintBorderAndBackground(component, big, 0, 0, component.getWidth(), component.getHeight());
            g2.setComposite(AlphaComposite.getInstance(3, info.opacity));
            big.setFont(component.getFont());
            if (info.foreground != null && !info.foreground.equals(component.getForeground())) {
                component.setForeground(info.foreground);
            }
            super.paint(big, component);
            g2.drawImage((Image)bi, 0, 0, null);
            g2.setComposite(composite);
            return;
        }
        super.paint(g, component);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

