/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class CSSToolBarUI
extends BasicToolBarUI {
    private static final Logger LOGGER = Logger.getLogger(CSSToolBarUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JToolBar);
        LOGGER.entering(CSSToolBarUI.class.getName(), "createUI");
        return new CSSToolBarUI(component);
    }

    protected CSSToolBarUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSToolBarUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Graphics2D g2 = (Graphics2D)g;
            Composite composite = g2.getComposite();
            BackgroundInfo info = CSS.getInfo(component);
            BufferedImage bi = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D big = bi.createGraphics();
            big.setClip(new Rectangle(component.getWidth(), component.getHeight()));
            ((CSSBorder)border).paintBorderAndBackground(component, big, 0, 0, component.getWidth(), component.getHeight());
            g2.setComposite(AlphaComposite.getInstance(3, info.opacity));
            big.setFont(component.getFont());
            if (info.foreground != null && !info.foreground.equals(component.getForeground())) {
                component.setForeground(info.foreground);
            }
            super.paint(big, component);
            g2.drawImage((Image)bi, 0, 0, null);
            g2.setComposite(composite);
            return;
        }
        super.paint(g, component);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        assert (component == this.component_);
        Dimension size = super.getPreferredSize(component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Insets in = border.getBorderInsets(component);
            LOGGER.fine("SIZE:" + size + "\tINSETS:" + in);
            BackgroundInfo info = CSS.getInfo(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        }
        return size;
    }
}

