/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class CSSToggleButtonUI
extends BasicToggleButtonUI {
    private static final Logger LOGGER = Logger.getLogger(CSSToggleButtonUI.class.getName());
    private MouseListener mouseListener = null;
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof AbstractButton);
        LOGGER.entering(CSSToggleButtonUI.class.getName(), "createUI");
        return new CSSToggleButtonUI(component);
    }

    protected CSSToggleButtonUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSToggleButtonUI.class.getName(), "installUI");
        super.installUI(component);
        ((AbstractButton)component).setRolloverEnabled(true);
        component.setBorder(new CSSBorder());
        LookAndFeel.installProperty(component, "opaque", Boolean.FALSE);
        if (component.getClientProperty("css_class") == null) {
            component.putClientProperty("css_class", "btn");
            component.putClientProperty("css_attribute_data-toggle", "button");
        }
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractButton abstractButton;
                    boolean isSelected = (abstractButton = (AbstractButton)mouseEvent.getSource()).getModel().isSelected();
                    abstractButton.putClientProperty("css_class", isSelected ? "btn active" : "btn");
                }
            };
            this.component_.addMouseListener(this.mouseListener);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        AbstractButton abstractButton;
        boolean isSelected = (abstractButton = (AbstractButton)c).getModel().isSelected();
        abstractButton.putClientProperty("css_class", isSelected ? "btn active" : "btn");
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
        LOGGER.exiting(CSSToggleButtonUI.class.getName(), "Called update()");
    }

    @Override
    public void uninstallUI(JComponent component) {
        LOGGER.entering(CSSToggleButtonUI.class.getName(), "uninstallUI");
        super.uninstallUI(component);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder && ((AbstractButton)component).isBorderPainted()) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }

    @Override
    protected void paintText(Graphics g, AbstractButton component, Rectangle textRect, String text) {
        g.setColor(CSS.getInfo((JComponent)component).foreground);
        FontMetrics fm = g.getFontMetrics(component.getFont());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, component.getDisplayedMnemonicIndex(), textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
    }
}

