/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.JTextComponent;

public class CSSTextPaneUI
extends BasicTextPaneUI {
    private static final Logger LOGGER = Logger.getLogger(CSSTextPaneUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTextPane);
        LOGGER.entering(CSSTextPaneUI.class.getName(), "createUI");
        return new CSSTextPaneUI(component);
    }

    protected CSSTextPaneUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSTextPaneUI.class.getName(), "installUI");
        super.installUI(component);
        component.setOpaque(false);
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "body");
        }
    }

    @Override
    public void paintSafely(Graphics g) {
        JTextComponent component = this.getComponent();
        assert (component == this.component_);
        BackgroundInfo info = CSS.getInfo(component);
        if (info.font != null && !info.font.equals(component.getFont())) {
            component.setFont(info.font);
        }
        if (info.foreground != null && !info.foreground.equals(component.getForeground())) {
            component.setForeground(info.foreground);
        }
        Background.addFontRenderingHints((Graphics2D)g, component);
        super.paintSafely(g);
    }
}

