/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.CSSFontIcon;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import javax.swing.text.JTextComponent;

public class CSSTextFieldUI
extends MetalTextFieldUI {
    private static final Logger LOGGER = Logger.getLogger(CSSTextFieldUI.class.getName());
    private FocusListener focusListener_ = null;
    private JComponent divContainer = new JComponent(){};
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTextField);
        LOGGER.entering(CSSTextFieldUI.class.getName(), "createUI");
        return new CSSTextFieldUI(component);
    }

    protected CSSTextFieldUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSTextFieldUI.class.getName(), "installUI");
        super.installUI(component);
        component.setOpaque(false);
        component.putClientProperty("css_parent", this.divContainer);
        this.divContainer.putClientProperty("css_element", "div");
        if (null == this.focusListener_) {
            this.focusListener_ = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    CSSTextFieldUI.this.component_.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CSSTextFieldUI.this.component_.repaint();
                }
            };
            this.component_.addFocusListener(this.focusListener_);
        }
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        if (null != this.focusListener_) {
            this.component_.removeFocusListener(this.focusListener_);
            this.focusListener_ = null;
        }
    }

    @Override
    public void paintSafely(Graphics g) {
        JTextComponent component = this.getComponent();
        assert (component == this.component_);
        this.fixClientProperties();
        Background.addFontRenderingHints((Graphics2D)g, component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            JTextComponent editor = this.getComponent();
            editor.setDisabledTextColor(component.getForeground());
            Graphics2D g2 = (Graphics2D)g;
            Composite composite = g2.getComposite();
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            this.divContainer.putClientProperty("css_class", component.getClientProperty("css_class"));
            Object icon = component.getClientProperty("css_icon_after");
            if (icon instanceof CSSFontIcon) {
                ((CSSFontIcon)icon).color_ = info.borderColor[0];
            }
            LOGGER.fine("DEBUG TEXT FIELD INFO(" + ((JTextField)component).getText() + "):" + info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D big = bi.createGraphics();
            big.setClip(new Rectangle(component.getWidth(), component.getHeight()));
            ((CSSBorder)border).paintBorderAndBackground(component, big, 0, 0, component.getWidth(), component.getHeight());
            g2.setComposite(AlphaComposite.getInstance(3, info.opacity));
            big.setFont(component.getFont());
            Background.addFontRenderingHints(big, component);
            super.paintSafely(big);
            g2.drawImage((Image)bi, 0, 0, null);
            g2.setComposite(composite);
            Background.recycleBuffer(bi);
            return;
        }
        super.paintSafely(g);
    }

    private void fixClientProperties() {
        JTextComponent component = this.getComponent();
        String undeditableCssClass = "uneditable-input";
        String origCssClass = (String)component.getClientProperty("css_class");
        if (!((JTextField)component).isEditable()) {
            component.putClientProperty("css_element", null);
            component.putClientProperty("css_attribute_type", null);
            if (origCssClass != null && !origCssClass.equals("")) {
                if (!origCssClass.contains(undeditableCssClass)) {
                    component.putClientProperty("css_class", origCssClass + " " + undeditableCssClass);
                }
            } else {
                component.putClientProperty("css_class", undeditableCssClass);
            }
            component.putClientProperty("css_focus", Boolean.FALSE);
        } else {
            component.putClientProperty("css_element", "input");
            component.putClientProperty("css_attribute_type", "text");
            if (origCssClass != null && origCssClass.contains(undeditableCssClass)) {
                String newCssClass = origCssClass.replace(undeditableCssClass, "").trim();
                component.putClientProperty("css_class", newCssClass);
                component.putClientProperty("css_focus", null);
            }
        }
        String disabledCssClass = "disabled";
        origCssClass = (String)component.getClientProperty("css_class");
        if (!component.isEnabled()) {
            if (origCssClass != null && !origCssClass.equals("")) {
                if (!origCssClass.contains(disabledCssClass)) {
                    component.putClientProperty("css_class", origCssClass + " " + disabledCssClass);
                }
            } else {
                component.putClientProperty("css_class", disabledCssClass);
            }
        } else if (origCssClass != null && origCssClass.contains(disabledCssClass)) {
            String newCssClass = origCssClass.replace(disabledCssClass, "").trim();
            component.putClientProperty("css_class", newCssClass);
        }
        this.divContainer.putClientProperty("css_class", component.getClientProperty("css_class"));
        if (origCssClass != null && component.isEditable()) {
            component.putClientProperty("css_icon_after", origCssClass.contains("success") ? this.getIcon("success") : (origCssClass.contains("warning") ? this.getIcon("warning") : (origCssClass.contains("error") ? this.getIcon("error") : null)));
        } else {
            component.putClientProperty("css_icon_after", null);
        }
    }

    private Icon getIcon(String icon) {
        return CSSFontIcon.getIcon("success".equals(icon) ? (char)'\uf402' : ("warning".equals(icon) ? (char)'\uf109' : '\uf42c'), "success".equals(icon) ? (float)(CSS.getZoom() * 20.0) : ("warning".equals(icon) ? (float)(CSS.getZoom() * 13.0) : (float)(CSS.getZoom() * 18.0)), new Dimension((int)(CSS.getZoom() * 28.0), (int)(CSS.getZoom() * 28.0)));
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            this.fixClientProperties();
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

