/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class CSSTextAreaUI
extends BasicTextAreaUI {
    private static final Logger logger_ = Logger.getLogger(CSSTextAreaUI.class.getName());
    private FocusListener focusListener_ = null;
    private final JComponent component_;
    private JComponent blockquote_ = new JComponent(){};
    private JScrollPane scroll_ = null;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTextArea);
        logger_.entering(CSSTextAreaUI.class.getName(), "createUI");
        return new CSSTextAreaUI(component);
    }

    protected CSSTextAreaUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        logger_.entering(CSSTextAreaUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
        this.blockquote_.putClientProperty("css_element", "blockquote");
        if (component.getClientProperty("css_parent") == null) {
            component.putClientProperty("css_parent", this.blockquote_);
        }
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "textarea");
        }
        if (null == this.focusListener_) {
            this.focusListener_ = new FocusListener(){

                private void repaint() {
                    Container grandparent;
                    Container parent = CSSTextAreaUI.this.component_.getParent();
                    Container container = grandparent = parent instanceof JViewport ? parent.getParent() : null;
                    if (grandparent instanceof JScrollPane) {
                        ((JScrollPane)grandparent).repaint();
                    } else {
                        CSSTextAreaUI.this.component_.repaint();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.repaint();
                }
            };
            this.component_.addFocusListener(this.focusListener_);
        }
    }

    @Override
    public void uninstallUI(JComponent component) {
        logger_.entering(CSSTextAreaUI.class.getName(), "uninstallUI");
        super.uninstallUI(component);
        if (null != this.focusListener_) {
            this.component_.removeFocusListener(this.focusListener_);
            this.focusListener_ = null;
        }
    }

    private void shuffleCSSProperties() {
        Container grandparent;
        JTextComponent component = this.getComponent();
        Container parent = component.getParent();
        Container container = grandparent = parent instanceof JViewport ? parent.getParent() : null;
        if (grandparent instanceof JScrollPane && "textarea".equals(component.getClientProperty("css_element")) && this.blockquote_ == component.getClientProperty("css_parent")) {
            this.scroll_ = (JScrollPane)grandparent;
            this.scroll_.putClientProperty("css_element", "textarea");
            this.scroll_.putClientProperty("css_parent", this.blockquote_);
            component.putClientProperty("css_element", null);
            component.putClientProperty("css_parent", null);
            parent.setFont(null);
        }
    }

    @Override
    public void paintSafely(Graphics g) {
        JTextComponent component = this.getComponent();
        this.shuffleCSSProperties();
        if (this.scroll_ != null) {
            BackgroundInfo sInfo = CSS.getInfo(this.scroll_);
            Background.updateComponentProperties(this.scroll_, sInfo);
        }
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        if (component.getClientProperty("css_element") == null && component.getFont() instanceof UIResource) {
            component.setFont(null);
        }
        Background.addFontRenderingHints((Graphics2D)g, component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paintSafely(g2);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paintSafely(g);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        assert (component == this.component_);
        this.shuffleCSSProperties();
        if (this.scroll_ != null) {
            BackgroundInfo sInfo = CSS.getInfo(this.scroll_);
            Background.updateComponentProperties(this.scroll_, sInfo);
        }
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        if (component.getClientProperty("css_element") == null && component.getFont() instanceof UIResource) {
            component.setFont(null);
        }
        Dimension size = super.getPreferredSize(component);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        }
        return size;
    }
}

