/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class CSSTableUI
extends BasicTableUI {
    private static final Logger LOGGER = Logger.getLogger(CSSTableUI.class.getName());
    private final JComponent component_;
    private JComponent table_ = new JComponent(){};
    private JComponent tbody_ = new JComponent(){};
    private JComponent tr_ = new JComponent(){};
    private CSSBorder border_ = new CSSBorder();
    private int mouseRow_ = -1;
    private MouseAdapter mouseAdapter_ = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent me) {
            JTable table = (JTable)CSSTableUI.this.component_;
            int mouseRow = table.rowAtPoint(me.getPoint());
            if (mouseRow != CSSTableUI.this.mouseRow_) {
                int columns = table.getColumnCount();
                Rectangle dirty = table.getCellRect(mouseRow != -1 ? mouseRow : CSSTableUI.this.mouseRow_, columns, true);
                dirty = dirty.union(table.getCellRect(CSSTableUI.this.mouseRow_ != -1 ? CSSTableUI.this.mouseRow_ : mouseRow, 0, true));
                CSSTableUI.this.mouseRow_ = mouseRow;
                CSSTableUI.this.component_.repaint(dirty);
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (CSSTableUI.this.mouseRow_ != -1) {
                int columns = CSSTableUI.this.table.getColumnCount();
                Rectangle dirty = CSSTableUI.this.table.getCellRect(CSSTableUI.this.mouseRow_, columns, true);
                dirty = dirty.union(CSSTableUI.this.table.getCellRect(CSSTableUI.this.mouseRow_, 0, true));
                CSSTableUI.this.mouseRow_ = -1;
                CSSTableUI.this.component_.repaint(dirty);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            JTable table = (JTable)CSSTableUI.this.component_;
            int mouseRow = table.rowAtPoint(me.getPoint());
            if (mouseRow != CSSTableUI.this.mouseRow_) {
                int columns = table.getColumnCount();
                Rectangle dirty = table.getCellRect(mouseRow != -1 ? mouseRow : CSSTableUI.this.mouseRow_, columns, true);
                dirty = dirty.union(table.getCellRect(CSSTableUI.this.mouseRow_ != -1 ? CSSTableUI.this.mouseRow_ : mouseRow, 0, true));
                CSSTableUI.this.mouseRow_ = mouseRow;
                CSSTableUI.this.component_.repaint(dirty);
            }
        }
    };

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTable);
        LOGGER.entering(CSSTableUI.class.getName(), "createUI");
        return new CSSTableUI(component);
    }

    protected CSSTableUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void uninstallUI(JComponent component) {
        LOGGER.entering(CSSTableUI.class.getName(), "uninstallUI");
        component.removeMouseListener(this.mouseAdapter_);
        component.removeMouseMotionListener(this.mouseAdapter_);
        super.uninstallUI(component);
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSTableUI.class.getName(), "createUI");
        super.installUI(component);
        component.remove(this.rendererPane);
        this.rendererPane = new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                if (c instanceof JComponent) {
                    if (c.getParent() != this) {
                        this.add(c);
                    }
                    c.setBounds(x, y, w, h);
                    if (shouldValidate) {
                        c.validate();
                    }
                    JComponent jc = (JComponent)c;
                    jc.setOpaque(false);
                    jc.setBorder(CSSTableUI.this.border_);
                    jc.putClientProperty("css_class", "");
                    jc.putClientProperty("css_element", "td");
                    jc.putClientProperty("css_parent", CSSTableUI.this.tr_);
                    JTable t = (JTable)CSSTableUI.this.component_;
                    int row = t.rowAtPoint(new Point(x, y));
                    boolean selected = t.isRowSelected(row);
                    boolean rollover = row == CSSTableUI.this.mouseRow_;
                    CSSTableUI.this.tr_.putClientProperty("css_hover", rollover);
                    CSSTableUI.this.tr_.putClientProperty("css_class", Boolean.valueOf(selected) != false ? "active" : "");
                    String cacheKey = "" + System.identityHashCode(this) + "|" + System.identityHashCode(jc) + "|" + selected + "|" + rollover + "|" + w + "x" + h;
                    jc.putClientProperty("css_cacheKey", cacheKey);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                if (c instanceof JComponent) {
                    ((JComponent)c).putClientProperty("css_cacheKey", null);
                }
            }
        };
        component.add(this.rendererPane);
        component.addMouseListener(this.mouseAdapter_);
        component.addMouseMotionListener(this.mouseAdapter_);
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "table");
        }
        if (component.getClientProperty("css_class") == null) {
            component.putClientProperty("css_class", "table table-hover");
        }
        this.tr_.putClientProperty("css_element", "tr");
        this.tr_.putClientProperty("css_parent", this.tbody_);
        this.tbody_.putClientProperty("css_element", "tbody");
        this.tbody_.putClientProperty("css_parent", this.table_);
        this.table_.putClientProperty("css_class", component.getClientProperty("css_class"));
        this.table_.putClientProperty("css_element", component.getClientProperty("css_element"));
        component.setOpaque(false);
        JTable table = (JTable)component;
        table.setRowHeight(34);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
        table.setShowGrid(false);
        table.setIntercellSpacing(new Dimension(0, 0));
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

