/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;

public class CSSTableHeaderUI
extends BasicTableHeaderUI {
    private static final Logger LOGGER = Logger.getLogger(CSSTableHeaderUI.class.getName());
    private final JComponent component_;
    private JComponent table_ = new JComponent(){};
    private JComponent thead_ = new JComponent(){};
    private JComponent tr_ = new JComponent(){};
    private CSSBorder border_ = new CSSBorder();

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTableHeader);
        LOGGER.entering(CSSTableHeaderUI.class.getName(), "createUI");
        return new CSSTableHeaderUI(component);
    }

    protected CSSTableHeaderUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void uninstallUI(JComponent component) {
        LOGGER.entering(CSSTableHeaderUI.class.getName(), "uninstallUI");
        super.uninstallUI(component);
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSTableHeaderUI.class.getName(), "createUI");
        super.installUI(component);
        component.remove(this.rendererPane);
        this.rendererPane = new CellRendererPane(){
            private boolean painting_ = false;

            @Override
            public void addImpl(Component c, Object constraints, int index) {
                if (!this.painting_ && c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setOpaque(false);
                    jc.setBorder(CSSTableHeaderUI.this.border_);
                    jc.putClientProperty("css_class", "");
                    jc.putClientProperty("css_element", "th");
                    jc.putClientProperty("css_parent", CSSTableHeaderUI.this.tr_);
                    JTableHeader header = (JTableHeader)CSSTableHeaderUI.this.component_;
                    JTable table = header.getTable();
                    CSSTableHeaderUI.this.table_.putClientProperty("css_class", table.getClientProperty("css_class"));
                    CSSTableHeaderUI.this.table_.putClientProperty("css_element", table.getClientProperty("css_element"));
                    boolean first = false;
                    boolean last = false;
                    jc.putClientProperty("css_cacheKey", System.identityHashCode(this) + "|" + System.identityHashCode(jc) + "|" + first + "|" + last);
                }
                super.addImpl(c, constraints, index);
            }

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                this.painting_ = true;
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setOpaque(false);
                    jc.setBorder(CSSTableHeaderUI.this.border_);
                    jc.putClientProperty("css_class", "");
                    jc.putClientProperty("css_element", "th");
                    jc.putClientProperty("css_parent", CSSTableHeaderUI.this.tr_);
                    JTableHeader header = (JTableHeader)CSSTableHeaderUI.this.component_;
                    JTable table = header.getTable();
                    CSSTableHeaderUI.this.table_.putClientProperty("css_class", table.getClientProperty("css_class"));
                    CSSTableHeaderUI.this.table_.putClientProperty("css_element", table.getClientProperty("css_element"));
                    int column = header.columnAtPoint(new Point(x, y));
                    boolean first = column == 0;
                    boolean last = column == table.getColumnCount() - 1;
                    jc.putClientProperty("css_first-child", first);
                    jc.putClientProperty("css_last-child", last);
                    if (jc instanceof JLabel) {
                        ((JLabel)jc).setHorizontalAlignment(10);
                    }
                    jc.setBounds(x, y, w, h);
                    jc.putClientProperty("css_cacheKey", "" + System.identityHashCode(this) + "|" + System.identityHashCode(jc) + "|" + first + "|" + last + "|" + w + "x" + h);
                    super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                    jc.putClientProperty("css_cacheKey", System.identityHashCode(this) + "|" + System.identityHashCode(jc) + "|" + first + "|" + last);
                } else {
                    super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
                }
                this.painting_ = false;
            }
        };
        component.add(this.rendererPane);
        this.tr_.putClientProperty("css_element", "tr");
        this.tr_.putClientProperty("css_parent", this.thead_);
        this.tr_.putClientProperty("css_first-child", Boolean.TRUE);
        this.thead_.putClientProperty("css_element", "thead");
        this.thead_.putClientProperty("css_parent", this.table_);
        this.thead_.putClientProperty("css_first-child", Boolean.TRUE);
        component.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        BackgroundInfo info = CSS.getInfo(component);
        Background.updateComponentProperties(component, info);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

