/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class CSSTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Logger LOGGER = Logger.getLogger(CSSTabbedPaneUI.class.getName());
    private final JComponent component_;
    private JComponent parent_ = new JComponent(){};
    private JComponent ul_ = new JComponent(){};
    private JComponent li_ = new JComponent(){};
    private JComponent a_ = new JComponent(){};
    private static Insets noInsets_ = new Insets(0, 0, 0, 0);
    private static Color transparent_ = new Color(0, true);

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JTabbedPane);
        LOGGER.entering(CSSTabbedPaneUI.class.getName(), "createUI");
        return new CSSTabbedPaneUI(component);
    }

    protected CSSTabbedPaneUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSTabbedPaneUI.class.getName(), "installUI");
        this.ul_.putClientProperty("css_element", "ul");
        this.li_.putClientProperty("css_element", "li");
        this.a_.putClientProperty("css_element", "a");
        this.component_.putClientProperty("css_element", "a");
        this.ul_.putClientProperty("css_class", "nav nav-tabs");
        this.li_.putClientProperty("css_class", "");
        this.component_.putClientProperty("css_parent", this.li_);
        this.a_.putClientProperty("css_parent", this.li_);
        this.li_.putClientProperty("css_parent", this.ul_);
        this.ul_.putClientProperty("css_parent", this.parent_);
        UIManager.put("TabbedPane.textIconGap", 20);
        UIManager.put("TabbedPane.tabsOverlapBorder", false);
        UIManager.put("TabbedPane.tabsOpaque", true);
        UIManager.put("TabbedPane.contentOpaque", false);
        UIManager.put("TabbedPane.opaque", false);
        super.installUI(component);
        LookAndFeel.installProperty(component, "opaque", Boolean.FALSE);
        MouseAdapter ma = new MouseAdapter(){
            private boolean inside_ = false;

            @Override
            public void mouseEntered(MouseEvent me) {
                this.inside_ = true;
                CSSTabbedPaneUI.this.component_.repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                this.inside_ = false;
                CSSTabbedPaneUI.this.component_.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                if (this.inside_ && me.getComponent() == CSSTabbedPaneUI.this.component_ && CSSTabbedPaneUI.this.component_.getComponentAt(me.getX(), me.getY()) == CSSTabbedPaneUI.this.component_) {
                    CSSTabbedPaneUI.this.component_.repaint();
                }
            }
        };
        component.addMouseListener(ma);
        component.addMouseMotionListener(ma);
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        BackgroundInfo info = CSS.getInfo(this.a_);
        Background.updateComponentProperties(component, info);
        return super.getPreferredSize(component);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        BackgroundInfo info = CSS.getInfo(this.a_);
        Background.updateComponentProperties(component, info);
        super.paint(g, component);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        super.paintTabArea(g, tabPlacement, selectedIndex);
        int x = 0;
        int y = 0;
        int w = this.component_.getWidth();
        int h = this.component_.getHeight();
        switch (tabPlacement) {
            case 2: {
                w = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 4: {
                int ww = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                x = w - ww;
                w = ww;
                break;
            }
            case 3: {
                int hh = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                y = h - hh;
                h = hh;
                break;
            }
            default: {
                h = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        this.ul_.setBounds(new Rectangle(x, y, w, h));
        BackgroundInfo info = CSS.getInfo(this.ul_);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D big = bi.createGraphics();
        Composite bic = big.getComposite();
        big.setComposite(AlphaComposite.Src);
        big.setColor(transparent_);
        big.fillRect(0, 0, w, h);
        big.setComposite(bic);
        Background.paint(info, big, 0, 0, w, h);
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, info.opacity));
        g2.drawImage((Image)bi, x, y, null);
        g2.setComposite(composite);
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        super.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        this.parent_.putClientProperty("css_class", tabPlacement == 4 ? "tabbable tabs-right" : (tabPlacement == 2 ? "tabbable tabs-left" : (tabPlacement == 3 ? "tabbable tabs-below" : "tabbable")));
        this.li_.putClientProperty("css_class", isSelected ? "active" : "");
        this.li_.putClientProperty("css_hover", this.getRolloverTab() == tabIndex && !isSelected);
        this.a_.putClientProperty("css_hover", this.getRolloverTab() == tabIndex && !isSelected);
        BackgroundInfo info = CSS.getInfo(this.a_);
        JTabbedPane tp = (JTabbedPane)this.component_;
        Color foreground = tp.getForegroundAt(tabIndex);
        if (info.foreground != null && foreground instanceof UIResource && !info.foreground.equals(foreground)) {
            tp.setForegroundAt(tabIndex, info.foreground);
        }
        Background.addFontRenderingHints((Graphics2D)g, this.component_);
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, false);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        this.parent_.putClientProperty("css_class", tabPlacement == 4 ? "tabbable tabs-right" : (tabPlacement == 2 ? "tabbable tabs-left" : (tabPlacement == 3 ? "tabbable tabs-below" : "tabbable")));
        this.li_.putClientProperty("css_class", isSelected ? "active" : "");
        this.li_.putClientProperty("css_hover", Boolean.valueOf(this.getRolloverTab() == tabIndex) != false && !isSelected);
        this.a_.putClientProperty("css_hover", Boolean.valueOf(this.getRolloverTab() == tabIndex) != false && !isSelected);
        this.a_.setBounds(new Rectangle(x, y, w, h));
        BackgroundInfo info = CSS.getInfo(this.a_);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D big = bi.createGraphics();
        Composite bic = big.getComposite();
        big.setComposite(AlphaComposite.Src);
        big.setColor(new Color(0, true));
        big.fillRect(0, 0, w, h);
        big.setComposite(bic);
        Background.paint(info, big, 0, 0, w, h);
        Graphics2D g2 = (Graphics2D)g;
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, info.opacity));
        g2.drawImage((Image)bi, x, y, null);
        g2.setComposite(composite);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        this.parent_.putClientProperty("css_class", tabPlacement == 4 ? "tabbable tabs-right" : (tabPlacement == 2 ? "tabbable tabs-left" : (tabPlacement == 3 ? "tabbable tabs-below" : "tabbable")));
        BackgroundInfo info = CSS.getInfo(this.a_);
        return Background.getInsets(info);
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        return noInsets_;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        return noInsets_;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return noInsets_;
    }
}

