/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class CSSScrollPaneUI
extends BasicScrollPaneUI {
    private static final Logger LOGGER = Logger.getLogger(CSSScrollPaneUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JScrollPane);
        LOGGER.entering(CSSScrollPaneUI.class.getName(), "createUI");
        return new CSSScrollPaneUI(component);
    }

    protected CSSScrollPaneUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSScrollPaneUI.class.getName(), "installUI");
        super.installUI(component);
        component.setOpaque(false);
        ((JScrollPane)component).getViewport().setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            Component focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            component.putClientProperty("css_focus", focus != null && SwingUtilities.isDescendingFrom(focus, component));
            BackgroundInfo info = CSS.getInfo(component);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            g2.setFont(component.getFont());
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
            return;
        }
        BackgroundInfo info = CSS.getInfo(component);
        if (info.foreground != null && !info.foreground.equals(component.getForeground())) {
            component.setForeground(info.foreground);
        }
        if (info.background != null && !info.background.equals(component.getBackground())) {
            component.setBackground(info.background);
        }
        super.paint(g, component);
    }
}

