/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.border.CSSBorderResource;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.ZoomedIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import sun.swing.SwingUtilities2;

public class CSSRadioButtonUI
extends BasicRadioButtonUI {
    private static final Logger LOGGER = Logger.getLogger(CSSRadioButtonUI.class.getName());
    private final JComponent component_;
    private JComponent dummy_ = new AbstractButton(){
        {
            this.putClientProperty("css_element", "span");
            this.putClientProperty("css_class", "radio");
        }

        @Override
        public boolean isEnabled() {
            return CSSRadioButtonUI.this.component_.isEnabled();
        }

        @Override
        public boolean isSelected() {
            return CSSRadioButtonUI.this.component_ instanceof AbstractButton && ((AbstractButton)CSSRadioButtonUI.this.component_).isSelected();
        }

        @Override
        public void setFocusPainted(boolean b) {
            if (CSSRadioButtonUI.this.component_ instanceof AbstractButton) {
                ((AbstractButton)CSSRadioButtonUI.this.component_).setFocusPainted(b);
            }
        }

        @Override
        public boolean isFocusPainted() {
            return CSSRadioButtonUI.this.component_ instanceof AbstractButton && ((AbstractButton)CSSRadioButtonUI.this.component_).isFocusPainted();
        }

        @Override
        public boolean isFocusOwner() {
            return CSSRadioButtonUI.this.component_ instanceof AbstractButton && ((AbstractButton)CSSRadioButtonUI.this.component_).isFocusOwner();
        }

        @Override
        public boolean isFocusCycleRoot() {
            return CSSRadioButtonUI.this.component_ instanceof AbstractButton && ((AbstractButton)CSSRadioButtonUI.this.component_).isFocusCycleRoot();
        }

        @Override
        public ButtonModel getModel() {
            return CSSRadioButtonUI.this.component_ instanceof AbstractButton ? ((AbstractButton)CSSRadioButtonUI.this.component_).getModel() : super.getModel();
        }
    };

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof AbstractButton);
        LOGGER.entering(CSSRadioButtonUI.class.getName(), "createUI");
        return new CSSRadioButtonUI(component);
    }

    protected CSSRadioButtonUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D g2 = bi.createGraphics();
            g2.setClip(new Rectangle(component.getSize()));
            g2.clipRect(0, 0, component.getWidth(), component.getHeight());
            if (((AbstractButton)component).isBorderPainted()) {
                Background.paintBackgroundToBuffer(g2, component, info, (CSSBorder)border);
            }
            g2.setFont(component.getFont());
            g2.translate(5, 0);
            Background.addFontRenderingHints(g2, component);
            super.paint(g2, component);
            g2.translate(-5, 0);
            Background.paintFromBuffer(g, bi, info.opacity);
            Background.recycleBuffer(bi);
            if (((AbstractButton)component).isFocusPainted() && component.hasFocus()) {
                g2 = (Graphics2D)g;
                g2.setColor(Color.gray);
                g2.setStroke(new BasicStroke(1.0f, 2, 1, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.draw(new RoundRectangle2D.Double(0.0, 0.0, component.getWidth() - 1, component.getHeight() - 1, 8.0, 8.0));
            }
        } else {
            super.paint(g, component);
        }
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSRadioButtonUI.class.getName(), "installUI");
        super.installUI(component);
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "body");
        }
        ((AbstractButton)component).setRolloverEnabled(true);
        component.setOpaque(false);
        component.setBorder(new CSSBorderResource());
        RBIcon rbIcon = new RBIcon();
        if (rbIcon.isAvailable()) {
            ((AbstractButton)component).setIcon(rbIcon);
        } else if (this.icon != null) {
            this.icon = new ZoomedIcon(this.icon);
            ((AbstractButton)component).setIcon(this.icon);
        }
    }

    @Override
    protected void paintText(Graphics g, AbstractButton component, Rectangle textRect, String text) {
        ButtonModel model = component.getModel();
        int mnemonicIndex = component.getDisplayedMnemonicIndex();
        BackgroundInfo info = CSS.getInfo(component);
        g.setFont(info.font);
        FontMetrics fm = g.getFontMetrics(info.font);
        g.setColor(info.foreground);
        if (model.isEnabled()) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            Color fg = g.getColor();
            fg = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() / 2);
            g.setColor(fg);
            SwingUtilities2.drawStringUnderlineCharAt(component, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            size.width = in.left + in.right + size.width + 10;
            size.height = in.top + in.bottom + size.height;
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }

    private class RBIcon
    implements Icon {
        private RBIcon() {
        }

        @Override
        public int getIconWidth() {
            BackgroundInfo info = CSS.getInfo(CSSRadioButtonUI.this.dummy_);
            return info.size.width;
        }

        @Override
        public int getIconHeight() {
            BackgroundInfo info = CSS.getInfo(CSSRadioButtonUI.this.dummy_);
            return info.size.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            BackgroundInfo info = CSS.getInfo(CSSRadioButtonUI.this.dummy_);
            AffineTransform saveTransform = g2.getTransform();
            Shape saveClip = g2.getClip();
            g.clipRect(x, y, info.size.width, info.size.height);
            g.translate(x, y);
            Background.paintImages(info, g, x, y, info.size.width, info.size.height);
            g2.setTransform(saveTransform);
            g2.setClip(saveClip);
        }

        public boolean isAvailable() {
            BackgroundInfo info = CSS.getInfo(CSSRadioButtonUI.this.dummy_);
            return !info.backgroundImageList.isEmpty();
        }
    }
}

