/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.ZoomedIcon;
import com.ge.med.iungo.laf.CSSMenuItemUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class CSSRadioButtonMenuItemUI
extends CSSMenuItemUI {
    private static final Logger LOGGER = Logger.getLogger(CSSRadioButtonMenuItemUI.class.getName());
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JRadioButtonMenuItem);
        LOGGER.entering(CSSRadioButtonMenuItemUI.class.getName(), "createUI");
        return new CSSRadioButtonMenuItemUI(component);
    }

    protected CSSRadioButtonMenuItemUI(JComponent component) {
        super(component);
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSRadioButtonMenuItemUI.class.getName(), "installUI");
        super.installUI(component);
        component.setBorder(new CSSBorder());
        component.setOpaque(false);
        RBIcon cbIcon = new RBIcon();
        if (cbIcon.isAvailable()) {
            ((AbstractButton)component).setIcon(cbIcon);
        } else {
            this.checkIcon = new ZoomedIcon(UIManager.getIcon("RadioButtonMenuItem.checkIcon"));
        }
    }

    private class RBIcon
    implements Icon {
        private JComponent dummy_ = new AbstractButton(){
            {
                this.putClientProperty("css_element", "span");
                this.putClientProperty("css_class", "radio");
            }

            @Override
            public boolean isEnabled() {
                return CSSRadioButtonMenuItemUI.this.component_.isEnabled();
            }

            @Override
            public boolean isSelected() {
                return CSSRadioButtonMenuItemUI.this.component_ instanceof AbstractButton && ((AbstractButton)CSSRadioButtonMenuItemUI.this.component_).isSelected();
            }

            @Override
            public ButtonModel getModel() {
                return CSSRadioButtonMenuItemUI.this.component_ instanceof AbstractButton ? ((AbstractButton)CSSRadioButtonMenuItemUI.this.component_).getModel() : super.getModel();
            }
        };

        private RBIcon() {
        }

        @Override
        public int getIconWidth() {
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            return info.size.width;
        }

        @Override
        public int getIconHeight() {
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            return info.size.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            AffineTransform saveTransform = g2.getTransform();
            Shape saveClip = g2.getClip();
            g.clipRect(x, y, info.size.width, info.size.height);
            g.translate(x, y);
            Background.paintImages(info, g, x, y, info.size.width, info.size.height);
            g2.setTransform(saveTransform);
            g2.setClip(saveClip);
        }

        public boolean isAvailable() {
            BackgroundInfo info = CSS.getInfo(this.dummy_);
            return !info.backgroundImageList.isEmpty();
        }
    }
}

