/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class CSSProgressBarUI
extends BasicProgressBarUI {
    private static final Logger logger_ = Logger.getLogger(CSSProgressBarUI.class.getName());
    private final JProgressBar progress_;
    private final JComponent progress_bar_ = new JComponent(){};

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JProgressBar);
        logger_.entering(CSSProgressBarUI.class.getName(), "createUI");
        return new CSSProgressBarUI(component);
    }

    protected CSSProgressBarUI(JComponent component) {
        this.progress_ = (JProgressBar)component;
        this.progress_bar_.putClientProperty("css_class", "progress-bar");
        this.progress_bar_.putClientProperty("css_parent", this.progress_);
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.progress_);
        logger_.entering(CSSProgressBarUI.class.getName(), "installUI");
        super.installUI(component);
    }

    private void prepareForCssMatching(JProgressBar progress) {
        assert (progress == this.progress_);
        String cssClass = (String)this.progress_.getClientProperty("css_class");
        if (cssClass == null || !cssClass.contains("progress")) {
            this.progress_.putClientProperty("css_class", "progress");
        }
    }

    private void matchCssAndUpdateProperties(JProgressBar progress) {
        assert (progress == this.progress_);
        BackgroundInfo barInfo = CSS.getInfo(this.progress_bar_);
        BackgroundInfo progressInfo = CSS.getInfo(this.progress_);
        if (barInfo.background != null) {
            this.progress_.setForeground(barInfo.background);
        }
        if (progressInfo.background != null) {
            this.progress_.setBackground(progressInfo.background);
        }
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        assert (component == this.progress_);
        this.prepareForCssMatching(this.progress_);
        this.matchCssAndUpdateProperties(this.progress_);
        Background.addFontRenderingHints((Graphics2D)g, component);
        super.paint(g, this.progress_);
    }
}

