/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.iungo.laf;

import com.ge.med.iungo.border.CSSBorder;
import com.ge.med.iungo.css.BackgroundInfo;
import com.ge.med.iungo.css.CSS;
import com.ge.med.iungo.graphics.Background;
import com.ge.med.iungo.graphics.CSSFontIcon;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class CSSPasswordFieldUI
extends BasicPasswordFieldUI {
    private static final Logger LOGGER = Logger.getLogger(CSSPasswordFieldUI.class.getName());
    private FocusListener focusListener_ = null;
    private JComponent divContainer = new JComponent(){};
    private final JComponent component_;

    public static ComponentUI createUI(JComponent component) {
        assert (component instanceof JPasswordField);
        LOGGER.entering(CSSPasswordFieldUI.class.getName(), "createUI");
        return new CSSPasswordFieldUI(component);
    }

    protected CSSPasswordFieldUI(JComponent component) {
        this.component_ = component;
    }

    @Override
    public void installUI(JComponent component) {
        assert (component == this.component_);
        LOGGER.entering(CSSPasswordFieldUI.class.getName(), "installUI");
        super.installUI(component);
        component.setOpaque(false);
        if (component.getClientProperty("css_element") == null) {
            component.putClientProperty("css_element", "input");
        }
        if (component.getClientProperty("css_attribute_type") == null) {
            component.putClientProperty("css_attribute_type", "text");
        }
        component.putClientProperty("css_parent", this.divContainer);
        this.divContainer.putClientProperty("css_element", "div");
        if (null == this.focusListener_) {
            this.focusListener_ = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CSSPasswordFieldUI.this.component_.repaint();
                }
            };
            this.component_.addFocusListener(this.focusListener_);
        }
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        if (null != this.focusListener_) {
            this.component_.removeFocusListener(this.focusListener_);
            this.focusListener_ = null;
        }
    }

    @Override
    public void paintSafely(Graphics g) {
        JTextComponent component = this.getComponent();
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            String origCssClass = (String)component.getClientProperty("css_class");
            this.divContainer.putClientProperty("css_class", origCssClass);
            if (origCssClass != null) {
                component.putClientProperty("css_icon_after", origCssClass.contains("success") ? this.getIcon("success") : (origCssClass.contains("warning") ? this.getIcon("warning") : (origCssClass.contains("error") ? this.getIcon("error") : null)));
            } else {
                component.putClientProperty("css_icon_after", null);
            }
            Graphics2D g2 = (Graphics2D)g;
            Composite composite = g2.getComposite();
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            Object icon = component.getClientProperty("css_icon_after");
            if (icon instanceof CSSFontIcon) {
                ((CSSFontIcon)icon).color_ = info.borderColor[0];
            }
            BufferedImage bi = Background.getBuffer(component.getSize());
            Graphics2D big = bi.createGraphics();
            big.setClip(new Rectangle(component.getWidth(), component.getHeight()));
            ((CSSBorder)border).paintBorderAndBackground(component, big, 0, 0, component.getWidth(), component.getHeight());
            g2.setComposite(AlphaComposite.getInstance(3, info.opacity));
            big.setFont(component.getFont());
            Background.addFontRenderingHints(big, component);
            super.paintSafely(big);
            g2.drawImage((Image)bi, 0, 0, null);
            g2.setComposite(composite);
            Background.recycleBuffer(bi);
            return;
        }
        super.paintSafely(g);
    }

    private Icon getIcon(String icon) {
        return CSSFontIcon.getIcon("success".equals(icon) ? (char)'\uf402' : ("warning".equals(icon) ? (char)'\uf109' : '\uf42c'), "success".equals(icon) ? (float)(CSS.getZoom() * 20.0) : ("warning".equals(icon) ? (float)(CSS.getZoom() * 13.0) : (float)(CSS.getZoom() * 18.0)), new Dimension((int)(CSS.getZoom() * 28.0), (int)(CSS.getZoom() * 28.0)));
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        Dimension size;
        assert (component == this.component_);
        Border border = component.getBorder();
        if (border instanceof CSSBorder) {
            String origCssClass = (String)component.getClientProperty("css_class");
            this.divContainer.putClientProperty("css_class", origCssClass);
            if (origCssClass != null) {
                component.putClientProperty("css_icon_after", origCssClass.contains("success") ? this.getIcon("success") : (origCssClass.contains("warning") ? this.getIcon("warning") : (origCssClass.contains("error") ? this.getIcon("error") : null)));
            } else {
                component.putClientProperty("css_icon_after", null);
            }
            BackgroundInfo info = CSS.getInfo(component);
            Background.updateComponentProperties(component, info);
            size = super.getPreferredSize(component);
            Insets in = border.getBorderInsets(component);
            if (info.size.width > 0) {
                size.width = in.left + in.right + info.size.width;
            }
            if (info.size.height > 0) {
                size.height = in.top + in.bottom + info.size.height;
            }
        } else {
            size = super.getPreferredSize(component);
        }
        return size;
    }
}

